* cr_RP_d_entryexit_models_expanded_IHS_char_regs

set more off
cap log close

*******************************************************************************
import excel "${IHS_char}/USA_data_2003_2019.xlsx", firstrow clear

* Rename the variables with the stock with time-consistent names
foreach v of varlist AH - AX {
	local x : variable label `v'
    rename `v' T_`x'
}

local vlist GenerationYear NoofDoors Engineltr Engineccm EnginekW EngineHP ///
NoofCylinders NoofGears GrossVehicleWeight Height Length Width Wheelbase ///
Fuelconscombined Fuelconsurban Fuelconsextraurban

foreach v of local vlist {
	replace `v' = . if `v'==-1 | `v'==0
}

local vlist NoofSeats FuelType Turbo Transmission AxleConfiguration
foreach v of local vlist {
	encode `v', gen(n_`v')
	drop `v'
	rename n_`v' `v'
}

replace NoofGears=. if NoofGears==99

gen id=_n
reshape long T_, i(id) j(year)

* Dummy for turbo
gen turbo2=Turbo==2
drop Turbo
rename turbo2 Turbo

* Dummy for manual transmission
gen Manual=Transmission==2

* Dummy for diesel
gen Diesel=FuelType==1

* Fuel types categories
gen FuelType3="Electric" if FuelType==2 |  FuelType==3 | FuelType==4
replace FuelType3="Diesel" if FuelType==1
replace FuelType3="Petrol" if FuelType3=="" & FuelType!=.

encode FuelType3, gen(FT3)
drop FuelType3
rename FT3 FuelType3

foreach v of local vlist {
	replace `v' = . if `v'==0
}

* Dummy for 4x4 Axle configuration
gen D4x4=AxleConfiguration==2

rename T_ NewRegistrations

keep if NewRegistrations>0 & NewRegistrations!=.

merge m:1 Make Model GenerationYear year using "${datbuild}/d_entryexit_models_IHS_char.dta", ///
keepusing(d_exit d_entry) 

* Make corrections
replace d_exit = 0 if d_exit==.
replace d_entry = 0 if d_entry==.

bys Make Model GenerationYear year: egen d_ee = max(d_exit)
bys Make Model GenerationYear year: egen d_en = max(d_entry)

drop d_exit d_entry _merge
rename d_ee d_exit
rename d_en d_entry

* Generate a numerical code for Maker, to be used to generate dummies for the regression
egen maker_code = group(Make)

* Generate logged variables and interaction terms for eq.
gen FuelEfficiency = 1/Fuelconscombined
gen ln_fueleff=ln(FuelEfficiency)
gen ln_HP = ln(EngineHP)
gen ln_weight = ln(GrossVehicleWeight)

gen ln_HP_sq = ln_HP^2
gen ln_weight_sq = ln_weight^2

* Save the dataset
save "${datbuild}/d_entryexit_models_expanded_IHS_char_regs.dta", replace


