* cr_RP_d_entryexit_models_IHS_char_regs

set more off
cap log close

*******************************************************************************
use "${datbuild}/d_IHS_charact.dta", clear

* Make replacement for the reshape (need to generate a group variable because the
* variables defining every row of the dataset are too many for the reshape) ->
* to avoid the fact that group puts a missing if any of the variables is missing,
* replace the missing with -1
local vvars GenerationYear Engineltr Engineccm Engineccm EnginekW EngineHP NoofDoors ///
NoofCylinders NoofGears NoofSeats FuelType Turbo Transmission AxleConfiguration 

foreach v of local vvars {
	replace `v'=-1 if `v'==.
}

egen grr = group(MakeGroup Make ModelGroup Model SubModel Version Trim ///
BodyGroup BodyType GenerationYear NoofDoors Engineltr Engineccm ///
EnginekW EngineHP NoofCylinders NoofGears NoofSeats FuelType ///
Turbo Transmission AxleConfiguration)

reshape long T_, i(grr) j(year)

* Then revert the missing values replacement and collapse the characteristics by
* model definition using as weights the number of transactions
local vvars GenerationYear Engineltr Engineccm Engineccm EnginekW EngineHP NoofDoors ///
NoofCylinders NoofGears NoofSeats FuelType Turbo Transmission AxleConfiguration 

foreach v of local vvars {
	replace `v'=. if `v'==-1
}

********************************************************************************
* Then, define the set of variables uniquely defining a row in the regression
* dataset

* Dummy for turbo
gen turbo2=Turbo==2
drop Turbo
rename turbo2 Turbo

* Dummy for manual transmission
gen Manual=Transmission==2

* Dummy for diesel
gen Diesel=FuelType==1

* Fuel types categories
gen FuelType3="Electric" if FuelType==2 |  FuelType==3 | FuelType==4
replace FuelType3="Diesel" if FuelType==1
replace FuelType3="Petrol" if FuelType3=="" & FuelType!=.

encode FuelType3, gen(FT3)
drop FuelType3
rename FT3 FuelType3

foreach v of local vlist {
	replace `v' = . if `v'==0
}

* Dummy for 4x4 Axle configuration
gen D4x4=AxleConfiguration==2

gen unit=1

bys Make Model GenerationYear Turbo Manual FuelType3 D4x4 year: egen BodyGroupm=mode(BodyGroup), maxmode
bys Make Model GenerationYear Turbo Manual FuelType3 D4x4 year: egen BodyTypem=mode(BodyType), maxmode
bys Make Model GenerationYear Turbo Manual FuelType3 D4x4 year: egen DrivenWheelsm=mode(DrivenWheels), maxmode
drop BodyGroup BodyType DrivenWheels
rename BodyGroupm BodyGroup 
rename BodyTypem BodyType
rename DrivenWheelsm DrivenWheels

* Collapse characteritstics using as weights the number of trsanctions 
collapse (sum) unit (mean) NoofDoors Engineltr Engineccm EnginekW EngineHP NoofCylinders ///
NoofGears NoofSeats Fuelconscombined ///
Fuelconsurban Fuelconsextraurban GrossVehicleWeight Height Length Width Wheelbase ///
(max) Diesel (firstnm) BodyGroup BodyType DrivenWheels ///
[fw=T_], by(Make Model GenerationYear Turbo Manual FuelType3 D4x4 year)

rename unit NewRegistrations

merge m:1 Make Model GenerationYear year using "${datbuild}/d_entryexit_models_IHS_char.dta", ///
keepusing(d_exit d_entry) 

* Make corrections
replace d_exit = 0 if d_exit==.
replace d_entry = 0 if d_entry==.

bys Make Model GenerationYear year: egen d_ee = max(d_exit)
bys Make Model GenerationYear year: egen d_en = max(d_entry)

drop d_exit d_entry _merge
rename d_ee d_exit
rename d_en d_entry

* Generate a numerical code for Maker, to be used to generate dummies for the regression
egen maker_code = group(Make)

replace NoofSeats=round(NoofSeats)
replace NoofGears=floor(NoofGears)
replace NoofCylinders=round(NoofCylinders)
replace NoofDoors=round(NoofDoors)

* Generate logged variables and interaction terms for eq. (6). 
gen FuelEfficiency = 1/Fuelconscombined
gen ln_fueleff=ln(FuelEfficiency)
gen ln_HP = ln(EngineHP)
gen ln_weight = ln(GrossVehicleWeight)

gen ln_HP_sq = ln_HP^2
gen ln_weight_sq = ln_weight^2



* Save the dataset
save "${datbuild}/d_entryexit_models_IHS_char_regs.dta", replace


