* cr_RP_d_entryexit_models_IHS_char

set more off
cap log close

*******************************************************************************
use "${datbuild}/d_IHS_charact.dta", clear

local vlist NoofDoors Engineltr Engineccm EnginekW EngineHP NoofCylinders ///
NoofGears NoofSeats FuelType Turbo Transmission AxleConfiguration

foreach v of local vlist {
	bys Make Model GenerationYear: egen `v'_m = mode(`v'), maxmode
	drop `v'
	rename `v'_m `v'
}
 
* Collapse characteritstics and transactions by year
collapse (sum) T_* (mean) NoofDoors Engineltr Engineccm EnginekW EngineHP NoofCylinders ///
NoofGears NoofSeats FuelType Turbo Transmission AxleConfiguration Fuelconscombined ///
Fuelconsurban Fuelconsextraurban GrossVehicleWeight Height Length Width Wheelbase, by(Make Model GenerationYear)

* Then fo the reshape
reshape long T_, i(Make Model GenerationYear) j(year)
rename T_ NewRegistrations

keep if NewRegistrations>0 & NewRegistrations!=.


bys Make Model GenerationYear: egen first_year = min(year) 
bys Make Model GenerationYear: egen last_year = max(year)

gen d_exit = (year==last_year)
gen d_entry = (year==first_year | year==first_year+1)

* Count the unique number of models by year
unique Make Model GenerationYear, by(year) gen(increm_nb_models)
bys year: egen nb_models = max(increm_nb_models)
drop increm_nb_models

* Save the dataset
save "${datbuild}/d_entryexit_models_IHS_char.dta", replace
