* cr_d_dominion_model_year_list

* This dofile generates a LIST of model names in the Dominion dataset
* to be merged with IHS data

set more off
cap log close

*******************************************************************************
use "${datbuild}/master_newprice.dta", clear

drop if sprice==. | sprice==0
drop if lease==1

rename year model_year
rename yy year

drop pumps city zip fleet lease countynum 

gen model_d2 = word(model,1)

* Make adjustments to model names with typos / slight variations
replace model_d2=upper(model_d2)

replace model_d2="F430" if model_d2=="430" & make=="FERR"
replace model_d2="575" if model_d2=="575M" & make=="FERR"

drop if segment=="Full-Sized Van" | segment=="Medium & Heavy Truck"
drop if make=="FRHT" | make=="INTL" | make=="WEST" | ///
make=="UD" | make=="STER" | make=="PETE" | make=="MACK" | ///
make=="KENW" | make=="HINO" | make=="WEST" | make=="BLUB" // Drop producer of trucks only

drop if body=="HT" | body=="VN" | body=="BU" | body=="MH"
drop if make=="FORD" & model_d2=="MTR" // Drop Ford motor home
drop if make=="FORD" & model_d2=="TRANSIT" // Van
drop if make=="CADI" & model_d2=="HEARSE" // Funeral coach

keep make model model_d2 model_year
duplicates drop 

drop if model==""
sort make model model_year, stable
order make model model_d2 model_year

* Save dataset
save "${datbuild}/d_dominion_model_year_list.dta", replace
save "${doR}/d_dominion_model_year_list.dta", replace

