* cr_RP_d_IHS_model_year_list

* This dofile generates a LIST of model names in the Dominion dataset
* to be merged with IHS data

set more off
cap log close

*******************************************************************************
use "${datbuild}/d_entryexit_models_IHS_char_regs.dta", clear

keep Make Model GenerationYear d_entry year
gen entry_year=year if d_entry==1
bys Make Model GenerationYear: egen entry_model_year=min(entry_year)

drop entry_year d_entry year
duplicates drop Make Model GenerationYear, force

rename Make make_IHS
rename Model model_IHS
drop if strpos(model_IHS, "Unspec.") > 0
drop if strpos(model_IHS, "Unspec") > 0

gen GenerationModelYear=entry_model_year+1
sort make_IHS model_IHS GenerationModelYear, stable
by make_IHS model_IHS: gen Generation=_n

sort make_IHS model_IHS Generation, stable

* Save dataset
save "${datbuild}/d_IHS_model_year_list.dta", replace
save "${doR}/d_IHS_model_year_list.dta", replace

