* an_RP_tableB2

* This dofile performs period-specific hedonic regressions and exports key 
* regression coefficients

clear all
set more off
cap log close

set scheme s2colorag

********************************************************************************

use "${datbuild}/d_pricechar_matchIHS_dominion.dta", clear  

local vars Engineltr Engineccm Fuelconsurban Fuelconsextraurban ///
Height Length Width Wheelbase EnginekW

foreach v of local vars {
	replace `v'=ln(`v')
	gen `v'_sq=`v'^2 
}

gen ln_fueleff_sq=ln_fueleff^2

keep if year>=2004 & year<=2017

replace sprice=ln(sprice)

areg ln_weight Wheelbase Width Height i.NoofSeats , absorb(maker)
predict hat_weight, xb
gen miss_w=ln_weight==.
replace ln_weight=hat_weight if ln_weight==.

drop ln_weight_sq
gen ln_weight_sq=ln_weight^2

replace BodyType="SUV Closed" if BodyType=="Monospace"

encode BodyType, gen(BT)
encode BodyGroup, gen(BG)
drop BodyType BodyGroup
rename BT BodyType
rename BG BodyGroup


********************************************************************************
* Table B2 - Hedonic regression on new models only

preserve

* Keep new models only
keep if d_entry==1

eststo clear 

* Pre-recession period
eststo: reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year>=2005 & year<=2007

* Recession period

eststo:  reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year==2008 | year==2009

* Post-Recession period
eststo: reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year>=2010

label var ln_fueleff "Log(Fuel Efficiency)"
label var ln_weight "Log(Weight)"
label var ln_HP "Log(HP)"
label var Engineccm "Log(Engine Size)"
label var Wheelbase "Log(Wheelbase)"
label var sprice "Log(Price)"

esttab using "${figures}\tab_B2.tex", ///
 label b(3) se replace  r2 keep(ln_fueleff ln_weight ln_HP Wheelbase Engineccm) ///
 nocon order(Wheelbase ln_HP ln_weight Enfineccm ln_fueleff) ///
 mtitles("Pre-Rec." "Recession" "Post-Rec.") nostar
 
restore




