* an_RP_tableB1B

* This dofile performs period-specific hedonic regressions and exports key 
* regression coefficients

clear all
set more off
cap log close

set scheme s2colorag

********************************************************************************

use "${datbuild}/d_pricechar_matchIHS_dominion.dta", clear  

local vars Engineltr Engineccm Fuelconsurban Fuelconsextraurban ///
Height Length Width Wheelbase EnginekW

foreach v of local vars {
	replace `v'=ln(`v')
	gen `v'_sq=`v'^2 
}

gen ln_fueleff_sq=ln_fueleff^2

keep if year>=2004 & year<=2017

replace sprice=ln(sprice)

areg ln_weight Wheelbase Width Height i.NoofSeats , absorb(maker)
predict hat_weight, xb
gen miss_w=ln_weight==.
replace ln_weight=hat_weight if ln_weight==.

drop ln_weight_sq
gen ln_weight_sq=ln_weight^2

replace BodyType="SUV Closed" if BodyType=="Monospace"

encode BodyType, gen(BT)
encode BodyGroup, gen(BG)
drop BodyType BodyGroup
rename BT BodyType
rename BG BodyGroup


********************************************************************************
* Table 1 - Panel B

preserve

********************************************************************************
* First, Fixed betas at 2004
reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
Wheelbase ///
i.NoofCylinders ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year>=2004 & year<=2007
predict char_all, xb


********************************************************************************
* Second, Time-varying betas
gen char_all_tv=.

* Pre-recession period
reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
Wheelbase ///
i.NoofCylinders ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year>=2004 & year<=2007

predict char_all_p1, xb
replace char_all_tv=char_all_p1 if year>=2004 & year<=2007 

* Recession period
reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
Wheelbase ///
i.NoofCylinders ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year==2008 | year==2009

predict char_all_p2, xb
replace char_all_tv=char_all_p2 if year==2008 | year==2009

* Keep new models only
keep if d_entry==1

collapse (sd) char_all_sd=char_all char_all_tv_sd=char_all_tv sprice_sd=sprice ///
(mean) char_all char_all_tv sprice [fw=NewReg], by(year)

keep if year==2007 | year==2008
tsset year, y

gen Data1=sprice-L1.sprice
gen All_NoW1=char_all-L1.char_all
gen All_tv_NoW1=char_all_tv-L1.char_all_tv

gen Data2=sprice_sd-L1.sprice_sd
gen All_NoW2=char_all_sd-L1.char_all_sd
gen All_tv_NoW2=char_all_tv_sd-L1.char_all_tv_sd

keep if year==2008

reshape long Data All_NoW All_tv_NoW, i(year) j(Ord)

gen Item="AVERAGE 2008 - AVERAGE 2007" if Ord==1
replace Item="ST. DEV. 2008 - ST. DEV. 2007" if Ord==2

rename All_NoW AllNoW
rename All_tv_NoW AlltvNoW


order Item Data AllNoW AlltvNoW
texsave Item Data AllNoW AlltvNoW using "${figures}/tab_B1B.tex", frag replace

keep Item Data AllNoW AlltvNoW
save "${figures}/tab_B1B.dta", replace

restore
