* an_RP_specific_figures_appendix

set more off
cap log close

set scheme s2colorag


********************************************************************************
* APPENDIX A

*-------------------------------------------------------------------------------
* Share of unmatched model-years Dominion-IHS
import delim "${doR}/algorithm_dominion_IHS_model_year_output.csv", clear

merge 1:1 make model model_year using "${datbuild}/d_dominion_model_year_list.dta", keep(3) nogenerate

count if model_ihs==""
local share_unmatched = r(N)/_N

* Share of model-years in Dominion not matched to IHS
di `share_unmatched'
 
matrix sA_1 = `share_unmatched'*100
clear
svmat sA_1

rename sA_11 Figure
gen Label = "Percentage of unmatched models"
order Label Figure

save "${figures}/nmbrs_sA_1.dta", replace

 
********************************************************************************
* APPENDIX B

*-------------------------------------------------------------------------------
* Percentage of fleet sales

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

* Keep years in a relevant time-window around the crisis
keep if year>=2004 & year<=2012

gen tot_trans=1
gen unit=1
collapse (sum) fleet tot_trans, by(unit)

gen sh_fleet = fleet/tot_trans
sum sh_fleet

matrix sB_1 = r(mean)*100
clear
svmat sB_1

rename sB_11 Figure
gen Label = "Percentage of fleet sales"
order Label Figure

save "${figures}/nmbrs_sB_1.dta", replace

*-------------------------------------------------------------------------------
* Number of new models introduced by European and US makers

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion_harmonmaker.dta", clear

* Keep years in a relevant time-window before the crisis
keep if (year>=2004 & year<=2012)

* Select expensive models and new models
sort model_id year, stable
bys model_id year: egen avgprice=mean(sprice)
gen d_expensive_model=(avgprice>=40000  & avgprice!=.)
by model_id year: keep if _n==1

gen d_new_expensive_model=d_expensive_model*d_new_model


collapse (sum) nb_new_models = d_new_model nb_new_exp_models = d_new_expensive_model, ///
by(make_region year)


* Number of new models by European makers in 2007
sum nb_new_models if make_region=="Europe" & year==2007
local m_new_eu_07=r(mean)

* Number of new expensive models by European makers in 2007
sum nb_new_exp_models if make_region=="Europe" & year==2007
local m_new_exp_eu_07=r(mean)

sum nb_new_exp_models if make_region=="Europe" & year==2009
local m_new_exp_eu_09=r(mean)

* Decline during the recession for new expensive European models
di `m_new_exp_eu_09'/`m_new_exp_eu_07'-1

* Number of new models by US makers in 2007
sum nb_new_models if make_region=="USA" & year==2007
local m_new_us_07=r(mean)

* Number of new expensive models by US makers in 2007
sum nb_new_exp_models if make_region=="USA" & year==2007
local m_new_exp_us_07=r(mean)


matrix sB_2 = (`m_new_eu_07' \ `m_new_exp_eu_07' \ `m_new_us_07' \ `m_new_exp_us_07' \ (`m_new_exp_eu_09'/`m_new_exp_eu_07'-1)*100)
clear
svmat sB_2

rename sB_21 Figure
gen Label = ""
replace Label = "Number of new models by European makers - 2007" if _n==1
replace Label = "Number of expensive new models by European makers - 2007" if _n==2
replace Label = "Number of new models by American makers - 2007" if _n==3
replace Label = "Number of expensive new models by American makers - 2007" if _n==4
replace Label = "Percentage drop in new expensive models by European makers, 2009-2007" if _n==5

order Label Figure

save "${figures}/nmbrs_sB_2.dta", replace


*-------------------------------------------------------------------------------
* Quality drop in OH and TX

do "${dobuild}/cr_RP_d_pricechar_matchIHS_dominion_rrcol_stateweights.do"

keep if year>=2004 & year<=2012
replace sprice=ln(sprice)

* OHIO

preserve

keep if state=="OH"

reg sprice FuelEfficiency ///
GrossVehicleWeight   ///
EngineHP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year<=2007

predict char_hat
predict res_hat, res

drop if char_hat==.

collapse  ///
 (mean) sprice char_hat [fw=nb_trans_dominion], by(year)

* Labels
label var char_hat "Predicted by Characteristics"
label var sprice "Actual"

sum sprice if year==2007
sum sprice if year==2008
sum char_hat if year==2007
local qual_oh_07 = r(mean)
sum char_hat if year==2008
local qual_oh_08 = r(mean)


restore




* TEXAS

preserve

keep if state=="TX"

reg sprice FuelEfficiency ///
GrossVehicleWeight   ///
EngineHP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year<=2007

predict char_hat
predict res_hat, res

drop if char_hat==.

collapse  ///
 (mean) sprice char_hat [fw=nb_trans_dominion], by(year)

* Labels
label var char_hat "Predicted by Characteristics"
label var sprice "Actual"

sum sprice if year==2007
sum sprice if year==2008
sum char_hat if year==2007
local qual_tx_07 = r(mean)
sum char_hat if year==2008
local qual_tx_08 = r(mean)

restore


matrix sB_3 = ((`qual_oh_08'-`qual_oh_07')*100 \ (`qual_tx_08'-`qual_tx_07')*100)
clear
svmat sB_3

rename sB_31 Figure
gen Label = ""
replace Label = "Peak-to-trough percentage drop in quality-predicted prices - Ohio" if _n==1
replace Label = "Peak-to-trough percentage drop in quality-predicted prices - Texas" if _n==2
order Label Figure

save "${figures}/nmbrs_sB_3.dta", replace

erase "${datbuild}/d_pricechar_matchIHS_dominion_rrcol_stateweights.dta"



********************************************************************************
* Export results to excel

use "${figures}/nmbrs_sA_1.dta", clear

forvalues n=1/3 {
	append using "${figures}/nmbrs_sB_`n'.dta", force
}

export excel "${figures}/tab_inpaper_appendix_figures_stata.xlsx", replace


erase "${figures}/nmbrs_sA_1.dta"

forvalues n=1/3 {
	erase "${figures}/nmbrs_sB_`n'.dta"
}
