* an_RP_specific_figures

set more off
cap log close

set scheme s2colorag


********************************************************************************
* SECTION 2 

*-------------------------------------------------------------------------------
* Number of transactions in Dominion data
use "${datbuild}/master_newprice.dta", clear
count

matrix s2_1 = r(N)
clear
svmat s2_1

rename s2_11 Figure
gen Label = "Number of transactions"
order Label Figure

save "${figures}/nmbrs_s2_1.dta", replace

*-------------------------------------------------------------------------------
* Average time to a new generation
use "${datbuild}/d_entryexit_models_IHS_char_regs.dta", clear
sort Make Model GenerationYear, stable

keep Make Model GenerationYear
duplicates drop
by Make Model: gen incgen = _n
by Make Model: egen totgen = max(incgen)
tab totgen
keep if totgen>=2

egen mdid=group(Make Model)
xtset mdid incgen
gen avglife = GenerationYear-L.GenerationYear

sum avglife if L1.GenerationYear>=2004 & GenerationYear<=2012

matrix s2_2 = r(mean)
clear
svmat s2_2

rename s2_21 Figure
gen Label = "Average model life"
order Label Figure

save "${figures}/nmbrs_s2_2.dta", replace

*-------------------------------------------------------------------------------
* Number of models

use  "${datbuild}/d_pricechar_matchIHS_dominion.dta", clear
unique model_id

matrix s2_3 = r(unique)
clear
svmat s2_3

rename s2_31 Figure
gen Label = "Number of models"
order Label Figure

save "${figures}/nmbrs_s2_3.dta", replace


*-------------------------------------------------------------------------------
* Number of models with missing weight


use  "${datbuild}/d_pricechar_matchIHS_dominion.dta", clear
unique model_id
local rmt=r(unique)
unique model_id if GrossVehicleWeight==.
local rmw=r(unique)

matrix s2_4 = (`rmw'/`rmt')*100
clear
svmat s2_4

rename s2_41 Figure
gen Label = "Percentage of models with missing weight information"
order Label Figure

save "${figures}/nmbrs_s2_4.dta", replace


********************************************************************************
* R-squared of weight-imputation regression

use "${datbuild}/d_pricechar_matchIHS_dominion.dta", clear  

local vars Height Length Width Wheelbase

foreach v of local vars {
	replace `v'=ln(`v')
}

areg ln_weight Wheelbase Width Height i.NoofSeats , absorb(maker)

matrix s2_5 = e(r2)
clear
svmat s2_5

rename s2_51 Figure
gen Label = "R-squared of weight imputation regression"
order Label Figure

save "${figures}/nmbrs_s2_5.dta", replace


********************************************************************************
* SECTION 3.1

*-------------------------------------------------------------------------------
** DROP OF CAR SALES

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

gen nb_trans_all=1
gen nb_trans_new=1*d_new_model

collapse (sum) nb_trans_all nb_trans_new, by(year)

keep if year>=2004 & year<=2013

sum nb_trans_all if year==2007
local ta07=r(mean)
sum nb_trans_all if year==2009
local ta09=r(mean)
di `ta09'/`ta07'-1

matrix s3_1 = (`ta09'/`ta07'-1)*100
clear
svmat s3_1

rename s3_11 Figure
gen Label = "Percentage drop in new cars sales"
order Label Figure

save "${figures}/nmbrs_s3_1.dta", replace


*-------------------------------------------------------------------------------
** AVERAGE GROWTH of TRANSACTION PRICE - 2004-2012

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

collapse (mean) sprice, by(year)

keep if year>=2004 & year<=2012

* Log-deviations
gen logprice=ln(sprice)
reg logprice year

matrix rres = r(table)
matrix growth_1204 = rres[1,1]

* Yearly growth rate of average transaction price 2012-2004
matrix list growth_1204

matrix s3_2 = growth_1204*100
clear
svmat s3_2

rename s3_21 Figure
gen Label = "Yearly % growth rate in average transaction price"
order Label Figure

save "${figures}/nmbrs_s3_2.dta", replace


*-------------------------------------------------------------------------------
** PEAK-TO-THROUGH OF AVERAGE AND S.D. OF TRANSACTION PRICE

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

* Average and S.D. of transaction prices in 2007
sum sprice if year==2007
local mpeak=r(mean)
local speak=r(sd)

sum sprice if year==2008
local mthro=r(mean)

sum sprice if year==2009
local sthro=r(sd)

* Peak-through average price
di `mthro'/`mpeak'-1

* Peak-through S.D. price
di `sthro'/`speak'-1


* Deviation relative to trend
collapse (mean) sprice (sd) sprice_sd=sprice, by(year)

keep if year>=2004 & year<=2012

* Log-deviations
gen logprice=ln(sprice)
reg logprice year
predict loglin_trend, xb

* Relative to trend - 2008
sum logprice if year==2008
local p08=r(mean)
sum loglin_trend if year==2008
local p08f=r(mean)
di `p08'-`p08f'


****************************
* Standard deviation
gen logprice_sd=ln(sprice_sd)
reg logprice_sd year
predict loglin_trend_sd, xb

* Relative to trend - 2009
sum logprice_sd if year==2009
local p09=r(mean)
sum loglin_trend_sd if year==2009
local p09f=r(mean)
di `p09'-`p09f'



matrix s3_3 = (`mpeak' \ (`mthro'/`mpeak'-1)*100 \ `speak' \  (`sthro'/`speak'-1)*100 \ (`p08'-`p08f')*100 \ (`p09'-`p09f')*100)
clear
svmat s3_3

rename s3_31 Figure
gen Label = ""
replace Label = "Average transaction price in 2007" if _n==1
replace Label = "Peak-to-trough decline in average price (%)" if _n==2
replace Label = "Standard deviation of prices in 2007" if _n==3
replace Label = "Peak-to-trough decline in standard deviation of prices (%)" if _n==4
replace Label = "Percentage decline of average price relative to trend" if _n==5
replace Label = "Percentage decline of price standard deviation to trend" if _n==6

order Label Figure

save "${figures}/nmbrs_s3_3.dta", replace



********************************************************************************
* SECTION 3.2.1

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

* Keep years in a relevant time-window around the crisis
keep if year>=2004 & year<=2012

gen one=1

bys year: egen avg_price_year=mean(sprice)
bys year model_id: egen avg_price_model_year=mean(sprice)
bys year: egen tot_transactions=sum(one)
bys year: egen tot_transactions_newmod=sum(d_new_model)
bys year model_id: egen tot_model_transactions=sum(one)

* Generate blocks
gen within_model = (sprice-avg_price_model_year)^2
gen covariance = 2*(sprice-avg_price_model_year)*(avg_price_model_year-avg_price_year)

gen within_model_new=within_model*d_new_model
gen covariance_new=covariance*d_new_model

collapse (sum) within_model within_model_new covariance covariance_new ///
(mean) tot_model_transactions tot_transactions_newmod ///
tot_transactions avg_price_model_year ///
avg_price_year d_new_model, by(model_id year)

bys year: egen nb_models=count(model_id)
gen between_model_eqsh=((avg_price_model_year-avg_price_year)^2)*(1/nb_models)
gen between_model_desh=((avg_price_model_year-avg_price_year)^2)*(tot_model_transactions/tot_transactions-1/nb_models)
gen between_model_eqsh_new=between_model_eqsh*d_new_model
gen between_model_desh_new=between_model_desh*d_new_model

xtset model_id year, yearly

gen model_share_year=tot_model_transactions/tot_transactions

gen d_between_model_ds=(model_share_year-L1.model_share_year)*((avg_price_model_year-avg_price_year)^2)
gen d_between_model_fs=(L1.model_share_year)*((avg_price_model_year-avg_price_year)^2-(L1.avg_price_model_year-L1.avg_price_year)^2)

collapse (sum) within_model within_model_new covariance covariance_new ///
between_model_eqsh between_model_desh between_model_eqsh_new between_model_desh_new ///
d_between_model_ds d_between_model_fs ///
(mean) tot_transactions tot_transactions_newmod, by(year)

replace within_model=(1/tot_transactions)*within_model
replace covariance=(1/tot_transactions)*covariance
gen between_model = between_model_desh+between_model_eqsh
replace within_model_new=(1/tot_transactions)*within_model_new
replace covariance_new=(1/tot_transactions)*covariance_new
gen between_model_new = between_model_desh_new+between_model_eqsh_new


gen between_model_newadj=between_model_new/(tot_transactions_newmod/tot_transactions)
gen within_model_newadj=(tot_transactions/tot_transactions_newmod)*within_model_new
gen covariance_newadj=(tot_transactions/tot_transactions_newmod)*covariance_new


tsset year, yearly

gen d_between_model = between_model-L1.between_model
gen d_between_netentry = d_between_model-d_between_model_ds-d_between_model_fs
gen tot_var = within_model+covariance+between_model_eqsh+between_model_desh


replace tot_var=tot_var/10^7
replace within_model=within_model/10^7
replace covariance=covariance/10^7
replace between_model=between_model/10^7
replace within_model_new=within_model_new/10^7
replace covariance_new=covariance_new/10^7
replace between_model_new=between_model_new/10^7
gen tot_var_new=within_model_new+covariance_new+between_model_new

replace within_model_newadj=within_model_newadj/10^7
replace covariance_newadj=covariance_newadj/10^7
replace between_model_newadj=between_model_newadj/10^7
gen tot_var_newadj=within_model_newadj+covariance_newadj+between_model_newadj


*-------------------------------------------------------------------------------
* Specific figures - 2007
sum tot_var if year==2007
local tv_07=r(mean)
sum within_model if year==2007
local wv_07=r(mean)
sum between_model if year==2007
local bv_07=r(mean)

di "In 2007, Within-model dispersion accounts for a share of total variance of " `wv_07'/`tv_07' 
di "In 2007, Between-model dispersion accounts for a share of total variance of " `bv_07'/`tv_07'


matrix s3_4 = ((`wv_07'/`tv_07')*100  \ (`bv_07'/`tv_07')*100)
clear
svmat s3_4

rename s3_41 Figure
gen Label = ""
replace Label = "Percentage of total variance accounted for by within-model component" if _n==1
replace Label = "Percentage of total variance accounted for by between-model component" if _n==2

order Label Figure

save "${figures}/nmbrs_s3_4.dta", replace


********************************************************************************
* SECTION 3.2.2

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

*-------------------------------------------------------------------------------
* Average price for old models pre-recession
sum sprice if d_new_model==0 & (year==2005 | year==2006 | year==2007)
local ap_all_pre=r(mean)
* Average price for new models pre-recession
sum sprice if d_new_model==1 & (year==2005 | year==2006 | year==2007)
local ap_new_pre=r(mean)

* Average price for old models in 2008
sum sprice if d_new_model==0 & (year==2008)
local ap_all_08=r(mean)
* Average price for new models in 2008
sum sprice if d_new_model==1 & (year==2008)
local ap_new_08=r(mean)


*-------------------------------------------------------------------------------
* Share of transactions on new vs continuing models
gen tot_trans = 1
gen new_trans = d_new_model

collapse (sum) tot_trans new_trans, by(year)

gen sh_new_trans =  new_trans/tot_trans

* Share of transactions on new vs continuing models - 2007
sum sh_new_trans if year==2007
local sh_new07=r(mean)

* Share of transactions on new vs continuing models - 2009
sum sh_new_trans if year==2009
local sh_new09=r(mean)


matrix s3_5 = (`ap_all_pre'  \ `ap_new_pre' \ `ap_all_08' \ `ap_new_08' \ `sh_new07' \ `sh_new09')
clear
svmat s3_5

rename s3_51 Figure
gen Label = ""
replace Label = "Average pre-recession price for all models" if _n==1
replace Label = "Average pre-recession price for new models" if _n==2
replace Label = "Average price for all models in 2008" if _n==3
replace Label = "Average price for new models in 2008" if _n==4
replace Label = "Share of transactions on new models in 2007" if _n==5
replace Label = "Share of transactions on new models in 2009" if _n==6


order Label Figure

save "${figures}/nmbrs_s3_5.dta", replace



*-------------------------------------------------------------------------------
* Share of "vertical" and "horizontal" innovation

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

sort make_IHS model_IHS, stable
by make_IHS model_IHS: egen first_gen=min(GenerationModelYear)
gen d_firstgen=GenerationModelYear==first_gen
drop first_gen

gen d_new_model_firstgen=d_new_model*d_firstgen

keep model_id year d_new_model d_new_model_firstgen
sort model_id year, stable
by model_id year: keep if _n==1

collapse (mean) d_new_model d_new_model_firstgen, by(year)

label var d_new_model "New Models"
label var d_new_model_firstgen "New Models - First Generation"

*-------------------------------------------------------------------------------
* Weight of first generation models on overall new models before the recession
sum d_new_model if year==2007
local shnew07 = r(mean)
sum d_new_model_firstgen if year==2007
local shnewn07 = r(mean)

di `shnewn07'/`shnew07'

*-------------------------------------------------------------------------------
* Decline between 2009 and 2007
sum d_new_model if year==2009
local shnew09 = r(mean)
sum d_new_model_firstgen if year==2009
local shnewn09= r(mean)

* Change in the share of first generation new models
di `shnewn09'-`shnewn07'

* Change in the share of new models
di `shnew09'-`shnew07'


matrix s3_6 = (`shnewn07'/`shnew07'  \ (`shnewn09'-`shnewn07')*100 \ (`shnew09'-`shnew07')*100)
clear
svmat s3_6

rename s3_61 Figure
gen Label = ""
replace Label = "Share of first generation new models over new models in 2007" if _n==1
replace Label = "2009-2007 change in the share of first generation new models (perc. points)" if _n==2
replace Label = "2009-2007 change in the share of new models (perc. points)" if _n==3

order Label Figure

save "${figures}/nmbrs_s3_6.dta", replace


********************************************************************************
* SECTION 3.2.3 - OHIO vs TEXAS

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

* Keep years in a relevant time-window around the crisis
keep if year>=2004 & year<=2012


* Compute share of transactions in OH and TX over total
preserve

gen nb_trans_all=1
collapse (sum) nb_trans_all, by(state)

gen nb_trans_oh_tx = nb_trans_all*(state=="OH" | state=="TX")
gen unit=1
collapse (sum) nb_trans_oh_tx nb_trans_all, by(unit)

gen sh_trans_oh_tx = nb_trans_oh_tx/nb_trans_all
sum sh_trans_oh_tx
local rmm=r(mean)

di "The share of total transactions in OH and TX is " r(mean)

matrix s3_7 = (`rmm')
clear
svmat s3_7

rename s3_71 Figure
gen Label = ""
replace Label = "Share of transactions in Ohio and Texas over total transactions" if _n==1
order Label Figure

save "${figures}/nmbrs_s3_7.dta", replace

restore




********************************************************************************
* SECTION 3.3


*-------------------------------------------------------------------------------
* Percentage variation in actual and predicted prices - Hedonic regression

use "${datbuild}/d_pricechar_matchIHS_dominion.dta", clear  

local vars Engineltr Engineccm Fuelconsurban Fuelconsextraurban ///
Height Length Width Wheelbase EnginekW

foreach v of local vars {
	replace `v'=ln(`v')
	gen `v'_sq=`v'^2 
}


gen ln_fueleff_sq=ln_fueleff^2

replace NoofSeats=round(NoofSeats)
replace NoofGears=floor(NoofGears)
replace NoofCylinders=round(NoofCylinders)
replace NoofDoors=round(NoofDoors)

keep if year>=2004 & year<=2017

replace sprice=ln(sprice)

areg ln_weight Wheelbase Width Height i.NoofSeats , absorb(maker)
predict hat_weight, xb
gen miss_w=ln_weight==.
replace ln_weight=hat_weight if ln_weight==.

drop ln_weight_sq
gen ln_weight_sq=ln_weight^2

replace BodyType="SUV Closed" if BodyType=="Monospace"

encode BodyType, gen(BT)
encode BodyGroup, gen(BG)
drop BodyType BodyGroup
rename BT BodyType
rename BG BodyGroup

* Hedonic regression
reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year<=2007

predict char_hat
drop if char_hat==.

collapse  ///
 (mean) sprice char_hat [fw=NewReg], by(year)


*-------------------------------------------------------------------------------
sum sprice if year==2009
local logp09=r(mean)
sum sprice if year==2007
local logp07=r(mean)
sum sprice if year==2012
local logp12=r(mean)
di "Average yearly price growth between 2009 and 2012 is " (`logp12'-`logp09')/3
di "Total price growth between 2007 and 2012 is " (`logp12'-`logp07')

sum char_hat if year==2007
local logphat07=r(mean)
sum char_hat if year==2009
local logphat09=r(mean)
sum char_hat if year==2012
local logphat12=r(mean)
di "Average yearly predicted price growth between 2007 and 2012 is " (`logphat12'-`logphat07')/5
di "Total predicted price growth between 2007 and 2012 is " (`logphat12'-`logphat07')



matrix s3_8 = ((`logp12'-`logp09')*100/3 \ (`logp12'-`logp07')*100 \ (`logphat12'-`logphat07')*100)
clear
svmat s3_8

rename s3_81 Figure
gen Label = ""
replace Label = "Yearly growth of average price in 2009-2012 (perc. points)" if _n==1
replace Label = "Total growth of average price in 2007-2012 (perc. points)" if _n==2
replace Label = "Total growth of quality-predicted price in 2007-2012 (perc. points)" if _n==3
order Label Figure

save "${figures}/nmbrs_s3_8.dta", replace


*-------------------------------------------------------------------------------
* Change in hedonic prices of key characteristics

use "${datbuild}/d_pricechar_matchIHS_dominion.dta", clear  

local vars Engineltr Engineccm Fuelconsurban Fuelconsextraurban ///
Height Length Width Wheelbase EnginekW

foreach v of local vars {
	replace `v'=ln(`v')
	gen `v'_sq=`v'^2 
}

gen ln_fueleff_sq=ln_fueleff^2

keep if year>=2004 & year<=2017

replace sprice=ln(sprice)

areg ln_weight Wheelbase Width Height i.NoofSeats , absorb(maker)
predict hat_weight, xb
gen miss_w=ln_weight==.
replace ln_weight=hat_weight if ln_weight==.

drop ln_weight_sq
gen ln_weight_sq=ln_weight^2

replace BodyType="SUV Closed" if BodyType=="Monospace"

encode BodyType, gen(BT)
encode BodyGroup, gen(BG)
drop BodyType BodyGroup
rename BT BodyType
rename BG BodyGroup

* Pre-recession period
reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year<=2007

local beta_wb_pre = _b[Wheelbase]
local beta_hp_pre = _b[ln_HP]

* Post-Recession period
reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year>=2010

local beta_wb_post = _b[Wheelbase]
local beta_hp_post = _b[ln_HP]

* Percent increase in wheelbase hedonic price
di (`beta_wb_post'/`beta_wb_pre' -1)*100

* Percent increase in horse power hedonic price
di (`beta_hp_post'/`beta_hp_pre' -1)*100


matrix s3_9 = ((`beta_wb_post'/`beta_wb_pre' -1)*100 \ (`beta_hp_post'/`beta_hp_pre' -1)*100)
clear
svmat s3_9

rename s3_91 Figure
gen Label = ""
replace Label = "Pre-Post-recession percentage change in wheelbase hedonic price" if _n==1
replace Label = "Pre-Post-recession percentage change in horse power hedonic price" if _n==2
order Label Figure

save "${figures}/nmbrs_s3_9.dta", replace





*-------------------------------------------------------------------------------
* Percentage of the between SD drop predicted by characteristics

use "${datbuild}/d_pricechar_matchIHS_dominion.dta", clear  

local vars Engineltr Engineccm Fuelconsurban Fuelconsextraurban ///
Height Length Width Wheelbase EnginekW

foreach v of local vars {
	replace `v'=ln(`v')
	gen `v'_sq=`v'^2 
}

gen ln_fueleff_sq=ln_fueleff^2

keep if year>=2004 & year<=2017

replace sprice=ln(sprice)

areg ln_weight Wheelbase Width Height i.NoofSeats , absorb(maker)
predict hat_weight, xb
gen miss_w=ln_weight==.
replace ln_weight=hat_weight if ln_weight==.

drop ln_weight_sq
gen ln_weight_sq=ln_weight^2

replace BodyType="SUV Closed" if BodyType=="Monospace"

encode BodyType, gen(BT)
encode BodyGroup, gen(BG)
drop BodyType BodyGroup
rename BT BodyType
rename BG BodyGroup


* First, Fixed betas at 2004
reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
Wheelbase ///
i.NoofCylinders ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year>=2004 & year<=2007
predict char_all, xb


* Second, Time-varying betas
gen char_all_tv=.

* Pre-recession period
reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
Wheelbase ///
i.NoofCylinders ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year>=2004 & year<=2007

predict char_all_p1, xb
replace char_all_tv=char_all_p1 if year>=2004 & year<=2007 

* Recession period
reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
Wheelbase ///
i.NoofCylinders ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year==2008 | year==2009

predict char_all_p2, xb
replace char_all_tv=char_all_p2 if year==2008 | year==2009

* Keep new models only
keep if d_entry==1

collapse (sd) char_all_sd=char_all char_all_tv_sd=char_all_tv sprice_sd=sprice ///
(mean) char_all char_all_tv sprice [fw=NewReg], by(year)

keep if year==2007 | year==2008
tsset year, y

gen Data1=sprice-L1.sprice
gen All_NoW1=char_all-L1.char_all
gen All_tv_NoW1=char_all_tv-L1.char_all_tv

gen Data2=sprice_sd-L1.sprice_sd
gen All_NoW2=char_all_sd-L1.char_all_sd
gen All_tv_NoW2=char_all_tv_sd-L1.char_all_tv_sd

keep if year==2008

reshape long Data All_NoW All_tv_NoW, i(year) j(Ord)

gen Item="AVERAGE 2008 - AVERAGE 2007" if Ord==1
replace Item="ST. DEV. 2008 - ST. DEV. 2007" if Ord==2

rename All_NoW AllNoW
rename All_tv_NoW AlltvNoW


*-------------------------------------------------------------------------------
sum Data if Ord==2
local drop_sd_data=r(mean)
sum AllNoW if Ord==2
local drop_sd_fixedchar=r(mean)

local perc_expl = `drop_sd_fixedchar'/`drop_sd_data'*100
di "Characteristics predict " `perc_expl' "% of the drop in between model price standard deviation"


matrix s3_10 = (`perc_expl')
clear
svmat s3_10

rename s3_101 Figure
gen Label = ""
replace Label = "Percentage of between-model price standard deviation explained by characteristics" if _n==1
order Label Figure

save "${figures}/nmbrs_s3_10.dta", replace


********************************************************************************
* SECTION 3.4

*-------------------------------------------------------------------------------
* Decline in quality of new models between 2006 and 2008

use "${datbuild}/d_entryexit_models_IHS_char_regs.dta", clear

keep if year>=2004 & year<=2012

gen ln_wheelbase=ln(Wheelbase)
gen ln_width=ln(Width)
gen ln_height=ln(Height)
gen ln_length=ln(Length)
gen volume=Length*Width*Height
gen ln_volume=ln(volume)
gen ln_engineltr=ln(Engineltr)

reg ln_weight ln_wheelbase ln_width ln_height i.NoofSeats ln_engineltr
predict hat_weight, xb
replace ln_weight=hat_weight if ln_weight==.

areg ln_fueleff ln_HP ln_weight i.Turbo i.Manual i.Manual#c.year i.Diesel ///
i.year i.year#i.d_entry [aw=NewRegistrations], ///
absorb(maker_code)  vce(cluster maker_code)


local qual_new_06 = _b[2006.year]+_b[2006.year#1.d_entry]
local qual_new_08 = _b[2008.year]+_b[2008.year#1.d_entry]
local delta_qual = (`qual_new_08'-`qual_new_06')*100

di "Quality drop for new models between 2006 and 2008 is " `delta_qual' "percentage points"


matrix s3_11 = (`delta_qual')
clear
svmat s3_11

rename s3_111 Figure
gen Label = ""
replace Label = "Quality drop for new models in 2006-2008 (percentage points)" if _n==1
order Label Figure

save "${figures}/nmbrs_s3_11.dta", replace



********************************************************************************
* Export results to excel

use "${figures}/nmbrs_s2_1.dta", clear
append using "${figures}/nmbrs_s2_2.dta", force
append using "${figures}/nmbrs_s2_3.dta", force
append using "${figures}/nmbrs_s2_4.dta", force
append using "${figures}/nmbrs_s2_5.dta", force

forvalues n=1/11 {
	append using "${figures}/nmbrs_s3_`n'.dta", force
}

export excel "${figures}/tab_inpaper_figures_stata.xlsx", replace

forvalues n=1/5{
	erase "${figures}/nmbrs_s2_`n'.dta"
}
forvalues n=1/11 {
	erase "${figures}/nmbrs_s3_`n'.dta"
}