* an_RP_figureB9

* This dofile replicates appendix figure B9

set more off
cap log close

set scheme s2colorag

********************************************************************************
* Figure B9 - Panel (a) - Transactions of all and new models

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

* Plot transaction share and expenditure share on new models
gen nb_trans_all=1
gen nb_trans_new=1*d_new_model

collapse (sum) nb_trans_all nb_trans_new, by(year)

keep if year>=2004 & year<=2013

replace nb_trans_all=nb_trans_all/1000
replace nb_trans_new=nb_trans_new/1000

* Plot total number of transactions on any car and on new models
twoway (line nb_trans_all year, lc(dknavy) lp(solid) lw(thick)) || ///
(line nb_trans_new year if year>=2005, lc(dknavy) lp(dash) lw(thick)), ///
ytitle("Number of Transactions (Thousands)") xline(2007.5 2009.5) xtitle("Year") ///
legend(label(1 "All Models") label(2 "New Models") r(1) pos(6)) 
graph export "${figures}\fig_B9a.eps", replace


********************************************************************************
* Figure B9 - Panel (b) - Share of new models on total models available

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

keep model_id year d_new_model
duplicates drop model_id year, force




collapse (mean) d_new_model, by(year)

label var d_new_model "Share of New Models"
label var year "Year"
twoway line d_new_model year if year>=2005, lw(thick) lc(dknavy) xline(2007.5 2009.5) ///
yscale(range(0.15 0.3)) ylabel(0.15(.05)0.3)

graph export "${figures}\fig_B9b.eps", replace

