* an_RP_figureB7


set more off
cap log close

set scheme s2colorag

*******************************************************************************

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

* Keep years in a relevant time-window around the crisis
keep if year>=2004 & year<=2012

gen one=1

bys year: egen avg_price_year=mean(sprice)
bys year: egen transactions_year=sum(one)
egen avg_price_sample = mean(sprice)
egen transactions_sample = sum(one)
bys model_id: egen avg_price_model = mean(sprice)
bys model_id: egen transactions_model_sample = sum(one)

collapse (mean) avg_price_year avg_price_sample transactions_year transactions_model_sample ///
avg_price_model avg_price_model_year=sprice transactions_sample ///
(sum) transactions_model_year=one (max) d_new_model, by(year model_id)

xtset model_id year, y
tsfill, full

* Fill variables
bys year: egen tm_avgp=mean(avg_price_year)
replace avg_price_year=tm_avgp if avg_price_year==.

egen tm_avgps=mean(avg_price_sample)
replace avg_price_sample=tm_avgps if avg_price_sample==.

bys year: egen tm_trans=mean(transactions_year)
replace transactions_year=tm_trans if transactions_year==.

bys model_id: egen tm_trans_s=mean(transactions_model_sample)
replace transactions_model_sample=tm_trans_s if transactions_model_sample==.

bys model_id: egen tm_avgpm=mean(avg_price_model)
replace avg_price_model=tm_avgpm if avg_price_model==.

replace avg_price_model_year=0 if avg_price_model_year==.
replace transactions_model_year=0 if transactions_model_year==.

egen tm_trans_ss=mean(transactions_sample)
replace transactions_sample=tm_trans_ss if transactions_sample==.
 
replace d_new_model=0 if d_new_model==.

drop tm_*

****************************************
** Generate aggregate between component
gen trans_share_model_year = transactions_model_year/transactions_year
gen trans_share_model_sample = transactions_model_sample/transactions_sample


* Average price
gen avg_p_fixedp = (trans_share_model_year-trans_share_model_sample)*avg_price_model
gen avg_p_fixeds = (trans_share_model_sample)*(avg_price_model_year-avg_price_model)
gen avg_p_covar = (trans_share_model_year-trans_share_model_sample)*(avg_price_model_year-avg_price_model)
gen avg_p = trans_share_model_year*avg_price_model_year
gen avg_avg_p = trans_share_model_sample*avg_price_model

* Between component
gen bet_var_fixedp = (trans_share_model_year-trans_share_model_sample)*(avg_price_model-avg_price_sample)^2
gen bet_var_fixeds = (trans_share_model_sample)*((avg_price_model_year-avg_price_year)^2 - (avg_price_model-avg_price_sample)^2)
gen bet_var_covar = (trans_share_model_year-trans_share_model_sample)*((avg_price_model_year-avg_price_year)^2 - (avg_price_model-avg_price_sample)^2)
gen bet_var = trans_share_model_year*(avg_price_model_year-avg_price_year)^2 
gen avg_bet_var = trans_share_model_sample*(avg_price_model-avg_price_sample)^2


collapse (sum) avg_p_fixedp avg_p_fixeds avg_p_covar avg_p avg_avg_p ///
bet_var_fixedp bet_var_fixeds bet_var_covar bet_var avg_bet_var, by(year)


gen check_between = bet_var-avg_bet_var-(bet_var_fixedp+bet_var_fixeds+bet_var_covar)

ge check_avgp = avg_p-avg_avg_p-(avg_p_fixedp+avg_p_fixeds+avg_p_covar)

gen centered_avg_p = avg_p - avg_avg_p
gen centered_bet_var = bet_var - avg_bet_var


********************************************************************************
* Plot

gen avg_p_fixeds_cov=avg_p_fixeds+avg_p_covar
gen bet_var_fixeds_cov=bet_var_fixeds+bet_var_covar

replace centered_bet_var=centered_bet_var/10^7
replace bet_var_fixedp=bet_var_fixedp/10^7
replace bet_var_fixeds=bet_var_fixeds/10^7
replace bet_var_fixeds_cov=bet_var_fixeds_cov/10^7
replace bet_var_cov=bet_var_cov/10^7


twoway (line centered_bet_var year, lp(solid) lc(dknavy) lw(thick)) || ///
(line bet_var_fixedp year, lp(dash) lc(dknavy) lw(thick)), ///
ytitle("Between Variance (10^7)") xline(2007.5 2009.5) legend(label(1 "Centered Between Variance") label(2 "Fixed Price Deviation")  r(1))
graph export "${figures}\fig_B7.eps", replace


