* an_RP_figureB6

* This dofile generates plots for average price of the top-sold models
* in Dominion

set more off
cap log close

set scheme s2colorag

*******************************************************************************
use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

* Plot transaction share and expenditure share on new models
gen nb_transactions=1

collapse (mean) sprice (sum) nb_transactions (firstnm) make model_d2 ///
make_IHS model_IHS, by(model_id year)

bys model_id: egen total_transactions=sum(nb_transactions) if year==2008 | year==2009
gsort -total_transactions model_id year

* Drop years in which the number of transactions is below 20% of the average 
* to correct for initial year or last year
bys model_id: egen avg_transactions=mean(nb_transactions)
drop if nb_transactions<=0.2*avg_transactions

gsort -total_transactions model_id year

* First - top 5 models by sales in 2008-2009 with prices below 30k
preserve

keep if year==2008 | year==2009 
keep if sprice<=30000
keep total_transactions model_id
duplicates drop model_id, force
gsort -total_transactions model_id
gen increm=_n

keep if increm<=5
keep model_id total_transactions

save "${datbuild}/mod_list_be30.dta", replace

restore

* First - top 5 models by sales in 2008-2009 with prices above 30k
preserve

keep if year==2008 | year==2009 
keep if sprice>30000 & sprice!=.
keep total_transactions model_id
duplicates drop model_id, force
gsort -total_transactions model_id
gen increm=_n

keep if increm<=5
keep model_id total_transactions

append using "${datbuild}/mod_list_be30.dta"

gsort -total_transactions model_id
gen increm=_n
drop total_transactions

save "${datbuild}/mod_list.dta", replace
erase "${datbuild}/mod_list_be30.dta"

restore

merge m:1 model_id using "${datbuild}/mod_list.dta", keep(3) nogenerate
bys model_id: egen tb=mean(total_transactions)
drop total_transactions
rename tb total_transactions
gsort -total_transactions model_id year

*keep if increm<=10

label var year "Year"
label var sprice "Average Model Price (US Dollars)"



********************************************************************************
* Plot Figure B6

twoway (line sprice year if increm==1, lc(dknavy) lp(solid) lw(thick)) || ///
(line sprice year if increm==2, lc(dknavy) lp(dash) lw(thick)) || ///
(line sprice year if increm==3, lc(dknavy) lp(dash_dot) lw(thick)) || ///
(line sprice year if increm==4, lc(dknavy) lp(longdash) lw(thick)) || ///
(line sprice year if increm==5, lc(dknavy) lp(dot) lw(thick)) || ///
(line sprice year if increm==6, lc(dknavy*0.5) lp(solid) lw(thick)) || ///
(line sprice year if increm==7, lc(dknavy*0.5) lp(dash) lw(thick)) || ///
(line sprice year if increm==8, lc(dknavy*0.5) lp(dash_dot) lw(thick)) || ///
(line sprice year if increm==9, lc(dknavy*0.5) lp(longdash) lw(thick)) || ///
(line sprice year if increm==10, lc(dknavy*0.5) lp(dot) lw(thick)), ///
legend(label(1 "Honda Accord") label(2 "Toyota Camry") label(3 "Honda Civic") ///
label(4 "Toyota Corolla") label(5 "Nissan Altima") label(6 "Ford Edge") label(7 "Chevy Tahoe") ///
label(8 "Lexus RX") label(9 "Toyota Highlander") label(10 "GMC Acadia") r(5) pos(6)) xline(2007.5 2009.5)

graph export "${figures}\fig_B6.eps", replace

erase "${datbuild}/mod_list.dta"
