* an_RP_figureB5

* This dofile produces variance decomposition and related plots for the variance 
* of prices by year, decomposing the contribution of dispersion of model's prices
* for fixed market shares of each of the models versus reallocation of market
* shares towards models with a price closer / farther away from the mean

set more off
cap log close

set scheme s2colorag

*******************************************************************************
* ROBUSTNESS - FIGUE B5 - No fleet sales
* PRICE LEVELS AND THEIR VARIANCE

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

* Keep years in a relevant time-window around the crisis
keep if year>=2004 & year<=2012

keep if fleet==0

gen one=1

bys year: egen avg_price_year=mean(sprice)
bys year model_id: egen avg_price_model_year=mean(sprice)
bys year: egen tot_transactions=sum(one)
bys year: egen tot_transactions_newmod=sum(d_new_model)
bys year model_id: egen tot_model_transactions=sum(one)

* Generate blocks
gen within_model = (sprice-avg_price_model_year)^2
gen covariance = 2*(sprice-avg_price_model_year)*(avg_price_model_year-avg_price_year)

gen within_model_new=within_model*d_new_model
gen covariance_new=covariance*d_new_model

gen within_model_old=within_model*(1-d_new_model)
gen covariance_old=covariance*(1-d_new_model)

collapse (sum) within_model within_model_new covariance covariance_new within_model_old covariance_old ///
(mean) tot_model_transactions tot_transactions_newmod ///
tot_transactions avg_price_model_year ///
avg_price_year d_new_model, by(model_id year)

bys year: egen nb_models=count(model_id)
gen between_model_eqsh=((avg_price_model_year-avg_price_year)^2)*(1/nb_models)
gen between_model_desh=((avg_price_model_year-avg_price_year)^2)*(tot_model_transactions/tot_transactions-1/nb_models)
gen between_model_eqsh_new=between_model_eqsh*d_new_model
gen between_model_desh_new=between_model_desh*d_new_model
gen between_model_eqsh_old=between_model_eqsh*(1-d_new_model)
gen between_model_desh_old=between_model_desh*(1-d_new_model)

xtset model_id year, yearly

gen model_share_year=tot_model_transactions/tot_transactions

gen d_between_model_ds=(model_share_year-L1.model_share_year)*((avg_price_model_year-avg_price_year)^2)
gen d_between_model_fs=(L1.model_share_year)*((avg_price_model_year-avg_price_year)^2-(L1.avg_price_model_year-L1.avg_price_year)^2)


*** Generate decomposition with 2007 as a reference year
* Generate variables for fixed 2007 market shares
gen model_share_2007_t = model_share_year if year==2007
bys model_id: egen model_share_2007 = mean(model_share_2007_t)
drop model_share_2007_t

* Generate variables for fixed 2007 model-level dev. from the mean
gen model_sqdev_2007_t = (avg_price_model_year-avg_price_year)^2 if year==2007
bys model_id: egen model_sqdev_2007 = mean(model_sqdev_2007_t)
drop model_sqdev_2007_t

gen between_model_ds07=(model_share_year)*model_sqdev_2007
gen between_model_fs07=(model_share_2007)*(avg_price_model_year-avg_price_year)^2 

collapse (sum) within_model within_model_new covariance covariance_new within_model_old covariance_old ///
between_model_eqsh between_model_desh between_model_eqsh_new between_model_desh_new  between_model_eqsh_old between_model_desh_old ///
d_between_model_ds d_between_model_fs between_model_ds07 between_model_fs07 ///
(mean) tot_transactions tot_transactions_newmod, by(year)

replace within_model=(1/tot_transactions)*within_model
replace covariance=(1/tot_transactions)*covariance
gen between_model = between_model_desh+between_model_eqsh
replace within_model_new=(1/tot_transactions)*within_model_new
replace covariance_new=(1/tot_transactions)*covariance_new
gen between_model_new = between_model_desh_new+between_model_eqsh_new


replace within_model_old=(1/tot_transactions)*within_model_old
replace covariance_old=(1/tot_transactions)*covariance_old
gen between_model_old = between_model_desh_old+between_model_eqsh_old

gen between_model_newadj=between_model_new/(tot_transactions_newmod/tot_transactions)
gen within_model_newadj=(tot_transactions/tot_transactions_newmod)*within_model_new
gen covariance_newadj=(tot_transactions/tot_transactions_newmod)*covariance_new

gen between_model_oldadj=between_model_old*((tot_transactions-tot_transactions_newmod)/tot_transactions)
gen within_model_oldadj=(tot_transactions/(tot_transactions-tot_transactions_newmod))*within_model_old
gen covariance_oldadj=(tot_transactions/(tot_transactions-tot_transactions_newmod))*covariance_old


tsset year, yearly

gen d_between_model = between_model-L1.between_model
gen d_between_netentry = d_between_model-d_between_model_ds-d_between_model_fs
gen tot_var = within_model+covariance+between_model_eqsh+between_model_desh

gen transaction_share_new=tot_transactions_newmod/tot_transactions

********************************************************************************
* Plot total variance and the different components from the exact
* decomposition

replace tot_var=tot_var/10^7
replace within_model=within_model/10^7
replace covariance=covariance/10^7
replace between_model=between_model/10^7
replace within_model_new=within_model_new/10^7
replace covariance_new=covariance_new/10^7
replace between_model_new=between_model_new/10^7
gen tot_var_new=within_model_new+covariance_new+between_model_new

replace within_model_old=within_model_old/10^7
replace covariance_old=covariance_old/10^7
replace between_model_old=between_model_old/10^7
gen tot_var_old=within_model_old+covariance_old+between_model_old

replace within_model_newadj=within_model_newadj/10^7
replace covariance_newadj=covariance_newadj/10^7
replace between_model_newadj=between_model_newadj/10^7
gen tot_var_newadj=within_model_newadj+covariance_newadj+between_model_newadj

replace within_model_oldadj=within_model_oldadj/10^7
replace covariance_oldadj=covariance_oldadj/10^7
replace between_model_oldadj=between_model_oldadj/10^7
gen tot_var_oldadj=within_model_oldadj+covariance_oldadj+between_model_oldadj


* Specific figures - 2004
sum tot_var if year==2004
local tv_04=r(mean)
sum within_model if year==2004
local wv_04=r(mean)
sum between_model if year==2004
local bv_04=r(mean)
sum covariance if year==2004
local cv_04=r(mean)
di `wv_04'/`tv_04'
di `bv_04'/`tv_04'
di `cv_04'/`tv_04'


* Specific figures - 2007
sum tot_var if year==2007
local tv_07=r(mean)
sum within_model if year==2007
local wv_07=r(mean)
sum between_model if year==2007
local bv_07=r(mean)
di `wv_07'/`tv_07'
di `bv_07'/`tv_07'


* Figure 2 - a
twoway (line tot_var year, lp(solid) lc(dknavy) lw(thick)) ///
|| (line within_model year, lp(dash_dot) lc(dknavy) lw(thick)) || ///
(line between_model year, lp(longdash) lc(dknavy) lw(thick)), legend(label(1 "Total Variance") ///
label(3 "Between") label(2 "Within") ///
r(1) order(1 2 3)) yscale(range(0 25)) ylabel(0(5)25) ///
ytitle("Price Variance (10e7, US Dollars squared)") xtitle("Year") xline(2007.5 2009.5)
graph export "${figures}\fig_B5a.eps", replace


* Figure 2 - b
gen tot_var_existing=tot_var-tot_var_new
twoway (line tot_var year, lp(solid) lc(dknavy) lw(thick)) || ///
(line tot_var_existing year if year>=2005, lp(dash) lc(dknavy) lw(thick)) ///
|| (line tot_var_new year if year>=2005, lp(dash_dot) lc(dknavy) lw(thick)), legend(label(1 "Variance - All") ///
label(2 "Component - Old") label(3 "Component - New") r(1)) ///
ytitle("Price Variance (10e7, US Dollars squared)") xtitle("Year") xline(2007.5 2009.5)
graph export "${figures}\fig_B5b.eps", replace


* Figure 2 - c
twoway (line tot_var_newadj year if year>=2005, lp(solid) lc(dknavy) lw(thick)) ///
|| (line within_model_newadj year if year>=2005, lp(dash_dot) lc(dknavy) lw(thick)) || ///
(line between_model_newadj year if year>=2005, lp(longdash) lc(dknavy) lw(thick)), legend(label(1 "Tot. Variance - New") ///
label(3 "Between - New") label(2 "Within - New") ///
 r(1) order(1 2 3)) yscale(range(0 25)) ylabel(0(5)25) ///
ytitle("Price Variance - New (10e7, US Dollars squared)") xtitle("Year") xline(2007.5 2009.5)
graph export "${figures}\fig_B5c.eps", replace


* Figure 2 - d
twoway (line transaction_share_new year if year>=2005, lc(dknavy) lw(thick)), ///
ytitle("Share of Transactions on New Models") xline(2007.5 2009.5) xtitle("Year") ///
yscale(range(0 0.5)) ylabel(0(.1)0.5)
graph export "${figures}\fig_B5d.eps", replace




