* an_RP_figureB2

set more off
cap log close

set scheme s2colorag


********************************************************************************
* ROBSUTNESS - Fig. B2 Appendix - Exclude July and August of each year

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

* Drop all transactions in July and August
gen yfm=floor(mon/100)
gen month=(mon/100-yfm)*100
drop if month==8 | month==7

* Keep years in a relevant time-window around the crisis
keep if year>=2004 & year<=2012


sum sprice if d_new_model==1 & year>=2005 & year<=2007
sum sprice if d_new_model==0 & year>=2005 & year<=2007
sum sprice if year>=2005 & year<=2007

sum sprice if d_new_model==1 & year==2008
sum sprice if d_new_model==0 & year==2008
sum sprice if year==2008

gen lnsprice=ln(sprice)
gen nb_trans_all=1

collapse (mean) price_avg=sprice ///
(sd) price_sd=sprice (p10) lnsprice_p10=lnsprice ///
(p50) lnsprice_p50=lnsprice ///
(p90) lnsprice_p90=lnsprice (sum) nb_trans_all, by(year)

replace nb_trans_all=nb_trans_all/1000

tsset year

label var price_avg "Price Average (US Dollars)"
label var price_sd "Price Standard Dev. (US Dollars)"
label var lnsprice_p10 "10-th p."
label var lnsprice_p50 "50-th p."
label var lnsprice_p90 "90-th p."


sum price_avg if year==2007
sum price_avg if year==2008
sum price_sd if year==2007
sum price_sd if year==2008

label var year "Year"

* Take log-differences for percentiles
local vars2 lnsprice_p10 lnsprice_p50 lnsprice_p90
foreach v of local vars2 {

	sum `v' if year==2007
	replace `v'=(`v'-r(mean))

}

* Panel (a): Number of transactions
twoway (line nb_trans_all year, lc(dknavy) lp(solid) lw(thick)), ///
ytitle("Number of Transactions (Thousands)") xline(2007.5 2009.5) xtitle("Year")
graph export "${figures}\fig_B2a.eps", replace

* Panel (b): Average price
twoway line price_avg year, lw(thick) xline(2007.5 2009.5) lc(dknavy)
graph export "${figures}\fig_B2b.eps", replace

* Panel (c): Standard deviation
twoway line price_sd year, lw(thick) xline(2007.5 2009.5) lc(dknavy)
graph export "${figures}\fig_B2c.eps", replace

* Panel (d): Percentiles rel. to 2007
twoway (line lnsprice_p10 year, lc(dknavy) lp(solid) lw(thick))  ///
|| (line lnsprice_p50 year, lc(dknavy) lp(dash) lw(thick)) ///
|| (line lnsprice_p90 year, lc(dknavy) lp(shortdash_dot) lw(thick)), ///
xline(2007.5 2009.5) legend(r(1)) ytitle("Percentage Change Relative to 2007")
graph export "${figures}\fig_B2d.eps", replace



