* an_revision_backenv_dyn_quality_matchIHS_dominion

* This dofile performs back of the envelope calculations for the dynamic effect
* of the quality drop on new cars sales during the great recession

clear all
set more off
cap log close

set scheme s2colorag

********************************************************************************
********************************************************************************
* Start from running Knittel's equation 5, based on all models making up new sales
* and weighting them by their market shares 
 
 
 
 
use "${datbuild}/d_entryexit_models_IHS_char_regs.dta", clear

keep if year>=2004 & year<=2017

gen ln_wheelbase=ln(Wheelbase)
gen ln_width=ln(Width)
gen ln_height=ln(Height)
gen ln_length=ln(Length)
gen volume=Length*Width*Height
gen ln_volume=ln(volume)
gen ln_engineltr=ln(Engineltr)

reg ln_weight ln_wheelbase ln_width ln_height i.NoofSeats ln_engineltr
predict hat_weight, xb
replace ln_weight=hat_weight if ln_weight==.

areg ln_fueleff ln_HP ln_weight i.Turbo i.Manual i.Manual#c.year i.Diesel ///
i.year [fw=NewRegistrations], ///
absorb(maker_code)  vce(cluster maker_code)
estimates store results

sum year
global min=r(min)
global max=r(max)

	*Restore DiD estimates
	estimates restore results
	
	*Save coefficients

	forvalues i=$min /$max{
	
	* Yearly effect
	cap local b_m`i'_unm_all=_b[`i'.year]
	cap local see_m`i'_unm_all=_se[`i'.year]
	cap local ub_b_m`i'_unm_all=_b[`i'.year]+1.96*_se[`i'.year]
	cap local lb_b_m`i'_unm_all=_b[`i'.year]-1.96*_se[`i'.year]
	
	}
		
*Create dataset with coefficients
local sum=${max}-${min}+1
clear
set obs `sum'
ge t=_n-1

ge b_unm_all=0
ge see_unm_all=0
ge ub_b_unm_all=0
ge lb_b_unm_all=0

gen year=t + $min

*Replace OLS coefficients

*Replace pre-trends
forvalues i=$min / $max {

cap replace b_unm_all=`b_m`i'_unm_all' if year==`i'
cap replace see_unm_all=`see_m`i'_unm_all' if year==`i'
cap replace ub_b_unm_all=`ub_b_m`i'_unm_all' if year==`i'
cap replace lb_b_unm_all=`lb_b_m`i'_unm_all' if year==`i'

}


keep if year>=2004 & year<=2012
drop t

********************************************************************************
* Keep relevant variables and rename

rename b_unm_all rel_new_qual
rename ub_b_unm_all ub_rel_new_qual
rename lb_b_unm_all lb_rel_new_qual




replace rel_new_qual = rel_new_qual+1
replace ub_rel_new_qual = ub_rel_new_qual+1
replace lb_rel_new_qual = lb_rel_new_qual+1


* Get the average yearly growth factor of quality of new sales between 2007 and 2004
sum rel_new_qual if year==2007
gen avg_rel_new_qual=(r(mean))^(1/3)

* The yearly average is around 0.92%. This figure is useful to compute the average
* quality od the stock relative to the quality of new sales in 2004 (normalized to 1)
* and to compute the cunterfactual trend absent the great recession




gen knittel_coeff=rel_new_qual-1
keep year knittel_coeff rel_new_qual avg_rel_new_qual 
order  year knittel_coeff rel_new_qual avg_rel_new_qual 
export excel "${datbuild}/d_knittel_all_weighted.xls", replace firstrow(variables)
