* an_RP_figureB16

* This dofile performs production possibility frontier regressions along the lines
* of equations  Knittel (2011, AER) 

clear all
set more off
cap log close

set scheme s2colorag



********************************************************************************
* Figure B16 (a) - SALESS WEIGHTED


use "${datbuild}/d_entryexit_models_IHS_char_regs.dta", clear

keep if year>=2004 & year<=2012

gen ln_wheelbase=ln(Wheelbase)
gen ln_width=ln(Width)
gen ln_height=ln(Height)
gen ln_length=ln(Length)
gen volume=Length*Width*Height
gen ln_volume=ln(volume)
gen ln_engineltr=ln(Engineltr)

reg ln_weight ln_wheelbase ln_width ln_height i.NoofSeats ln_engineltr
predict hat_weight, xb
replace ln_weight=hat_weight if ln_weight==.

areg ln_fueleff ln_HP ln_weight ///
 i.Turbo i.Manual i.Manual#c.year i.Diesel ///
i.year [fw=NewRegistrations], ///
absorb(maker_code)  vce(cluster maker_code)
estimates store results

sum year
global min=r(min)
global max=r(max)

preserve
		*Restore DiD estimates
		estimates restore results

		mat vc = e(V)
		
		*Save coefficients

		forvalues i=$min /$max{
		
		* Baseline for all models
		cap local b_m`i'_unm_all=_b[`i'.year]
		cap local see_m`i'_unm_all=_se[`i'.year]
		cap local ub_b_m`i'_unm_all=_b[`i'.year]+1.96*_se[`i'.year]
		cap local lb_b_m`i'_unm_all=_b[`i'.year]-1.96*_se[`i'.year]

		}
		
*Create dataset with coefficients
local sum=${max}-${min}+1
clear
set obs `sum'
ge t=_n-1

ge b_unm_all=0
ge see_unm_all=0
ge ub_b_unm_all=0
ge lb_b_unm_all=0

gen year=t + $min

*Replace OLS coefficients

*Replace pre-trends
forvalues i=$min / $max {

cap replace b_unm_all=`b_m`i'_unm_all' if year==`i'
cap replace see_unm_all=`see_m`i'_unm_all' if year==`i'
cap replace ub_b_unm_all=`ub_b_m`i'_unm_all' if year==`i'
cap replace lb_b_unm_all=`lb_b_m`i'_unm_all' if year==`i'


}

label var b_unm_all "All Models"

keep if year>=2004 & year<=2012

*Twoway graph
twoway  ///
(scatter b_unm_all year, mc(dknavy)) ///
(rcap ub_b_unm_all lb_b_unm_all year, lc(dknavy)), ///
xtitle("Year") ytitle("Car Quality (% Deviation Rel. to 2004)") yline(0, lcolor(black)) ///
 plotregion(color(white)) ///
 legend(order(1 "Point Estimate" 2 "95% C.I.")) ///
tline(2007.5 2009.5)

graph export "${figures}\fig_B16a.eps", replace

restore




********************************************************************************
* Figure B16 - Panel (b) - NO WEIGHT

use "${datbuild}/d_entryexit_models_IHS_char_regs.dta", clear

keep if year>=2004 & year<=2012

gen ln_wheelbase=ln(Wheelbase)
gen ln_width=ln(Width)
gen ln_height=ln(Height)
gen ln_length=ln(Length)
gen volume=Length*Width*Height
gen ln_volume=ln(volume)
gen ln_engineltr=ln(Engineltr)

reg ln_weight ln_wheelbase ln_width ln_height i.NoofSeats ln_engineltr
predict hat_weight, xb
replace ln_weight=hat_weight if ln_weight==.

areg ln_fueleff ln_HP ln_weight ///
 i.Turbo i.Manual i.Manual#c.year i.Diesel ///
i.year, ///
absorb(maker_code)  vce(cluster maker_code)
estimates store results

sum year
global min=r(min)
global max=r(max)

preserve
		*Restore DiD estimates
		estimates restore results

		mat vc = e(V)
		
		*Save coefficients

		forvalues i=$min /$max{
		
		* Baseline for all models
		cap local b_m`i'_unm_all=_b[`i'.year]
		cap local see_m`i'_unm_all=_se[`i'.year]
		cap local ub_b_m`i'_unm_all=_b[`i'.year]+1.96*_se[`i'.year]
		cap local lb_b_m`i'_unm_all=_b[`i'.year]-1.96*_se[`i'.year]

		}
		
*Create dataset with coefficients
local sum=${max}-${min}+1
clear
set obs `sum'
ge t=_n-1

ge b_unm_all=0
ge see_unm_all=0
ge ub_b_unm_all=0
ge lb_b_unm_all=0

gen year=t + $min

*Replace OLS coefficients

*Replace pre-trends
forvalues i=$min / $max {

cap replace b_unm_all=`b_m`i'_unm_all' if year==`i'
cap replace see_unm_all=`see_m`i'_unm_all' if year==`i'
cap replace ub_b_unm_all=`ub_b_m`i'_unm_all' if year==`i'
cap replace lb_b_unm_all=`lb_b_m`i'_unm_all' if year==`i'


}

label var b_unm_all "All Models"

keep if year>=2004 & year<=2012
*Twoway graph

twoway  ///
(scatter b_unm_all year, mc(dknavy)) ///
(rcap ub_b_unm_all lb_b_unm_all year, lc(dknavy)), ///
xtitle("Year") ytitle("Car Quality (% Deviation Rel. to 2004)") yline(0, lcolor(black)) ///
 plotregion(color(white)) ///
 legend(order(1 "Point Estimate" 2 "95% C.I.")) ///
tline(2007.5 2009.5)

graph export "${figures}\fig_B16b.eps", replace


restore

