* an_RP_figureB15

* This dofile performs production possibility frontier regressions along the lines
* of equations  Knittel (2011, AER) 

* Distinguishes whether a new model is a new generation of a previously existing
* car model or it's a brand new car name

clear all
set more off
cap log close

set scheme s2colorag



********************************************************************************
* Figure B15

use "${datbuild}/d_entryexit_models_IHS_char_regs.dta", clear

* Identify first "generation" (in the data) by model
sort Make Model GenerationYear, stable
by Make Model: egen first_GY=min(GenerationYear)
gen d_firstgen=first_GY==GenerationYear
drop first_GY

keep if year>=2004 & year<=2012

gen ln_wheelbase=ln(Wheelbase)
gen ln_width=ln(Width)
gen ln_height=ln(Height)
gen ln_length=ln(Length)
gen volume=Length*Width*Height
gen ln_volume=ln(volume)
gen ln_engineltr=ln(Engineltr)

reg ln_weight ln_wheelbase ln_width ln_height i.NoofSeats ln_engineltr
predict hat_weight, xb
replace ln_weight=hat_weight if ln_weight==.


gen d_entry_gen=d_entry
replace d_entry_gen=2 if d_firstgen==1 & d_entry==1
* Can identify new models only from 2005 onwards
replace d_entry_gen=0 if year==2004

areg ln_fueleff ln_HP ln_weight i.Turbo i.Manual i.Manual#c.year i.Diesel ///
ib2004.year ib2004.year#ib0.d_entry_gen, ///
absorb(maker_code)  vce(cluster maker_code)
estimates store results

sum year
global min=r(min)
global max=r(max)

preserve
		*Restore DiD estimates
		estimates restore results

		mat vc = e(V)
		
		*Save coefficients

		forvalues i=$min /$max{
		
		local r = rownumb(vc, "`i'.year#1.d_entry_gen")
		local r2 = rownumb(vc, "`i'.year#2.d_entry_gen")
		local cy = colnumb(vc, "`i'.year")
		local ry = rownumb(vc, "`i'.year")
		local e = colnumb(vc, "1.d_entry_gen")
		local e2 = colnumb(vc, "2.d_entry_gen")
		
		* Baseline for all models
		cap local b_m`i'_unm_all=_b[`i'.year]
		cap local see_m`i'_unm_all=_se[`i'.year]
		cap local ub_b_m`i'_unm_all=_b[`i'.year]+1.96*_se[`i'.year]
		cap local lb_b_m`i'_unm_all=_b[`i'.year]-1.96*_se[`i'.year]
		
		* Entering models - First gen
		cap local b_m`i'_unm_entry_fg=_b[`i'.year]+_b[`i'.year#2.d_entry]
		cap local see_m`i'_unm_entry_fg=_se[`i'.year#2.d_entry]
		cap local ub_b_m`i'_unm_entry_fg=_b[`i'.year]+_b[`i'.year#2.d_entry]+ ///
		1.96*sqrt(vc[`r2', `r2']+vc[`cy', `cy']+2*vc[`r2', `cy'])
		cap local lb_b_m`i'_unm_entry_fg=_b[`i'.year]+_b[`i'.year#2.d_entry]- ///
		1.96*sqrt(vc[`r2', `r2']+vc[`cy', `cy']+2*vc[`r2', `cy'])
		
		* Entering models - Subsequent gen.
		cap local b_m`i'_unm_entry_sg=_b[`i'.year]+_b[`i'.year#1.d_entry]
		cap local see_m`i'_unm_entry_sg=_se[`i'.year#1.d_entry]
		cap local ub_b_m`i'_unm_entry_sg=_b[`i'.year]+_b[`i'.year#1.d_entry]+ ///
		1.96*sqrt(vc[`r', `r']+vc[`cy', `cy']+2*vc[`r', `cy'])
		cap local lb_b_m`i'_unm_entry_sg=_b[`i'.year]+_b[`i'.year#1.d_entry]- ///
		1.96*sqrt(vc[`r', `r']+vc[`cy', `cy']+2*vc[`r', `cy'])

		}
		
*Create dataset with coefficients
local sum=${max}-${min}+1
clear
set obs `sum'
ge t=_n-1

ge b_unm_all=0
ge see_unm_all=0
ge ub_b_unm_all=0
ge lb_b_unm_all=0

ge b_unm_entry_fg=0
ge see_unm_entry_fg=0
ge ub_b_unm_entry_fg=0
ge lb_b_unm_entry_fg=0

ge b_unm_entry_sg=0
ge see_unm_entry_sg=0
ge ub_b_unm_entry_sg=0
ge lb_b_unm_entry_sg=0


gen year=t + $min

*Replace OLS coefficients

*Replace pre-trends
forvalues i=$min / $max {

cap replace b_unm_all=`b_m`i'_unm_all' if year==`i'
cap replace see_unm_all=`see_m`i'_unm_all' if year==`i'
cap replace ub_b_unm_all=`ub_b_m`i'_unm_all' if year==`i'
cap replace lb_b_unm_all=`lb_b_m`i'_unm_all' if year==`i'

cap replace b_unm_entry_fg=`b_m`i'_unm_entry_fg' if year==`i'
cap replace see_unm_entry_fg=`see_m`i'_unm_entry_fg' if year==`i'
cap replace ub_b_unm_entry_fg=`ub_b_m`i'_unm_entry_fg' if year==`i'
cap replace lb_b_unm_entry_fg=`lb_b_m`i'_unm_entry_fg' if year==`i'

cap replace b_unm_entry_sg=`b_m`i'_unm_entry_sg' if year==`i'
cap replace see_unm_entry_sg=`see_m`i'_unm_entry_sg' if year==`i'
cap replace ub_b_unm_entry_sg=`ub_b_m`i'_unm_entry_sg' if year==`i'
cap replace lb_b_unm_entry_sg=`lb_b_m`i'_unm_entry_sg' if year==`i'

}

label var b_unm_all "Old Models"
label var b_unm_entry_fg "New - First Gen."
label var b_unm_entry_fg "New - Subs. Gen."


keep if year>=2004 & year<=2012
*Twoway graph

gen year_p1=year+0.1
gen year_p2=year+0.2

twoway  ///
(scatter b_unm_all year, mc(dknavy)) ///
(rcap ub_b_unm_all lb_b_unm_all year, lc(dknavy)) ///
(scatter b_unm_entry_fg year_p1, mc(dknavy*0.66)) ///
(rcap ub_b_unm_entry_fg lb_b_unm_entry_fg year_p1, lc(dknavy*0.66)) ///
(scatter b_unm_entry_sg year_p2, mc(dknavy*0.33)) ///
(rcap ub_b_unm_entry_sg lb_b_unm_entry_sg year_p2, lc(dknavy*0.33)), ///
xtitle("Year") ytitle("Car Quality (% Deviation Rel. to 2004)") yline(0, lcolor(black)) ///
 plotregion(color(white)) ///
 legend(order(1 "Old Models" 2 "Old M. - 95% C.I." 3 "New - First Gen." 4 "New F.G. - 95% C.I." 5 "New - Subs. Gen." 4 "New S.G. - 95% C.I.")) ///
tline(2007.5 2009.5)

graph export "${figures}\fig_B15.eps", replace

restore



