* an_RP_figureB14

clear all
set more off
cap log close

set scheme s2colorag

********************************************************************************

use "${datbuild}/d_entryexit_models_IHS_char_regs.dta", clear

keep if year>=2004 & year<=2017

gen ln_wheelbase=ln(Wheelbase)
gen ln_width=ln(Width)
gen ln_height=ln(Height)
gen ln_length=ln(Length)
gen volume=Length*Width*Height
gen ln_volume=ln(volume)
gen ln_engineltr=ln(Engineltr)

reg ln_weight ln_wheelbase ln_width ln_height i.NoofSeats ln_engineltr
predict hat_weight, xb
replace ln_weight=hat_weight if ln_weight==.


* Specify the regions of the makers
gen make_region="USA" if Make=="Cadillac" | Make=="Chevrolet" | Make=="Chrysler" ///
| Make=="Dodge" | Make=="Ford" | Make=="GEM Car" | Make=="GMC" | Make=="Hummer" ///
| Make=="Jeep" | Make=="Lincoln" | Make=="Mercury" | Make=="Oldsmobile" ///
| Make=="Plymouth" | Make=="Pontiac" | Make=="Ram" | Make=="SRT" | Make=="Saturn" ///
| Make=="Tesla" | Make=="Think"

replace make_region="Europe" if Make=="Alfa Romeo" | Make=="Alpina" | Make=="Aston Martin" ///
| Make=="Audi" | Make=="BMW" | Make=="Bentley" | Make=="Bugatti" | Make=="Buick" ///
| Make=="Ferrari" | Make=="Fiat" | Make=="Jaguar" | Make=="Lamborghini" | Make=="Land Rover" ///
| Make=="Lotus" | Make=="Maserati" | Make=="Maybach" | Make=="McLaren" | Make=="Mercedes-Benz" ///
| Make=="Mini" | Make=="Porsche" | Make=="Rolls-Royce" | Make=="Saab" | Make=="Smart" ///
| Make=="Volkswagen" | Make=="Volvo"


replace make_region="Asia" if Make=="Acura" | Make=="Daewoo" | Make=="Genesis" ///
| Make=="Honda" | Make=="Hyundai" | Make=="Infiniti" | Make=="Isuzu" | Make=="Karma" ///
| Make=="Kia" | Make=="Lexus" | Make=="Mazda" | Make=="Mitsubishi" | Make=="Nissan" ///
| Make=="Scion" | Make=="Subaru" | Make=="Suzuki" | Make=="Toyota"



keep if year>=2004 & year<=2017

replace NoofSeats=round(NoofSeats)
replace Turbo=round(Turbo)
replace Manual=round(Manual)
replace Diesel=round(Diesel)





********************************************************************************
* Figure B14 - Panel (a) - EUROPEAN MAKERS

* UNWEIGHTED
areg ln_fueleff ln_HP ln_weight i.Turbo i.Manual i.Manual#c.year i.Diesel ///
i.year i.year#ib0.d_entry if make_region=="Europe", ///
absorb(maker_code) vce(cluster maker_code)
estimates store results

sum year
global min=r(min)
global max=r(max)

preserve
		*Restore DiD estimates
		estimates restore results

		mat vc = e(V)
		
		*Save coefficients

		forvalues i=$min /$max{
		
		local r = rownumb(vc, "`i'.year#1.d_entry")
		local c = colnumb(vc, "`i'.year")
		
		* Baseline for all models
		cap local b_m`i'_unm_all=_b[`i'.year]
		cap local see_m`i'_unm_all=_se[`i'.year]
		cap local ub_b_m`i'_unm_all=_b[`i'.year]+1.96*_se[`i'.year]
		cap local lb_b_m`i'_unm_all=_b[`i'.year]-1.96*_se[`i'.year]
		
		* Entering models
		cap local b_m`i'_unm_entry=_b[`i'.year]+_b[`i'.year#1.d_entry]
		cap local see_m`i'_unm_entry=_se[`i'.year#1.d_entry]
		cap local ub_b_m`i'_unm_entry=_b[`i'.year]+_b[`i'.year#1.d_entry]+1.96*sqrt(vc[`r', `r']+vc[`c', `c']+2*vc[`r', `c'])
		cap local lb_b_m`i'_unm_entry=_b[`i'.year]+_b[`i'.year#1.d_entry]-1.96*sqrt(vc[`r', `r']+vc[`c', `c']+2*vc[`r', `c'])

		}
		
*Create dataset with coefficients
local sum=${max}-${min}+1
clear
set obs `sum'
ge t=_n-1

ge b_unm_all=0
ge see_unm_all=0
ge ub_b_unm_all=0
ge lb_b_unm_all=0

ge b_unm_entry=0
ge see_unm_entry=0
ge ub_b_unm_entry=0
ge lb_b_unm_entry=0


gen year=t + $min

*Replace OLS coefficients

*Replace pre-trends
forvalues i=$min / $max {

cap replace b_unm_all=`b_m`i'_unm_all' if year==`i'
cap replace see_unm_all=`see_m`i'_unm_all' if year==`i'
cap replace ub_b_unm_all=`ub_b_m`i'_unm_all' if year==`i'
cap replace lb_b_unm_all=`lb_b_m`i'_unm_all' if year==`i'

cap replace b_unm_entry=`b_m`i'_unm_entry' if year==`i'
cap replace see_unm_entry=`see_m`i'_unm_entry' if year==`i'
cap replace ub_b_unm_entry=`ub_b_m`i'_unm_entry' if year==`i'
cap replace lb_b_unm_entry=`lb_b_m`i'_unm_entry' if year==`i'


}

label var b_unm_all "Old Models"
label var b_unm_entry "New Models"


keep if year>=2004 & year<=2012
*Twoway graph

twoway  ///
(scatter b_unm_all year, mc(dknavy)) ///
(rcap ub_b_unm_all lb_b_unm_all year, lc(dknavy)) ///
(scatter b_unm_entry year, mc(dknavy*0.5)) ///
(rcap ub_b_unm_entry lb_b_unm_entry year, lc(dknavy*0.5)), ///
xtitle("Year") ytitle("Car Quality (% Deviation Rel. to 2004)") yline(0, lcolor(black)) ///
 plotregion(color(white)) ///
 legend(order(1 "Old Models" 2 "Old M. - 95% C.I." 3 "New Models" 4 "New M. - 95% C.I.")) ///
tline(2007.5 2009.5) yscale(r(-0.1 0.2)) ylabel(-0.1(0.05)0.2)
graph export "${figures}\fig_B14a.eps", replace


sum b_unm_entry if year==2007
local qln_07_en_nw=r(mean)
sum b_unm_entry if year==2009
local qln_09_en_nw=r(mean)
di `qln_09_en_nw'-`qln_07_en_nw'
di (`qln_09_en_nw'-`qln_07_en_nw')/`qln_07_en_nw'

sum b_unm_entry if year==2008
local qln_08_en_nw=r(mean)
di `qln_08_en_nw'-`qln_07_en_nw'
di (`qln_08_en_nw'-`qln_07_en_nw')/`qln_07_en_nw'

sum b_unm_all if year==2007
local qln_07_all_nw=r(mean)
sum b_unm_all if year==2009
local qln_09_all_nw=r(mean)
di `qln_09_all_nw'-`qln_07_all_nw'
di (`qln_09_all_nw'-`qln_07_all_nw')/`qln_07_all_nw'


restore







********************************************************************************
* Figure B14 - Panel (b) ASIAN MAKERS

* UNWEIGHTED
areg ln_fueleff ln_HP ln_weight i.Turbo i.Manual i.Manual#c.year i.Diesel ///
i.year i.year#ib0.d_entry if make_region=="Asia", ///
absorb(maker_code) vce(cluster maker_code)
estimates store results

sum year
global min=r(min)
global max=r(max)

preserve
		*Restore DiD estimates
		estimates restore results

		mat vc = e(V)
		
		*Save coefficients

		forvalues i=$min /$max{
		
		local r = rownumb(vc, "`i'.year#1.d_entry")
		local c = colnumb(vc, "`i'.year")
		
		* Baseline for all models
		cap local b_m`i'_unm_all=_b[`i'.year]
		cap local see_m`i'_unm_all=_se[`i'.year]
		cap local ub_b_m`i'_unm_all=_b[`i'.year]+1.96*_se[`i'.year]
		cap local lb_b_m`i'_unm_all=_b[`i'.year]-1.96*_se[`i'.year]
		
		* Entering models
		cap local b_m`i'_unm_entry=_b[`i'.year]+_b[`i'.year#1.d_entry]
		cap local see_m`i'_unm_entry=_se[`i'.year#1.d_entry]
		cap local ub_b_m`i'_unm_entry=_b[`i'.year]+_b[`i'.year#1.d_entry]+1.96*sqrt(vc[`r', `r']+vc[`c', `c']+2*vc[`r', `c'])
		cap local lb_b_m`i'_unm_entry=_b[`i'.year]+_b[`i'.year#1.d_entry]-1.96*sqrt(vc[`r', `r']+vc[`c', `c']+2*vc[`r', `c'])

		}
		
*Create dataset with coefficients
local sum=${max}-${min}+1
clear
set obs `sum'
ge t=_n-1

ge b_unm_all=0
ge see_unm_all=0
ge ub_b_unm_all=0
ge lb_b_unm_all=0

ge b_unm_entry=0
ge see_unm_entry=0
ge ub_b_unm_entry=0
ge lb_b_unm_entry=0


gen year=t + $min

*Replace OLS coefficients

*Replace pre-trends
forvalues i=$min / $max {

cap replace b_unm_all=`b_m`i'_unm_all' if year==`i'
cap replace see_unm_all=`see_m`i'_unm_all' if year==`i'
cap replace ub_b_unm_all=`ub_b_m`i'_unm_all' if year==`i'
cap replace lb_b_unm_all=`lb_b_m`i'_unm_all' if year==`i'

cap replace b_unm_entry=`b_m`i'_unm_entry' if year==`i'
cap replace see_unm_entry=`see_m`i'_unm_entry' if year==`i'
cap replace ub_b_unm_entry=`ub_b_m`i'_unm_entry' if year==`i'
cap replace lb_b_unm_entry=`lb_b_m`i'_unm_entry' if year==`i'


}

label var b_unm_all "Old Models"
label var b_unm_entry "New Models"


keep if year>=2004 & year<=2012
*Twoway graph

twoway  ///
(scatter b_unm_all year, mc(dknavy)) ///
(rcap ub_b_unm_all lb_b_unm_all year, lc(dknavy)) ///
(scatter b_unm_entry year, mc(dknavy*0.5)) ///
(rcap ub_b_unm_entry lb_b_unm_entry year, lc(dknavy*0.5)), ///
xtitle("Year") ytitle("Car Quality (% Deviation Rel. to 2004)") yline(0, lcolor(black)) ///
 plotregion(color(white))  ///
 legend(order(1 "Old Models" 2 "Old M. - 95% C.I." 3 "New Models" 4 "New M. - 95% C.I.")) ///
tline(2007.5 2009.5) yscale(r(-0.1 0.2)) ylabel(-0.1(0.05)0.2)
graph export "${figures}\fig_B14b.eps", replace


sum b_unm_entry if year==2007
local qln_07_en_nw=r(mean)
sum b_unm_entry if year==2009
local qln_09_en_nw=r(mean)
di `qln_09_en_nw'-`qln_07_en_nw'
di (`qln_09_en_nw'-`qln_07_en_nw')/`qln_07_en_nw'

sum b_unm_entry if year==2008
local qln_08_en_nw=r(mean)
di `qln_08_en_nw'-`qln_07_en_nw'
di (`qln_08_en_nw'-`qln_07_en_nw')/`qln_07_en_nw'

sum b_unm_all if year==2007
local qln_07_all_nw=r(mean)
sum b_unm_all if year==2009
local qln_09_all_nw=r(mean)
di `qln_09_all_nw'-`qln_07_all_nw'
di (`qln_09_all_nw'-`qln_07_all_nw')/`qln_07_all_nw'



restore







********************************************************************************
* Figure B14 - Panel (c) US MAKERS

* UNWEIGHTED
areg ln_fueleff ln_HP ln_weight i.Turbo i.Manual i.Manual#c.year i.Diesel ///
i.year i.year#ib0.d_entry if make_region=="USA", ///
absorb(maker_code) vce(cluster maker_code)
estimates store results

sum year
global min=r(min)
global max=r(max)

preserve
		*Restore DiD estimates
		estimates restore results

		mat vc = e(V)
		
		*Save coefficients

		forvalues i=$min /$max{
		
		local r = rownumb(vc, "`i'.year#1.d_entry")
		local c = colnumb(vc, "`i'.year")
		
		* Baseline for all models
		cap local b_m`i'_unm_all=_b[`i'.year]
		cap local see_m`i'_unm_all=_se[`i'.year]
		cap local ub_b_m`i'_unm_all=_b[`i'.year]+1.96*_se[`i'.year]
		cap local lb_b_m`i'_unm_all=_b[`i'.year]-1.96*_se[`i'.year]
		
		* Entering models
		cap local b_m`i'_unm_entry=_b[`i'.year]+_b[`i'.year#1.d_entry]
		cap local see_m`i'_unm_entry=_se[`i'.year#1.d_entry]
		cap local ub_b_m`i'_unm_entry=_b[`i'.year]+_b[`i'.year#1.d_entry]+1.96*sqrt(vc[`r', `r']+vc[`c', `c']+2*vc[`r', `c'])
		cap local lb_b_m`i'_unm_entry=_b[`i'.year]+_b[`i'.year#1.d_entry]-1.96*sqrt(vc[`r', `r']+vc[`c', `c']+2*vc[`r', `c'])

		}
		
*Create dataset with coefficients
local sum=${max}-${min}+1
clear
set obs `sum'
ge t=_n-1

ge b_unm_all=0
ge see_unm_all=0
ge ub_b_unm_all=0
ge lb_b_unm_all=0

ge b_unm_entry=0
ge see_unm_entry=0
ge ub_b_unm_entry=0
ge lb_b_unm_entry=0


gen year=t + $min

*Replace OLS coefficients

*Replace pre-trends
forvalues i=$min / $max {

cap replace b_unm_all=`b_m`i'_unm_all' if year==`i'
cap replace see_unm_all=`see_m`i'_unm_all' if year==`i'
cap replace ub_b_unm_all=`ub_b_m`i'_unm_all' if year==`i'
cap replace lb_b_unm_all=`lb_b_m`i'_unm_all' if year==`i'

cap replace b_unm_entry=`b_m`i'_unm_entry' if year==`i'
cap replace see_unm_entry=`see_m`i'_unm_entry' if year==`i'
cap replace ub_b_unm_entry=`ub_b_m`i'_unm_entry' if year==`i'
cap replace lb_b_unm_entry=`lb_b_m`i'_unm_entry' if year==`i'


}

label var b_unm_all "Old Models"
label var b_unm_entry "New Models"


keep if year>=2004 & year<=2012
*Twoway graph

twoway  ///
(scatter b_unm_all year, mc(dknavy)) ///
(rcap ub_b_unm_all lb_b_unm_all year, lc(dknavy)) ///
(scatter b_unm_entry year, mc(dknavy*0.5)) ///
(rcap ub_b_unm_entry lb_b_unm_entry year, lc(dknavy*0.5)), ///
xtitle("Year") ytitle("Car Quality (% Deviation Rel. to 2004)") yline(0, lcolor(black)) ///
 plotregion(color(white)) ///
 legend(order(1 "Old Models" 2 "Old M. - 95% C.I." 3 "New Models" 4 "New M. - 95% C.I.")) ///
tline(2007.5 2009.5) yscale(r(-0.1 0.2)) ylabel(-0.1(0.05)0.2)
graph export "${figures}\fig_B14c.eps", replace


sum b_unm_entry if year==2007
local qln_07_en_nw=r(mean)
sum b_unm_entry if year==2009
local qln_09_en_nw=r(mean)
di `qln_09_en_nw'-`qln_07_en_nw'
di (`qln_09_en_nw'-`qln_07_en_nw')/`qln_07_en_nw'

sum b_unm_entry if year==2008
local qln_08_en_nw=r(mean)
di `qln_08_en_nw'-`qln_07_en_nw'
di (`qln_08_en_nw'-`qln_07_en_nw')/`qln_07_en_nw'

sum b_unm_all if year==2007
local qln_07_all_nw=r(mean)
sum b_unm_all if year==2009
local qln_09_all_nw=r(mean)
di `qln_09_all_nw'-`qln_07_all_nw'
di (`qln_09_all_nw'-`qln_07_all_nw')/`qln_07_all_nw'



restore











