* an_RP_figureB12

* This dofile performs hedonic price regression

clear all
set more off
cap log close

set scheme s2colorag

********************************************************************************
* Figure B12 - Panels (a) and (b)

use "${datbuild}/d_pricechar_matchIHS_dominion.dta", clear  

gen one=1
collapse (mean) Turbo Manual D4x4 NoofDoors Engineltr Engineccm EnginekW EngineHP ///
NoofCylinders NoofGears NoofSeats Fuelconscombined Fuelconsurban Fuelconsextraurban ///
GrossVehicleWeight Height Length Width Wheelbase Diesel ///
d_entry maker_code FuelEfficiency sprice (firstnm) BodyGroup BodyType DrivenWheels ///
(sum) one [fw=NewRegistrations], by(model_id year)

rename one NewRegistrations

local vars Engineltr Engineccm Fuelconsurban Fuelconsextraurban ///
Height Length Width Wheelbase EnginekW FuelEfficiency EngineHP GrossVehicleWeight

foreach v of local vars {
	replace `v'=ln(`v')
	gen `v'_sq=`v'^2 
}

replace NoofSeats=round(NoofSeats)
replace NoofGears=floor(NoofGears)
replace NoofCylinders=round(NoofCylinders)
replace NoofDoors=round(NoofDoors)

keep if year>=2004 & year<=2017

replace sprice=ln(sprice)

areg GrossVehicleWeight Wheelbase Width Height i.NoofSeats , absorb(maker)

predict hat_weight, xb
gen miss_w=GrossVehicleWeight==.
replace GrossVehicleWeight=hat_weight if GrossVehicleWeight==.

drop GrossVehicleWeight_sq
gen GrossVehicleWeight_sq=GrossVehicleWeight^2

replace BodyType="SUV Closed" if BodyType=="Monospace"

encode BodyType, gen(BT)
encode BodyGroup, gen(BG)
drop BodyType BodyGroup
rename BT BodyType
rename BG BodyGroup

replace Manual=round(Manual)
replace Diesel=floor(Diesel)
replace Turbo=round(Turbo)
replace D4x4=round(D4x4)


********************************************************************************
* Figure B12 - Panel (a) - Constant prices, Rounding

preserve

reg sprice FuelEfficiency ///
GrossVehicleWeight   ///
EngineHP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year<=2007

predict char_hat
predict res_hat, res

drop if char_hat==.

collapse  ///
 (mean) sprice char_hat [fw=NewReg], by(year)

* Labels
label var char_hat "Predicted by Characteristics"
label var sprice "Actual"

sum sprice if year==2007
sum sprice if year==2008
sum sprice if year==2009
sum char_hat if year==2007
sum char_hat if year==2008
sum char_hat if year==2009

twoway (line sprice year if year<=2012, lw(thick) lc(dknavy) lp(solid)) || ///
(line char_hat year if year<=2012, lw(thick) lc(dknavy) lp(dash)), xline(2007.5 2009.5)  ///
ytitle("Log Price Average - Log(Dollars)") yscale(r(10.05 10.25)) ylabel(10.05(0.05)10.25)
graph export "${figures}\fig_B12a.eps", replace


restore


********************************************************************************
* Figure B12 - Panel (b) - Time-varying prices, Rounding

* Pre-recession period
preserve

gen char_hat=.

reg sprice FuelEfficiency ///
GrossVehicleWeight   ///
EngineHP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year<=2007
predict ch

replace char_hat=ch if year<=2007
drop ch

* Recession period
reg sprice FuelEfficiency ///
GrossVehicleWeight   ///
EngineHP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year==2008 | year==2009
predict ch


replace char_hat=ch if year==2008 | year==2009
drop ch

* Post-Recession period
reg sprice FuelEfficiency ///
GrossVehicleWeight   ///
EngineHP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year>=2010
predict ch

replace char_hat=ch if year>=2010
 
drop if char_hat==.

collapse  ///
 (mean) sprice char_hat [fw=NewReg], by(year)

* Labels
label var char_hat "Predicted by Characteristics"
label var sprice "Actual"

sum sprice if year==2007
sum sprice if year==2008
sum sprice if year==2009
sum char_hat if year==2007
sum char_hat if year==2008
sum char_hat if year==2009

twoway (line sprice year if year<=2012, lw(thick) lc(dknavy) lp(solid)) || ///
(line char_hat year if year<=2012, lw(thick) lc(dknavy) lp(dash)), xline(2007.5 2009.5)  ///
ytitle("Log Price Average - Log(Dollars)") yscale(r(10.05 10.25)) ylabel(10.05(0.05)10.25)
graph export "${figures}\fig_B12b.eps", replace

restore




********************************************************************************
* Figure B12 - Panels (c) and (d) 

use "${datbuild}/d_pricechar_matchIHS_dominion.dta", clear  

gen one=1
collapse (mean) Turbo Manual D4x4 NoofDoors Engineltr Engineccm EnginekW EngineHP ///
NoofCylinders NoofGears NoofSeats Fuelconscombined Fuelconsurban Fuelconsextraurban ///
GrossVehicleWeight Height Length Width Wheelbase Diesel ///
d_entry maker_code FuelEfficiency sprice (firstnm) BodyGroup BodyType DrivenWheels ///
(sum) one [fw=NewRegistrations], by(model_id year)

rename one NewRegistrations

local vars Engineltr Engineccm Fuelconsurban Fuelconsextraurban ///
Height Length Width Wheelbase EnginekW FuelEfficiency EngineHP GrossVehicleWeight

foreach v of local vars {
	replace `v'=ln(`v')
	gen `v'_sq=`v'^2 
}


keep if year>=2004 & year<=2017

replace sprice=ln(sprice)

areg GrossVehicleWeight Wheelbase Width Height NoofSeats , absorb(maker)
predict hat_weight, xb
gen miss_w=GrossVehicleWeight==.
replace GrossVehicleWeight=hat_weight if GrossVehicleWeight==.

drop GrossVehicleWeight_sq
gen GrossVehicleWeight_sq=GrossVehicleWeight^2

replace BodyType="SUV Closed" if BodyType=="Monospace"

encode BodyType, gen(BT)
encode BodyGroup, gen(BG)
drop BodyType BodyGroup
rename BT BodyType
rename BG BodyGroup


********************************************************************************
* Figure B12 - Panels (c) - Fixed prices, Continuous

preserve

reg sprice FuelEfficiency ///
GrossVehicleWeight   ///
EngineHP  ///
Engineccm    ///
NoofCylinders ///
Wheelbase ///
D4x4 NoofGears Turbo Manual Diesel NoofSeats NoofDoors ///
i.maker_code i.BodyType if year<=2007

predict char_hat
predict res_hat, res

drop if char_hat==.

collapse  ///
 (mean) sprice char_hat [fw=NewReg], by(year)

* Labels
label var char_hat "Predicted by Characteristics"
label var sprice "Actual"

sum sprice if year==2007
sum sprice if year==2008
sum sprice if year==2009
sum char_hat if year==2007
sum char_hat if year==2008
sum char_hat if year==2009

twoway (line sprice year if year<=2012, lw(thick) lc(dknavy) lp(solid)) || ///
(line char_hat year if year<=2012, lw(thick) lc(dknavy) lp(dash)), xline(2007.5 2009.5)  ///
ytitle("Log Price Average - Log(Dollars)") yscale(r(10.05 10.25)) ylabel(10.05(0.05)10.25)
graph export "${figures}\fig_B12c.eps", replace


restore




********************************************************************************
* Figure B12 - Panels (d) - Time-varying prices, Continuous

* Pre-recession period
preserve

gen char_hat=.


reg sprice FuelEfficiency ///
GrossVehicleWeight ///
EngineHP  ///
Engineccm    ///
NoofCylinders ///
Wheelbase ///
D4x4 NoofGears Turbo Manual Diesel NoofSeats NoofDoors ///
i.maker_code i.BodyType if year<=2007
predict ch

replace char_hat=ch if year<=2007
drop ch

* Recession period

reg sprice FuelEfficiency ///
GrossVehicleWeight   ///
EngineHP  ///
Engineccm    ///
NoofCylinders ///
Wheelbase ///
D4x4 NoofGears Turbo Manual Diesel NoofSeats NoofDoors ///
i.maker_code i.BodyType  if year==2008 | year==2009
predict ch


replace char_hat=ch if year==2008 | year==2009
drop ch

* Post-Recession period
reg sprice FuelEfficiency ///
GrossVehicleWeight   ///
EngineHP  ///
Engineccm    ///
NoofCylinders ///
Wheelbase ///
D4x4 NoofGears Turbo Manual Diesel NoofSeats NoofDoors ///
i.maker_code i.BodyType  if year>=2010
predict ch


replace char_hat=ch if year>=2010
 
drop if char_hat==.

collapse  ///
 (mean) sprice char_hat [fw=NewReg], by(year)

* Labels
label var char_hat "Predicted by Characteristics"
label var sprice "Actual"

sum sprice if year==2007
sum sprice if year==2008
sum sprice if year==2009
sum char_hat if year==2007
sum char_hat if year==2008
sum char_hat if year==2009

twoway (line sprice year if year<=2012, lw(thick) lc(dknavy) lp(solid)) || ///
(line char_hat year if year<=2012, lw(thick) lc(dknavy) lp(dash)), xline(2007.5 2009.5)  ///
ytitle("Log Price Average - Log(Dollars)") yscale(r(10.05 10.25)) ylabel(10.05(0.05)10.25)
graph export "${figures}\fig_B12d.eps", replace

restore

