* an_RP_figureB11

* This dofile replicates appendix figure B11

set more off
cap log close

set scheme s2colorag


********************************************************************************
* Figure B11 - Share of new models on total models available

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

sort make_IHS model_IHS, stable
by make_IHS model_IHS: egen first_gen=min(GenerationModelYear)
gen d_firstgen=GenerationModelYear==first_gen
drop first_gen

gen d_new_model_firstgen=d_new_model*d_firstgen

keep model_id year d_new_model d_new_model_firstgen
sort model_id year, stable
by model_id year: keep if _n==1

collapse (mean) d_new_model d_new_model_firstgen, by(year)

label var d_new_model "New Models"
label var d_new_model_firstgen "New Models - First Generation"
label var year "Year"
twoway (line d_new_model year if year>=2005, lw(thick) lc(dknavy)) || ///
(line d_new_model_firstgen year if year>=2005, lw(thick) lc(dknavy) lp(dash)), xline(2007.5 2009.5) ///
yscale(range(0 0.3)) ylabel(0.0(.05)0.3) ytitle("Share of Models")

graph export "${figures}\fig_B11.eps", replace

