* an_RP_figureB10

* Introduction of European makers vs US makers

set more off
cap log close

set scheme s2colorag

*******************************************************************************
********************************************************************************
use "${datbuild}/d_expshare_matchIHS_newmodels_dominion_harmonmaker.dta", clear

* Keep years in a relevant time-window before the crisis
keep if (year>=2004 & year<=2012)

* Select expensive models and new models
sort model_id year, stable
bys model_id year: egen avgprice=mean(sprice)
gen d_expensive_model=(avgprice>=40000  & avgprice!=.)
by model_id year: keep if _n==1

gen d_new_expensive_model=d_expensive_model*d_new_model

* Check on European models and expensive models in 2007
tab model_IHS if make_region=="Europe" & year==2007 & d_new_model==1
tab model_IHS if make_region=="Europe" & year==2007 & d_new_model==1 & d_new_expensive_model==1 


collapse (sum) nb_new_models = d_new_model nb_new_exp_models = d_new_expensive_model, ///
by(make_region year)


********************************************************************************
* Figure B10 - Panel (a)

twoway (line nb_new_models year if make_region=="Europe", lp(solid) lc(dknavy) lw(thick)) || ///
(line nb_new_models year if make_region=="Asia", lp(longdash) lc(dknavy) lw(thick)) ///
(line nb_new_models year if make_region=="USA", lp(shortdash) lc(dknavy) lw(thick)), ///
ytitle("Number of New Models") xline(2007.5 2009.5) legend(label(1 "Europe") label(2 "Asia") label(3 "US") r(1)) ///
yscale(r(0 40)) ylabel(0(5)40)

graph export "${figures}\fig_B10a.eps", replace


* American
sum nb_new_models if make_region=="USA" & year==2007
local m07=r(mean)
sum nb_new_models if make_region=="USA" & year==2009
local m09=r(mean)
di (`m09'-`m07')/`m07'

* European
sum nb_new_models if make_region=="Europe" & year==2007
local m07=r(mean)
sum nb_new_models if make_region=="Europe" & year==2009
local m09=r(mean)
di (`m09'-`m07')/`m07'

* Asian
sum nb_new_models if make_region=="Asia" & year==2007
local m07=r(mean)
sum nb_new_models if make_region=="Asia" & year==2009
local m09=r(mean)
di (`m09'-`m07')/`m07'


********************************************************************************
* Figure B10 - Panel (b)

twoway (line nb_new_exp_models year if make_region=="Europe", lp(solid) lc(dknavy) lw(thick)) || ///
(line nb_new_exp_models year if make_region=="Asia", lp(longdash) lc(dknavy) lw(thick)) ///
(line nb_new_exp_models year if make_region=="USA", lp(shortdash) lc(dknavy) lw(thick)), ///
ytitle("Number of New Models w. Avg. Price>40k") xline(2007.5 2009.5) legend(label(1 "Europe") label(2 "Asia") label(3 "US") r(1)) ///
yscale(r(0 40)) ylabel(0(5)40)

graph export "${figures}\fig_B10b.eps", replace


* American
sum nb_new_exp_models if make_region=="USA" & year==2007
local m07=r(mean)
sum nb_new_exp_models if make_region=="USA" & year==2009
local m09=r(mean)
di (`m09'-`m07')/`m07'

* European
sum nb_new_exp_models if make_region=="Europe" & year==2007
local m07=r(mean)
sum nb_new_exp_models if make_region=="Europe" & year==2009
local m09=r(mean)
di (`m09'-`m07')/`m07'

* Asian
sum nb_new_exp_models if make_region=="Asia" & year==2007
local m07=r(mean)
sum nb_new_exp_models if make_region=="Asia" & year==2009
local m09=r(mean)
di (`m09'-`m07')/`m07'
