* an_RP_figure4

* This dofile performs hedonic price regression

clear all
set more off
cap log close

set scheme s2colorag

********************************************************************************
********************************************************************************

use "${datbuild}/d_pricechar_matchIHS_dominion.dta", clear  

local vars Engineltr Engineccm Fuelconsurban Fuelconsextraurban ///
Height Length Width Wheelbase EnginekW

foreach v of local vars {
	replace `v'=ln(`v')
	gen `v'_sq=`v'^2 
}


gen ln_fueleff_sq=ln_fueleff^2

keep if year>=2004 & year<=2017

replace sprice=ln(sprice)

areg ln_weight Wheelbase Width Height i.NoofSeats , absorb(maker)
predict hat_weight, xb
gen miss_w=ln_weight==.
replace ln_weight=hat_weight if ln_weight==.

drop ln_weight_sq
gen ln_weight_sq=ln_weight^2

replace BodyType="SUV Closed" if BodyType=="Monospace"

encode BodyType, gen(BT)
encode BodyGroup, gen(BG)
drop BodyType BodyGroup
rename BT BodyType
rename BG BodyGroup


********************************************************************************
* Figure 4 - Left Panel - Fixed betas at 2004-2007

preserve



reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year<=2007

predict char_hat
predict res_hat, res

drop if char_hat==.

collapse  ///
 (mean) sprice char_hat [fw=NewReg], by(year)

* Labels
label var char_hat "Predicted by Characteristics"
label var sprice "Actual"

sum sprice if year==2007
sum sprice if year==2008
sum sprice if year==2009
sum char_hat if year==2007
sum char_hat if year==2008
sum char_hat if year==2009

twoway (line sprice year if year<=2012, lw(thick) lc(dknavy) lp(solid)) || ///
(line char_hat year if year<=2012, lw(thick) lc(dknavy) lp(dash)), xline(2007.5 2009.5)  ///
ytitle("Log Price Average - Log(Dollars)") yscale(r(10.05 10.25)) ylabel(10.05(0.05)10.25)
graph export "${figures}\fig_4a.eps", replace


restore




********************************************************************************
* Figure 3 - Right panel - Period-specific betas

* Pre-recession period
preserve

gen char_hat=.

reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year<=2007
predict ch

replace char_hat=ch if year<=2007
drop ch

* Recession period

reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year==2008 | year==2009

predict ch
replace char_hat=ch if year==2008 | year==2009
drop ch

* Post-Recession period

reg sprice ln_fueleff ///
ln_weight   ///
ln_HP  ///
Engineccm    ///
i.NoofCylinders ///
Wheelbase ///
i.D4x4 i.NoofGears i.Turbo i.Manual i.Diesel i.NoofSeats i.NoofDoors ///
i.maker_code i.BodyType if year>=2010

predict ch
replace char_hat=ch if year>=2010
 
drop if char_hat==.

collapse  ///
 (mean) sprice char_hat [fw=NewReg], by(year)

* Labels
label var char_hat "Predicted by Characteristics"
label var sprice "Actual"

sum sprice if year==2007
sum sprice if year==2008
sum sprice if year==2009
sum char_hat if year==2007
sum char_hat if year==2008
sum char_hat if year==2009

twoway (line sprice year if year<=2012, lw(thick) lc(dknavy) lp(solid)) || ///
(line char_hat year if year<=2012, lw(thick) lc(dknavy) lp(dash)), xline(2007.5 2009.5)  ///
ytitle("Log Price Average - Log(Dollars)")
graph export "${figures}\fig_4b.eps", replace

restore
