* an_RP_figure3c




set more off
cap log close

set scheme s2colorag

*******************************************************************************
********************************************************************************

use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

* Keep years in a relevant time-window around the crisis
keep if year>=2004 & year<=2012


**///////////////////////////////////////////////////////////////////////////////
* Figures: Compute share of transactions in OH and TX over total
preserve

gen nb_trans_all=1
collapse (sum) nb_trans_all, by(state)

gen nb_trans_oh_tx = nb_trans_all*(state=="OH" | state=="TX")
gen unit=1
collapse (sum) nb_trans_oh_tx nb_trans_all, by(unit)

gen sh_trans_oh_tx = nb_trans_oh_tx/nb_trans_all
sum sh_trans_oh_tx

restore
**///////////////////////////////////////////////////////////////////////////////


* Keep relevant states
keep if state=="OH" | state=="TX"

gen nb_trans_all=1

collapse ///
(sd) price_sd=sprice, by(year state)

egen state_id=group(state)
xtset state_id year, y

label var price_sd "Price Standard Dev. (US Dollars)"

sum price_sd if year==2007
sum price_sd if year==2008

label var year "Year"


********************************************************************************
* Combined standard deviation for OH and TX
twoway (line price_sd year if state=="OH", lw(thick) lc(blue) lp(solid)) || ///
(line price_sd year if state=="TX", lw(thick) lc(red) lp(dash)), ///
xline(2007.5 2009.5) legend(label(1 "OH") label(2 "TX") r(1)) ytitle("Price Standard Dev. (US Dollars)")
graph export "${figures}\fig_3c.eps", replace
