% clear
% clc
% close all

year = 2004:1:2012;

auto_lighttrucks_flow = xlsread('..\rawdata_replication\stock\ALTSALES.xls', 1, 'B40:B48');

% quality of initial stock (2004)
A = 14; %scrap all at A+1

qN(1) = 1;

T = 2012-2003;

x = xlsread('..\deriveddatasets\d_knittel_all_weighted', 1, 'D2')-1; 

for a = 2:A+1

qN(a) = qN(1)/((1+x)^(a-1));

end

q = zeros(T,1);

q(1) = 1/(A+1)*sum(qN);

q_noqN = q;
q_noGR = q;

q_dis = zeros(A+1, T);

n_dis = zeros(A+1,T);

q_dis (:,1) = qN;

q_dis(1,:) = xlsread('..\deriveddatasets\d_knittel_all_weighted', 1, 'C2:C10');

n_dis(1, :)= auto_lighttrucks_flow./auto_lighttrucks_flow(1);

n_dis(:,1) = n_dis(1,1);


for t = 2:T
    
   for j = 2:A+1       
       
      q_dis(j,t) = q_dis(j-1, t-1);
      
      n_dis(j,t) = n_dis(j-1, t-1);
      
   end    
    
   q(t) = n_dis(:,t)'*q_dis(:,t)/sum(n_dis(:,t));
   
   q_noqN(t) = n_dis(:,t)'*q_dis(:,1)/sum(n_dis(:,t))*(1+x)^(t-1);
  
   q_noGR(t) = q_noGR(t-1)*(1+x);
   
end

fsize = 12;


figure
plot(year, q, 'b', 'LineWidth', 2)
hold on
plot(year, q_noqN, 'r--', 'LineWidth', 2)
plot(year, q_noGR, 'k-.', 'LineWidth', 2)
grid on
xlabel('Years', 'fontsize', fsize, 'interpreter', 'latex')
ylabel('Quality of the Stock', 'fontsize', fsize, 'interpreter', 'latex')
legend({'Baseline','Constant $q^N$ growth','No recession'}, 'Interpreter',...
    'latex','Location','southeast','fontsize', fsize) 
axis([2004 2012 .93 1.02])
saveas(gcf,'..\figures\fig_B17','epsc')


q_noqN./q_noGR
q./q_noGR


tot_quality_drop = (1-q(end)./q_noGR(end))*100
constS_quality_drop = (1-q_noqN(end)./q_noGR(end))*100
constQ_quality_drop = (q_noqN(end)./q_noGR(end)-q(end)./q_noGR(end))*100





