%% house prices
% OH is column AK, TX is column AS

cd(fld)

housep_OH = csvread('.\rawdata_replication\OH_TX\State_houseprice_purchaseonly.csv', 53, 36, [53 36 85 36]);
housep_TX = csvread('.\rawdata_replication\OH_TX\State_houseprice_purchaseonly.csv', 53, 44, [53 44 85 44]);

time = 2004:0.25:2012;
fsize = 12;

figure
plot(time, housep_OH./housep_OH(1)*100, 'b', 'LineWidth', 2)
hold on
plot(time, housep_TX./housep_TX(1)*100, 'r--','LineWidth', 2)
hold off
grid on
xlabel('Time (Quarters)', 'fontsize', fsize, 'interpreter', 'latex')
ylabel('House Price Index', 'fontsize', fsize, 'interpreter', 'latex')
legend({'OH', 'TX'},'Location','southwest', 'fontsize', fsize, 'interpreter', 'latex')
saveas(gcf,'.\figures\fig_3a','epsc')

% house price drop in Oh
houseprice_drop_oh = (1- housep_OH(21)/housep_OH(13))*100

%% employment total nonfarm

empl_OH = csvread('./rawdata_replication/OH_TX/State_employmenttotal_nonfarm.csv', 169, 36, [169 36 265 36]);
empl_TX = csvread('./rawdata_replication/OH_TX/State_employmenttotal_nonfarm.csv', 169, 44, [169 44 265 44]);

time = 2004:(1/12):2012;

figure
plot(time, empl_OH./empl_OH(1)*100, 'b', 'LineWidth', 2)
hold on
plot(time, empl_TX./empl_TX(1)*100, 'r--','LineWidth', 2)
hold off
grid on
xlabel('Time (Months)', 'fontsize', fsize, 'interpreter', 'latex')
ylabel('Nonfarm Employment', 'fontsize', fsize, 'interpreter', 'latex')
saveas(gcf,'.\figures\fig_3b','epsc')


% employment drop in OH
employment_drop_oh = (1-empl_OH(73)/empl_OH(37))*100
