import requests
import os
import json

# To set your environment variables in your terminal run the following line:
# export 'BEARER_TOKEN'='<your_bearer_token>'
bearer_token = os.environ.get("BEARER_TOKEN")

search_url = "https://api.twitter.com/2/tweets/search/all"

# Optional params: start_time,end_time,since_id,until_id,max_results,next_token,
# expansions,tweet.fields,media.fields,poll.fields,place.fields,user.fields
query_params = {
        'query': 'conversation_id:1161161387290136582',
        'since_id': '1161161387290136582',
        'max_results': 500,
        'tweet.fields': 'id,created_at,author_id,conversation_id,in_reply_to_user_id,referenced_tweets,text,lang,geo,possibly_sensitive,public_metrics,attachments',
        'expansions': 'author_id,referenced_tweets.id,in_reply_to_user_id',
        'user.fields': 'id,username,name,url,location,description,created_at,profile_image_url,protected,public_metrics,verified'
}


def create_headers(bearer_token):
    headers = {"Authorization": "Bearer {}".format(bearer_token)}
    return headers


def connect_to_endpoint(url, headers, params):
    response = requests.request("GET", search_url, headers=headers, params=params)
    print(response.status_code)
    if response.status_code != 200:
        raise Exception(response.status_code, response.text)
    return response.json()


def main():
    headers = create_headers(bearer_token)
    json_response = connect_to_endpoint(search_url, headers, query_params)
    print(json.dumps(json_response, indent=4, sort_keys=True))


if __name__ == "__main__":
    main()