# Title of Dataset: Combined measures of mimetic fidelity explain imperfect mimicry in a brood parasite-host system.
---

This dataset contains 4 excel files as well as R code detailing statistical analyses.

1. Prinia_CF_DataSheet_alleggs.csv: a dataset containing colour and pattern metrics extracted for cuckoo finch and prinia eggs.

2. CFPSexperiments_final.csv: a dataset containing results of egg rejection experiments. These experiments involved painting cuckoo finch egg with scribbles or one of two controls and testing whether this affected rejection frequency.

3. IntMFs_CFs_pre_manip_comparison.csv: a dataset containing Minkowski Functional values for cuckoo finch eggs before and after manipulation (i.e. painting with scribbles or control)

4. IntMFs_CFs_pre_manip_comparison_scribbles.csv: a dataset containing Minkowski Functional values for perimeter squared / area for cuckoo finch eggs before and after manipulation.

## Description of the Data and file structure

Prinia_CF_DataSheet_alleggs.csv:
Column names

Year_Nest_Egg_and_maybe_NestIn: Individual code for each egg
Year: Year in which egg was laid 
Nest: Nest ID in which egg was laid
Egg: Egg ID
Species: Species which laid the egg
u: Relative cone catch value for UV cone
s: Relative cone catch value for SW cone
m: Relative cone catch value for MW cone
l: Relative cone catch value for LW cone
lum: Luminance
FN: Number of features (extracted from NaturePatternMatch)
FS: Mean size of features (extracted from NaturePatternMatch)
FSD: Standard Deviation of size of features (extracted from NaturePatternMatch)
PC_a: Total proportion of eggshell covered in pattern (extracted using adaptive thresholding)
PD_a: The extent to which pattern is dispersed between the blunt and narrow poles of the egg (i.e. proportion of pattern at blunt end - proportion of pattern at narrow end)
OldEmax_ac: (Mean Filter Size)^2 (extracted using granularity analysis)
OldEmax1_ac: Mean Filter Size (extracted using granularity analysis)
OldEprop_ac: Pattern Proportion Energy (extracted using granularity analysis)
OldEtot_ac: Total energy (extracted using granularity analysis)
OldEsd_ac: Standard deviation of energy (extracted using granularity analysis)
MF_Area: Integral of Minkowski functional for area
MF_Perim: Integral of Minkowski functional for perimeter
MF_Euler: Integral of Minkowski functional for Euler characteristic
MF_Psqovera: Integral of Minkowski functional for perimeter^2/area


CFPSexperiments_final.csv:
FemaleID: Identity of each host female
Year: Year of experiment
HostNest: Code for host nest in which egg was placed
EggColour: Colour of host clutch and experimental egg
ExpNest: Code for nest from which experimental egg was taken
Egg_rejected: Whether experimental egg was rejected (1=rejected, 0=accepted)
Rejection_error: Whether the host rejected one of its own eggs
ExpEggReceived: The identity of the experimental egg received
HostEggReplaced: The identity of the host egg replaced
EggStage: Incubation stage of host clutch
Treatment: Whether the cuckoo finch egg was painted with scribbles (S), blotches (B), or water (W)
DateManipulation: Date of experiment	
TimeManipulation: Time of day at which experiment was conducted
Day of removal: If egg rejected, day of rejection.
ClutchSize: Clutch size
CFeggID: Identity of the cuckoo finch egg used in experiment

IntMFs_CFs_pre_manip_comparison.csv:
EggID: Individual code for each egg
Sum_Perim: Integral of Minkowski Functional for perimeter for unmanipulated egg
Sum_Perimmanip: Integral of Minkowski Functional for perimeter for manipulated egg
Sum_Psqovera: Integral of Minkowski Functional for perimeter squared / area for unmanipulated egg
Sum_Psqoveramanip: Integral of Minkowski Functional for perimeter squared / area for manipulated egg
Sum_Euler: Integral of Minkowski Functional for perimeter squared / area for unmanipulated egg
Sum_Eulermanip: Integral of Minkowski Functional for Euler characteristic for manipulated egg
Species SBW: Manipulation Treatment (S=Scribbles, B=Blotches, W=Water)

IntMFs_CFs_pre_manip_comparison_scribbles.csv
Psqovera: Integral of Minkowski Functional for perimeter squared / area
BeforePost: Defines whether the value for Psqovera was extracted from eggs "Before" or "Post" manipulation



