(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    183339,       3500]
NotebookOptionsPosition[    180653,       3442]
NotebookOutlinePosition[    181056,       3458]
CellTagsIndexPosition[    181013,       3455]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Spectrum Plots", "Title",
 CellChangeTimes->{{3.879879253527519*^9, 
  3.87987926592211*^9}},ExpressionUUID->"f0ef8759-47dd-4d6d-832f-\
9103af72e689"],

Cell[CellGroupData[{

Cell["Reader", "Section",
 CellChangeTimes->{{3.879879153664411*^9, 3.879879154769874*^9}, {
  3.879879188699011*^9, 
  3.87987918948831*^9}},ExpressionUUID->"497bb92b-065a-4d63-bc70-\
c246b06b95d2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CreateSpectrumPlots", "[", 
    RowBox[{"inputData_", ",", "\[CapitalDelta]_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"temp", ",", "DataFT", ",", "DataFS", ",", "DataFV"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"temp", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"inputData", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "\[Equal]", 
           RowBox[{"{", 
            RowBox[{"\[CapitalDelta]", ",", "2"}], "}"}]}], "&"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"DataFT", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"temp", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", 
           RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"temp", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"inputData", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "\[Equal]", 
           RowBox[{"{", 
            RowBox[{"\[CapitalDelta]", ",", "0"}], "}"}]}], "&"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"DataFS", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"temp", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", 
           RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"temp", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"inputData", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "\[Equal]", 
           RowBox[{"{", 
            RowBox[{"\[CapitalDelta]", ",", "1"}], "}"}]}], "&"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"DataFV", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"temp", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", 
           RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"Show", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ListPlot", "[", 
           RowBox[{"DataFT", ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Red", ",", 
               RowBox[{"PointSize", "[", "0.006", "]"}]}], "}"}]}], ",", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0.01", ",", "3.29"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "0.99"}], ",", "2.49"}], "}"}]}], "}"}]}], ",", 
            
            RowBox[{"Frame", "->", "True"}], ",", 
            RowBox[{"FrameTicksStyle", "->", 
             RowBox[{"Directive", "[", 
              RowBox[{"Automatic", ",", "15"}], "]"}]}], ",", 
            RowBox[{"BaseStyle", "->", 
             RowBox[{"{", 
              RowBox[{"FontFamily", "->", 
               RowBox[{"Latin", " ", "Modern", " ", "Roman"}]}], "}"}]}], ",", 
            RowBox[{"ImageSize", "->", "500"}], ",", 
            RowBox[{"Axes", "->", "True"}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"GrayLevel", "[", "0", "]"}], "}"}]}]}], "]"}], ",", 
          RowBox[{"ListPlot", "[", 
           RowBox[{"DataFS", ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Blue", ",", 
               RowBox[{"PointSize", "[", "0.006", "]"}]}], "}"}]}]}], "]"}], 
          ",", 
          RowBox[{"ListPlot", "[", 
           RowBox[{"DataFV", ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Black", ",", 
               RowBox[{"PointSize", "[", "0.006", "]"}]}], "}"}]}]}], "]"}]}],
          "}"}], "]"}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.879591372286591*^9, 3.879591469105638*^9}, {
  3.879591543051403*^9, 3.87959157133181*^9}, {3.879594634710054*^9, 
  3.87959463646796*^9}, {3.8795972613269367`*^9, 3.879597261336966*^9}, {
  3.879703169054529*^9, 3.879703351754521*^9}, {3.879703398873502*^9, 
  3.879703414628199*^9}, {3.879703452020465*^9, 3.879703494156551*^9}, {
  3.8797035402350388`*^9, 3.879703540438155*^9}, {3.879879298912891*^9, 
  3.87987930098742*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"c298cd96-4a47-4861-94c2-9d9dcedc9413"],

Cell[BoxData[
 RowBox[{
  RowBox[{"inputData", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", 
      "\"\<SpectrumData.csv\>\""}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8795945881724663`*^9, 3.879594597496763*^9}, {
   3.8795951026530724`*^9, 3.8795951188444567`*^9}, 3.879597261344736*^9, {
   3.879703103263084*^9, 3.879703126652169*^9}, {3.8797032308866243`*^9, 
   3.879703241032983*^9}, {3.8797035875128317`*^9, 3.879703588168993*^9}, 
   3.8798792254510403`*^9, {3.8806192081357546`*^9, 3.880619208472011*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"81ef99c1-0bac-4ffe-97b2-65fac95b495f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Section",
 CellChangeTimes->{{3.87987924330765*^9, 
  3.879879244923197*^9}},ExpressionUUID->"2ded8988-14d0-483e-a523-\
16c8a37e0f08"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "2.55"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"CreateSpectrumPlots", "[", 
   RowBox[{"inputData", ",", "\[CapitalDelta]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, 3.879597260947003*^9, {
   3.879703629763515*^9, 3.879703747494426*^9}, {3.879704188185258*^9, 
   3.879704188783512*^9}, {3.879704544338423*^9, 3.879704565083949*^9}, 
   3.879879306112813*^9, {3.880613161883105*^9, 3.880613162328912*^9}, {
   3.8806132007543907`*^9, 3.8806132028089185`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"6222af51-66fa-4ea1-9651-a5c2c72f2452"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[1, 0, 0], PointSize[0.006], AbsoluteThickness[1.6], 
     StyleBox[PointBox[CompressedData["
1:eJxd2nk8lO33B/DZzJgFY2asRUT7ghYqy4wkoY0WRGULLRIVSVFKq716WpRQ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       "]],
      FontFamily->$CellContext`Latin $CellContext`Modern \
$CellContext`Roman]}, {{}, {}}}, {{}, 
    {RGBColor[0, 0, 1], PointSize[0.006], AbsoluteThickness[1.6], 
     PointBox[CompressedData["
1:eJxN3Xc8lf/7OPBzOAMH59h7RUNUpJLQfVIh0lKkoUFEaaCsKKuMlBFZEQoZ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      "]]}, {{}, {}}}, {{}, 
    {GrayLevel[0], PointSize[0.006], AbsoluteThickness[1.6], 
     PointBox[CompressedData["
1:eJxF2nk8VG0bB/BZmRkzY8Yw1ijZsrSLbOeEJEurFoXKVolSoaJFQqKIqChL
RVJKodCmyBZZinqIiJKlmLGv49Xzzrme+afPt/ldd9PMOWeu6z4zz/nQJjcC
DodbS8Th/v6JPZbXlz/xzBlEMO8XfRuUfVQALhlnOc04klDMd+W+HEz1pILX
mnVONHozwcn2pew9eWw0QPLRmu/+qUhc6EvO/Nn1MXetb8yXnl0f84fuvI0x
s+tjDjOu7pCdXR+zZaJFgP7s+phPWGxWmXqGrZ+LXFBVF7PIxtbPRV6dLDJf
e1gAfvk6OdvagQT5l6ebxE54UMEbQxX6lh5kgp1U/nlQ/5SN5iuG9G7Mf43M
XFBf9enxIIL5XOBIzeqDAnDEpGuV5g4S5Jd8ebOzaC8VrDmSvK7ZgwlW6IiZ
6s3BXv87pEbf5mn5I+z1v0O2vwzdwPAQgJU9C9cv2UaCPI0sWzjmQgXPW7uh
Qt2dCT7ekXlL7wkbTYj/+6hAdintK1fOHEQwb6m/n57iKgCnrQgX372ZBHmD
q1vL5HZRwSNvhr7b7GaCadMenIqH2PtTjZh2fnnffA97f6qRA6fxu2YcBWBO
x6PXeetIkI/Le2Kx0J4KbpjHfapizwR709QcEjLY6O+Nf/+mDqmrTV42kDqI
YC6TIrsu2CoAxykIDAzWkiDvU69csHwTFXwl/Oqtig1MsCzSEZCZir3/9cgv
s239TinY+1+PqFjX+yrbCsAp0otP9JiSII+mzyxeakUF78lJ2ay3hgnOzqy4
hE9mo7Qvd7yNaV+QF6mX3s+5MYhgzrvSK9drKgD7mOnNqzQkQX5JeMw67VVU
cLZdhIWFERP82t80IfU69vk2IhFxLB2tOOzzbUSU1msFhekJwN5jWUZty0iQ
j7zA1FHRo4KvnSiM0VzMBMf8Yn+NjmajCxyiioY1mpFBSlJLUOQggtlsv+7q
KU0B+LKAs0xHiwT5wv6NEvO0qWBzSVx9nzITfCE9N7j2Anb8fEPa1W1J889j
x883ZKdri9e6OQJw+n3f8wXzSJC/t2+judZcKvh8zBmFc5JM8MpPTmohZ9lo
6t93604bsqP9RhD1zCCCWSMphxzMFICJrwWVIdIkyI8N6LZYcqjgzNbKSjyZ
Ce60X/fj2HHs+PyOHD2Zxljhhx2f35FmQwnrVME0ePty0x/xdBLk32VvUw8k
U8Fn/AJuuQ4xwMWhazvLD7LRZf8+OpDWm31xGZ6DCOaC8b1B+X+mwR/Jixqn
cCTIW840qDePUMCnDil31rUzwCyn7wHBrtjx/wMJrtkx4eaMHf8/EL9e3r6y
r9NgxxdvxXKGiJBv8R7l7f1FAV9ZHr1IvZYBtrdeviPVno0WD2vMfuI/EYfz
Wp0Htw0imE2vLr7ytXwaPMHO47/7RYT8ew76c/4XCvhmxDZa3EsG+HRAxj7z
ddj59QtRuE53LrfGzq9fiOmW9jczudPgnbXX8vWaiJBfY2X5TaaUAk4cV3NV
uscAb6ylL7M2ZaOb/j2guhDS2dq048gggln/yk29VSnT4N45Tx0kqoiQjzQ5
12iRSwF3Lmd6vo9hgOWHg9o/62LnbzdCDZFyDl2Knb/dSPBuTeOU8Gmwv8fm
NdteESFP2HA48sMtCviwhmjGtZMMMLH6oGiVBhv97v/3A+lB9g9mOo+rDCKY
r/Lbqdo+0+DubrV73EdEyJf+vib1IJICnjm9Gol3Y4Afdr0J3SePXR9+I7K7
IiybuNj14TeSFbMrtd9hGjy5JNxkfRIR8jcc+39+9aeAdVt2TdbZMsCeOJPo
cAYbPfz3dPP+gzgO4d8spQwimEX8wt4OmU+Dy6pV3UUjiZBvMvAf8nKngLe/
K7prp8sQXh/6kDXXZprp4wMIZqOwxZdWa0+D25fOVFmcIkLesqzp7L6NFDD/
VoL1F3mGsN/hIY/is1KPdA8gmGvL2pV7JKbBf8hmfkxPIuS9korKPxhSwPc2
X17Kx/+3njtp54D7dxb4x3iNuRLKAduyiO+vJUqBbxA1Da5NSIN3+pfpu22R
A6cPb1S++lgBPFhUGm4npiS8nvGQT3vNCw81DiCYV7eN2/8ZmwLnu56y2b+D
CHmaYrNauioFPNfbRMXtFx08Ur/CgF/HAvOTFlofXMgB5w/FaWVdkAK/cHlR
mNghDe7WmEavGsmBCxhZV7hXFcA9ehl9P/sUUct/D0g+cr704ASzYgDBbK1v
W7P12xS4oSz/t50lEfINdUyxUSYFjCx5qjCnig7OezfnCbOIBd7yateJdQoc
sHbbMhsbXylw3I9kD7EP0uDYrebxQfPlwImhe/5wAhTA9nmHVO/UKQqv93xk
+M9zY4f8AQRz94XrajrFU2CHNxfvfdElQt4xoeZY4agoOCqedHvlYzp4W99t
w/dPWGDdytc7X1A5YOu8qoITu6XADPKt8YGn0uBzj0nuFjQ5cEQYfcB2lwKY
zT/35FKOIvr3bHWIGkB6bzdudU4fQDBnTMf3BqRPgf34G3eOKhMhv1pbbzu5
TRR8LMl23fMrdLDeGk8XrVsscF6KbVnFiATYWeqQq6K1FNivL77KMkkaPEfb
1kmVJwvuWDzZPW2qAPaWG6Ey4hSF34eDiPtTWqbO1QEEM9/x5xKbiClwTu2d
7gJxIuQnV9TdrikTBf9W2Nfyyo8OXuZ1eO6yyyzwFZlLazw7JMB94tHz9+lK
gU96OSkuDpUGE5lPF+Y2yII3iBsFS6gpgPHtfrmdvoro/9vBQQSVLGstDx5A
MN/qfnfz9sEp8Fd5RCA7RYB8Ed46Rz5LFOy6vTmPaU8Hz8soGv5+mgVWvb6O
LaiWAEenMj1XKUmBC20nX53xkgY/0BSLjn8uCyZHl8pFUhSE/cEQEijb8As5
OoBgLvuyLTh04xTY6+3KN0pdBMiXkxbR++JEwWGxzwdKDejgR+UOX/S8WOCg
XytPXX8uAfYr0Dh1nSIF1lSxitprJw1Wcn6xaCBJFpzROfbSu0ceVfp7uVcc
RvzLC6MS9wwgmG/lxX4QLJsCc+Wffan4RIB851p5utVJUbBpGbt9Rp4ODrzZ
Kqu7kwXueb3E5MFdCfDq/Hf9x/mS4NbbuTmFBtLgU0QFxp0gWfBYBImTXSkv
7I+GkUMPh7J+rx9AMAdGRW2Q4E6BX5ifLlcsJEA+s2DHgkXOomBaNelZ1JQY
uLXexv0fSxb4d2hrm1yMBPh9CuNjd6Mk+KZ+5tPkudLgPpFAzkd3WbCRPEtt
b6Y86v7vYwTRmvuTqW8ygGDOblgyv3R0Eqwq6zmldJ8A+aql3tkpa0TB4lo6
BtHNYmBLxyMZ+itY4M5edt/rkxLgHcygyYG3kmB+lLtlP1kafKXr9JMDa2XB
Phyr+JyL8sL+cBSxbBu7fUF7AMFsXPZp+dzGSfB07lt+ZSwB8qHrXVgx2qLg
95uSD+FfioGfSqVV6s5ngfflS50T2SsB9r3p3X0sQxJsrGByfbqHC37Cjywu
15IF5+EXB/0+II/+PZolH40iQd/WBvTKDSCY60ftO9WeT4KVz7/PUz1DgLzi
umOfldmi4L1utJc/EsTAtQeX25aKs8B8lvS19g0SYC1to+2xlyXBbx/p+ofW
cMEbPm3yZDNlhf3wGLIkwnzcnTqAYM5UCNT6ljAJ7tBYfktnPwHyX/N3yhgP
i4CHgy20V54QA69hdbcvGhMHc+e3WW0xkADnPTrjY3xMEqzdTXuyPYcLXi1a
ke7ZL4OO/Hu4jiE/K5VtyGN8BHOqz+V0q4BJcFfOu7VdmwiQz/RN2drzjwi4
xXqkeXqrGLi+0my5eq04+NqHPvtD8yXA+1XfNns5SoLPVzfUZl/lgtPkfXXH
amSE/f44svPtTF91Jx/BXLpWRPXwzklwXuT8FVuMCJC/cSHrmvJLEXCu83ND
reVi4KJ/zgzeSBcHK/PqtOXoEuCn5oUJC8wk/3s+reZ9wgkueHVe6bOxLBn0
3/bbeAJpjdaTrGrgI5j9RRLvbTWcBNtb77fxUSVAvvjpGdrvJBGwY4/lsQaW
GPhNYm+l3mlx8GudpR37htjggaq3/ec0JMFoXoY0wYELPl2L73aLkhHOMxMI
lWXcQirhI5grc/twArlJ8AIdiQoLJgHy7aY+by3OioAdLhZH9/2mgZ8sTj8u
ZycO/ixLbl3ZzAYbkiWO7WdIgpUjZG62GnPBmaF3fxkelEH/vbyHTCIqDbrO
Z3L5CObidTVvPCYmwEaWq5VqR/CQ33bY/foyFxFwYNjrmhPlNHDmzJKTjgvE
wUx7mufbYjZ49GjDTAefA+5d08tHlbjC+WwKWZK0aLdZKh/BTGdOXb3TOAF2
vWk1xWjFQ95bzt/0ibkIWK+xbtL7Dg2cNrjWeHSaCdbmeJZ23GeD319b4dXS
wAEPH2nVy5yRQj9U/X1MIRfFIvy3xvIRzPPNpwzS8ifAkUci6YQyPOQ/9bzP
f6MqAl7Z36jQfooGFgxxzb/XMcEOrcrbk6LZ4IANdTTPAg6YcNc6kNMmJZw3
p5H9RTeaXgfzEcwayfQxv2sT4HvFDe8yH+EhP/dIRIuriAi4wKD1U8k2Gtho
FDFSTmOCUz4Phw8fY4On5xi+vHeTA348qErrKJRC/21nJAXIoP+hS2d9+Qjm
GWPlP7J+E+DVD0uvi1/FQ77E48iZuE4yuHbXzEOZJTQwJ1bBIfMYE5xEfTf3
jyMbrFa7ymLBGQ74aXzLobfJUsL5WYCkf96Ju+PORzCrR51Tumw3Ab6XZCGi
dQoP+U9oraZLKRlcrreqsJ1KA/c8sPhSvZYJHljOH0gwY4NXrxp8HLKHg/57
+DjMIKMXqofVt8/OVUKvajfe3rJ0AsyuSS/HueIhf+Tjee93aWTwlLHRKsV2
Knjw/k+RUTkmuPiIwZkKDTZ4eW3ucSMzbH7HoXs6fe9wrPjY/RW02FriBIE9
AQ6sfrY42goP+VfXvXxeBpPBQVfv9n8sgPsv6KWOqW0JvQxwldunzFgGG9x7
L+JytMp//77rnoAjLw2kwE46TZeNN0iDuzPufa5xlQUPzan45OAvD9acal06
P2qO8PsSh4aN/Ureb8RHMDd/+l2A6x8Hfz5K0G1ZjId8am5Rj7ULGWzfnfoQ
F00Fn0gW87zyggHWqTlNmOCzwG7ssExfMgesf/J12hwZKXBBlkKwjqY0+CIa
n2xtKAsufyXt6mUrDxbzmem74zRHuL+AQz0vn+VpL+IjmLt3WDxsqhoH7/sT
N93BxUN+s6Co02cVGfz2If1txl4qWLXzgPavcAb48PtDbUMNLHBvOO3Zm58S
/9V/ezA4OSQJPpLSFnOaKA02MwnJ4rNlwT9Xd58sVJIH57w+sX21zhxhvzD7
/1vXbr1LGetfcKiL6mX7y/fHwT8vfEYzpnCQt02NsjNQIoN/W7O2VRhTwasD
shVv2DPAlRYt4bcKWGDOtgKzmhIJ8GhJtt2hOkmwxyU/WbtmLjgm8n7TeKcM
WF78g48LH9s/waO++vi5RC4fwXy4b/c/ymHjYK8m9Xua7TjIS8ytLrg2RQLH
mD+ef5BDBZ89XL0jQZ0BNgql3ui6yQIX6jkb7EuTAMtc7H7j81AS3B6saJKa
ywXfiygOKn4hA953W1fTpUhO2A/h0fGu7sVyNKw/w6Mme7SuxriNgx8cT8Af
KMNBXimf3X2lkQTm2TQsPN9FAYd3RBRIDdPBu9eu8G8+wwJ/1PS4zjsnAV4h
+/5KV5gkOH6TNn/XRS64VE/xcfVlGXDIYH5kUQy2/4NHF5o+ckwT8BDM8j/S
676bjoPHW41tPDJxkJdALCUXPSOBX7VMzKi8ooDJrTd3976lg3esVsk66swC
Z3S1Wz91lgAfHvncOOgiCT40I9NEdOWC/ymOD7d1xfpNAlqR0CSdNshDMI8V
htqJzx0HJ07la2lF4yD//tzBr/tjSOCG4+UyltEUcIFhSoZOJB28J/301H1z
FvhbqRTuwSoJcPaCz6NnTSTBcRtTTz434ILv3UjZoa8nI9yPIqDJ0pOhct08
BPPCsMBR2ekx8AF5t3WPfHGQd50Rlbc8SALvtXimwXOlgIfZBm237OngXkvF
OdFqLLB/eDC5Q0kCfK0wWjtZRhL8kphBZrG54Nz4ixpFVKxfJqDyn6gq5FYe
gvlPfX8dvmkMXNdpXzJgj4O8zqS6TOVaEjggRTtXXZ8CHrG6sqRIhQ6+L67S
r0BhgY9ZJYtGTLPB0iNqspYDHPBgGa7kY6cUWM9btCf2K7afRkSrSlQq3Rp4
COZYtU//zE4o4LmXXtKnjHGQD81KjPmjQgInFp0Z/UGjgM9x79us7hcD/3DD
J93/KA6W+rLvVk4TG/yywFE0pJIDrll4XVX1pZSwvyaid6UOTRlU8RDM7jdp
392vjIGVV27qqJiHg/yNeSG2JTNEsJzJ+TrNFlHw9kO9dy0LxMDhN0u2x8aK
g0fffi5JzGODq9QXI26pHHCWvtH5jMvY/h4R1dlz1ju4mIdgrj9l09Z2aAw8
P9bquRMZB3nPIe5Z8yYiWNf1UTID9huJ6GXiC2pTkBi485YTvXCLODhyWWDF
/Fg2+Op+MYNfJzngKrOQg0puUsJ5gIRSpIbiTF/wEMxUblLNcpsxsNS7IcsT
dTPgBBUrEb9cItQvmzprFxIoCm4K6on8bi0GLlj6M34DVxzcwWG56XuzwbmU
+rPTdhzwhUk96zsrsf3G2e8h/eEPR3J4CObDhzxaHTXGwB4nig6UXZsBb9BR
Nd0eSYR6N5Ia7tpGUfCkqfmqnZJiYG5g76Ldn5ng04u+FUrasMGv+vQNG7Sx
eYWEKuaE7uVm8hDMumSfbY6kMXDxSF/PY8cZ8KngLbZDe4lQ/9XsxDxLZVEw
pUh9mWszDdwfb5JEu8oEd7iXaN1SZ4Pd+/enc0kc4f4lGf04L9JfM42HYH44
h5Sk0zYK/ubA2rRi/gz45If759asIkJ9q0v+5sQBEfDRM0aRk7PzJeaGoJ0J
hC1McP6zgKwWAhu8Ovl5tslXCeH8REZf69ENspJ4COYzuiccq1+MgjPPfo52
7BKATbaujd0uR4R69dqbMzeKRMAXqXUqGgdo4L0PElae5zDB0ly9ip4WFrj9
XdTPrifY/ioZTaDs1U69zkMwp7RXbja6NgpuD9vwYeFDAVhWOa5Ka5AA9TV1
482WMSLgb7udVvBm5znMDhOnRWPqGODFJhnrb+ezwJrrNRwdwySE85wIatz4
jEe5wkMwpzgutfE9Mgo24Px48viwACzBFdS/qyRAvV16S3TmHhFwxcDzP05j
VLCUVzBeI4oBfiovsJlzBdvPna2/Ylj29RIPwazJOXnPx3YUnD4SfaxLVwB+
GjR8QDOVAPWLGcVr3i0WAfeV1lF8X1PBmz6uoUbZMMDVz7yGTLxYwnlSBB29
rzipcIGHYObo993S1xgFx+ctYbWNT4OpPVctnU8SoB7Ja6akz5DBdXF27ebB
1P/Wr+3Z6kxlgD381JZarsH2h0XRqVR79epgHoK5XOT190LCKDjqR8i5O6+m
wbgeB5qvHQHq73LwupuqyWAlKmNH9VoqmBx7znmkhA7WmaJOyc9jCedZUfTp
XpTUH8hDMIey45RFWkbAsbG1HkZnp8HOttNeLtoEqH/09f6+mptksPEN5nsl
cSp4c9jFZxZBdOF+sSiacEw19uwpHoJ5sd4KVCxvBOxeIv0q33wa/PB+Vd1K
EgHqTXj/JC84QAbvEfmgYVpPAQdOu7hsNaEL51sK+sNv+mWYPw/BrCSWH1xz
eQRs7vIoYgFlGryL5S/ANeOhnrvLquPASjLYMXOBqVU8BbzplF3u5gkxcMKS
7TmlO8XBO3A73gw4scEBXxhVveLYvEtBdwYuTaQc5yGY/Q5EJWz2GAFXavaG
3K6cAlv26nNLcvBQbxyUL0gWJYMZdA+qmRMFfLLi08NFz8TAZt9Pn0thioMv
Zved71vGBtulmL840obNrxT02eilBpIfD8H84KZBdrzZCHiteFmHXtQU+Fxw
xIWICDzU21kHb2tuIIGvtrl56M+ngNV8S1bwDouBxdfKP7n8lgk2JIVeqaOw
hfPkbJ8ZYjfvnA8PwexnKjKapjAC3qVZTcBvngJzBF7X3V3wUH90p2qNZioJ
7BAfOIp0iYKT+pGOzzpiYJm19Qf3+TDBmzQP5da3YPMlFa1JTHSOPMpDMLMV
SMyg4WGwyQNVW0XpKfAj/XUeboZ4qJ+U1HG9dYQEtpGtJB57KApehfrvZfTQ
wKFHfbkZ6kywWWrjOn42Ni9S0VMzsnkLZ18P5pIjmon61cNgnBdJIuvrJPjS
nS8mNzh4qNdZOULetooE3hFmdnTwiChYq5RSduouDcx8YRuu9JUBPlOlyVkX
hs1/VDSOb1h09Cg2b1JRfAQ+9+vdYXC48ox6U8okuPzdfjf53zioTyz8fMWF
RQKjufae5fqi4C7LeyWbXGjgzH3W9YzZ75v/z2c0tHxNsrSXDzY/0tC83OyF
QWeGwTcvDx2sdp8EL6oWRONKcFD/1BO90tFKBB8eNqxcOCMCjsj/lF00lwYW
C6eV3zFjCOctGvq14rz3Ej9sHqShWbneZ2y2D4PNss3uFutMgpdbJOw5kISD
ekecdxrpMRFstBzVNC8VAR9ATJ2Hv1HBl+avZIiPY/MXDb1xIXdD83Fsvpt9
vYLcY65LhsFcQ6fU0eEJcJdVjnPgcRzUV4i8ae8JJIJJHhxlk0gRMDX71+Ll
SVRw8XMX8ydZ2O8nxND4FWM1kSexeU0MvRDSc3qGNgxesU13W0HhBDjf4/Bt
j804qPeqraqt3kQEL0koUduxTQT8uMEzJMeJKpx3Zp8fe/fx8Fls/hJDp/+0
XXP+OQTmPmvj74qYAMc3OzvuXoSD+r2x2bo8VSJ4odc/BW3zRMA3f8vkVc+l
CucXMVSWi5+bdx6bp8TQo5V03o83Q+A5z8MbN9tPgB+tF+tLpuOgfvxLmVX8
BAH8rT5NcW4fGVxdSnn8/Qf2+zo6uqnu++/4KGw+oqMt+9YJ+IlD4PeDfjSG
5sR/zj6t3/N5Brz1gY/NnDoCrNdutenuxZdkcOZRernTA+z3oHRUxsogwjEe
m3fo6GkfVgzt1BBYaVHYQUnBOBjvVv5i7/UZcLFc1I3WDAKs51a2xTriEhns
GDIVVOFDEc4TdNTE5RTFJg2bZ+hocpuPRoXTEDiF4zuG/zwOzsq0LvF3mgG3
zxjv2RhCgPV4Klc3Je8hC+cDBtrAvrbuSQ42nzBQz8qAiSazIbAu0RXvlz0O
FqFfChlcMAMuPudL6HUhwHr4JTGUDbP9wf/7fQa6yGNl+cd32LzBQG0XFaJ4
nSGw2dn3BpKx4+AHGQ8upE0KwH0c4xPzLQiw3jn9J08XSpGF/TsDFVdcbdfx
DzY/MNDGG8okUfkhsP7ZNWreAePg24fue+6oF4CtPx+O9dImwHq7/Xx/5g+T
hP05E71gYvh8sB+bB5joeobyyzzmEPjWH33LmX3jYL+bWbYvcgVgu5kaK2Vp
AqwX17/byeErSdh/M1HCUmfqTyofwTzyO6upkTIEDvDR7GQ6joNbyV6yaKIA
rO4+1yxEBOu/maiES9c7RzXs/hMTfbJgx2I12hDY8PyTT1nbxsFrRq1NVSIF
4DDNP32PJ/DC/lgc/V58XLzcnI9gDnqW7mPJGQKPtX8Jfr19HExQD3njel4A
NvgTPBA/iN1vEkePS7bq7XTF7k/NrvfqQOU3lSFwXICWfdeucXC80qauijAB
WJEqVcnl44X9rThqvyv86qJgPoL58NdlW3yQIXDwVTH5As9xcIrJsN1ItAD8
tWDfyZ4BrL9loQxPybadd7D7Vyy0yfiR1XGXIbAV56X4/dPj/z3fnvTF67YA
nCb7orVi7L/1Ih6vcijKJKH/AymUVl0=
      "]]}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.010000000000000023`, 0},
  BaseStyle->{
   FontFamily -> $CellContext`Latin $CellContext`Modern $CellContext`Roman},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->500,
  LabelStyle->{
    GrayLevel[0]},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0.01, 3.29}, {-0.99, 2.49}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879879864884684*^9, 3.880534864033408*^9, 3.880549226864986*^9, 
   3.8805494733555813`*^9, {3.88061319317863*^9, 3.8806132035809298`*^9}, {
   3.8806191988441358`*^9, 3.8806192146687813`*^9}},
 CellLabel->"Out[7]=",ExpressionUUID->"be88dd94-4a71-4f71-8910-ee9a9b18af5a"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Probe Plot", "Title",
 CellChangeTimes->{{3.879879253527519*^9, 3.87987926592211*^9}, {
  3.87987933469722*^9, 
  3.879879336911059*^9}},ExpressionUUID->"58207fe0-a924-4f6c-a139-\
bda5d005af5d"],

Cell[CellGroupData[{

Cell["Reader", "Section",
 CellChangeTimes->{{3.879879153664411*^9, 3.879879154769874*^9}, {
  3.879879188699011*^9, 
  3.87987918948831*^9}},ExpressionUUID->"0071b4a0-08ee-42ff-bfb2-\
74977630c52e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CreatePlotsProbe", "[", 
    RowBox[{"inputData_", ",", "inputDataP_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "temp", ",", "DataFT", ",", "DataFS", ",", "DataFV", ",", "DataFSPr"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"temp", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"inputData", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "\[Equal]", 
           RowBox[{"{", 
            RowBox[{"2.5", ",", "2"}], "}"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DataFT", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"temp", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", 
           RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"temp", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"inputData", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "\[Equal]", 
           RowBox[{"{", 
            RowBox[{"2.5", ",", "0"}], "}"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DataFS", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"temp", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", 
           RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"temp", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"inputData", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "\[Equal]", 
           RowBox[{"{", 
            RowBox[{"2.5", ",", "1"}], "}"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DataFV", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"temp", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", 
           RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"temp", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"inputDataP", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"{", "1", "}"}], "]"}], "]"}], "\[Equal]", 
           RowBox[{"{", "2.5", "}"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DataFSPr", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"temp", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", 
           RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"Show", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ListPlot", "[", 
           RowBox[{"DataFT", ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Red", ",", 
               RowBox[{"PointSize", "[", "0.006", "]"}]}], "}"}]}], ",", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0.01", ",", "3.29"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "0.99"}], ",", "2.49"}], "}"}]}], "}"}]}], ",", 
            
            RowBox[{"Frame", "->", "True"}], ",", 
            RowBox[{"FrameTicksStyle", "->", 
             RowBox[{"Directive", "[", 
              RowBox[{"Automatic", ",", "15"}], "]"}]}], ",", 
            RowBox[{"BaseStyle", "->", 
             RowBox[{"{", 
              RowBox[{"FontFamily", "->", 
               RowBox[{"Latin", " ", "Modern", " ", "Roman"}]}], "}"}]}], ",", 
            RowBox[{"ImageSize", "->", "500"}], ",", 
            RowBox[{"Axes", "->", "True"}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"GrayLevel", "[", "0", "]"}], "}"}]}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ListPlot", "[", 
           RowBox[{"DataFSPr", ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Orange", ",", 
               RowBox[{"PointSize", "[", "0.006", "]"}]}], "}"}]}]}], "]"}], 
          ",", 
          RowBox[{"ListPlot", "[", 
           RowBox[{"DataFS", ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Blue", ",", 
               RowBox[{"PointSize", "[", "0.006", "]"}]}], "}"}]}]}], "]"}], 
          ",", 
          RowBox[{"ListPlot", "[", 
           RowBox[{"DataFV", ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Black", ",", 
               RowBox[{"PointSize", "[", "0.006", "]"}]}], "}"}]}]}], "]"}]}],
          "}"}], "]"}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.879591372286591*^9, 3.879591469105638*^9}, {
  3.879591543051403*^9, 3.87959157133181*^9}, {3.879594634710054*^9, 
  3.87959463646796*^9}, {3.8795972613269367`*^9, 3.879597261336966*^9}, {
  3.879703169054529*^9, 3.879703351754521*^9}, {3.879703398873502*^9, 
  3.879703414628199*^9}, {3.879703452020465*^9, 3.879703494156551*^9}, {
  3.8797035402350388`*^9, 3.879703540438155*^9}, {3.8798318858265038`*^9, 
  3.879831936291888*^9}, {3.879832022050131*^9, 3.879832036294516*^9}, {
  3.879832066775037*^9, 3.879832093233252*^9}, {3.8805487728208647`*^9, 
  3.880548825359293*^9}, {3.8805488763705597`*^9, 3.880548880374303*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"41001fd5-1be1-417d-8f0a-42f6db906069"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inputData", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", 
      "\"\<SpectrumData.csv\>\""}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inputDataP", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", "\"\<ProbeData.csv\>\""}],
      "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8795945881724663`*^9, 3.879594597496763*^9}, {
   3.8795951026530724`*^9, 3.8795951188444567`*^9}, 3.879597261344736*^9, {
   3.879703103263084*^9, 3.879703126652169*^9}, {3.8797032308866243`*^9, 
   3.879703241032983*^9}, {3.8797035875128317`*^9, 3.879703588168993*^9}, {
   3.8798305275266*^9, 3.8798305426796217`*^9}, {3.879832116345127*^9, 
   3.8798321290338707`*^9}, {3.8805488973363934`*^9, 3.880548899944662*^9}, 
   3.880548970404661*^9, {3.880549023292515*^9, 3.880549023800297*^9}, {
   3.8805490626080217`*^9, 3.880549064115617*^9}, {3.880549202267799*^9, 
   3.880549210318369*^9}, {3.880549481439817*^9, 3.880549483183117*^9}, {
   3.8806192206391897`*^9, 3.880619223102831*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"a93caa63-f53f-463d-9a98-f48f537e74cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plotting", "Section",
 CellChangeTimes->{{3.87987924330765*^9, 3.879879244923197*^9}, {
  3.87987945209233*^9, 
  3.879879453543911*^9}},ExpressionUUID->"248d86e3-1ed3-4e22-9fff-\
74deaaf700c7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"CreatePlotsProbe", "[", 
   RowBox[{"inputData", ",", "inputDataP"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.880549043865221*^9, 3.8805490483660717`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"d0a3905e-676d-4ede-b903-a97967b2e736"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[1, 0, 0], PointSize[0.006], AbsoluteThickness[1.6], 
     StyleBox[PointBox[CompressedData["
1:eJxd3Hk8VO37B3BjZyyzmsVgxhYlZEllbbOUPUWifZEtSSpCZQvtuxQtSlEo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       "]],
      FontFamily->$CellContext`Latin $CellContext`Modern \
$CellContext`Roman]}, {{}, {}}}, {{}, 
    {RGBColor[1, 0.5, 0], PointSize[0.006], AbsoluteThickness[1.6], 
     PointBox[CompressedData["
1:eJxE3Hk8VN//B/CxG+ts9n1JlijJlphJ2SKypCKEQhJSpBIhSZIWiURIKmQp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      "]]}, {{}, {}}}, {{}, 
    {RGBColor[0, 0, 1], PointSize[0.006], AbsoluteThickness[1.6], 
     PointBox[CompressedData["
1:eJxM3Hk8VP37P3D7vgxmjLHvSSlLRGHI0mLfQyEpJJEtUUoLkUSoLC2oJCSy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      "]]}, {{}, {}}}, {{}, 
    {GrayLevel[0], PointSize[0.006], AbsoluteThickness[1.6], 
     PointBox[CompressedData["
1:eJxF3Hk8VO/bB3DGOtbZjBnLmLGTRIVKdSaVJGVJSogW0YL2RYmEQkq0i5TK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      "]]}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.010000000000000023`, 0},
  BaseStyle->{
   FontFamily -> $CellContext`Latin $CellContext`Modern $CellContext`Roman},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->500,
  LabelStyle->{
    GrayLevel[0]},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0.01, 3.29}, {-0.99, 2.49}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.88054904900314*^9, 3.8805492337109423`*^9, 
  3.880549487820492*^9, 3.88061321858535*^9, 3.880619228522447*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"003bfe16-8874-428a-abd9-88293ef0493e"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Critical Masses Plot", "Title",
 CellChangeTimes->{{3.879879253527519*^9, 3.87987926592211*^9}, {
  3.87987933469722*^9, 3.879879336911059*^9}, {3.879879501013043*^9, 
  3.87987950702829*^9}},ExpressionUUID->"7ba60490-0282-49f6-bac3-\
a322235190ba"],

Cell[CellGroupData[{

Cell["Reader", "Section",
 CellChangeTimes->{{3.879879153664411*^9, 3.879879154769874*^9}, {
  3.879879188699011*^9, 
  3.87987918948831*^9}},ExpressionUUID->"b1513d17-e0bd-4433-89bd-\
f5c647f88961"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CreateMassPlot", "[", "inputData_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"temp", ",", "DataFTC", ",", "DataFSC", ",", "DataFVC"}], "}"}],
      ",", 
     RowBox[{
      RowBox[{"DataFTC", "=", 
       RowBox[{"{", "}"}]}], ";", 
      RowBox[{"DataFSC", "=", 
       RowBox[{"{", "}"}]}], ";", 
      RowBox[{"DataFVC", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"DeltaSet", "=", 
       RowBox[{"{", 
        RowBox[{
        "0.5", ",", "1", ",", "1.5", ",", "1.7", ",", "1.75", ",", "1.8", ",",
          "1.85", ",", "1.9", ",", "1.95", ",", "2", ",", "2.25", ",", "2.3", 
         ",", "2.35", ",", "2.4", ",", "2.45", ",", "2.49", ",", "2.499", ",",
          "2.5", ",", "2.501", ",", "2.51", ",", "2.55", ",", "2.6", ",", 
         "2.65", ",", "2.7", ",", "2.75", ",", "3", ",", "3.5", ",", "4", ",",
          "4.8"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"temp", "=", 
          RowBox[{"Select", "[", 
           RowBox[{"inputData", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "\[Equal]", 
              RowBox[{"{", 
               RowBox[{"2", ",", 
                RowBox[{"DeltaSet", "[", 
                 RowBox[{"[", "jj", "]"}], "]"}]}], "}"}]}], "&"}]}], "]"}]}],
          ";", "\[IndentingNewLine]", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"DataFTC", ",", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"temp", "[", 
              RowBox[{"[", 
               RowBox[{"ii", ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"ii", ",", 
               RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], 
          "]"}], ";"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", 
          RowBox[{"Length", "[", "DeltaSet", "]"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"temp", "=", 
          RowBox[{"Select", "[", 
           RowBox[{"inputData", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "\[Equal]", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"DeltaSet", "[", 
                 RowBox[{"[", "jj", "]"}], "]"}]}], "}"}]}], "&"}]}], "]"}]}],
          ";", "\[IndentingNewLine]", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"DataFVC", ",", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"temp", "[", 
              RowBox[{"[", 
               RowBox[{"ii", ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"ii", ",", 
               RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], 
          "]"}], ";"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", 
          RowBox[{"Length", "[", "DeltaSet", "]"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"temp", "=", 
          RowBox[{"Select", "[", 
           RowBox[{"inputData", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "\[Equal]", 
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"DeltaSet", "[", 
                 RowBox[{"[", "jj", "]"}], "]"}]}], "}"}]}], "&"}]}], "]"}]}],
          ";", "\[IndentingNewLine]", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"DataFSC", ",", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"temp", "[", 
              RowBox[{"[", 
               RowBox[{"ii", ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"ii", ",", 
               RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], 
          "]"}], ";"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", 
          RowBox[{"Length", "[", "DeltaSet", "]"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"LF", "=", "29"}], ";", "\[IndentingNewLine]", 
      RowBox[{"MagPlot", "=", 
       RowBox[{"Show", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ListPlot", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"DataFSC", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"2.41", ",", "2.59"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.35", ",", "0.39"}], "}"}]}], "}"}]}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Blue", ",", 
               RowBox[{"PointSize", "[", "0.02", "]"}]}], "}"}]}], ",", 
            RowBox[{"FrameTicksStyle", "->", 
             RowBox[{"Directive", "[", 
              RowBox[{"Automatic", ",", "8"}], "]"}]}], ",", 
            RowBox[{"FrameTicks", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], 
            ",", 
            RowBox[{"Frame", "->", "True"}], ",", 
            RowBox[{"BaseStyle", "->", 
             RowBox[{"{", 
              RowBox[{"FontFamily", "->", 
               RowBox[{"Latin", " ", "Modern", " ", "Roman"}]}], "}"}]}], ",", 
            RowBox[{"ImageSize", "->", "160"}], ",", 
            RowBox[{"Axes", "->", "True"}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"GrayLevel", "[", "0", "]"}], "}"}]}]}], "]"}], ",", 
          RowBox[{"ListLinePlot", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"DataFSC", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "1", ",", "17"}], "}"}]}], "]"}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Blue", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
          RowBox[{"ListLinePlot", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"DataFSC", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "18", ",", "LF"}], "}"}]}], "]"}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Blue", ",", "Thin"}], "}"}]}]}], "]"}]}], "}"}], 
        "]"}]}], ";", 
      RowBox[{"Show", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ListLinePlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFSC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0.01", ",", "4.99"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", ".16"}], ",", "1.69"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Blue", ",", "Thin"}], "}"}]}], ",", 
           RowBox[{"Frame", "->", "True"}], ",", 
           RowBox[{"FrameTicksStyle", "->", 
            RowBox[{"Directive", "[", 
             RowBox[{"Automatic", ",", "15"}], "]"}]}], ",", 
           RowBox[{"BaseStyle", "->", 
            RowBox[{"{", 
             RowBox[{"FontFamily", "->", 
              RowBox[{"Latin", " ", "Modern", " ", "Roman"}]}], "}"}]}], ",", 
           
           RowBox[{"ImageSize", "->", "500"}], ",", 
           RowBox[{"Axes", "->", "True"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"GrayLevel", "[", "0", "]"}], "}"}]}], ",", 
           RowBox[{"Epilog", "->", 
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteDashing", "[", "Medium", "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"2.625", ",", "0.37"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"3.45", ",", "0.19"}], "}"}]}], "}"}], "]"}], ",", 
              "Transparent", ",", 
              RowBox[{"EdgeForm", "[", "Thin", "]"}], ",", 
              RowBox[{"Rectangle", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"2.4", ",", "0.33"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"2.6", ",", "0.41"}], "}"}]}], "]"}], ",", 
              RowBox[{"Inset", "[", 
               RowBox[{"MagPlot", ",", 
                RowBox[{"{", 
                 RowBox[{"4.05", ",", "0.18"}], "}"}]}], "]"}]}], "}"}]}]}], 
          "]"}], ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFSC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], ",", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFSC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0.01", ",", "4.99"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", ".05"}], ",", "1.69"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Blue", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFSC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], ",", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFSC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0.01", ",", "4.99"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", ".05"}], ",", "1.69"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Blue", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFSC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], ",", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFSC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "4"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0.01", ",", "4.99"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", ".05"}], ",", "1.69"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Blue", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFSC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "4"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], ",", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFSC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "5"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0.01", ",", "4.99"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", ".05"}], ",", "1.69"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Blue", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFSC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "5"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], ",", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFTC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0.01", ",", "4.99"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", ".05"}], ",", "1.69"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Red", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFTC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFTC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0.01", ",", "4.99"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", ".05"}], ",", "1.69"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Red", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFTC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFVC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0.01", ",", "4.99"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", ".05"}], ",", "1.69"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Black", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DataFVC", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "LF"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]}], "}"}], 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwlylsog3EABfC1mJR5ULIWskJpFMPDtpet0IrMpYhM7so9iymXhmbTag9z
KR6UGFnS8K2ZhaRl5TJjaljJk0t7EKVNI9/5ezj9Op3Da+qtaGUyGIxkOvCY
P213PAekzY0rTsgxPV3C7KWOa3iyV1V+QKsNGYgFg+aFQ9pu17/UIa/sgzY6
LdgG9z8fumA+19sD19bVSqhiOodgn0Y7BusjDUQh+3kn8yUgTdGLdqFkOeMR
UsY8YpPa9g43v6qDMMLBD8PE0klmFu3rr3Agm5afOz4GRUlWDdSxQzpIRYVm
4GqDaxYK1Kkr0J4ea4JaE9MMDS8Jm+SfE96GfjF3l+yKOBuUcQTEtzq5A3qM
LcTaxaEjOJIRJFos+gsoEfiI/hLKC/flV7eQ9X5zB0M1BfeQ8cPtlNGqztqJ
c4Xf/TDGPayEE55RDSwqPp2C4srFZdK1vC14Hl9EQdaGnDhv9bl1rwGpomL2
Cv4BL7oSPA==
  "],
 CellLabel->"In[12]:=",ExpressionUUID->"aef02028-f638-4a28-8fb1-62e0eeb07052"],

Cell[BoxData[
 RowBox[{
  RowBox[{"inputData", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", "\"\<CriticM.csv\>\""}], 
     "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8795945881724663`*^9, 3.879594597496763*^9}, {
   3.8795951026530724`*^9, 3.8795951188444567`*^9}, 3.879597261344736*^9, {
   3.879703103263084*^9, 3.879703126652169*^9}, {3.8797032308866243`*^9, 
   3.879703241032983*^9}, {3.8797035875128317`*^9, 3.879703588168993*^9}, {
   3.8798305275266*^9, 3.8798305426796217`*^9}, {3.879879527056673*^9, 
   3.879879544833469*^9}, 3.87987975611831*^9},
 CellLabel->"In[13]:=",ExpressionUUID->"3cab3b94-7ae6-4a7d-9b80-a89939421b02"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plotting", "Section",
 CellChangeTimes->{{3.87987924330765*^9, 3.879879244923197*^9}, {
  3.87987945209233*^9, 
  3.879879453543911*^9}},ExpressionUUID->"3fb8b87f-d7cd-43eb-81f8-\
304b2407edbc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CreateMassPlot", "[", "inputData", "]"}]], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, 3.879597260947003*^9, {
   3.879703629763515*^9, 3.879703747494426*^9}, {3.879704188185258*^9, 
   3.879704188783512*^9}, {3.879704544338423*^9, 3.879704565083949*^9}, {
   3.879830556817265*^9, 3.8798305598020487`*^9}, 3.8798797710741653`*^9},
 CellLabel->"In[14]:=",ExpressionUUID->"b33d283b-c4ff-4b6d-9a50-a051efe91313"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], Thickness[Tiny], 
      StyleBox[LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7G0vFGUvdn5kD+F/sD/Xy7Gled1DKP+H/Zd7
mpdY4x/YG4PBb/t84cyZ027eg8r/sU8pkuq44XPP/uwZEPhjr2itvd1o1137
WTNB4K+9lLNKm6DyXfs0MPhnf8TaoVui8w7UvP/24sfuLxZ4dxtqHoPD19Wz
5j8MhvGZHOx2nqk7tOwGVD+Twwuz1uJNdjeg9jE5aHF/Sr7y/DrUPGYHASUL
lsPLrkPtZ3Z4a2TjvKLluv2bwB1yra+ZHZrn+/x50Xfd/vRC122f/zI75K3X
N/acfh1qH4vD4iUPpyv+vmZvGrfLk4eJxeHwjzRhn//X7EXWuT+sEmFxuHtR
6v4uletQ97A49D48w1p26jrUPSwOB2xPndOecQPqHlaHewdNdcJSbkLdw+rw
tT7j7Se9W1D72Bys11aacv6A8TkcUjZ9P/H0DCx8eRzOPruiNO8wLH4EHB5W
xc2L3fIYar6ww87ZhRdkrz22BwDlGr+s
        "]],
       FontFamily->$CellContext`Latin $CellContext`Modern \
$CellContext`Roman]}}, {{}, {}}}, {{}, 
    {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
     1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7G0vFGUvdn5kD+F/sD/Xy7Gled1DKP+H/Zd7
mpdY4x/YG4PBb/t84cyZ027eg8r/sU8pkuq44XPP/uwZEPhjr2itvd1o1137
WTNB4K+9lLNKm6DyXfs0MPhnf8TaoVui8w7UvP/24sfuLxZ4dxtqHoPD19Wz
5j8MhvGZHOx2nqk7tOwGVD+Twwuz1uJNdjeg9jE5aHF/Sr7y/DrUPGYHASUL
lsPLrkPtZ3Z4a2TjvKLluv2bwB1yra+ZHZrn+/x50Xfd/vRC122f/zI75K3X
N/acfh1qH4vD4iUPpyv+vmZvGrfLk4eJxeHwjzRhn//X7EXWuT+sEmFxuHtR
6v4uletQ97A49D48w1p26jrUPSwOB2xPndOecQPqHlaHewdNdcJSbkLdw+rw
tT7j7Se9W1D72Bys11aacv6A8TkcUjZ9P/H0DCx8eRzOPruiNO8wLH4EHB5W
xc2L3fIYar6ww87ZhRdkrz22BwDlGr+s
      "]]}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], Thickness[Tiny], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7N89OiS3MfCdPYT/wX5JcHdO09SXUP4Pe5cS
faeAl0/tjcHgt31X7IIfVz89gcr/sf9bVW4od/iJ/dkzIPDHPuJvR/XKGU/s
Z80Egb/2Zn3sx4yKn9ingcE/+69zrscXBD2BmvffPvn3X0s+M5h5DA5OdRMn
HZWF8ZkcwsRtzyy4+Riqn8nh2c/Yuuyrj6H2MTns9Nr6gP/KY6h5zA6um31D
WoDyEPuZHZQuuLS+Aup/E7hDrvU1s8OMS4ZNP+4/tj+90HXb579A9a2rWdY9
fAy1j8WhQFK3/OHtx/amcbs8eZhYHBZYXv/8DMgXWef+sEqExeFeDUuPxB2Y
e1gcnO/e0v15B+YeFofm0vIwsXsw97A6HM3frGh3H+YeVoek/+UHih/A7GNz
YDU8GrAPbj+HQ9sDxa+Wr2B8HofLXwz+MJnCwkPAwXIB75/PRc+g5gs77Nl+
bJOz/Et7ABuRxLk=
       "]]}}, {{}, {}}}, {{}, 
    {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
     1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7N89OiS3MfCdPYT/wX5JcHdO09SXUP4Pe5cS
faeAl0/tjcHgt31X7IIfVz89gcr/sf9bVW4od/iJ/dkzIPDHPuJvR/XKGU/s
Z80Egb/2Zn3sx4yKn9ingcE/+69zrscXBD2BmvffPvn3X0s+M5h5DA5OdRMn
HZWF8ZkcwsRtzyy4+Riqn8nh2c/Yuuyrj6H2MTns9Nr6gP/KY6h5zA6um31D
WoDyEPuZHZQuuLS+Aup/E7hDrvU1s8OMS4ZNP+4/tj+90HXb579A9a2rWdY9
fAy1j8WhQFK3/OHtx/amcbs8eZhYHBZYXv/8DMgXWef+sEqExeFeDUuPxB2Y
e1gcnO/e0v15B+YeFofm0vIwsXsw97A6HM3frGh3H+YeVoek/+UHih/A7GNz
YDU8GrAPbj+HQ9sDxa+Wr2B8HofLXwz+MJnCwkPAwXIB75/PRc+g5gs77Nl+
bJOz/Et7ABuRxLk=
      "]]}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], Thickness[Tiny], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7GW3B8wJjPtuD+F/sDecxbhv6dKvUP4Pe395
W9O4rM/2xmDw215wwoc3oW2foPJ/7Hn4VzcU+X6yP3sGBP7YHyj33rBY5JP9
rJkg8Ne+yMcy/MPtj/ZpYPDP/rjHxZqExR+h5v23Pyb0k+l/1keoeQwOh9TO
PbtuBOMzObTdO/jKS+EDVD+Tw4eA9Nkvrr2H2sfk8EQoyLU5/z3UPGYHX9VE
iSju91D7mR1qZ964LrLmnf2bwB1yra+ZHSRfBS0MS3tnf3qh67bPf5kd6rtq
fx0Mfwe1j8WBU/uilZPtO3vTuF2ePEwsDtNd9m5fb//OXmSd+8MqERYHu5nf
23tC30Hdw+JQ53nzYuG2d1D3sDg0xRTJ/dODuYfVIV/zrvDdZTD3sDoUNIsu
E+L/ALWPzcGVp3pBoheMz+EQ3Ol/XDYP5n8eh5v3u19enfkZyhdwiEgI3NvU
8xVqvrBDrlyhmHPSd3sA/vm5YA==
       "]]}}, {{}, {}}}, {{}, 
    {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
     1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7GW3B8wJjPtuD+F/sDecxbhv6dKvUP4Pe395
W9O4rM/2xmDw215wwoc3oW2foPJ/7Hn4VzcU+X6yP3sGBP7YHyj33rBY5JP9
rJkg8Ne+yMcy/MPtj/ZpYPDP/rjHxZqExR+h5v23Pyb0k+l/1keoeQwOh9TO
PbtuBOMzObTdO/jKS+EDVD+Tw4eA9Nkvrr2H2sfk8EQoyLU5/z3UPGYHX9VE
iSju91D7mR1qZ964LrLmnf2bwB1yra+ZHSRfBS0MS3tnf3qh67bPf5kd6rtq
fx0Mfwe1j8WBU/uilZPtO3vTuF2ePEwsDtNd9m5fb//OXmSd+8MqERYHu5nf
23tC30Hdw+JQ53nzYuG2d1D3sDg0xRTJ/dODuYfVIV/zrvDdZTD3sDoUNIsu
E+L/ALWPzcGVp3pBoheMz+EQ3Ol/XDYP5n8eh5v3u19enfkZyhdwiEgI3NvU
8xVqvrBDrlyhmHPSd3sA/vm5YA==
      "]]}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], Thickness[Tiny], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7F+52z1tafphD+F/sNc4cvNhGROM/8M+PKnn
yHzpH/bGYPDbnuvCu/YUNZj8H3ufSz4SZpo/7M+eAYE/9j3RwVukdH7Yz5oJ
An/t91RbMojr/7BPA4N/9gcXNl7SN4KZ99+efaHkxAxTmHkMDpu21x4+YgHj
Mzmki3JbxfjA9DM5XElM3s0eCLOPycFpWuYfmTCYecwOT9buULoZDbOf2aHp
y+uu50k/7N8E7pBrfc3ssP3/gdT7WT/sTy903fb5L7PDufaKtQa5MPtYHHb8
Pt/hk/rD3jRulycPE4uDSLaUagSQL7LO/WGVCIvD1XW33+1IhbmHxcHN8O6m
m2kw97A43LrEumpuOsw9rA65W8V1BDNg7mF1OHn4rmZsBsw+NgfmM2L+k+B8
DodXO6W1+DNhfB6HpvPRorZwvoDDo98mnoszYeYLO5S+S63TzPlhDwC46bqj

       "]]}}, {{}, {}}}, {{}, 
    {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
     1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7F+52z1tafphD+F/sNc4cvNhGROM/8M+PKnn
yHzpH/bGYPDbnuvCu/YUNZj8H3ufSz4SZpo/7M+eAYE/9j3RwVukdH7Yz5oJ
An/t91RbMojr/7BPA4N/9gcXNl7SN4KZ99+efaHkxAxTmHkMDpu21x4+YgHj
Mzmki3JbxfjA9DM5XElM3s0eCLOPycFpWuYfmTCYecwOT9buULoZDbOf2aHp
y+uu50k/7N8E7pBrfc3ssP3/gdT7WT/sTy903fb5L7PDufaKtQa5MPtYHHb8
Pt/hk/rD3jRulycPE4uDSLaUagSQL7LO/WGVCIvD1XW33+1IhbmHxcHN8O6m
m2kw97A43LrEumpuOsw9rA65W8V1BDNg7mF1OHn4rmZsBsw+NgfmM2L+k+B8
DodXO6W1+DNhfB6HpvPRorZwvoDDo98mnoszYeYLO5S+S63TzPlhDwC46bqj

      "]]}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], Thickness[Tiny], 
      LineBox[{{1.984491639746671, 1.69}, {2., 1.6857893792269998`}, {2.25, 
       1.6190065573845156`}, {2.3, 1.6059940125185954`}, {2.35, 
       1.5931485797657519`}, {2.4, 1.5804984071936012`}, {2.45, 
       1.5680885521804322`}, {2.49, 1.5583612698008444`}, {2.499, 
       1.5561742797647824`}, {2.5, 1.554215097827781}, {2.501, 
       1.554508265295178}, {2.51, 1.5571439385556936`}, {2.55, 
       1.5689756144354043`}, {2.6, 1.58387025454578}, {2.65, 
       1.5987845389954118`}, {2.7, 1.613679232239725}, {2.75, 
       1.6285404145830331`}, {2.9588436241980665`, 
       1.69}}]}}, {{}, {}}}, {{}, 
    {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
     1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7A90fnwROJfBAcL/YK/Jy3ntk/t/ewj/h/15
TbnVf9T+2huDwW/782ub+cU8/kDl/9hHLnqdqSbwx/7sGRD4Yy+WGb/E8MZv
+1kzQeCv/cajdjxOC37bp4HBP/u4cwVb4zN+Q837b1/Rnss90+A31DwGhw9T
d3v8+/ELymdyuDe3Prv4+U+ofiYHr1zR42qbfkLtY3KwNqmJ7az9CTWP2eFv
zpJNOzx/Qu1ndhDv7WV9IvbT/k3gDrnW18wOF2KErHje/7A/vdB12+e/zA4K
pekM4s9+QO1jceh81bhM4N4Pe9O4XZ48TCwOGvd5+F3u/7AXWef+sEqExaFA
z+Qw/6sfUPewOHR1N+u0ScHcw+LwWJItrCMc5h5WB/X4oxLzp8Dcw+owz7k7
YOHFn1D72BxEJ59NaeCD+ZfDwcuhvfamNSw8eByShcyXzWn6C+ULOHjJsF1/
Muc/1Hxhh4wnUu9U7jI4AABlzLY9
      "]]}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], Thickness[Tiny], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7CH0Bxz0DzjfGAx+o8n/gfPPngEBBH/WTBD4
C+engcE/NPP+o5nH4IDKZ3JA1Y/gQ+xD8CHmMcP5EPsR/DeBO+RaXyP4pxe6
bvv8F8GH0CxwvmncLk8eJgRfZJ37wyoRBB/iHgQf4h4EH+IeVjT3IPgQmg2N
z4HG50HjC6CZLwznAwCjyWaz
       "]]}}, {{}, {}}}, {{}, 
    {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
     1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7CH0Bxz0DzjfGAx+o8n/gfPPngEBBH/WTBD4
C+engcE/NPP+o5nH4IDKZ3JA1Y/gQ+xD8CHmMcP5EPsR/DeBO+RaXyP4pxe6
bvv8F8GH0CxwvmncLk8eJgRfZJ37wyoRBB/iHgQf4h4EH+IeVjT3IPgQmg2N
z4HG50HjC6CZLwznAwCjyWaz
      "]]}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], Thickness[Tiny], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7Oesnvhz3rSf9hD+B/vTLoqpL1/C+D/sj0cH
57gL/7I3BoPf9nv+/VdNVvgFlf9jf05k45XJyr/sz54BgT/2pxofCB1W+2U/
ayYI/LWPca+p/az5yz4NDP7ZxwQujdHUhZn33/6OSGhcugHMPAaHhAZh8Q3G
MD6Tw+JbP1X/usD0MzlImtZ8XeEBs4/JYdmba6q5PjDzmB1W6bhmBQfA7Gd2
cHK711Eb8sv+TeAOudbXzA4HXUxaHCN+2Z9e6Lrt819mB3XVMz91ImH2sTjE
FjE/dA37ZW8at8uTh4nF4VrBzMsgvsg694dVIiwObTEtdiA+xD0sDpyfP9Y7
hcHcw+Ig4Sm+yC4M5h5Wh0U/49OtwmDuYXWomBndaRoGs4/NoclqabABnM/h
wD9j7SF+OJ/H4c39lxyrQmF8AQe3QP7flaEw84UdZN/EGLuE/7IHACN8trQ=

       "]]}}, {{}, {}}}, {{}, 
    {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
     1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7Oesnvhz3rSf9hD+B/vTLoqpL1/C+D/sj0cH
57gL/7I3BoPf9nv+/VdNVvgFlf9jf05k45XJyr/sz54BgT/2pxofCB1W+2U/
ayYI/LWPca+p/az5yz4NDP7ZxwQujdHUhZn33/6OSGhcugHMPAaHhAZh8Q3G
MD6Tw+JbP1X/usD0MzlImtZ8XeEBs4/JYdmba6q5PjDzmB1W6bhmBQfA7Gd2
cHK711Eb8sv+TeAOudbXzA4HXUxaHCN+2Z9e6Lrt819mB3XVMz91ImH2sTjE
FjE/dA37ZW8at8uTh4nF4VrBzMsgvsg694dVIiwObTEtdiA+xD0sDpyfP9Y7
hcHcw+Ig4Sm+yC4M5h5Wh0U/49OtwmDuYXWomBndaRoGs4/NoclqabABnM/h
wD9j7SF+OJ/H4c39lxyrQmF8AQe3QP7flaEw84UdZN/EGLuE/7IHACN8trQ=

      "]]}, {{}, {}}}, {{}, {{}, {}, 
     {GrayLevel[0], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], Thickness[Tiny], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7AV5hV44B362h/A/2Pv5KCl4F8L4P+xD/7Pf
jm/9bG8MBr/tY5ynz3reA5P/Y9/oXmFyo++z/dkzIPDH3shs0cJLEz7bz5oJ
An/tV0/fwn5j0mf7NDD4Z2/zS5bv9RSYef/tJQ95LOSZDjOPwUEilv+n7UwY
n8khL/pat8lSmH4gP9Vb5vRymH1MDlHlhx4UrYKZx+yQ7sCQZLgWZj+zg4zf
XzXpDZ/t3wTukGt9zewg0cp5bvumz/anF7pu+/yX2SFpc7xv1GaYfSwOTcvr
dSM2frY3jdvlycPE4tB7KUYZxBdZ5/6wSoTF4fKmXZvDN8Lcw+KQvT56T+hG
mHtYHA5MdZMN3ghzD6tD4oul2QEbYe5hdShq6yj13Qizj83hlXhCrhecz+GQ
1jSHxRLO53E4d2LTFC44X8DB9n7sA164+cIO2e9eXHQA+gcAMQi6pw==
       "]]}}, {{}, {}}}, {{}, 
    {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7AV5hV44B362h/A/2Pv5KCl4F8L4P+xD/7Pf
jm/9bG8MBr/tY5ynz3reA5P/Y9/oXmFyo++z/dkzIPDH3shs0cJLEz7bz5oJ
An/tV0/fwn5j0mf7NDD4Z2/zS5bv9RSYef/tJQ95LOSZDjOPwUEilv+n7UwY
n8khL/pat8lSmH4gP9Vb5vRymH1MDlHlhx4UrYKZx+yQ7sCQZLgWZj+zg4zf
XzXpDZ/t3wTukGt9zewg0cp5bvumz/anF7pu+/yX2SFpc7xv1GaYfSwOTcvr
dSM2frY3jdvlycPE4tB7KUYZxBdZ5/6wSoTF4fKmXZvDN8Lcw+KQvT56T+hG
mHtYHA5MdZMN3ghzD6tD4oul2QEbYe5hdShq6yj13Qizj83hlXhCrhecz+GQ
1jSHxRLO53E4d2LTFC44X8DB9n7sA164+cIO2e9eXHQA+gcAMQi6pw==
      "]]}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.010000000000000023`, 0},
  BaseStyle->{
   FontFamily -> $CellContext`Latin $CellContext`Modern $CellContext`Roman},
  DisplayFunction->Identity,
  Epilog->{
    GrayLevel[0], 
    AbsoluteDashing[Medium], 
    LineBox[{{2.625, 0.37}, {3.45, 0.19}}], 
    GrayLevel[0, 0], 
    EdgeForm[
     Thickness[Tiny]], 
    RectangleBox[{2.4, 0.33}, {2.6, 0.41}], 
    InsetBox[
     GraphicsBox[{{{}, {{{
           Directive[
            AbsoluteThickness[1.6], 
            FontFamily -> $CellContext`Latin $CellContext`Modern \
$CellContext`Roman, 
            RGBColor[0, 0, 1], 
            PointSize[0.02]], 
           PointBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQDQEP7G0vFGUvdn5kD+F/sD/Xy7Gled1DKP+H/Zd7
mpdY4x/YG4PBb/t84cyZ027eg8r/sU8pkuq44XPP/uwZEPhjr2itvd1o1137
WTNB4K+9lLNKm6DyXfs0MPhnf8TaoVui8w7UvP/24sfuLxZ4dxtqHoPD19Wz
5j8MhvGZHOx2nqk7tOwGVD+Twwuz1uJNdjeg9jE5aHF/Sr7y/DrUPGYHASUL
lsPLrkPtZ3Z4a2TjvKLluv2bwB1yra+ZHZrn+/x50Xfd/vRC122f/zI75K3X
N/acfh1qH4vD4iUPpyv+vmZvGrfLk4eJxeHwjzRhn//X7EXWuT+sEmFxuHtR
6v4uletQ97A49D48w1p26jrUPSwOB2xPndOecQPqHlaHewdNdcJSbkLdw+rw
tT7j7Se9W1D72Bys11aacv6A8TkcUjZ9P/H0DCx8eRzOPruiNO8wLH4EHB5W
xc2L3fIYar6ww87ZhRdkrz22BwDlGr+s
            "]]}}}, {{}, {}}}, {{}, {{{}, {}, {
           Hue[0.67, 0.6, 0.6], 
           Directive[
            PointSize[
             NCache[
              Rational[7, 360], 0.019444444444444445`]], 
            AbsoluteThickness[1.6], 
            RGBColor[0, 0, 1], 
            Thickness[Tiny]], 
           
           LineBox[{{0.5, 0.5707566355326957}, {1., 0.5525530353810895}, {1.5,
             0.5115994553334233}, {1.7, 0.4820305345677331}, {1.75, 
            0.4734402970441691}, {1.8, 0.4644896305807596}, {1.85, 
            0.45526540851374053`}, {1.9, 0.4458676681396663}, {1.95, 
            0.4364053345044296}, {2., 0.4269947107920296}, {2.25, 
            0.38517820723327023`}, {2.3, 0.3788267257813076}, {2.35, 
            0.37352475891400394`}, {2.4, 0.369553331489926}, {2.45, 
            0.367471757563904}, {2.49, 0.36809754026989355`}, {2.499, 
            0.36860876082095373`}}]}}}, {{}, {}}}, {{}, {{{}, {}, {
           Hue[0.67, 0.6, 0.6], 
           Directive[
            PointSize[
             NCache[
              Rational[7, 360], 0.019444444444444445`]], 
            AbsoluteThickness[1.6], 
            RGBColor[0, 0, 1], 
            Thickness[Tiny]], 
           
           LineBox[{{2.5, 0.359077833482454}, {2.501, 0.3593321027254996}, {
            2.51, 0.3616168192632168}, {2.55, 0.3717322403567998}, {2.6, 
            0.384287788337101}, {2.65, 0.3967490607965639}, {2.7, 
            0.40911553558726094`}, {2.75, 0.42138891431996556`}, {3., 
            0.48125595689524503`}, {3.5, 0.5863791160874939}, {4., 
            0.6157672970910789}, {4.8, 0.619887263409388}}]}}}, {{}, {}}}}, {
      DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
       NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
       AxesLabel -> {None, None}, 
       AxesOrigin -> {2.4100000000000055`, 0.35000000000000075`}, 
       BaseStyle -> {
        FontFamily -> $CellContext`Latin $CellContext`Modern \
$CellContext`Roman}, DisplayFunction :> Identity, 
       Frame -> {{True, True}, {True, True}}, 
       FrameLabel -> {{None, None}, {None, None}}, 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       FrameTicksStyle -> Directive[Automatic, 8], GridLines -> {None, None}, 
       GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], ImageSize -> 160, LabelStyle -> {
         GrayLevel[0]}, 
       Method -> {
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}}, PlotRange -> {{2.41, 2.59}, {0.35, 0.39}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
       Ticks -> {Automatic, Automatic}}], {4.05, 0.18}]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->500,
  LabelStyle->{
    GrayLevel[0]},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0.01, 4.99}, {-0.16, 1.69}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879879548294207*^9, 3.879879585444961*^9, 3.8798796434497433`*^9, {
   3.879879743728422*^9, 3.8798797725222187`*^9}, 3.879879885175261*^9, 
   3.879880039353731*^9, 3.8798800727112427`*^9, 3.879880120515881*^9, 
   3.8805348805182743`*^9, 3.880535690796277*^9, 3.880549244672195*^9, 
   3.880549325988179*^9, 3.880549495051324*^9, 3.880613223431552*^9, 
   3.8806192379103355`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"e1633aa1-03d3-4b3c-ba63-60821a0af21b"]
}, Open  ]]
}, Open  ]]
}, Closed]]
},
WindowSize->{808.5, 735.75},
WindowMargins->{{141, Automatic}, {Automatic, 0}},
FrontEndVersion->"13.1 for Microsoft Windows (64-bit) (June 17, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e37710aa-58a4-4495-8e6f-71723ceff036"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 156, 3, 98, "Title",ExpressionUUID->"f0ef8759-47dd-4d6d-832f-9103af72e689"],
Cell[CellGroupData[{
Cell[761, 29, 199, 4, 67, "Section",ExpressionUUID->"497bb92b-065a-4d63-bc70-c246b06b95d2"],
Cell[963, 35, 5309, 137, 276, "Input",ExpressionUUID->"c298cd96-4a47-4861-94c2-9d9dcedc9413"],
Cell[6275, 174, 695, 13, 28, "Input",ExpressionUUID->"81ef99c1-0bac-4ffe-97b2-65fac95b495f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7007, 192, 151, 3, 67, "Section",ExpressionUUID->"2ded8988-14d0-483e-a523-16c8a37e0f08"],
Cell[CellGroupData[{
Cell[7183, 199, 795, 13, 48, "Input",ExpressionUUID->"6222af51-66fa-4ea1-9651-a5c2c72f2452"],
Cell[7981, 214, 43159, 727, 329, "Output",ExpressionUUID->"be88dd94-4a71-4f71-8910-ee9a9b18af5a"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[51201, 948, 200, 4, 72, "Title",ExpressionUUID->"58207fe0-a924-4f6c-a139-bda5d005af5d"],
Cell[CellGroupData[{
Cell[51426, 956, 199, 4, 67, "Section",ExpressionUUID->"0071b4a0-08ee-42ff-bfb2-74977630c52e"],
Cell[51628, 962, 6562, 170, 333, "Input",ExpressionUUID->"41001fd5-1be1-417d-8f0a-42f6db906069"],
Cell[58193, 1134, 1291, 26, 48, "Input",ExpressionUUID->"a93caa63-f53f-463d-9a98-f48f537e74cc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59521, 1165, 200, 4, 67, "Section",ExpressionUUID->"248d86e3-1ed3-4e22-9fff-74deaaf700c7"],
Cell[CellGroupData[{
Cell[59746, 1173, 288, 5, 28, "Input",ExpressionUUID->"d0a3905e-676d-4ede-b903-a97967b2e736"],
Cell[60037, 1180, 82971, 1381, 329, "Output",ExpressionUUID->"003bfe16-8874-428a-abd9-88293ef0493e"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[143069, 2568, 255, 4, 72, "Title",ExpressionUUID->"7ba60490-0282-49f6-bac3-a322235190ba"],
Cell[CellGroupData[{
Cell[143349, 2576, 199, 4, 67, "Section",ExpressionUUID->"b1513d17-e0bd-4433-89bd-f5c647f88961"],
Cell[143551, 2582, 19582, 491, 828, "Input",ExpressionUUID->"aef02028-f638-4a28-8fb1-62e0eeb07052"],
Cell[163136, 3075, 735, 14, 28, "Input",ExpressionUUID->"3cab3b94-7ae6-4a7d-9b80-a89939421b02"]
}, Open  ]],
Cell[CellGroupData[{
Cell[163908, 3094, 200, 4, 67, "Section",ExpressionUUID->"3fb8b87f-d7cd-43eb-81f8-304b2407edbc"],
Cell[CellGroupData[{
Cell[164133, 3102, 585, 8, 28, "Input",ExpressionUUID->"b33d283b-c4ff-4b6d-9a50-a051efe91313"],
Cell[164721, 3112, 15892, 325, 335, "Output",ExpressionUUID->"e1633aa1-03d3-4b3c-ba63-60821a0af21b"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}
]
*)

