# Phase transitions and light scalars in bottom-up holography; data release

This dataset contains the data points in the plots of the preprint [Phase transitions and light scalars in bottom-up holography][https://arxiv.org/abs/2212.07954].

If you use this data release in the context of your research, please cite the aforementioned paper.

## Data layout of files

Figures 1-4 and the left panel of Figure 9 are represented by the file `SpectrumData.csv`. For the left panel of Figure 9, the results of the probe approximation calculation are represented by a separate file, `ProbeData.csv`. The files contain columns:

* `Delta`: parameter appearing in the scalar potential of the model.
* `Spin`: spin of the composite state, with 0 indicating scalar, 1 vector, and 2 tensor.
* `phi_I`: parameter appearing in the IR expansion of the confining solution.
* `M^2/|M|`: where M^2 is the mass squared.

Figure 10 is represented by the file `CriticM.csv`. It contains columns:

* `Spin`: spin of the composite state, with 0 indicating scalar, 1 vector, and 2 tensor.
* `Delta`: parameter appearing in the scalar potential of the model.
* `M^2/|M|`: where M^2 is the mass squared.

The dataset above can be read, and plots can be reproduced with the help of the Wolfram Mathematica notebook `SpectrumPlots.nb`. 

Figures 5-8, the right panel of Figure 9, and Figure 11 are represented by the file `FreeEnergy.csv`. It contains columns:

* `Delta`: parameter appearing in the scalar potential of the model.
* `solution_type`: type of solution, with 0 indicating confining solutions and 1 indicating domain-wall solutions.
* `phi_I`: parameter appearing in the IR expansion of either the confining or domain-wall solutions.
* `hatphi_J`: the normalised source.
* `hatF`: the normalised free energy.

The dataset above can be read, and plots can be reproduced with the help of the Wolfram Mathematica notebook `FreeEnergyPlots.nb`.