(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1164110,      20207]
NotebookOptionsPosition[   1155303,      20042]
NotebookOutlinePosition[   1155722,      20059]
CellTagsIndexPosition[   1155679,      20056]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Free Energy Plots", "Title",
 CellChangeTimes->{{3.699605342354641*^9, 3.699605343482767*^9}, {
  3.786375975784514*^9, 3.786375981887814*^9}, {3.8697263382971973`*^9, 
  3.869726342057108*^9}, {3.879584516310639*^9, 3.879584554478018*^9}, {
  3.879594977541781*^9, 3.8795949808929577`*^9}, {3.879595216220639*^9, 
  3.879595218196191*^9}},ExpressionUUID->"9280be19-2d04-4c67-8ad1-\
72125d11421f"],

Cell[CellGroupData[{

Cell["Initialize", "Section",
 CellChangeTimes->{{3.879586934628786*^9, 3.879586935610271*^9}, {
  3.879595403675497*^9, 
  3.8795954426989603`*^9}},ExpressionUUID->"4e654dc9-ee16-427f-bcff-\
6b611fa9541e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF_", ",", "\[CapitalDelta]_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "temp", ",", "Fvs\[Phi]\[Alpha]p", ",", "FDWvs\[Phi]\[Alpha]p", ",", 
       "Fvs\[Phi]\[Alpha]m", ",", "Fvs\[Phi]\[Alpha]", ",", 
       "FDWvs\[Phi]\[Alpha]m"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"temp", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "\[Equal]", 
           RowBox[{"{", 
            RowBox[{"\[CapitalDelta]", ",", "0"}], "}"}]}], "&"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Fvs\[Phi]\[Alpha]p", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"temp", "[", 
          RowBox[{"[", 
           RowBox[{"i1", ",", 
            RowBox[{"{", 
             RowBox[{"4", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i1", ",", 
           RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"temp", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "\[Equal]", 
           RowBox[{"{", 
            RowBox[{"\[CapitalDelta]", ",", "1"}], "}"}]}], "&"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"FDWvs\[Phi]\[Alpha]p", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"temp", "[", 
          RowBox[{"[", 
           RowBox[{"i1", ",", 
            RowBox[{"{", 
             RowBox[{"4", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i1", ",", 
           RowBox[{"Length", "[", "temp", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Fvs\[Phi]\[Alpha]m", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Fvs\[Phi]\[Alpha]p", "[", 
             RowBox[{"[", 
              RowBox[{"i1", ",", "1"}], "]"}], "]"}]}], ",", 
           RowBox[{"Fvs\[Phi]\[Alpha]p", "[", 
            RowBox[{"[", 
             RowBox[{"i1", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i1", ",", 
           RowBox[{"Length", "[", "Fvs\[Phi]\[Alpha]p", "]"}]}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Fvs\[Phi]\[Alpha]", "=", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Fvs\[Phi]\[Alpha]m", "//", "Reverse"}], ",", 
         "Fvs\[Phi]\[Alpha]p"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"FDWvs\[Phi]\[Alpha]m", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"FDWvs\[Phi]\[Alpha]p", "[", 
             RowBox[{"[", 
              RowBox[{"i1", ",", "1"}], "]"}], "]"}]}], ",", 
           RowBox[{"FDWvs\[Phi]\[Alpha]p", "[", 
            RowBox[{"[", 
             RowBox[{"i1", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i1", ",", 
           RowBox[{"Length", "[", "FDWvs\[Phi]\[Alpha]p", "]"}]}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ListLinePlot", "[", 
         RowBox[{"Fvs\[Phi]\[Alpha]", ",", 
          RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "Full"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ListLinePlot", "[", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"FDWvs\[Phi]\[Alpha]p", "[", 
             RowBox[{"[", "i1", "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i1", ",", 
              RowBox[{"Length", "[", "FDWvs\[Phi]\[Alpha]p", "]"}]}], "}"}]}],
            "]"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", "Blue"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "Full"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ListLinePlot", "[", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"FDWvs\[Phi]\[Alpha]m", "[", 
             RowBox[{"[", "i1", "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i1", ",", 
              RowBox[{"Length", "[", "FDWvs\[Phi]\[Alpha]m", "]"}]}], "}"}]}],
            "]"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "Full"}]}], "]"}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.879591372286591*^9, 3.879591469105638*^9}, {
  3.879591543051403*^9, 3.87959157133181*^9}, {3.879594634710054*^9, 
  3.87959463646796*^9}, {3.8795972613269367`*^9, 
  3.879597261336966*^9}},ExpressionUUID->"5d76392a-8461-4f98-94ba-\
db672df52cf2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotOptions", ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ImageSize", "\[Rule]", "500"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "plotrange"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Automatic", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Latin Modern Roman\>\""}], ",", 
        "Bold"}], "}"}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.8697268671304417`*^9, {3.879592186546294*^9, 3.87959219060788*^9}, 
   3.8795950413369303`*^9},ExpressionUUID->"1f5e2b19-b451-4800-8083-\
f513f66d4e7f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", 
      "\"\<FreeEnergy.csv\>\""}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8795945881724663`*^9, 3.879594597496763*^9}, {
   3.8795951026530724`*^9, 3.8795951188444567`*^9}, 
   3.879597261344736*^9},ExpressionUUID->"59314870-7e52-4b94-b32f-\
ccb3522ef5c8"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[CapitalDelta]", "=", "0.5"}], ",", " ", "1", ",", " ", "1.5", 
   ",", " ", "3.5", ",", " ", "4", ",", " ", "4.8"}], 
  TraditionalForm]],ExpressionUUID->"12480097-0426-4076-b74d-f7185409da6a"]], \
"Section",
 CellChangeTimes->{{3.879595940949706*^9, 
  3.879595954859313*^9}},ExpressionUUID->"313fea30-fd9f-4208-b515-\
fcb4bba72eba"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "0.85"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, 
   3.879597260947003*^9},ExpressionUUID->"3374f5b6-9877-4e97-a6d1-\
1b88cdad541f"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.011111111111111112`], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxtm3dcz23Y/ttFSkvaw0iIblJkfa4iERklOyPZ2ZKdTSm7KFKR0qCBRHFe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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c41f8bxu3VMQ/HSogoSimjKM9HKqMvipaVQjtJRSotI0JKkYzI1kCI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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVlnc01f8fx+15zcu1EiJCKTKK8npLZfRFoWGl0FCpVEqlZURoKCojsjUQ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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-8, 8}, {-0.8, 0.85}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.879595306534096*^9, 3.87959547302907*^9, {
   3.879596433456541*^9, 3.879596447354084*^9}, 3.8795969319594316`*^9, 
   3.8795972747535667`*^9, 3.87959742155891*^9, 3.879601447569881*^9, 
   3.879604192226778*^9, 
   3.879606172065008*^9},ExpressionUUID->"e7fc6b26-958d-45ad-a030-\
b45ebcc48121"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "1.7"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.879595261334096*^9, 
   3.879595261773943*^9}, 3.8795953206909037`*^9, 
   3.87959726095172*^9},ExpressionUUID->"0d010cf1-4478-4c09-a84f-\
3836d03b600d"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxtm3dczm3Y/1NJaKddpOyVVQh9T7LLym0WkZW9V7JFQ2gRGQ2JJG2jcZwt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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVlnc01/8Xx+09PvjYM0qRMhKVcd++DU2pENGSiIYoM5ktQtkjo5SRETIj
Xi8rZGeGj5Ate33I+PX7657Hufd5z7nnnju2mduev0lHQ0Pzm5aG5v9W4aBz
aszxbVgpLIvuUmg6zC5RSoR2bcOHbe4q1fBlwMzYxJUx5m1Yy3yrlFyYAauH
2x3YxqTwt7lLzp/NPwGZbWr6cY0UjmGKUSCTMqH6pl+RzkcpvKT9s/9TXiYU
5qzXG/hJ4Wy3uLKQA1lA2+EskX9bCtPVigRwvcqC3Q9Z0yzOSGGt+7ZW69NZ
UCnvbn9VUQrfFPjg0nA2G6IOmjon8vzTr17xZvmUDXGCYc9vj0li5RgZfUWO
z+DXIIAkPkni0a3dbDqOn6Gs+1uO+UNJ3H7m+xuLns8wtUPKd7+GJOZBBVZq
R3Lg+Mt71mF0kvhzT2GAe1oOqGZ9fur5XQIPl7+f/yiUCza2T/mXgiXwiKtM
3dEXuVBS/9dozlQCr151eLS0nAteQv6BD3ZI4ADnywGkh3mgUzXH5Dojjrt9
Xd/oUvLAWY/MQ18kjh8xFpzx188HraA/9JxPxbFp66BJdHs+OJ+x0QzXF8dv
vp04vnWsAPJbzcRjxcSxmPcXXbuWAhC+YcwtNS6GFxO/NGWcLgRj03hP8Xwx
HCh1vd6jthDOurMOh/iI4USdiksaJl8gQu9Pntc5Max3idmI+/cXqH/CYD8s
KYaL5hHn+VtFAHxXY0umRXG6Ph5p3igCf5f/ylhKRfGLYFeWk37FMGwpfKcq
QBQzm7wzrub9CuQZM+X5y6I4m2ZOJbrkK9TdcP8YsFcUN/N79VD0S2D6b6td
+JYIdrbelvxntAQ+FlxWYG8RwV+NY6hb/qWgyXPMcyJBBIf83nY0dS+Ccs45
oX0OIjjrSJJWVB0CetVHSb91RfB6pNtsjiYG6htPypqICB4/Ec7A9RrD2fl9
Tk7TwthKUfyt6AgGhz2pSsblwnhW/Nl9I80yME79UvcmXBgrT7fuZI8sA1M2
XS6d28JY3kUcdS6WQdxus/JjhDDu4/7MFWFQDntVBfLT+IVxsrNfo2leOcjm
hBbfmxTCVzs6Tl/irYC62rGUwDIhbKUaanjaoQJ4ZRmM2SKFcAIX6XQspQI2
ElKS+u8JYb1bDhX6hyshq8PYkXRMCAs5DvtMpVVCnJZueqS4EH66+JhSz1cF
qVd1lZ2XBHHdyd9CoY+rwGBb6VxGgyA2d/+uFzhZBQuOwZQDSYJYWpGFi870
GwzXSowJeghidlYfr6H6b3B/eRvLSWNB/Pj6nc1CohokFLLVG5UFMasqq5FE
QTUIKMk9fM8uiE/s87m6oFADaubbSmuGBfC7Dctzcsk1UHrTTFgLC+BqOofR
3TK1YNRY7L8VLYDTPvj+mYyvhXYOFWluRwGs+NJ57xHJ77D1KW/E5pwADlLZ
5Xoq4Tv41+2b4Nkj8G/eXyrXy9bBTj8foGcVwOOmbOGeaXXAUGmyrjXMj9VE
HxjKqNZD81+Ng2Vl/LinsN3TEteDltpDHv84fpz+bo5D/kwDnHZhfB/7iB+P
lWvyXe5pAAsinmvJmB/vdKry2HW3EVbHgpyC1PjxyH82kh50TfCSsYLensyP
n8zVe3RGNkHM8YSesHky3tjpeeGDUDPU/xGXX28mY67zop9HbzaDbG+E2IdM
Mg7T/1q8K68ZRAy6B/0DyVj7ncURbcYWYPPnzMy7S8a8F7WEtIxagGM4PU/8
DBmTF1Vi+lJaYMTQbU+lAhk/9hyl27PRAmfo3M+mcJDxefftcXrnfwCt7phR
7R8+nFSkx5iZ8gMYbot6yTbw4dwXg+Q3NK2w6B/BiTL4sPma4Kdck1ZIP7yg
FRzIh8eyvtoo5bbCJasWw3hbPlymZETmIbVB3Vhn9LA+Hz6SPR11+G4bXBBM
MrBQ4cNZoSxV7XVtIH2jrl6EzIcblVzO9O5uh2CTUj2WZV7M7uulczygHXTV
WncqdPFi+Uudh3hm2yHCaF/y0yJeLOXLE+5q0AEKw63i5FheXKtMO7b+pQNI
fnf7Ojx4cUWbdtCsVCcwPnqg1WDOi79MzCd/9u2ELiH2oOWjvFioyboqY6ET
3tykVz4vx4unAmszGa52QeFEveMvDl48cCfwl1V9F8jI2ZXEzvJg4TOyZycO
/YSaFL/r/m08+AJzgu2n1J+gvE+rLLWQB9+Z+K2rLdYNIef2aFJjeHCn7Oec
O6+6QaPNed9DLx68q0mvrIm+B84czmSVsOTBjS+v3pZy7YGtoFrppZM8OH34
KLo/1wPGl2WGqIo8OOKKXWm6TS+4pdnn7uL/x47Ghx4M90K9StlfnzUSrg5M
rqu8ToH4BxYybP0kfKH/ws/6XxQ4trAcVlRFwk7B2Tt2Xe2D5VF9FJpGwt4K
obxa/X1wXMaLIzKIhK25NedbzX9BbnzlZIUTCTP4qt9mG/0F5n5P6wWvkPCR
7qgkB7V+CE48JRlyhISVb+WGCLv2w2+7YsP9u0lYgGHLwq+0HzSHAwY3eEjY
Lrr39gD9AMSG8T3omuPGJma7tGdPDAC/zN+4LcSNN+PdSjpfD0Byyn3V+4Hc
OGGzbuh21wCU6bFsk7vMjdE7rh9zUoOwoK5tIKfAjR2n4aOSzSCo77iNbP9y
4dVDJrTquYPw6V6B4d/vXDiTzjCbdmsQOJ5wc9RFc2Gec5rBb07+BiU5wZ8U
Gy5cziWqxhXxG2xHxfNUNLiwZTf9qT1Dv+FxNV90DTsXzqo7cFRWZQh0rnn4
xPVyYrU9JKtezyFYYLK+l5PBiXWL41yuNg9B2YkrJkwenPiCjKx9rNQwPGkx
OxKuz4k9e4o5o+2GISm3Vslc+p/+VOc+w4phYK6w3Ga9yIGZNXZPtvOPQH2U
rkjqNw7cVc3ixG09Amb01VLbozjwYTfG5PWvI9A57qbRcZsDy500lkvlGYW7
VvvskTYHln5oQmay+sdilIY+Hg6scU1/mK9kFEon/Yz3DbPj/WyhhW18YyB3
wFz8ayE79mU56E3cHgPz+eBdzv7sOJJV0/pCxRiInNF7bnmNHb8KY7IkiY2D
99ES3Weq7Niio2PWxmEcGhRWnDtY2HEDW1uWVdM4dDZS5Y0obHg0eAf7ptwE
bBi8ucfwmQ17xRt27n46AeWhLw37n7Fh7ZrexMn+CZC31ZkfM2XDBtevGKhr
TUL3iZWL4spsWJBV1pMjehKsp95FuzGx4euf1TMsVyZBw3KskbGXFYfm+7wF
wz/AwyvGVpjNil37eOOCcv6AXamSefBzVjxAzok05p0CG7e8qZDLrFiIdR/P
S7spKPtVX1G8jxWfo3K57myZghgp2XUWNlZ8b88LbxnlaShfXfrk2s+CfT+h
Gy5B07BdenaRu4AFB53j0Zaen4b7dsRodQALVmjdchW+MAP81U/i31mw4FdS
4i3nc2eguv+beowGC6ZM9GwOsc1C3APH7/m8LNj0OedWkcYsNHy8YT87zow1
7+ukJd+ZhaG7X04eL2PGwnWMpYmxsxDpR71XEsmMq7Lmf2c1zoJI9Pya3n1m
7JFCGqjcmoUmxyq2dV1mzKM3XNGrNAdt2Z1FFZLMeL/x5NeF63PAmtm8M3GF
CTf8vljKEDIHvx9G34tvYsKJEWJ9rJVzoPzoUnp2MhM2KGGx3FycA2tW281u
DyYs+ZwtrnfHPJx8dcdbxJgJTwvqqMUbzQNdsYiRrRIT7h/1Kdd+Pg99Z+wj
uliYsCxF7mt+wTzEjkVbGA4w4nTPW4dpxuZh6eV4z9AXRmxWLRFFFloAzvU+
0WfBjNh/THRrSncB7DdlDx+4zYgPSSsGP3FaAKpfxP21w4yYV1rW9UfSApS4
K1XUiTFi411rxU3tCyBXLXopbYkBJ+YuLjgwLIJOQYZBZCMDfrTqVfNVZRG+
Mlj+CEpmwL2k50Gx1xahcmR2PtyTAVduRMVzBy7CdcqujiQTBkzxsz3BXrwI
ByOEYrAKA/YNnNv9YnQRwj9uWPxmZ8BUX5lxd74l0NA4dY5rmB4fvzxNGdZe
gsC3GV5EKT3uj5BQy7NegvcLnIIuEfT48PU00lDIErhFhKsU3KfHB3ssxKxL
/sWjgqXVE/R4CisMaowswYVyBW9Chh7nzTO9P8+1DH4ZtGu+63TYpuh15fv9
y7D4McqjvZ0OZ4Q+9ZE1WwZd67z90pl0eNrk+qlmr2W4EugKti/oMJfwTv3I
pGXIkX2Ei6/TYSE6zf4H35fBjaG0l0mDDl+8+ohsMrUMqperC8+S6fBVM01R
be4VWBRNcAmbosX23MtSQkoroBYyfqTzGy32O5R1mXJ2BXy7WgnyW1o8sovP
wOfeCmg91ww95UKLb63I9G2+XIE5yLJ0O0+L3UrvSx5L+ae/6tyfuJsW59Le
7D1TsQKiacny1Qy0uIHgaWGnrACP+E7bXxQaLN7uU/twaQVqn1V0TeXTYIPD
H6+7c1CBM1AjZO4VDYbeSy7i0lTIPKdXN36LBq8OOD/RVaNCutv3T+06NHjn
TvrAueP//Fuxd3JFaLDj24lU0iUqCMvXW7ONbqFmgakd0dZU8FaisQ+M3EKl
upM1Pk5UuMux/+LCiS0Uhn/tLfehAuVxgJf6300kZ73H+1QgFQ6rCZiZpG8i
xfngb+QIKoTxThpcvLyJaulvTPLFUaF932WKItcmahoai9J+T4WXA8I2A6Ub
KPv8aL9fEhWyTc8/sLHdQBzDwj3TyVQwvzT0sFZyAwWt1X2/9o//WPhMrzet
I6/sI16dH6gQ1zZ4g95zHbkziZ448ZYKxUb9Zj2K6ygg4LpDRhQVCnQzb/r8
+osWjumf+fuaChE3GbjXAv+iyMfZR+SfUWF1QWdaS/svkshptlBxoQLZ/kPs
mak1RFrdRWG3ocKgk+3XnTFrqPbsHJFp/K++EZGZ7yfXUMxUuA//USrcOOn5
a//qKkowDJQ8oPiPdVm0rJJXEV3q3AxJkAp95K6vlw1XkZTBEjl6fQVESjaF
hehX0YuKsXONv1bA4lECf1gWFc2etJf5iFfA1GqPU+tlKtrT7cgtG78CziRX
jh9sVBSvV+qg8+hf/923Pr4qWEF3JNr2Uw1WYC1gXZ7dYgXVsITk6SqsQFd8
gt1h0gradN7S3Eu7Aj9NwUr96zIKbp0wSm1dBsGkm+vDVstogP2tc/H7ZVjT
45fT41tGNv2qEdftlmE1beDPvdIl5Pgp+3Ss5jLUtAqc1bVeQoqWhbL3GZdB
9DTlSgffErrLU63RW7cEtapm+0RLF9GddBr3oVdLsC/85yT51iIqXAow9T+3
BIyLXZnlPIvoA2OKUxdpCWYz1DNlihdQ9m7fXw0Ni3DYWFda3WIBhbWWB9m/
WASh1OET6xwLyM3O7FQDsQiyAsG29nnzSKHLIGl4eQHMczyHIy/Po4VZCbbK
1AUQdUtlsmWcRyUpM2/tzBZAPrVbbTF9DqUITd6nsi9AkMCXwZ0GcyhOLu/s
jS/zYOXW4sH6dxb5LuatlljMg/K9CP/Id7PozNDsDJlrHn7OWL5u051FtS6W
9xzy5mBmF726a88MusZgFzl1aQ5CB7gD38vOoBXv2Iv+m7Ogldtnvd1uGjGy
0VhcfzsLEqGjkutFU2jRgY54TMzCRgi7oDzDFPpptl12sGQG7tXcqs44/Qc9
zqzOi12ZBpfWHUXPQifRl5Abuef3TsNb2v2+uT0TyNb1VONO8yngXeT6pSY9
gbTuMP93NOQPBPtYOHLeGkeaXgcs28omgXmhWvhAxhgSnpee3JqaAKrqmff5
c6MoYkDx/YLgBHic37b+Yv8oKigty+yFcbiVLySW6TyCJHN+943dHIPOTFVW
ueJhJN0yf17XbxQsSiQ7l9eHUEvdja6dGSNQTf8uSUh7CG0Kz+0obhyGV2VM
iYHuv9Gz3Z4JKjNDsGvqObtJ6SCS5sgwxVxDIMoRK+G8MYAqbpsshO/5DchE
f88fjQG09IvNdvzUIMw5PX2d59KPyhPe6ExaD8B/D+wMPt79hQbyf8g0P++H
o353akNGKCi632ku4tQv6PYIvrH7Si/yulxzaccLCuwK+8Zn19aNtqcZX8uq
6gEeqnPHzRM/UX/ngbC3DN0Qf6Mrm62kE71QfcF6+WgXkLiXc64pdiD99D/H
T7/oAMqF3tlbb9sQ5eZmd2tDG5znivLcTmpF5laXdIwFWiFMXfNxqHsLej0y
W65p3gK7l8JpH3Y2oRnul8rfbjRBv/fFYwqZ9aix8GSrEXs9VHnSzV54UosE
NkyHRotroPkol/CU0TdkdfZmv7JjFfy3Wvp9VbYCUXWFq8YOlYODjv3cyhhC
l1leJjrxl4JrH2l1wv0LynK9eiG1vgBexxyUbubOQcpbXkufY7Ihc2TjgKH6
RyR+S3g8jjMZ+EJIUku+kej9sF7+N6VweGpzcNJgygg+Px+yP+ZpgKq7jh9O
f/QGrm1utpafjESSYv9ZH2lMBa3MTK5E62RkyGvvbLKYA23xhnPW6tlI790I
7+tnRcDcfSr3RVQ+Km/16h8MxHBMue/k2e5i5Cwfb7XRWwE2vyXfOLphtB6u
wRO5p/rf3LXF6K+Vo4A127c5nt8h61xjk5llFdoRbbHnXEcDfPeiqJzE1WiI
vZ18MKIZVl4/iW9i/o5I7joq/kd+QEfy2/40zXrEfCCQWWahFdp3vqpOvNKI
blpc6t9MaIfJvQ/pv6k1ozr1i1rbDDoB2Vu/j1ZtQXcZdDteMv2EhHctXHjX
D0SYzb0hirrh1qfbtnJ8rSgqkb1Ix7YX8j9f/tWw0Ira6vijgnb0waGriQdS
vrehAAf5fhXKL9BvYpAoiGhHBtrXNch1/fCkhn1o/VIHan23v+JQygBMjRDP
PcidiLZPvZTr2SAsstqZHq/sRBkNXxiDLX6DbHTHQwubLiTxzDP82+EhMDnE
sPmb6SeiSjwJ+iQzDPtCtG93R/1E6EWK5mmGEXD6nHfmikw3ErlhS58wPALX
FVYFfd93o+S6BKfP1aMwamRy10mkB42fXz3nmToG4qvY4viLHmS6/tmeK3Ac
HpeJF4pP9SAXJ8XBq/YT8ITmQLboiV4UUvi4xeniJNC3hnBYx/SiB7TD0SZa
fyDW0fPO3tFexOVtVc6yfQru6vUXh8tR0OkW7eUX7P/2DsNSe+MNChK6cZ67
b2Ea5KPKzjOGU9Bh5RQeDsoM8Ki0+9tgCvqyZBX+8sYslLf1ZSn+pqBrl7b3
0f6cBb594X+fb1JQyeaszKTeHOS0rcmn8PahB53s5Seq5kDIhDRZKdmH6jtU
5aQ05yFEUDSNLNuHqF86++/nzIOW0/SJxh196Fjfvufauxeg/eGVNbl/8Qdu
e7e8fL8A4alPHlz9l+9Qm4i/qdgiTPfVNiVvUVAKR3h0VtgipLod+KMxSkGS
T2ZXAriX4PKJIj+DWgpyYE/LX/Zdgglpf2J3EgXtWJigmWZYhsmeuFbqYwoi
3kQJOXkuw3MRnSdL+hT0Xt3nYtj6MhzoyH9tKklB8fkOiqddViDC8Lm/+Xgv
crp0VT5+eQU+nkr9qJPZi9gd7k4EPfz3p+yJvKps14sinHbL71r499cI356x
UuxFF90Svt60XwVv8SczIhM96LOfS4De/CpkDigNerzrQf1xAu9G7NfgpPa5
lDrDHpQ3jMkqi2vgsPP0tBJzD7omUymx3/EvRFNQ2GBeNxINC+NapP4Fp9iG
WF7zbpR5Yu30A7d16Ct3S59l70a3vBTNCmg2wKVJXSUt5ye6V0fuqny6Aabf
+AwfmPxEY4+NHd+yb8JNhs24Bxtd6M65JKazwZuwWaB09Gd8F8qz77VvF94C
mIg3aCC6kGvrbnQgYQt+JsYpPOrvRPyjhxgRPw3BTNrZyOLRiTZuKeq2X6Ih
yp7Yir4R60Q9u5uarr+lIcKAamX2pQOJxolftBqhIe6PSQnfN+xA9NGjCWMK
tERree2r5dl2VFk88mzsAS3RIZvgQ/JvR/HUkSHrYlrCXUm4ul+2HZEKptJt
6emITKO0XJ+yNrShcoOyfoqOMA44Xi1s1oaEy7R8yGF0BP0JbZrS5VaU4KJY
9KWPjgiMm7nwMqgVfcxuT/93swnuA2d9YxVaUQ9pMvTLA3oiW8vBiLbmB1Iq
eFQsguiJAgs51sEbP5ClhJiLADsDoVEaNaxN8wPVVG9Ty7rIQDxofBl1PLYF
RZv8spn8wEA0DLwLWj3UgkxtB+Pr5hkIk2jwtfnZjCwcVe8Z6DAS9ZtvbuU5
NyM6zTgP39eMRP6Vi8t9Qs3oqeR04L1+RkIlym6d+qAJGY8Qt5iVmYgq2xF1
zcJGtH3gzPhFbybC41CSTNhmA7r3Io/Woo2J8DQ0sjyk24DEVS7kKO5kJi4k
hfrtD65HVnTBvMiVmehmYP9A/KpDMScrjwk0MRMJpm0iCop1qOaRh9/B7SzE
Qk/wuoLXd3SWf3X3HlcWIovufcFiey1q4rYOWGpmIR5baEfa7KlFMf/d2xGx
i5U4txWn1Pi8BkkFOXoIeLESiP2I2MehamQcIK/p3M1KJHbdiZc/Uo20THt5
ylTZCPLJ3uP6Sd+Q4Nm1+qVXbMSc/PGFaPZv6NzKU33RP2yEe/WcUeyDKuSy
4B+udoKdYD9SZenUV4kW4pOzTiezEyf5RFdkT1ciTiXXGnMmDiIhUe1GxdcK
xGRzSMrdkoNQlPJOUVaqQNlMB/k+VHMQ1D0eB72TytFtJ1uBbjlOgsk94lqG
ZDkyO8jzZUcAJzHmjPemvSlD+RrSif5znMQ9gygBP5Ey1FFJeku+yEVENORK
EjEY+R8weFlRwkXY0j969EUKow/apJvxO7iJD3uzkaw+Quccvh7/FMhNyDTd
oh+xKEVrb5ttl6ncRPYb/fGKxyVIdvGQMKiQiBjvKln92K+II1WCIekWieB0
zw9PLCtGQyN3juTEkwhuzw1+ykQRKgy9r2bTSSJCXjxz6RcuQopmx3UbuXmI
qxcc4/fqfUG0oqeXBo/zEPW5v/Q9XhSiM5wOzWnePMR4Uc6DvdUFaO/5GleF
Eh6iNXlm2pulAJ09XJlyi8pDXOu6ZjxzPh+pbrRss1DlJXj2WhU/jMtDt4sL
sLQdL1G8PU67fyEX7TQiPUz59I97Fz9nnsxFYZqV2qt/eIkqaavXHEk5qP/j
swPCCnxE0EvBl6eYcpBfuWEgxx0+or7wV8mAzWcUI7Pp3ZnOR9x+pKYf15qN
Dga/s3Wf5iNymiWMGrWyUesbnUpGZTKxETlGGkjLQmyPzrDYPyQTssZXJHSl
s1DcAdWe6kIyYaxxSv6VeiZKGVldZN8kE1Uiew7ZKX5C2SvNsoeP8BOpS5sO
pvsykAZHoan9S35C1jOl5Z52OvJWEY2Ka+Un9ppE6y+dTUMXQl226sUECMs7
95G2RSoierjr6KwEiMeF/t/6nnxEtySfGRz9LECEmylLX09LQdZu73miNwUI
tD2Ot7MjGf3VYAxnOi1IhByJfK/Fmoyk/XtCXkcLEhslJ3TyTyUhZvG0Xq0J
QcLxzoLbXp9EJJrJa07WECKOnM8IPtb4AVXORaiJBAgRNdVpbwJ5PqDU406B
hv1CRNnllel3pu+RX4wrrlcVJkbI9qkVmQmI9X37sWd+wsTe9+meX8USEGMX
M34xIEykpRCmHA7v0CuiYqb7oAjBm8wX1dj0Ful0dCOfEBGiMy/D++/xtyjC
VV3Hb1qE4Pv60dfpdjxSS2tOXzopSvinqI6omMah53cyLRpSRInG3rJICf1Y
RMguLQqxiBGXig6XFx6LQe08k+T+W2KEeaiTHKH5Bq1fE0qRrxMj9AMTlz4e
i0YJt68iGkVxIiaIM7LGIgp5LstE24SKE/cqWgr2e0aip88dk+//FSfo2VTn
CxIjUEfbyeeiFhLE9tYz82E/wtG2y7nsDxslCAmj3rVttOEo3F7hkM8hSSI0
o813x4Ew9Kqx//T5FEnCNF0+x8I5FMU6MF5aYpciaPfaHP5aEoJEI1LY045I
EYzXN37Is4SgZ06Ru8+6SxFNj+GonnkwEnE5WD1SKEW40O17JVYUhMbd21id
FqWIkviNqWzhIPQ/GoxQvw==
       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVlnc8198Xx+29fewZpUgZico411elKRUiWhLREGUms0Uoe2SUMjJCZsR9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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-8, 8}, {-0.8, 1.7}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, {3.879595306667239*^9, 3.879595322239215*^9}, 
   3.879595473165341*^9, {3.879596433595359*^9, 3.879596447490705*^9}, 
   3.87959693209795*^9, 3.879597274878751*^9, 3.879597421690913*^9, 
   3.879601447767984*^9, 3.879604192358732*^9, 
   3.879606172200612*^9},ExpressionUUID->"a8d457a1-0f1b-4d6e-87ed-\
06bd1729c9f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9"}], ",", "2.9"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952843426733`*^9, 
   3.879595284438703*^9}, 3.879595335531414*^9, 
   3.879597260955765*^9},ExpressionUUID->"97ad55bc-2a45-464e-831d-\
f529594103e1"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxtm3dYzm/Y/xvSTnsoCtmSkT0+l50QsrKykj2yV4qMhlGRNNBetEtDdV5F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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVlndYDW4fxs+pzmnvvScqaSnqR56nKRQNTYmGEJIKSUsSCQ0hFdpFoV1a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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVlmdYzv8Xx++7uu/23kMblbQU9SOfU4lQNDQlGkJIKiQtSSSUhFRoF4V2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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-8, 8}, {-0.9, 2.9}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.879595306798767*^9, 3.87959533684604*^9, 
   3.8795954733502617`*^9, {3.879596433782022*^9, 3.87959644762263*^9}, 
   3.879596932225618*^9, 3.879597274999061*^9, 3.879597421820882*^9, 
   3.879601447905678*^9, 3.879604192542232*^9, 
   3.879606172355233*^9},ExpressionUUID->"455015f3-f007-432f-afc8-\
c38846662cac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "3.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.879595289168426*^9, 
   3.879595290470706*^9}, 3.879595350995791*^9, 
   3.87959726095989*^9},ExpressionUUID->"51bd983b-8573-46f6-990e-\
a183f7d18aee"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.006944444444444445], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxtm3dYzn3Y/1NW9ogos+y9yu60R0QhUWZGVoRCiqQoKymUkCREJKRCeqei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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV2c4138XtulPoRBJSZGtzMyPKCUpK0SyV8helR2ikL1ndtmRfb4IWdkr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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c4138Xxm2KQiEqkiJbmVnfI0pJykoi2Stkr2SHKGRlz+yyI7P3x87K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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-1.2, 1.2}, {-3, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.8795953069444036`*^9, 3.879595352422681*^9, 
   3.87959547347814*^9, {3.879596434015938*^9, 3.879596447762455*^9}, 
   3.879596932356299*^9, 3.879597275179821*^9, 3.879597422008741*^9, 
   3.879601448133243*^9, 3.879604192767775*^9, 
   3.8796061725072002`*^9},ExpressionUUID->"f448601c-492a-4bdc-ba5d-\
4fadcead43c0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7"}], ",", "0.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952941910763`*^9, 
   3.879595295278755*^9}, 3.879595367196748*^9, 
   3.879597260963807*^9},ExpressionUUID->"48c2cd83-1fe6-4dfb-afe6-\
9418688c174a"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.006944444444444445], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxtm3lYzW3UtjMnUwkZMybzHKFaSKZkJkNEigghIVOGZBYVypTMhTQQon2V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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV2c4Fn4blaQkFCGjUKQpktKf+slKNGWnlNAuhUgRSbKyt5I9k5Gd59hk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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVVmVUFWwTRCSkGyQUUBATQUTxBe/SIphIi6CUmICAlCBISUl3d3fnw6W7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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.7, 0.7}, {-2, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.8795953070752974`*^9, 3.879595368014861*^9, 
   3.879595473933865*^9, {3.879596434152302*^9, 3.879596447982288*^9}, 
   3.87959693249498*^9, 3.879597275402467*^9, 3.8795974222262783`*^9, 
   3.879601448268244*^9, 3.879604192925634*^9, 
   3.879606172760933*^9},ExpressionUUID->"e455c504-f4d9-4dfd-a06c-\
48cde3d486da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "4.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.2"}], ",", "0.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.35"}], ",", "0.55"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, 
   3.879597260967861*^9},ExpressionUUID->"b2629268-b836-499f-9bb9-\
7188fed84bc8"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.006944444444444445], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxtm3dczX34/0NGZWfvZI8yu63OlVWyCclMtqxKIVHKyKiMyEoqDSMaSoPz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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl2c8Fn4XxhEpKiIr1T8rZGSESPfPJntGVkZkj2wpe2+ys8nest3Hum97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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c01/8fxREpKiIr1TcrZGSESO+nTfaMrIzIHtlS9t5kZ5O9ZYWX9fnY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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.2, 0.2}, {-1.35, 0.55}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.87959530735952*^9, 3.879595388312813*^9, 
   3.879595474058312*^9, {3.879596434355278*^9, 3.87959644811381*^9}, 
   3.8795969327387037`*^9, 3.8795972755268993`*^9, 3.8795974223648987`*^9, 
   3.879601448408535*^9, 3.879604193096418*^9, 
   3.879606172899626*^9},ExpressionUUID->"00575a22-76b1-499f-a3d2-\
91cf68e87e74"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[CapitalDelta]", "=", "2"}], ",", " ", "2.25", ",", " ", "2.3", 
   ",", " ", "2.35", ",", " ", "2.4", ",", " ", "2.45"}], 
  TraditionalForm]],ExpressionUUID->"9b13d768-3848-468c-aa41-e3482a4f42a2"]], \
"Section",
 CellChangeTimes->{
  3.879595983994315*^9},ExpressionUUID->"d63e462e-be41-4844-996c-\
b16cd6e232db"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "6"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595517200596*^9}, 
   3.879597260975473*^9},ExpressionUUID->"f1afc697-3a46-4bb8-a29b-\
e05bf3ae143c"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlu3dcz/v//9/eW4X2Usc42aOMxyMi2VIdK5nZhEhGaclqavdCiBJFaQi5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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c0F94bx+09PtPH3hRaqKi+uTeUilCojBRRhEpIiiIys1VEVkRIQiTl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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c8198Xx+09PsPHx94UWqiovrknlIpQqIwUUQqVkBRFZGZriKyIkESR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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-0.8, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.87959530735952*^9, 3.879595388312813*^9, 
   3.879595474058312*^9, 3.8795955228171864`*^9, {3.879596434495575*^9, 
   3.879596448246253*^9}, 3.8795969328791847`*^9, 3.879597275649845*^9, 
   3.8795974224937963`*^9, 3.8796014485488567`*^9, 3.879604193309576*^9, 
   3.879606173114895*^9},ExpressionUUID->"2ecc15b5-6ec1-4348-a7f3-\
44731b23bfa8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "2.25"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "6"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595541033268*^9}, 
   3.879597260989581*^9},ExpressionUUID->"96dae5c4-9fbb-4d81-be5d-\
7e8c311eb731"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3lYzW3UthPau3mOUhrIXEkI0b3KPCYZKlNPZFaGJJmKClEaCSFTCIlC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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c41t8bx63sPZ794LGeL6JCZVTn0LAqSSUVTQkhiciKrOwtQmZk763P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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c41t8btrL3ePeL13q/iAqVUZ2HllFJSyqaEkISEZGysrcIWZXsvfX5
2CFCKiGRKFJ2qPDz++tc93Wu55z7jOd+7odxyeGYJRsLC8t7VhaW/49xtdu4
qtuZQN0iTWoTSUWPXmW4t8UxwWaXcMGJoFTU87dVMfIKE8J7Kt5s4k5DXjx2
AkJqTCj3nBmd9k9D0tcuq+1hYULjtO2CAl86KitXLqG9UYCJBz9jsIh0FC1q
W/s8WQFUmgSaWqkZ6FGbUMCgvQKg6/rK519kIFbTY+cqkALkz/25Eqr9FGmD
SoSmiAJcqTBZuvnmKbJfsgo6MyoP0jrUbYxrzxAx624ttUweKIofK3I4niOy
TeBzt4fyEPKIGKL69DkyEK5872guD9u2GFXXGGQi2eeUMVY1eXjYLv7abi4T
CQbfdGNyycNEj3zsmScv0B7ZnweGB+WgT8wgOOloFir8nsWvVCwH9/2F/jvM
mY00e3tj2ALloLHJZN0Hz0Y7JtYqrC7KgRLbVMJZrxwkEXjltKmWHOhf/2w6
rZeL9FSlLr4RkYNpdi5tU7485NHk2d4xKQvwuyyoqC8PedNMEo42ysLmxs8M
anY+Gqb97j+ZLAtC9dx1p3QLkEi97NMBV1mokxSfb8gvQGwWsZTh47JgRPZs
GZUuRJmcrFYXt2zgpmdbmqMLUWRCHGbOJwsfdp5edeUrQoK5mpfffpMBOUu1
S/y+RSiSJpKAN8oAQ8qnMpy1GG3Z5VIqmyYDRlfNPxG8i5GkSprQXy8Z+P5J
j5HPXoLsDsfw7beQgZh3kdPWD0vQQSduCZbdMuC5h3uzmWgpKlIQTVGiycC2
b/U/QpJLkWKDlmLDXwbY6xVspqqWocUItu2vBhjw1lHUTLSuDP0OYDuqWcMA
LY8kMT/TcrTJqk5QNIkB2zOJjoGz5Uj94AGBE54M+Ltc47YtrAKF7LCd/nee
AeQzO/3Dt1Yi08GtF/j0GOCh169U9a4SrV9jiHrKMWDJ85d4o2cVGjD/9PI4
FwPY3b7faVCuRi4JPxWCJqVhT8vAg9eD1eiI8g8R2U5pcLmX7bQYUYOkE3cf
oRRJg6X9J+pJo1pk6N9b4BArDQmPQnew8rxEwcUnJWTcpSGFsylOpP0l8mWJ
NNt6QRp44j7WJEZg6MgP85vx+6XBu/2slIUqjuRFx3TPKUtDSY5k195YHKlQ
fuK3RaSh/0ZaRRBLHeptjOh9Ny0FCyQh0l67OpRq98vDulYKRC7qqbgM1qFj
Y/SAzCAp0DA4NqR2pB75rdgLRpyRgj0uRb5+9fXI476LOkNJCgRB57WnVgPq
L6iUN/0jCXPMGCPF4gakvktaalu7JCxwCFJitjSiGd6Wy7mJkhDYeMqkK68R
ydxP0muzl4TfFpHsk1ubkNWJDnE/XUm4J3lReba0CWWXT+z+LC4J3eyaIYu7
m1Ha2k3l3u90yGud+cbZ2oyuH/pw4nItHQ47iJpvN21BsRRFnaBIOtwm98hF
fG9BqfdPWRteo8N/WyWuKN99hbj9gp2e7KGD8TOilIREKzpnabIUIEEH0/yk
1vMFregO3eXxpp80OBSgd5du3IZIt5KFxJtokFH5Z8eF2TbEnLjEX5xEg+0r
zu7ace3I8uDx4yMuNOByfZmOwWtEznPPSzpKA8vdMWT2X68RO8F8ZlyJBnE1
RpGkJx0o62zDfPUmGrha6/4TO9GJSAVyidQRKth29cbwCrxBpy2rezlqqVDN
LbpLpO0NmuxYC3eJp0LA9Hx/8v4upLlb/rWDCxW+x9AWjmV2oRts2x5OH6dC
pmouaatANzJWZHm7sI0KDMvf47q3utHUjHCNpzAVDmuUGkR/6kZpSfPmwdMU
0CIusakb9KB89x8faW8ocI77jpNSeQ+qVH18eks+BYZNzM/7M9+imwRLnoYw
CkSNLlmeSniL7Br+yHy4QQHjasGSDKFeZFcsMWpzjAI8jPVeL/9edPU8LfSu
BgXYYwcdF1nfocYfZg6CRAr8sNZ4Jub1DgUcT+uj/SFDJp9+zfe1d8hiLFgm
8xMZXGJmfB54v0f/8XLm5NeRofDmBMs85wfkGGTXr/aMDHeF1uIPhH1ACdX6
5G1BZLgnXDUdQulDhk5J/S9ukKFv5I3Bx8w+VG1wMDbxFBkCXBx4tLQ/ItEu
pzbu3WQ4UZ6k87LzIzJ6PfDnpywZtqZnz7hd7UfOPt6FRnxkWO6M5PdkHUA7
6svuMuZJ4PiYz37wyQCq0WZftB8ggbAF/9hz3UH0fDdLkXojCb61kLbNjw+i
cHe1kw65JJB1/zzZHfYJfVew9mHEkWDqvAPr6V1DSGUqYtLAmwSKhsZZ8VND
qNOAqfndlgT/lJc+Z6d8RnwLcTL/TpFgZXPEosnmYdSgXnjFV48EfJKPfhkF
DiPD9tXaB6ok6DjO5DGeHEZsyv/mflNIEOdj8vLqoRGUakruGOIigYPeQH9y
wQg6G3WRorNIhKnVeCt24heUNxOayzdKBJ6UgeoUry+oNInF4mg3EXw4q3wf
TH5BA1N3uHhwIsTexysqTEeRXfOuwO35RGhUeZFxuGUUnaTyt75LJsKLpIxx
Y62viPv6TP5EKBF+XnSz7sj9iq5u+qXs6EWEiaohr165MWTKyVS6foMIid3r
tU7JYyjhvn1q/0UiVIWh/VWUcVTuRAysOU6EGv/8E+Xx4+jdUsmwyAEirAu+
b7pD/Yb8UnY97dckAp90XIV4yje0JZk0QNhMhHtKXzJjmN9RcpTNw2YpIsxM
x8YLFn1HJtIuVRNiRBhqDx4JRxOom+2j+z1uIgTT+kxUuyaQRe6WocBVAjyz
vEVfuTyJmpMOLHLPE0BZWvof+99JxMsM+fDnOwFW95asXoz5gVjXApMvfCbA
U4Nz7QrqU2jz3MGr2u8JIFpa7ny1dwr1rFkfDuggQP0v/sjtbj+R9d/mW4ZN
BOhyWqW8YPxCunbD6/dqCeDqalz2vuMX2iLMJb65jADakRFWvXenEZvKep9R
PgFqLFqcBkkziN45e3s4kwC8ludTO27NIAEfIm0yjQDH7KQSWntm0GEl07lr
SQRI+27iP6g2i7RMav4zf7QR3xjRJhozizy56n81RxEg7qA+0W1lFr2WO+D8
LIwAgge+utEuzKHWvMiff4MIYACTKrytcyhpwCKwJYAAiS+lPxtrzCPWnd6e
PH4EkF5Tt/ubOo92WrxYrXtAgL4+T0mq6AL6PaijM+tNgBPVfna1PgvIuG+f
bdw9AqykVRycXVlA6VyWdSVeBKhwDvvc5LiIJP7V3DDYwB/0r5cYTi2ivl9b
c05uYP0b9rlh1r+RCj3y6ccNvENry0rGxG9EtagOebexXnrHDsbj60vonKpD
tMF9AuxWviH8YG4JRa2VfdvuQwAJ3aPrdu7LyFZ4ujhhg+/04yUfO64VFDJ5
RNb1IQFUvvQHR8WuIIsQVovOYAIcnhu2mfvvD7I/K/0wKZwAV1jTSxJf/kHO
9n4tY9EEYDFJuvvU9C8aYaprPo8nwFjjD2Hphb9oX0vn75Hkjfu55ygpHf0P
GVH9qbEZBHh1tbaxcucquq1SUdmQRYC28ZUzrJ9X0WpJ2rBNIQHGx6Ze8AWu
Ib4624SgCgJ8Y1t69VNzHV3JKv4hjxNASaGQWvtjHYWFv3qr9YoApxmXKg6a
sEC5g71RSxcB1JKv29TmsUB/xvK+zo8EUJ0oem8oyArUM93ZR0YJwDiUcOav
Ayvs1LK6rP+TAF9vmTv1v2WF2/eE9auXCNC4Vat5XosNwvjIKs/ZiCBjXiJ9
PI0Nsq8+HuQTJEJQho8lhwA7ZLu0ESfIRDhluC9V7A47fKAHRO9RIIKg44OZ
4Al2GLW5uc6nvqEfO+4nepzlgB3tX5aPAhEuLf+Z/fWGA4LquiQEjhBBbX76
wsyBTRCdqDaEzhFh3OuWRQi+CTI6pTq+2xDBVvLm7Z5dnDCY6GPMdYcIx8tI
u15Xc8Lad++GhIdEEE28tMd/Nxc8Wma4psUTIVJTlSJczwWum9az6VlE+K/S
+IKTATcM/4sL5qsmQn0mS0ztW25IvPJqu+1rIggMpqv9vcCzoZsWBTpDRDh0
aj1Kc5YHaLGEOfcZIhwR8uW878MLM7EeA0rsJJD5by1llMIHKS+ZmgcJJChX
4rWwLuGDzX7dNW8USbA27LMiacIPUSHFnA27SZA192VOaJYfajmSEqSOkcB3
ctb/YLQAHDryYnT0Kgk+GOg/7dIWBJfbrGqCHiSoStDsK/0qCKrkn5WJESRI
0dxmyBopBHGMe5Ehz0nArvHotAVDGCxLLpYM1ZLg9u6yVFd3YWj8kLEc0kuC
3RFF749/EIa1r0eJ8T9I0GDmtT6vIQKNIctPV9nIcOCPQce5aBEAqTxCJYUM
rLSQuIhFEVBnSpa9UiODelfioZjTorCXGZelaEQGNZrqDZtaUch9pzLXd5kM
l+sD+MXkxEDCyfLiWw8yyIfkZocHi4HWrvhUiVgy0PprDn39LQZmboZbEvPJ
EDz33lTwsjhQrpSdvtxKhpwctVjBbnEYPj2kYzVKBnP7V4yvIAFvnBSa0lfJ
MLzyxTykSAJiZl1zxUkUWOnZ/51LgQD5Xt6upWoU4DvzKOjoYwKcitnk5H2Y
Anv1HdQvi27UET/uQqdrFPj48PegdhARYoJ5+P0fUMDq2GxA96aNOligxihL
pkCdg99m6fskWI4PNv5bSYFr/0TSJFnIMClwsOzoOwoIRzsnNHiRwf9SmlrB
DAVm2XsDOFg3fMu5axZi/FToF1uKebexrt5TjVAnJhXWjjuFK3JTQcti75tW
PSosKVv2zoZQYZGiPi5oQYWu5g5dSQkaPJvXOqzjRoXrA0gxacP32eVvVzsY
vRH/V3b7WSYdrAlWzkr5VLj7R9B8bxEdvPf/ej7YSgXkPPV2zx5JMLVR4j35
lQq6WwTnNTZ88JH81MDANSr8evl6M5+ZFCRWxjQ6kWhwe/LAcsY3KVDTWV7j
VKPB2tXvw4460iBOz1DWNqLBe295h+MPpOFlmfY42xUaNOvqV1u2S8PpLZVO
pzxokNwWuCdWjAE6v/7VKUbTIJxD/Wj3WQZ8u3TFyjGbBqbxSZJsGQzgrFxO
Y9TTIGE1P1t0igGslY7nVPtosDpV2/xDXQbmGV/kgjb8r9WjFl5n9w188tBO
ZTY6eAk69kfXy8CI/bQbK4EOq4b4ha08shCYauvFokgHP9WxUGVjWQjd2RZA
0aFD//C6lHW0LJh6OvrrHqLDSa3QhLY+WWg53CZldY4OO79xntpKkwNpEeUc
D1s6yO+fvOdmIQcVb4zAyY0OV63CFH2eyMGhedlcHT86+N510lf5LAdvLpj4
NkfQwT33v46jdHl4wr3M4Eikb/xvldxWM3m4HLoz82sGHRrnni06RsuDZ5q8
0OkcOlhcPPFZpkMeWAlmCkc23ulqCWOshF0BCgcISWVldGg++vHT+k4FSCnk
4/WupMPozBbSgLUCqMWnzydWbfQPzxvc6PEKUK/O8XFlY175h3xqUpMCPBJM
0/Evp4MjtYhXbVoBhh64vdAopgPb75uahRJMSLv9vmV2Y/8bz88Nzmoy4S6t
3CJvg1981alN7aeZwCY9cuVMAh1KAz8bizszQePpJf7xEDrcihohPgthwvOG
3De6XnTo+WSXa5bGBN4yVS8L+43zPzYI4ilmQledo7HKWTp81JMMj8CYcEXo
4bcn++kgZZq7800LE2YOzDlkqtBBePXg+9R2Jhze/DpVS2yDrzTt3WQbE5Qt
6e8P/KaBSuHenyFNTHA/ESrR+J4G3RsJ4VjNBMeXs8xnJTSQMvtk6JnDhGt5
C+lfwmiQ9Mg+L+UREzyPVq05XKPBAc+O/hYvJpQtEB/v30OD+H/JgeMXmTD3
ta3vrAgNunju0ub3MMF0jFs2Z6Pf4TwXXveNwAQX26S1rRv5U77yMLN+QgEE
CQ+I4xv51k3ukPMrVwBRjcDDr3SpMMXh0al5TwGKZwzxd5xUOI8mksb2KoB1
9NpHgVYK5G8LX3/MpgB+10+YOQZQQDOueMShRh6SXITOsO2nwH5Zjyo3R3ko
9d5yrnGNDN39sr7vGfLw6dCCQU3phv4FKFc+75CDke2SHjPWZLijv32nmLMc
8G7Nr7lGJcMrJRXVvSQ5+LYiqq/atqH/yneWLctlIUHs1msjlw29D2WZyT0m
C65PD1l1SJFAMPmvlsmkDBTq7EvFm4mQnVAU9NBTBh5+FbumYUuEnqr741FC
MtAtUMCpJUAEuUePDxckMcA1IJY6nEOAAsu5WwxFBiy3Hg3ZZUgAkcSzNpuL
pEHhjMbdS2MS8PG6rxZJSxq+OvlpWnlKQISQLemshxT8ifrIvCghAWVM5eDr
DyQh0kCu1ipLHB6626I//nR4Iqh2IWq3OPSfkLybEEgD/vvjZqudYuCsWJ0w
GrTRZypdfolZiEH1tUQl22AKRHwTOLU4JQrIS3VrUzAZxjKafCvdREE9ut3s
QchGXdvnuOO/TaJgc0JVTyNsw6fz/Ko2DxMB9rqwykuRBDjnmFftQhIBukQr
OSZOAu75ksTCU4ThRk/e00NPNniozNU2M4WBh9P6N0eWGGy6+NLN4ZwQHGfX
dlGvEAUvi+PL61aCoBZmNHmgTQSq3mm6uN4UgPZ3JwWeDwvDRHPVNxEPfgjz
+Xrz2pIQeIsoBXD48sHQ1Mj+0J2CcOikRK5/CC8E3W3Vv3ifH/Yb737cHcMD
oh+71Z36eOGIG9WCmMwNvVHsifu1eYBFNjQ1+BkXvLo2PmGQyQW1DXahl/M5
gfkz68aIDCcct/Z98bpiE4jfZHtinsUB8hJVpb/rOeC9LNdhFsQOjPGRR4Kd
7LA4/1r63zArsOtX7EX9bHBjksrrHM4CLfK9iYXfWIEEI+msj9fQ68oo++Df
LIAcKC7GW/8h8xyx0wucLGBuGn65bXgFibwg3CeqraEelT9CJjlLqClUJ3XM
7B/K+Vvskh25iD75vOsI9f2D1G2++wZHzaPw9gQ1w9Jl5KZDbozKm0XpHi6X
DDd8dtjQ6eWk5mnEXkk9W8tYRLSbau9vX5pCO/lQ8GuLeTQwlPIhassE2sGg
jiamzKIaZT2d8s3j6NL5leKkzmm0RU+NI+L0KPpRtUJYtZxCfAO/JGsLh9HL
CyqR/lwTqFh7pjfUbhDF80dYXykeQzKtzL3mrz+gS9JvqoqsvyDyOUndTo+3
CMbOOoudHEJTZ1nFXJY6kTa7zs/ZHx+Qa5166NegFkR9G6Eu8qgbaddEmrsV
4Ij9+rHe8aJm5H7OScC3tgTFkCOMNPASlJIqJ2qom4ZWzw+xGPkHY2vxtytE
mK6Y95KGnFRoNeaRpNJXeeMZNrDdlJOU2IpVuYQIhAqUYNIm0f/YMnowu2P3
h7QEazA26hvdYss+7Mlwi7Jieh2m5BtjZic2hDUckhPChhsxVi7DmKb3Ixhx
dfpTQFMLtqTnXLgz4SvGUrC8wGHahvGJ5zjqnfiGSfg433iQ8Br7cjGIILVp
EkNe+GG5mE4s3+uZNW/uFNZ7+9n6pHwXln9i0nXfoWnsBmpRyxrpwmy7fikG
zM5gWrQn4uL3ujFFHrexj5pzWHYpUfM4ew8WxK0br+Mxj2luybR1tevBumud
onqqF7C9l9WG7+A9mNn2Y0pNS4tYvMw+a821Hux8qk2q9tYlTHl3Vr/zf2+x
hH/9QmctlzFZxcL7n+EtFtH6VN84bgXrFYst5DF4i30v6W2A5j/Y0PYpM0e9
t9jLtuSHZnN/sbD7/eUeqm+xJxxbJRupq5iKhYyQh+BbzC3nvkO23hoW3mFk
nTXag/kevdSobbWORQb4mKvm92BHw3e979zHgp8RGvtCudmDtTUtLa/3suC7
WU1kbqj0YBnTWs0HrrDiavSwg7Qv3ZjDQrFh5RwrXlo/dfxfeDfWlGOcbHeP
Dc/rZ1kd1O7GDEfxz24C7DhJI8fRfbgLa+3Yv3Uhnh0/KCeh5He/C9OYas+f
k+fATynuqU5idGHOjutuQYUc+LfeDqVsjzcYgS87vXfXJpxQ3v/QuqgTYxWK
1/zasgmX325sZjfWgWXFFGt1HePEpeVOBsYROrBzx1UT8z5x4mJCYzdKDrzG
tjlc1Y+5xoXL55/SuOvSjs2fjiMnzHPhSUJuPPHP2jB/Vf6hHk9uPL2gxCT5
Qyv28sUx05O8PHiozYteMd5WzJy9V3tnLA9ebv3qu+OeV1jWgrF6qAwvfsss
+YiscwvGlvBlxCGfF/ft3GXml9eM+c5zDs/u4sM3PZ0p/znZhPV9U65TbOfD
swavBqcqNWEzlNsSKmf48aTwJbZhu0YsTHbBVmSSH5dlndUfKmnAdD0TT07d
EcCHLz9Wbl2vx2ai1q3e8gvit44m/Ws6Uo990tLSHXwiiOu4B/XPpdZhZwsq
A2kaQvi187p5Vis45h5ps/qiVQhX8vfx3HESx7Q/Rqsd3iqMjz/67NRng2ED
kq96vD2E8TWPl0kMjZeYW0jf0N1WYXzYfXrKmLMWyx47fPUQUQS338yKLo9U
Yx+uHgxathTBC33TV483VWF9gvY+IaUieGT6aSGJokpsrw0lhcApiu/e+WIw
8nkFJh6tduCJqSj++4dQf+nTcuz67XN/1bJE8c7X3DUXc8owHqmmy59WRXHT
S2vjztWlWNjMtf1Zx8Twg0tJ3m96SjDrP7VBTzPF8N0Mlc6Dc8XYtWyC4cC6
GK5BFDlTRi7GGs8JYaanxXG7XrurM/pFGLdGlSmzSBy/eq1Ou9WrELtQllJ0
SkAC99EPB7GXBVj42K30OWsJ/MJZv51P2Asw6/ubd3C/ksD9v7zjdE/Jw2rS
R4symASct33W487BXExX4UfKuwAC/jKrPX3wbzZ2JVK/PfMHAS9O9uHdU5uF
XWKp2rv5KBF/q6T+aXfQC4x1yNbKvoyIu1+eeeFqmYlFM5hf7kqS8BGtC+Wh
Rs+xkKKDxdYBJPwLYcZWcvczjJV+eJvuAgnnsIwIa9V6ivH9XBYUv0TGL21L
X9+im4GFKS9YzHWT8aZMLYffx9Kxz2ST+Km9FLzoQV4HZp+Gdd60fyJWQcFf
eRk81ohOxcoqZ+pcVam40lkl+z/1KRjnl3eNKs+peM6g8V3XxSdYrP7OsX0y
NLzAxjTpkEsylt/WPNT1hIYTfX6ntnElYZdbibNfpej487+jgsdePMZO3jUf
i06j40UWvWv6ZxKwIFqt+CJTEr/1KP6OBCUea1FXtKcUSOKBk4vFMt/jMEmx
eg+KjhSumnesarghFlNOM7Lna5XCB1R097fkxGBU0BFgU5HG03oc8o3SojEx
vVIOwdvSeL/ziVM/0qMw8I6pLa2Xxgk7+9mVCiOxq19ayzcJM/CU4zKjAa0R
2KR9y3ve8ww8u+rijaipcGysvMWyJ5+BL1Rh0h/J4djTMS6aDZsMnr54Y/ld
aih2a686Y/iUDM4Cm+pLZEKwmnhMZG+uDD5vqmTvXRqE+d7JY0/bJIsPt6e2
3TULxPIKcoL4L8jiwQOCVaMCD7GZ0xN1kTWyuN43bam1bn9MV9D34H6qHL5j
rPgu9akfFizBc2i7hxx+/i2beISfL/bDiT/q1mc5fAQqAxqdfTAPo+A7Evvl
8VghCWWWmw+wwTeXWJRz5fHnV+Z/NNy5jxl9tml9RVTAo3N9+NzDvLH+yiUm
u68C3smZ2h2Vfw8bWG6UmV5QwCN09B6KlHphD9QNPdKsmHjXyAJvuZQnJhG7
q0r9ExN/0WNdhJI9sP8BvuuKNg==
       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-0.8, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.87959530735952*^9, 3.879595388312813*^9, 
   3.879595474058312*^9, {3.879595527396482*^9, 3.879595543157379*^9}, {
   3.8795964346247063`*^9, 3.879596448383502*^9}, 3.8795969330812073`*^9, 
   3.879597275774582*^9, 3.879597422622676*^9, 3.879601448682485*^9, 
   3.879604193463731*^9, 
   3.879606173331915*^9},ExpressionUUID->"92d5bec3-3178-4719-ad49-\
5e2aa9b226fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "2.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "6"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.8795955650421143`*^9}, 
   3.87959726100344*^9},ExpressionUUID->"e50e3acd-c992-415b-a0b3-\
770a78469ae0"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3lYjl3U9kPj1TxrlJISklnEXgiZ5zmURChTMlOmktJsCoXHVCIkMu5t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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c4lt8fx62MsiKeYT3PY8+MEOIcaViVFElShAgZZetbCiEiSpJNyIqM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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c8lt8btjLKiniH9b6vPTOKEOeWhlVJkaRBEUmhbH1LIUSUkmQTsiIj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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-0.8, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.87959530735952*^9, 3.879595388312813*^9, 
   3.879595474058312*^9, {3.879595527396482*^9, 3.879595578712463*^9}, {
   3.8795964347523317`*^9, 3.879596448512898*^9}, 3.879596933283263*^9, 
   3.879597275897806*^9, 3.879597422752191*^9, 3.879601448825802*^9, 
   3.87960419361371*^9, 
   3.8796061734705276`*^9},ExpressionUUID->"fd1a280e-e1b1-425c-8e5e-\
6835df2172c0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "2.35"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "6"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595613235258*^9}, 
   3.8795972610168858`*^9},ExpressionUUID->"eafa86cd-da6e-47ed-b315-\
9c0677013cf1"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3lcjd33/stQ4ZzOaS4VJSQyRsbaCyFC5iciY+ZQoggZKponyRRKmacM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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c81d8fx42sJHvci+ve6w5k34Sic5KMbGn4ltBCpSRZJaKQkUjJSCQp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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c81d8fNrKS7HGvdV3ci+ybUHTeSUa2NHxLaKFSkqwSUchIpGQkkhTK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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-0.8, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.87959530735952*^9, 3.879595388312813*^9, 
   3.879595474058312*^9, {3.879595527396482*^9, 3.8795956142724247`*^9}, {
   3.879596434880892*^9, 3.879596448640979*^9}, 3.879596933415339*^9, 
   3.8795972760251303`*^9, 3.879597422880907*^9, 3.879601448961051*^9, 
   3.879604193811749*^9, 
   3.8796061736037607`*^9},ExpressionUUID->"1a0ccca3-d673-4b26-ac75-\
7bf648ad80d4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "2.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "6"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595635803899*^9}, 
   3.879597261030443*^9},ExpressionUUID->"39770ce5-07e0-4030-8130-\
6638f6e74f15"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3lYzV3U/oUMkXNOdU4qpdkYIbPsxWPImEzJLEMeU4gUpVKSSAMi81Cm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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c81d8ftkqyN/e6173X3q6Z1TmikozQoCm0VEapvkQSJSIaVGRklRlZ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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c41e8bRiLZm3Oc45yDY49jZvU+VklGaNAUWiqjVF8iiYiIFBUZWWVG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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-0.8, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.87959530735952*^9, 3.879595388312813*^9, 
   3.879595474058312*^9, {3.879595527396482*^9, 3.879595636943009*^9}, {
   3.8795964350627413`*^9, 3.879596448777562*^9}, 3.879596933547289*^9, 
   3.879597276155075*^9, 3.879597423014677*^9, 3.879601449137833*^9, 
   3.879604194013546*^9, 
   3.879606173772677*^9},ExpressionUUID->"de9d35d5-e50b-4a3d-8998-\
abd7a1d6c589"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "2.45"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "6"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595655130554*^9}, 
   3.879597261043859*^9},ExpressionUUID->"a5b853e2-884c-45b9-8a0c-\
0be53d1b067a"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3dYzu37x1PRXnd7atxS2Uq2z2kme9cjRCQ7DSRJQ7TlQUpWD5khSWXk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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVlnc8198Xx1FkZO/1GT4fI9l732tvpaISaWjISioVKSVZiaKMEEplFpH9
PkQ0lL2/RokiM5RR/fz+Oo/n4zzOvY97zn28Xod6xG/XMSYGBoZWRgaG/8ez
3H9asn7KwgfFIPN0iSxU/OcZbw3IgjYX86u1jCyUZN4xkxwrCxWZdXE9Mtlo
c/ZIjJabLFy22HXU6kU2Eh5yoccpyIJE85KGB3qErALDGR+ty4DlDksr07ZH
yOeJw1W/FhngruF6sH78MfrSkcM9ly4D0cMVB58x5CDHs+WKNH8Z4GHnKzuc
noOWrsh6sZjJQL90xWaMnyAZgdcn7gvLgNvitNLB8SdoCt3p6JiShtWmfd3d
cU9RzV1BvwqQBqfu9PZG9Ax9+ejObnFPGir7Dz6y/PkMdbRzhgV6SwPrV9aW
C3m5SLl4/ztbU2m475S3fv5kHhr2MukHMWk4mkSOOySfj0Rbk4nOBTrs16rs
2DOfj3hXPBNuvKdDE8avAmoKkKkjY2jbIzoEcu3jHIotRLxl+VVlIXQQaV65
XnqsCLF5NN9U30+HB5vCWbmozxFaz9C20KBDtOa3HrE7z1Hvx5Rt09x0MJE+
KcnP8gIdO5bwVuYHDcZC97iyXX6BmC7Wx88302DUfh+J99cLZBTxncUuhwb0
l+3XDc8Wo0vBV6s1wmig7VzKmL1YjOQ6mRxzj9DgKl3vn9OFEjTPZXY6z5gG
y+NjXV7/SlDLnl3tWlQasEoznl2NfInOxQbo2TLSwGeuaauISCkKuvLowsSo
FHybaCAGnpUi+S+uJ9lfSwGtzlrVDZWhxYdn5oofSYG4yL87L3vL0K3hr5tG
wqVAorOXae3cKxTUXPwwzlMKIuJvytsIl6Ndz0xbX9tJgVIrz+Xq6nLUUMb+
5IKKFIhNiVJ9jlegS+JZZoUCUhB17g/XBYFKNPftVMfRFSqsRnD9XXlTid6R
tSKThqiwu2a8mCekCq3t4MyxbaDC9XnxjH7damT/jPlccC4Vhj9EGgWuVqM9
Jdq28vFUCCzwfMsCNYhjfH/EngtUkNpaEJwbVYsG56/dX3WnQp170myYC4E4
B7J/iFtRIeNDcMagMKCDY/xbylWoEF3fyaR1A9CDnud+H0WpYBHKcOTwEiDa
ykjFwU1UIH1LlT5zsg49Xoq4dnKaAizVp3SDh+pQzFNf/6keClj06e9K2FuP
ZlYltSfqKYCW3iZ/6qhHdY5xsQcKKTBlM8Zgtvs1Wni32dAqhQLRuaLGrN2v
EYu/Jk9BOAWmaXpJ6q4N6Og022BkAAWibolaDn1tQI6PjOOHDlHgvuVTDWpA
I1oIKOXIc6DArsFgZqHNb1DHj07zWQMKOEieOdqT9AYNjtCM8rZT4Gs8d/NV
1SbEafZubUhs47wf184qfWxCBZxLcVHsFAgukh/949uMlN7IK7sukcGu7qkR
p8Bb9O9B4sm73WSYGvdZD6p5i8YFF+Sqysmgc9b4+imvd6i0x3WwI5UMHYNG
hquS7xGn0Q+moStkWNpzrM++6z1qTj2i3O9BhudP8gwi4z+gjNCDzG9tyHAR
C3q27WpBayZFBnmqZCBN+7TaiX5Ejp2b00NFyTCApyVoXz+ibcWxm+2ZyKCb
r3H4ctknNO5ocZDrBwkunjYSem3RirqtTue+6SbBjoM+NRqlraggjGHtfD0J
As4Wn86VaUO1bOYBlCIS6PKZ1umntqEPp5FNwwMSuDmfk2Xkb0eNdeJNR6NJ
MD39dpw/th09TzQ2YwgiwYs6a63YrR1IVjlYIdWLBE7ZSCE6tgNduRD6R9ON
BI+1k0dlBDqRg3+mZfsOEvyZNbwQktaJxJ8z5vubkqAseoTvuXwXskp8+5+g
DgkevnKc6q/qQkFSmzJBkQTwL86R7NiN5Bl/twTQSYCk9/elT3YjldFXtqoS
JIhspCsGR/SgzEfbBNcESGBTvGg/IN+LiHvXtDq4SOBhcezGaFsvcjas/lDF
RoLdRUHepZf7UJpfzpZXzCS4d/Eb5xWlfsR4ZKtsExMJQm51dZ0Y60f7i9ZD
ZhhIkHjl+/uUjAEkY3rtjPIG7xlvOmV2aBB1RlYHxmzw0jupvjsy/yGh2/6C
rBv1Lc13hksX/kM1qytjjzaTIDBTfetwwxC6Kqkbd4yVBLEaVwuM04aRN69P
hx0nCQYyFi+xGY2gaBvikhs/CRQf319peD6CVmXFjqeIkYA/bc/YrMwoUnQQ
vMFCI8FBDfL7Jw9HkfJ7475HCiSo2A2OHKTPKO/di3MXtElwcy+btl7GZ3RQ
f/Zy2EZ/D3ir7Xeif0E3r5rIfthJgh+FC29CCr6gcA+Xil3uJIhIf9nSpzeG
3DaVR4v7kWCQI2w56sMYmhd33CJ/lQRq1sJi5Ue+IpXsqpzQOxvzj3b2ifjz
FeU9d1+SziGBith/EfS0cfThwYdYsSoSPPng7V9mPIEsLp6nHm0jgb5Ib4nn
1ATak17ktek7CfQOSB/2SvmG3IdG9f8xkuH77U2Skw7f0e8B4zMuEmRwMufX
FGKbRMMlLgyiOmSo5s3Mp76dRDgXTRg5kSGQuQrj21MIHRfVbQ0gw1rg8pUn
B36gB0XfRdrukkHrztXeWKVpxBy4Wm5eSoZB94R0ZdYZVFIs6abWSwaBvWPb
Gr/NoFhH0v7UdTJYfWP/L6Z1Fvmeiww34d3QH8UMoS/uc+g/t4i1FToFbvSx
+e0fmEMZzUFW53U38tdYjr53mUfXuNrLKzb0RC9JWsB1aB7py6mmv/GgQJ0Y
a7vy8QXkxRTtmBFEAZ2AWZr3wgJCFyU0LO5SoP/QRK/29Z/oddSTwpo8Chg8
oHBWiSyifCUZVdZGCix1uauRSxaR9FZCTW6YAloeZmK3dy0hhagJNcoqBQ7e
zWLV/rWEThx5X7YgSIX4GxkFZpnLyIOFapelRgXh6RrTiZ2/0CqaDVfdSYUp
nq6YHSy/0Yz+GGO2LxX2XJYYKar7jdLCLhxcuUWFz7vNtQ2ur6CJMaq5diEV
+EOcDORtV1Flm56H+ycq/DpW7/BCdA2dSv18+uz8hj+wX7vHPruGyGIkmYsb
fqTlK8Xh/34d6VkKmp3WkYJezoIgatEfVFGocMfVTQrUTz/Kc0n5i6JIVQP4
uhQEx65bud36h4yJ4AVyrhQcTpBl0TJjwBVvaQXrbVLAcstz6GsjA5bbvW+8
b1UKArWfpY7aMuIu3YiQSjoNym9ca7TvZsQmwsX7M3fQ4NHC+NqOY0xY8FGH
e3wQDQR5vBi4V5hwP1358q2nNLBL0CGK4zdh8bFNmUndNLi9c9jRQ3kzPtkl
VFvKTIfLqtfZHNo3478zQ80TmnTIOe/tl3qJGc/2X6hQPUGHWxz7nS7KsWBF
7wuR95LpkCpR3ik4yIIpyeHqoi10mIk0dXqYuAWXNdBeVjNKQ2pHeZK1EytG
GgysYdrS8NRcttpUnA0THf3bz/hKg75lC6qfYMNbnzBIRuVIwzklBr7VSnZs
YXOw++OwNCiVH46iJnLgNNbmXaZiMrBm+CP49PmteDF0IXLSSQZKS69oUNw5
cULNYf+mOzKQ8hCueO3gwiwf8tcGW2Vg2x/TslhLbvxvflpQiUcWFM4Y9n+h
8eDfprPPanbKwrzd4V/yT3nw86iklNg7ssDk9Fe9RoUXc0TINmZ3ycJh57Hh
qhpezE8e//tPVA70608LW+/gw7bcmoI57nJAOn676eZXPjxpmvAhKUcOGJh4
i1Kv8uMc3eGh/hk5sPpb4PaMIoATD06v+OpsA8pKo3p3owB2V/hC7L2+DXSS
nx23Oi2Ir+vYN97/tA3qdsn9k6EI4dq8jNuqkvJw1c2jO7lLCH99hhNkveVB
0GYw6W2cMD7MbKIdXC0P+5yn6ocdRTD7lcomVa7tQOuuTGERFcX4XtY1m8Pb
ge3pJ23PcVHMoChyq7l0O2RtuXtOvVIMbws4v1TAoQD5e879ik8Qxwp5lUXr
RxSA4UI9qficBD4005ZQVqUAjwdWWOvdJHFj02P3/wQVofXSpfA5OxImiebm
nfFXhOQPRwR9TMn4MOPEQuBHRbA8TJouoVBw7lpD9IyCEvj4P3gfkU3Bn917
HvfEKIH05qRP9vJU/Nq92UpjRgkKopMmxEup+CeH6w5mR2Vg9G4y2Gomhc/z
Hz9hW6oMnOwvVXR6pDDv6Fz4dU4VcD48sLvCl4axyWYLCWMVmDl01O0ZOx23
u8Sv+J1Tgb18w2SpPDr+PNFwKyRXBRZ/h1433CmNtRNXPlqOqICbSe9ZwVVp
nOMRcuq9kCqcMIfPr5/KYJrA5++sDqrA0eCRc8RVFovfyS3+d0MVFu0eBXEI
ymE3UsemolpV4LbcMdfTLofpFlZLgr9VwWTr7L7RxG24KXPBX11NDYzUs4rx
QXm8W9dbl8VHDb5yl6dxKWzHsKN3IOapGjw7mmV69N92LJdYXtY4pgZHKI2G
zr0KODu77WchVR2Imviwv2WK2PrA7xsW7upwoiNgz5lUJZxz2EMmKk0dDiS/
4W+6oYxpelsdAwfV4b/6sGRWfRW8Hs5myiGhAUWKqexqZSr4gbf0somrBnT6
VC+e1FDFeka/SOJpGmCm39JUWqqKT2XkycUNaYD2wQltip4a9tYkq6VTNKFN
6en2ojo1LEznYzc+qgn6s1efnLRTx7Xa5xXO5miCcwxLlWO/Oh4SINWoTWrC
N5FXx329NLBh6/qNQCUtsH/OG1X3TwN7uF2cNwjQgos/st/Y3dfElxPvbrlc
rgWxXbGePGpa+Dn3gKfqXy3QDeVz5GjVwlLx4LDbTBsK/wV+0vPXxsO+cHkg
SnvD72xupwjqYJu5k7b1bdqgOOhynl6jg7flFCT8E9GB8emJG60ndDFDRkNl
1CEdCEg9UJUgqIcvZvxMd3mqA5viOOc83ujhlXCW9GNzOlBepPBK7ZI+Dtjc
Fp2powv6e3/qTasYYL6c+0WbQnWB8dSoeOikAQ4PWa+9+lYXpmurbXpzDDHN
RaJ/K58eXNwe9bXvmBF275q8meqiB6FiHQKnZBE+Nq/1gpytB4UK28c8pxBu
cDiWFj2lB5aHRm4P7Nv4rvHWs63q+vBpQlRUqAbjqLOPHo4E6YP4gcm/O6SM
sdbeyn+5r/VhPOzE0JkIY2yxsJBH5jCAEDUlv+OzxphZ9PxdxV0G4BHfEcCz
1wT/thudq08ygJ//teTuIUxwVN0565YhA+CMjQMBOVMssVDlpUs3hP3KKyYq
8ab4i1OJ78+ThtB3c8+9sFVTvKQQ+WI83xC8dUR+/Dhqhm0Flgc2dlGoMivS
N2kxw7KW9sNSakaw53mC4QEtc3wu3+S3UYARdO6eO7k1wxy3DYW/0Csxgnke
0UXZLRa4T8Fo4s+8EfBZqfde9rXAkf3H3/spI0h8YNg70GmBb8ygqfNeCKSK
+6M59SyxpGWl5spjBMkHhHwH0yxxbDzPpsEhBM/do+a4Gaxw9v06LiYODHYz
LHd9Dlnh5qDCr7nSGKKvKzFU1FrhPwUiPi4IwzLzVuWXYtaY1aDZiWkfhr53
BlHks9Z4jCGQmuCHocnHWKLynTWO3JcozxiOYTB1ps6YZIM9dYrz9VIxeDrv
PBLga4OrQl62qBZhEPOoV+CossGs9iVPeuowLD04NdiwyRYf30rsluzAQBNz
ZXK1ssXJ+jJLPz9vMP3InpgIW8wqXNBoN4+hVNCYia/BFo+dOSwl+hfDx4RW
7txVW9z+hyvZhs0YMrqIEj4FO2yi6rPczmcMexWkqjj22eEXIgN7HokZA92w
aM45xA6PP0nb/oJiDOl1YjfL0+1whGrhwR90Y2gxtgz/VW6HrXf3O1jLGkPe
AugOfbDDybOKk1Ub/C2pJUOv3w5fePGmWkfGGOIG13uHRuxwmPplxlIpY8iV
4EvM3GAd+XfFMpLGoJSyO+Rgnx0WXopNDRM0Bp19HJnL7+zwKPn0iTccxqD4
gdqys9QOXwoTKRn7h0GOmrCwP8kOq4aUifdtvHdyJ/kc81k7LO7I7pA+ikHS
fDbQ3mrjfs8oAZVPGPJ90kjqgnbYainPI7oSQ3WS4uvaflvsnzp/qjAbQyT3
Cokh2RaH5q0kJkVt5JuETnDttMXBglsf2mzMbzKmcz8rgy3umRC9/8YRg8aO
QQOBZzbYheL0hVsNg5lr6gd3Wxtc7jNiu50Hw8yZ72KUCWt8jz36p2Evgtd2
C27xwdY4R4F1YSwawdp9lqJlDmvs/M3Uz00fgcG+0IrkRCus1mXFXD1uBEfi
hVzeiVrhnrAIJpFYI3DQe6IylGSJcxQDD0SrGoHoHkGaCr8lJgnEJKm1GULj
pnud5EgL3Eolg4KPIXzuyOXlXTPH7Zd1DVKZDSHlqqmal6c5JriFazJTDACK
288mdZrh3lPRwscVDEBzyHQXs6EZ/liYTuGp0odwkaaP5GxT3Hfz9o23FvrQ
9O9Yk/MWUzxaW5FZ80kPfMcisegpE3zpcqajqLMeJE9eLO16b4xVsrka2Pt1
IUqr2WtFwRirnQqxrjugC9sqXD7M3sJ4TdhTymdABzKEft40HUK428zNDu3X
AZdrFfsmM42wjyHXDs8ubfBwKriadMIQC7U2s0ru1IbU6BJN9g193K5WGxTz
VguK3sjeXFjTw1oLOanfjbWgyk8zfvW9Ll6AWxLHKzShyXVLCzzUwbbpxqbq
KppQyLvlSu8lbcxkIvMqNEcDVq51G7910cKPf/k4h2741UAC5TmXsSaW09y7
9fAddUis/SUvoqSB2TLpuQ6s6vB7h3WNlZQ6XiR/rD8fogbeO/PEfkmqYXaR
a5Gbl1ShLn/ilQ9VFQtvdy6hequCQozM+qSCCk7hnT+w/EUFckGAxzRUCQd7
xU0/dVWBbTfbpPwrFPBlmqZIdb4yCO3Ry0xi2o7Hm2hb/LOUYN27dW3QdRs2
lNYKKE5RhIB3La/sm2Wx/ZitWW2iAvwnT06ZMJPBmo12vh/vbofdIZ1fEtvp
WFfDa1wkUR5KjV1T1f1puOwQe/qn5G3ALnpyKIYihb/de32NkiUHXYWcOodG
KNhMqeS6ZqEsmDX4zhGHyPj7S2qqRq0MnO76zn2CIol9KkoGUbs0EKPfT8//
FcO/Go7dPDdJhz/yaXxRayLYy09EfI6FDi8MvjfZCwrj0E43/zeyNDjIXptg
byuIL0Rw9nHYS0H4C9pM3AN+/HrVVqP1PBXGevz6hVn58NXmfBHKYwpUD9+f
HYzhwS5c9M9sz8nQd1fNtXA3F/5izGjCTiZBBssev19VHNipiHuX1X0JeJio
Vx+ykw3396/fbxQRh6zdO5AK9xb8OC7BMyRbFBY4WrLXlzbjyBu9Oqe0RaAy
pOfdANMmPHfLZCSoUwiozUslH9UZscRi4kzmJUEY5b8VW8/5D7XfYV14s00A
wi6klu5dXEPbGZ3r20b5wGJO7vdT4RVkIxnw9nEWLxQ8D95EObuMiKQwG5o3
D4Sc8m8zZ1lEU17t9juCueBPyjxjw7t5dDQp00RcdSuwQ9ir98GzSEKV0fDA
Mhs4q977pVo9hUTGmt9Uvd8CcRoyZwfsv6Hs80OZX58zwznLuBQlha+IfpdV
P+TxJnAllx3vcfyM9LZUCso9Y4RCl7T4WwHDaN+vMk+WwH/E+qeQk0dr+5GD
J/WXS/kaET5qWkYO6kbKndqC4YK/ieTNcbs1MttRxbfLyjW3FomePicq3fEj
UjwpG6xOmSeyAxoLrfmbEXF/XkUzaYrwvKLGl3GpHvXvuCljQf1KtK4fOZ7+
sxLdImV2/yz5jzip1S9Wz1qMHG6EfD0U2kYIqsjYVeg9QqnJ8pW708sISofM
0Yz/IpBz1pv6gjOvUHgbk+i96xEEv/eB2XtcbajhyojX+58PicmS57sPzg+g
Bovl6+oeuYRH84k7gmZfUNz57j4D6xfExbG7u7i9vqHqPc3OVh9fEkDvPSnn
N40YSHpNfJ9eEW2lvcM/5ebRr6/K6PC+SuKml9apE1E/0ditHvHf56qJ6xYB
BfmDS8jWaJt8nlotMdpgHhRC+Y2UrWaUfZIIIuVI7NUE51Xk/HDqmPI+IEJk
LslnX1lHad+4nX3rgJC5Epp44MFftGCaEPWGo46gqY1Vlzoz4BRntsNlenVE
1oe6uNr9jFiaNhzl41hH+ITGFafuZcL2vBEf23fVEaVaR9rTd27CI1UelyKN
64iRsogxYfPNWDlGPWyZXEfIfjemO2ky48m00r3mc0AEyqsKZ1NZsN7Lqf3e
L4HgD30YZ8e+Bc/Y2cuq+gJx99CvypTZLXg2uvuyAhmIXUdLRbvaWHGPyNdf
qfEE8Wpy/p7xCzbsXGzISPTWEvr85yLpsex4xqW2hUeolrCnn6yDkxw44WTK
94e2NURlScbtvcZbcVhx9i7zoGrCqki2W06EE/s+OeyTkVNFWFRh3oBpThyp
ZNVJ+VRJQOQpj4A6Liw4NFbMvVxBqHLa5B1L4MY8bVvyoyQqCBXGEWyizoNz
r/JCjGk5kd24mL/5AQ+eiNviN+f1iniV5mlybzMvFjTy4Q64V0YsMzVn8vnw
4jtOiymvXpcSak6hUwldvLhO1t7WevElUTzc3axtxIeLXf5+T5N7SfyWvHJa
8Akf1lbosxY5XEKMBASUWPLw42jlrFG29GIiiLmU4dtFfny9cxND6fALwkFn
wI97jB/HVxWYOMi8ILK8fzV3Owjg7Mh9Un/9nxPHR27fcq4UwB++c99ouFFE
7J8I+psjI4jPOfCPSqoVEteXQ2RH7grin2tMP8jf84lc27vjokxCePNsx7mO
3DxCI/P1gpe/ENY1GCY0AnOJ7+aJE9OjQrgo5v0tDYdnxIHTqbavdgtjz/F+
vkrlpwT3qS3Jw2+E8fyO3F2PxJ8Q2kZHrUL0RfCqUcbwO94coshptjv3hQge
CYq58I/3MWEg3f0peJsoNtC6PcUl8YiYuJTQzZEtih2Km27XKWcTu9ZW8/1I
Yjir7SMxaJdFiMywY0gVw0n5BjFSAZkE99lP+YLi4rjcIN5jd9ZDQmOk1zbi
gThm1z3N6voyg9DSRhUqFAnc5ex+fkQjnfjhkz0smyOBL9TvqyhofEC84/77
N1xJEi+xbckyPJ5KiKoblZ+okMTuymZpbEIpRLvINsExCxJ+WPEYxXQmEUpu
IQlCPSQsIi/uhDPvE+ZJzKpip8hY5dar31lB9whhf6zFzEDBlpdy/NWPJhJ/
ym8WhNpRcInN5+YzexMI94SK7rgUCrbrCZQY23uX2FxKdzOepGCF/iPA6XGH
uI1LzbL0qThoa5HUxaB4IvbLt9n6WCpmnmLwLU6LIxR3eEmXfKHipfZfQfEJ
twl1hi+C1/WkcBRf/M0HjLFE2iTLEdO7UviH6dTR56ExRExMJJl5Rgr7RYo5
MApEEzutFkf7bGh425/Xa42vIgm3xPrajmc03Mc6027kHUEkMFx1ZuagY+HZ
pYRClZvEUMve3lBfOs5SnGc4tjmcoCW7crp10vEybejli/EwQs+a4pZnII1f
SkfwT3dfJ4ycNLtCn0hjygOblQud14i0Q+rqywIy2N5L+mnFUChx+g/vD9IN
GexUr+EpsnSVYN0kp87/WwYfZXFdZxW+SlQutjNP+cjiIyEfV/7eDCEu0x6p
EuOyOP1Mq/3ycjDxPzrmuiY=
       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c41t8bRsjI9tre4X2NZO99ntfekqhEGhoSkkpFSklWoigjZKQyi8j+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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-0.8, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.87959530735952*^9, 3.879595388312813*^9, 
   3.879595474058312*^9, {3.879595527396482*^9, 3.87959565603207*^9}, {
   3.8795964351895657`*^9, 3.87959644895432*^9}, 3.8795969337322197`*^9, 
   3.8795972762838087`*^9, 3.879597423143383*^9, 3.879601449272976*^9, 
   3.8796041942075043`*^9, 
   3.8796061738994904`*^9},ExpressionUUID->"9c8dfc68-23c9-41ac-b4d9-\
6681bd5b2b73"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[CapitalDelta]", "=", "2.55"}], ",", " ", "2.6", ",", " ", 
   "2.65", ",", " ", "2.7", ",", " ", "2.75", ",", " ", "3"}], 
  TraditionalForm]],ExpressionUUID->"0e45e524-2894-481d-ab02-8744d0ad133c"]], \
"Section",
 CellChangeTimes->{{3.879596010627838*^9, 
  3.879596044885311*^9}},ExpressionUUID->"cf54a3db-a495-4a03-9914-\
b5f2f9fb4048"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "2.55"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.8"}], ",", "4"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595677519822*^9}, 
   3.879597261053898*^9},ExpressionUUID->"25ac4ae3-c2ac-4725-b5b5-\
e2629b3cd060"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.006944444444444445], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3c41+/b/+2trIqG2f609+K6GlqUSjtS0kR7aGcVSZRRRlmZFRKKxnmR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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVlnc0EO4Xxm0he+8RMrOSzPfNHiGkpGGTFpKSkREqoySRkpCyskJE3Ddk
JrOMSJEyUlkR4ff9/XXPPc95nnPuOZ/nnCvu6mPrQUVBQbFMSUHx/9lYXzLw
ffoZ/A6NkVmhy4JFuLzLdqMI8mw5KXwjskC+wWpRUqAEWCW9bzBuZYG4asZZ
e7FS4KkxKh8My4ZnyWteqdWlUPky9tks9WMoqspx27Ivg81yjzD7uMcQ/eUA
Z+VqGTSXxorK8OSA8RzF9S+Zz+HnpY/CF3NywP239tNiq3I47naZznbPEyhK
8LtgQlUBnDacZe86nkDc5szQQG0F2HmlL266P4XMiAMHE4Ir4e6hzON/KHNB
3F914e6+F8DXQcffmp0L1YNzJ8VZquCPKQPjdZM8oPt8w9z5SxVce+89b/Y7
D2IUr0dF1VZDwq/8afGH+XBKsMLtdfpLaOSadZa0KoDFIRlei+ga+EaVd9uD
uhC+jhVKHQ6ohXr/mYW/rwphiDW1V+jsK6ATWbv9J+gZGN7wMOw/Uwcp3MbK
vrpFcNrDma3qQj3EdTI1B9MUQ29YrCpFNAD7ILfvru5ieOluSPPHigC1XLPz
w8wSeF8gt2tkjIDoLaHfP7VK4Te3mYFtwGsQeL1QSpVXCo659yMDWRtAq6M6
Lpm3DD5fmpL1LW6At8MPD5fcKAMz21m6o7aN0BNkXXd8swzUDqVVH11vhMig
f2cLAp5DT1dP4d38JjDaNcOf+es5uLHFiCsefwMGtdd9zM6UAzdvxJYxTzOY
HYicLZ0thxM3EvczvG8Ghs+X0ZezFWBffSrzfloL9MsFvf26UAF381WuS7i3
QnzhvqU3QZXgnXfFt213GyybXNq8SfsCdJLPJFcztcOtbGpq8zsv4M7iqK7A
dDvEYh0+Sskq8DlvZ8vf2QHqV2ln66qqYK4vnWq86i1IO7KZxlpVg9usOndW
fid8DGgL9Zmqhhbh98FR2e/AanGj82L0S2DRZ1utye6CBL18gXypGij2E9HS
su+GqFmHHaxtNcBRKdD/e6QbfithtTKfWug4/FHt/skeOLN/8mAq/ytgpblf
Yb3aA6WtQYJtza9gU27JXj6+FzxLOiYtL9XB0cnqcyaSfbCnz+CEgnw9nC7f
xwykDxx0tSlOj9fDgZsRWUUu/bDwpSSO9SGAh/w+fSX696B9rKDkliKBfdvu
BDuXvYddjbm3rW8SKHaEyBPOH6Ci5tDVtt8EllOMKEy4BkDIzl516+BraLFa
R3s7B0Aw0n1jvuY1pL6qk7KJG4RflhVfsyUaQJUhja/MaghaO8UvcMQ3gIGr
8M5A3mHgvCvQj1ca4G77zvXmyWGQ4u2sVnRvhLBPHa/rX36EKc4D+oO9jWAc
dcwn4s4IMD9pNEYGTbD7oZabiv8ouFHaEufKJmDnWGiZd/gEcfvLrLRk34Di
KQH7b4ZjkPln4VNrxhsIi6ysShP8DIXXjtdt+4+TDL0ohq3Uz7DZcCd0+WYz
lJydXK3k/QItU6JUsQwtsGnm+aLn/heIT31/hkS3wDG6ZvAQH4d3gnN0SdSt
8Krm0Vx04TgofKY0WolsBZyyddZYcwICPopVfKdug0J6o5ba9gngy+P+fSSm
DVbrFD6tOX2F6wln0w0Y2yExtGSO7+9XqGvxsUy71Q7KnDPX5VMmYS56KdiK
pwMU0iazTDW+Qe7r1FD7jA6I3s4dHTPyDUYs3Xwf7XwL/2TtPq1Hf4eQlBEl
oedvwbvKoRbUpmCl8I5xjW4n2PX7XZmenIKapMUuz/ZOWK/WWUlMn4b1GwFX
mB3egZmdgNm7wzPwI/i2771v7+Cs0RWqGt5ZUH6+pPo7oAtYw8PZzo7Mwr8v
Lr0bVN2wqBLZQPH0B/jVX/llbdENVYH73t28MAe7n2lyf77TDX1/TPermP4E
ocMB8xn/ccvIlfmKSvwXxJ5NVQ2R6oFJGx8aka1fMKz5NsjzXA+Y/RrQsPb7
DXSumQctqnpgaPeuoa7J38AfMCfNS9ELGjdPLoscn4dji0Sm0rQXOJ7odpkP
zMOPwDpb1tu9sC9t+yeXgwsQyipryzLUC8ouud3n+xdgOCQ4JE2sD5Qpz8fG
H16EhZup9SlefbB6/LpE/eginLBVSJgp6gMum6xZHq8lMPrVPHRpsQ/U30V7
P11cAoer0v9E9/bD0/v0R0OuLoO6mGtuQ3A/7GTvrsjj+QM5gWHvdev74TOn
fo520R9w/y5RdXarH7Y9nYg3MlkBz4LORwroPbheeMw48HUFGhwYl2xD30Pf
EYYliphVmLuUy1P18j1st6473C/3Fxxqje0Ul97D/TNMoa59f0Hf5lXbNYUP
0MgpPvEqbA3kFh0cUlw/QFUmt/Gy0joEq3hdk075APXvre4Jf10HyS+svtQt
H+DTIxp60/R/UC7h+HR56QOk8O/cjHHYAJuJVPFG0QHI/twsPMe3Cect34kp
mQxA8WtT/YTRTai/Jsi5dmoAzorrXAt6ugWDlKahX2IHYLRVUvSrJgWhLVsZ
efR0AD4vNv5tyqYgXHTxCT/qBqB9WrNmmpmSiFRGFAZ3D0Be7YDLsWBKEjJd
u7wxOgD1xY5sO2cpyYJaWonYtwGYmjhCc/A4FQnvkI1ImBqAPdMZaXM9VCT0
HTk083UAFAd7TTdNqYnr2CIaGh6A2Kuv8xMbqElc6cT+1bYBuMzj7leiR0MM
7506/aVsADgbis971NGQyG1v9eWSBiB/cOBBnR4tqZLwYHD/7575XMOthgZa
snBsxV9QawB+3GhoCzejI+eKMvwHKQYgoeCnHlUfHRlMNGIRqf8ABvM/Wmyd
6AnTly7rU34foFhxaCb0Jz1p9o/ftkfgA2zt+GJ8K3wbib+8/myp6j3IZWw9
SOJmIAJjThJc5u/hd074mztFDGTIQznlX1c/HFw5W5thykisGfdYsZn1w17H
uST4xkiYr0sGFlb0QW5tQAjVdSYys/v32g6OPtjUvvrGX2E7EWh00m9z7oXn
SvEfRPu3E6fbt1i+PuqB0zJc6pxhzOQAN7/Oi3f/9cuVOsxRkYVQ2IgpLA92
QbPGZV+qMRZSEc8i1/a7E8ouRI/wJrOSXUVvvfBEBxRICwzZSbMRwak6x8fF
baASURjiFMVG4lSKb8rZtIDNgxlv9a9spOaHv8xmaxPU20nrjhixk2cU/UHq
XA3gdMw9wzGfney+Hspa5FIP1iMt+lUsHCTlMeVkgWY1DNtZTK8GcBD6vBZd
mWdl4BledFR6jIPYvfC/G+P9BPKyaXyMzTnJeLbZsfRLsVBQmkLlXMVJGpbq
8kd2JqH6uykbl6W5yJhsNEdhZT6i9j5o+yCVi1w2FFIryKtEpToNa+2M3EQY
M1zNXq1HZnHnVlnDuckr6573TCebkNzn/fZ+K9wEjTmumdxvQ0hTSfyPLw/x
3LO7a4y7C/GfpPN/8oOHqIaIJYyf60Udlzg9Y07xkrxf5cPhQe/R5UMhgpkz
vMT/Apv4sZJBVJfc+uLvGT7CPC5kzME6glqdeJ3uz/MR9hc7ha0ejKG3YR/0
bgTyE0PeoOGJgi9IS1A8rJNSgLzzLdSTyJxA9yxLzc8lCBC3nk+DFsWTSPfu
t/bzgoLkZry6ic2H76jOeE16vFCQPLxmtl+Ofwb5j6RENOoJEYU6ntn3l36g
QMpTa8L9QuTR3JlUx8WfSGFUI3/1tDBBUX3ibs2/UXq58iNHOhEC3S9NUiUW
ENnB+dX8sQhRTij0Gby5iLbznvfv1hcllVJxmi+ZltG65Rndha+iRMF+h2l3
2h90bvXf7Y+GYuRc6JZFteYqimh8tJ50T4wEc1Awsv34iw4FDNVkz4mRirfp
Z4PK1pEKNpRkMRQnbttO38yI3UB2Uarhgw/ESXi51YudgVuI5QHPdtplcVLg
5V7rWkeBM7XCllOsJUhMeG3n3TZKzPQz7+jtQgmykZQrwvCFCpv2M1msbNtB
opVohgVoaLDW+Wzo8NpB5C+u28ur0WKmap5M9tYdZCZpnP7hOTr89IhSfYes
JFEae3uj/wU99pr42/svXpI8Dda+uXc7A64XCQ/LnZcko5kC31R8GHGcS5DJ
u8NShHmb22n5z0y4GYKT/EGKfJDhp09yYsbu2n65aTLSRH3wZnr/HAvuTn1Z
qH9HmtCpNFI+N2LDSw7Wj3y3pMneNz6Xjwix4/snco5Knd1JxndZrAuss2Ou
G7G3XEd2EhvznAKVcQ4sGj1VJ2spQ9zk1sKHejjxCY2nmiEgQ7a0H+tZt3Ph
F1cyxY+qyZKvWVSO3R3c+LOnp1NLniy5kKOzfP8DD3am+5j9WlSOKIbIt8/N
8OIEn9IT5vfkCM3vnbzbGPhxRjRdowuHPAlVzI6SVRHAKLW7lv6mPKm0ceJK
chPEeZu/ZrWZFEi61zHayEwhfPRdW+7GDQXyouhbueaUMH4TaDVvwahIHK/K
hfzVEsXWTdf9peIVSVFx3tvw/WL4YwBv6HXWXeREuPeWKaU4fn9bbf188i4S
xJPKt1wrjocbLS+MCygR/VT3hJwQCcxmVEbZn61EBLH92YsGO7CLXIGUBI8y
MVOT23+DTRKnHTSA1KPKROXhT7H1CUnMaeL1pDVLmTTUfdw1XSeFtQ6Wn3k+
pUxE4fm4T4Y0nq+/5WarrELWmIeeF0TvxAM5EwlPAlXINbmO1XJ/GRwgb5+d
91qF5L+eepdzUhbfW56idWBSJTGvhyaT3eVwUda9lhJ7VXJnLPnwfS95TDsR
+LAwU5UYnWILa/NTwNzr3z8Z/1AliXpsr3dfVcTiWl0RIXvViOgFQecfD3bh
pRuWXCbRaiRU3VBvs1YJs2bz1WT2qpHnY5kfavyU8bTKtNRVsd3Ex1bsriKD
Cs6ltk/5fm43kR2O4nTMUcGfe6u7mut2k+WNKy77DFQxv282Lz+zOgkps20a
n1TFuZQFSh+OqZORMIY72vFq2NzS/8DyM3ViFtnFbrJnN46k2y95dkOdiBkI
WWxO7MbSakINalZ7yNiF4KnDd9Wx9Rm1PL1He0jgrg8MpuZ7cLb/sxeRv/cQ
F4vLAoRKA0eNVMgt7dMgvW4BucX1Gni/kHJazB0NwmJrrLYVuhd7Hk2ZVpjU
IIlligz3sSaOnnO2Gdqzl4hOObC702nh2+LDVqHX95LuC3ey9bq08LmGrhyG
4b2kOWXDnv6BNjZS/WZ/Tl6TbO7QH0r11sEv19iz7odokgAltqY3WrpY3iJ8
I6RTkxhzjJ12ZdHDA68kealFtIjrvYGXWl/1cL7Qyw7+c1qktiWRivcVwgrD
6zJFdVrk7BEjv1FzjIN5Z7zztmuTvQqq8eerMX6ZqvRn2VGbfFZtKc+V3ocv
dfC4hOVpk1WvGN3Dd/dhnQyOU4rL2uRjTct3Bxp9vP1UwsZ3rEOO5vl1R/jr
Yx2mxT0pcTrk9nFln5xxfZytleUm8l6HOEwPJiXaGODhty10nsK6ZFMLu3IS
Ayy4+faTjbsuMdhsd1lRNMSj4/6zb/J1idxQWgjNA0NsVFYU8GROl/TQKXFS
0BthjvQSvj4lPbKqzsVa5GeE1RJPvlX21SO0NLPrHcNGWMxjdP5RsR6pPim4
U1DfGAvLX3OmnNUjVx/kNh3KNcZ/oj8FqEsh8jUgWlCT0QRbtSVKCx1H5G5t
WXXQKROsChLsd5MQ6Qx9ktfbYoIfRzQlhb1BhL2/rvqPuCmuj3g5WrOMyM4p
P3gQaIp9LPq33WHHRPzw39mADlOsenpKrlsakwP21sKaAmbY5pp3UJQWJtn2
fSjN3Qy7lOK6R/sx6bbXfW5eYIZtpeKn2Y9jEpHvXUo1a4av54vv6TiNSUm2
b9MlaXO8Y7ZV/lUgJid2/tBxPWaO+Tz5q95fxSRsIT03JN4cV4mvaTEkYGLc
MWod9cIc18alPjZNxmT78STQHDbHMmHjl2PSMMk5oqrvsmKO10RFVyrTMQkv
1fBqZLbA7L09fB0PMYn86R2lKGyBz99Nqaj5T9fhN1c/L2WBY1ma44L+8zMf
MP7gLW2BNUppnSj/y2f5bL6+IGqB3eL4KU3i/9uVqD8tsFvgJ7KW3oaRmAzy
WzfZ/zPHFjzTTYsBmPAKvzvKOmaOXeLbrx3wwkSZmYVRsMYcF9YlBB8+hAn7
9f27QhLMMQd7bSedASYJ3Zv2ekfMMe31NcETiphM0IQ7BQib41Xn2SsnuDG5
QsmboDtshpt1t0lz/0GE/ltidO0tMyzx59rm21eINHBc3SekZ4bTzLiWfl1B
RG+u4FvypCl+sWc1JV4HkfvSNrdcY0zxYKzIg4plPWLfEbPZJmaKc0Xy+0IK
9MjX1x76vJUmuE5WSHbDUY9svDpi8NDABK+Y7ow7QK9HTnXcMqh8a4wFnbaP
JpfokuHGLsv6A8ZYPspwdMZOl4w8dkoR6v6PT4+X2y4u6ZDWNs7uvRZG+KfM
SOCx2zrEU6U3IKzBEL+hmq9rltMhO981bHfeY4htawUrx4g2UZhgct6fa4BX
Dmc69ttpE+vyiuoqbgNcxrMtrW9Ci4zoPOXiidTHjPJy3Cx+WkS+4MKJjz/2
4aenx1cq1zWJD+9cXtChfdhF4n7l5lVNYtAj4usBGOdzZvULMWqSPMEv44wy
GJt83CozurmXfAsYOVUsjvBBC3vjEra9ZI1Nn9JzSRcbq1jM3LqtQcjOwqO0
bTqYNTZbUIRdgyjbK0xYZGrjgKB9Bom39pD6buZnP4O0MG3fsxAh5j2Eeyyh
MPWIJj74l9pp9YY6cfbIYpnU2YvXLetaHejUSdK+rIqTUhr4c/OZIr/I3cQv
o6E9l3MPXn3Y8C1gU42o+5jGCmxTxx9Czm1LDVIjYfGER4F6N043qNagXVEl
6Z5+IVq0apjvii7dL39VEheg3ZHCoopvZT4/EDGvQqxyX1lGi6rgD5+R+Hcf
FUL9hGtId68yDtv15q7ZL2XSF17nOVi2C9vnzrZ1+SiTSK9xQRdqRbxPnitW
d0KJfOSLFMce8th/MX7g+fQuIhGqNBU7IItTVV7N4EVFAlr1FgaOMjg2tL9V
kkKR0IVd/eUwJ43/+3jpUtkUyKiNU25BohS+7HSlqUNSnlhXWU3RG0ri2Q2f
6gUdOXI7OlBHlX4HTmyeVNU4Ikuo5CoqPw2J4819y8rksgxZuvT9aFWtGF7r
GPApzdhJVo7dk3rpIIpdey2jpVuliT5N8fTbQ8J4f1/lus4fKeJL34Xf+gri
mqoHfoyyUmRzlWm28wk/7t6x/VWWsyR5pKwZNbbEi9+5nmfieLiDtHCdqaI/
zoN/i5zn8PokQdrN9S1MR7mw96tzu/IlJcjlrO10mRc48ZUHdrdHfcRJWJu8
93YJDiwrbnGGjoiRPvYyg7ivbPj6xD+BHdxiJDaJX3PvRVbssayV4fxJhDQt
d89EmjHjfqOflw6kCxONu6HvqPcx4e03Xa/SugsRB5Gk3b2ODHg5SlX5tLog
ofv+T539Lj1uLzs/f5JNgFTHqwjNz9FigWbBxPElPpIudDyu1I0Gd8VcDa4e
5yWUnw/6P1yiwh6bZrytQzzEeImtg/sRJc51HKX7McRNkrf1Cl53ocDcsq4X
/41zkfhdSeT7hU00JX3QuWuJk0RYXrvYd+Af+pqe2b2XlZMIFM/x8B5cQ9qv
D0syqXIQn65D9Xwhq2jH7t3GvMfZybY9h+85N/9B1+qVpxQS2cjktfdO95SX
0YHuJX/1FFailUD7IrZ6ETXyXNA4LshCUJ6kvcSxBXRxMij9dMl2coLy4k5v
/nmkasuI12yYCE3uYDzL6C8k7dekmE3FSDYP6by9Wj6Hsvo9dv0j20hDdaTX
0vNZ5LRuw5oVT08ebBO0cRicRtUpeydlPehIZ4hL0bDYFLqBjcyVzWnJGV95
r4Eb31CGESRbadMQ2SGR+kG2SZSstskotpea/BpbGUkun0Ajo63s+zAVqfuX
EjDrM47WB8wPWdtREsRnd3LC4AsKzWZdnPalIAXcmoF5ip8RQpNSbipboJd5
RJrj8CdUWnmX/3byBmjhLsupSyNo6JLv5hPGf8BSfEDsZ80weoCedc4lrQH5
trrnkvAQctOIcatW+Ava5n80tz8cQP30QRlHBlbA63m6lpfGB3TCUCtUNukP
6Edf2ec704/iJDPUoo4twzJVO41WRR8KLM3UbldfggnO/M7NpF50PEHe1Vl4
EWx7aeOEo3uQgN1WTwnHAjyv1efkvdGNDlR0c0lzz0NCsgcHr3YXKgq041GX
/A2uTu0TPpGdyHIyyPjplZ8gGvFj/PtkB/rV+aN5ueMHjP32cHBya0cSNxWf
HlKaBYZkzYcTq63oqbeoT1fuNFQK8p0rzGlB3J1dO312T0G+8GQUp0czMn9R
oG7Z/w0uJl7we7D3DTK7fRnfiJkEa2++snHhJsT87uZ2C/OvULNis/qEsxE5
125YN4hMwPfV6JJXfA3oa0/bfWnqcehq33zJo/AabZlm8Vf9+Qx9lxMMavYT
xNIxPH9hfgyOaVi/vrpYj1hzhT022D7BFLofUeleh6aNmyrKzEcgKHeUOWa2
FtEzJK2ZPRyGDsW/lYkxNWgNemrj6IfAu7TiR/zulyiJ9fwzs+sD4OwjP2+x
VIUOs/9VdxP5AG+3GM++aHqBMs0uiDa19oOod//p9pxKNLhMo+ge0wc5ZyQC
0+5UIFFBzwrjQ73QVRM2YJxYjrY6BlCQRg/8ePNzg/b+c7RhvaDHJ9sN/jMZ
6vylZUjD5xrTjYPvQG1VTLG7pxSdNnDmd7zwFsSYw0eYN0qQx3IqDWdpOxy5
y+xvdroYla8JrqjTtYFM7C2tPXPPkPmXV2yHA1pgY8iOsj2iEI3YKf0W/PcG
KLwGVphkCpBN1lirVloTPOOu/MMxlocuFoV+vmzRCB6hB1xonuaiBu+Xo8Xs
DfBJpW+aI+QpGiwsEq2fIcDgF3Mx1PkJEtwwydhdCPB9nsnrpm0OaqpJXo7J
roPMEia7+zaPEZf+qQcJL2thuTQna+tYNjKjUT0b/PMl9IuF+0pdyEIXj4y5
PkDVsO4W4RyckomCPKznrApfADonpD4f8wj9FM/cx6xcCWLtC2t7lh+iDaHT
Fq5vy8HOsVS+92I6kuH782zuynMI+1htMsT4AHUlSH93MS6DWsOWq+dK09BC
tlXIVfFSqGod4wbPe+hNFG+xtUgxlHcty1AppqLQNUW6U0LPQJp+mesyVQry
Ga0zxdoFEPnu/NOz35KR5cF58Y+BeeArk7SkOngHyTvwqZ3oewoauno2OwaS
kGXcpVfbzJ7AkitFVNb4bZSSlfdRdfAxLM+f1+ZdS0QaCz8b9odlw+X0ea5l
oUS0GXHy3KhOFjC6l552v3sTib2JVYpgzYS2tQvnUmkTUBLFr4+9sw/BtFbK
MPZGHMIv+pcrRh8AKqI5aCUWi4zS6k4dWkiD94GBNBRt1xG9x5Xl6zvvgfit
Jc6WyGtonz/p0AlOgQNj2um9+2NQVe8zvajZZOjn/jp+XDoaCZg3FcZfvAO7
tMfyC1iikK6hRmymQBJ8YTY8TUN7FeXiQF/JD4nA7boVV78tEoXfZYqQt74F
XPZ64rv5I5A8t9swl2ACsHY6T7Sqh6N+z+p/DsxxsOT8hbTXXkGepavul3fc
gEMNPTPL4qHoGV30X6Gj1+BW2L8GiofBqOAfayz782i4k9xj8V0+CL37OHXW
RDoKKk0Hl0s7A1Fw6JeTnZWREMchc/5sxCU09bA+4f2JCJjKY8zQMb6IPIWZ
JgtFw4Hfu73GUDAAuZoqufjPhUK2RoRG9ZY/ssz4aEb9JhjOcnEk9i6cRxpR
p/fjxstQ39pkPbzoh3p0dQLjJi8BB+9XJkEqP5R99/aBANmLwBnq3Tcr5Iv8
Za+Q5/EX4O/HrAaba+fQX9HUSilmf+DKnym9OHsGnZrj+9iZ5wdqmeLTIh6n
UWWt0+u2475w4rlus8KiNzp9ymSQHDwHvge7zTKST6L0yzcUPvKfgdJGjmxf
Uy/03JInYIT+FOQ6JTm/YPZEyarx/r8FT0J08pOw+Al3pPcWKk/aeUL9MaZ5
9jY31Br+172v0B2Y8zrCQ+tckdS5lH3jEm6QyPL9KCNxQauCP53OvHABu558
kfUuZzQ19bDb290ZSnhi6nYNOaG1yyXS3IdOwMvNmYlrcifQnf2dn/jYjwHv
s8dF1UnHEK3hqsijP0cAGNiyb7EdRQI5gdfiqR3g663ihP7sIyipdU+tovoh
OEU9pnPH1AHpyUh/H7h+EPzf+Z2ooTiMfmWqyXL+swWdlpKPZu32SPpWJePT
eBsQOrE85pZzEJU/eX3Pee8BYFVayue4aYfKlcJjfqxZgsav2c7KGFvE9sBg
rrvcAkakFv4dSLBBtVd01yXumUFLOW2VetYB9Ff1+I6qHBPQ7Tf46HjVGu0s
CXmd9MEI4vsC9RlHLFFy6e3mXfKG8H3/o4PBFvvR/wD488i5
       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c40A8TwG0he++RPbJC5p29slOadqUSkpKRESqjJCMl4aesrCIivpLs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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-1.8, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.87959530735952*^9, 3.879595388312813*^9, 
   3.879595474058312*^9, {3.879595527396482*^9, 3.879595678444026*^9}, {
   3.879596435329919*^9, 3.8795964490906773`*^9}, 3.879596933869444*^9, 
   3.879597276440446*^9, 3.8795974233124113`*^9, 3.879601449410161*^9, 
   3.87960419445166*^9, 
   3.8796061740371227`*^9},ExpressionUUID->"a8a20cc5-29f8-45fe-8faa-\
18e717f5f9e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "2.6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.8"}], ",", "4"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595703834207*^9}, 
   3.879597261059623*^9},ExpressionUUID->"d7cecaa4-15dd-4fd0-b510-\
a7f4acbb7e28"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.006944444444444445], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlu3c8l/37/y9kZEbr0t6lEi0tHWd7J5WGhigNWkqkMjKaSENpCaWoVCKS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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c00O8btTdJJHvv7C15P0hGStklIyuUElIqJTJKZFVkr5KRLft5kcjI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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVVXc4F+4XtTdJJHvv8LFHcl8kI6XskpEVSgkplRIZJbIqslfJyJb9GomM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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-1.8, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.87959530735952*^9, 3.879595388312813*^9, 
   3.879595474058312*^9, {3.879595527396482*^9, 3.8795957055127697`*^9}, {
   3.879596435465602*^9, 3.879596449225306*^9}, 3.879596934005436*^9, 
   3.879597276558559*^9, 3.879597423444522*^9, 3.879601449553327*^9, 
   3.87960419464532*^9, 
   3.879606174172921*^9},ExpressionUUID->"2e8b38e5-73b2-4849-be44-\
55341701e4c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "2.65"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.8"}], ",", "4"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.8795957221862392`*^9}, 
   3.879597261067135*^9},ExpressionUUID->"b81c638b-fd89-4fb2-ba11-\
4c1d13fc8296"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.006944444444444445], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm2lYjm3XhqNJmadEZpkfZMicdZGpDClFERGiIgmlEhJFikQyFCpRQgMR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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c01/8Xx22RvYWsD2VvDdXrnVSKjJJINiENo6xQIZRQ+BqRrLK3bO7L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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c0F+4XtkX2FrI+lL01VPdNKpWsJJJNSMMoK1R2CYWvEcnK3mTzWpFs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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-1.8, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.87959530735952*^9, 3.879595388312813*^9, 
   3.879595474058312*^9, {3.879595527396482*^9, 3.879595722978798*^9}, {
   3.879596435604767*^9, 3.879596449356476*^9}, 3.8795969341430492`*^9, 
   3.879597276689398*^9, 3.879597423579444*^9, 3.879601449691366*^9, 
   3.879604194848625*^9, 
   3.879606174310836*^9},ExpressionUUID->"97d3635e-763f-470a-bc02-\
5391a15348fe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "2.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.8"}], ",", "4"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595741394744*^9}, 
   3.879597261074992*^9},ExpressionUUID->"67856506-ec60-4ad0-b2d8-\
016d8664afbc"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.006944444444444445], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3c41/v7x432EU2lUGlpF5U03G9Ke5O0pB2VkJGGysgokSKFzCSjrIaS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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c00O8Xtilk770r+lZCUno/kUSRFpVSFElE9iyERNk7svcmO93XKit7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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c0F+4Xtilk770r+iYhie4bSRRpUSlFkURkz0JIlL0je2+y02tmZm/J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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-1.8, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.87959530735952*^9, 3.879595388312813*^9, 
   3.879595474058312*^9, {3.879595527396482*^9, 3.879595742169587*^9}, {
   3.879596435746664*^9, 3.8795964494919024`*^9}, 3.8795969342792883`*^9, 
   3.879597276821064*^9, 3.879597423710351*^9, 3.87960144982763*^9, 
   3.879604195038412*^9, 
   3.8796061744734993`*^9},ExpressionUUID->"ede18541-7394-47a4-b141-\
81412cf884c3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "2.75"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.8"}], ",", "4"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595759803381*^9}, 
   3.879597261083373*^9},ExpressionUUID->"556eac12-22ed-468f-828b-\
655958908d45"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.006944444444444445], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3dYz33Y/hGyIoTsG9l7RIgLKVuyZ2Z2GYmyoqjsoiINsyJFJFI42ylF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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVlnc01/8Xx22y90pG9S0KyYrQ6x0RDQ0NkllGZiorMkOIjDKzssrInuG+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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c4F/4Tt8neKxnVtygkK0L3joiGhgbJLCMzlRWZIUSozKysMjKzwtve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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-1.8, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.87959530735952*^9, 3.879595388312813*^9, 
   3.879595474058312*^9, {3.879595527396482*^9, 3.879595761193214*^9}, {
   3.8795964358783407`*^9, 3.879596449630981*^9}, 3.879596934416008*^9, 
   3.8795972769535303`*^9, 3.8795974238422937`*^9, 3.87960144997342*^9, 
   3.879604195176484*^9, 
   3.879606174771706*^9},ExpressionUUID->"69962757-94a8-4bde-a383-\
77c7f012a7fd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.8"}], ",", "4"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595779243949*^9}, 
   3.87959726109173*^9},ExpressionUUID->"479c6edf-ed98-4823-baad-\
4a865b131dea"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.006944444444444445], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3dYz33Y/hEhbiubrAZRZlbhCgllpDIiMrMryt4tISTREFqEFEIhOkMU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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c81/8TNz8oERqIrySRFqJCeX0olFEJacjKViKZWVlZ2ZSQvUf25t72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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c01/8XNj8oEUqIrySRUogK5b4plFEJoWRlK5HMrKyskFVC9h7ZWy97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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-1.8, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879594845312233*^9, {3.8795948792965384`*^9, 3.879594886178192*^9}, {
   3.8795951237439947`*^9, 3.879595132775153*^9}, 3.879595181131072*^9, 
   3.879595253918599*^9, 3.87959530735952*^9, 3.879595388312813*^9, 
   3.879595474058312*^9, {3.879595527396482*^9, 3.8795957803115053`*^9}, {
   3.8795964360203*^9, 3.879596449764063*^9}, 3.879596934551961*^9, 
   3.8795972770966043`*^9, 3.879597423973825*^9, 3.879601450111979*^9, 
   3.879604195312025*^9, 
   3.8796061749422493`*^9},ExpressionUUID->"2772cba6-28ea-4ffa-a153-\
48d00cc6cff3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[CapitalDelta]", "=", "1.7"}], ",", " ", "1.75", ",", " ", "1.8",
    ",", " ", "1.85", ",", " ", "1.9", ",", " ", "1.95"}], 
  TraditionalForm]],ExpressionUUID->"2455baa3-487f-46b1-9721-63faa868d0fa"]], \
"Section",
 CellChangeTimes->{
  3.879596067518147*^9},ExpressionUUID->"3c4ab98a-2c72-481b-9b46-\
98cd6cf978c6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "1.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "6"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595807961852*^9}, 
   3.87959726110382*^9},ExpressionUUID->"9a5dc5cf-cdfa-41ce-92ec-\
c923083b9744"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3dYz23Y/9tDSaWd9iJ7k/G5Qlkhu5KVdJOVlBGVUiIZkSjaGt9UkkKK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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVVXc0Fu4ftddrvPbeK1IkI0rPk2TTQkoZadikQVaSnREKGdlURlnZnkcU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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVlHc01/8Xx+31MT723itSJCpKr5tk00JKGWnYpL6R0RAZGaGQkU1llJXt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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-0.8, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8795958058422747`*^9, 3.87959580835611*^9}, {
   3.879596436201055*^9, 3.879596449892308*^9}, 3.879596934692388*^9, 
   3.879597277225739*^9, 3.879597424107999*^9, 3.879601450281267*^9, 
   3.879604195445904*^9, 
   3.8796061750685*^9},ExpressionUUID->"1271995d-c971-43b6-8e4b-847a860cc7ff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "1.75"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "6"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595827405424*^9}, 
   3.8795972611207237`*^9},ExpressionUUID->"1c3affc3-16eb-43ff-ac8b-\
6003152c93a4"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3c4lv37x+1N9iarpa2Nuj4NaWnvFA3tQWTkSZR2IlGU7b4pIy0V0fmh
VNqpKFEaVmmbWV+/4zjPv37PP8/hOHTjvq/rc53n+/16ma/ZMd9NSkJC4pK0
hMT//f/urrES7U/68UNpufVy6h5Q/jbZsyihH4+o1N44cJkHZLuruMt49ePu
gxafKkn2AN0zJ4OuO/bj5n6130/89ICo6Unjyo36cZ7bd+90+50wMq12yPZf
fblesHyi8tGdMKloaKd7UV/+YkFgmsXbnbAlaJnDx7N9ufkm6z9BAzyBvRYy
8937cjuHQ8Zy/p6wZoX4g4xjXz7d2lFp/xNP8Mw0P55t0pfH+frIjTX3gq9R
qhueNvbhHq/G6fp6e8Ekgx0DZj/uw21zbG/xx15Q3lYbNkLUh+/aeK7DyWoX
LN+c7LLnvz48xu2xaft/u8D28yRn60V9+IGiwDTtsl1w/sCTeeOG9OFZ0umi
uTbe0KQT1+uCfB+eZqR+qv2EN8TcmLfJ96MVD7KPbXnW4A0dT2+MTrllxS8E
X9/zbaYPmC3gC4aftuLb3GTtN2T4wEHLrQn6HlZ8t3bFxYVqvjA+Ok9ixSwr
njjIfECRhy+op6U4t/Sz4nqf2KHBpb7wN60jvkHaiu/vatw8wd4PvETrc8dV
WfKgIHOD7GQ/YHZz4ivzLPm17NgNx1R2w7L6Vw5l0Zb8TMj6Bc+9d0PG9vzz
fXws+bGuryW+n3bDiBdu9+4vtORzR8xQOTDHH0JnZifk2VjyJ37F9nK3/WHc
h17jpTUs+dTne/71HvIf7JOaJjr704JnrygwOxT/H/Q/FPYp6KkFT7fqMg3Q
3ANN63bK38y04F57nDc0HNwDW37l9bEPseBlH6Jd2zv2wCPP3QtUt1lwHXnv
7JNeASB1/fMFaycLPqPbcsG57wGgYbXQ4dRgC666b+Bb7Y17wSfc3mGqmgW3
W7dSZvyXvfC2Xu/xpJ/mPPa0TIDa8EAw++Tafei5OX90wPXfVfdA6MwMlte5
Ys47M8dU6F4OhC8Fb3rVnzLveT254IV/AmEHnJgq7W3OLx35rrRlZBBMrkir
WLPUnAe8q6yd4xMEZgptsvJ25nzw+fjSn7lB8GK+ZNsPE3O+sbJl4IbuIChX
6vphIGnOZX8NC70xZR/0mVVieeiLGa9ccCug5ug+8A/vej3qgRm3kLP3qH+x
D1xio6b2yTDj7TO2dt0w2A+b5VjOwjAzbg45dkvW7AfbAh2vO15mfJeb9cjy
9P3QPuoKuC8z42XXM+aMbt4Pd9VMaldMMONhW6aVLZ0YDI3VBWOCLc24d8nK
yC0hwSCzfpNkvYIZ77PgwKdV5cHwb5TrIK3K3nx99JLr5v0PwJGIfxEPz/fm
mQNvNN/0PgAdBY31zV69+bk8P2/h3gFQEHQrT0/szf/2S1sRr3sQNkQdsbqg
1pu/+exX/GbDQdiq+WT3oApTzu+2S0jkHoQ9MslxvdNMubWlqV2ryiGw+q97
fpCvKe/s5Zb33vUQrHPuWDXX0ZSvl/95WJx9CJRDH4Qc0zXl48uX6kxXPgwj
NKIuDq8x4SK/OvGd1Ych91ZkxMTrJnzs8tErxuYchht5Zbq5B024/IvJo3w0
jsA2i5nqZ5eY8OmlRx5kbD4CTm3pLlX9TfiW+lbnK3ePwOyzXrXH/hlzpjfy
hqj3UdiV9Czk3GNjfrJ4gvQB/6NQ4X/MXi3emHe913pq++YolKSrfvzkYcy9
dLc8eDTqGOQumLJV38GYm726XzUz4hh4dkWXZOob89xXp5yy/h6Dc32/KSc1
GPGag/YPviw4Dud379Jq5EY8/1lZjFL2cchze16bFGnU83oJ0b30QmDM78qj
mZuN+KyPLc9r/EIgOxkktZgRlzVfMT2lMgResUcLS3SM+H2HMw3TJ50ArdK9
oV+/GfJ3OWoSt1NPwO9mX7680JAffPRtnZZaKNzZ5NZmHm3Ij8343WvmrlD4
5fJvtuBuyNs2SMkurwyFirVf31x2NOSdr2o/mFqGgap6+WXf3oZ8s9MZm44l
YTBNZlFLeIsBnzLUb/L0kDD4GnC3uPuZAe9urLbuKgyDTAu3WbfPG/CFN7J/
mrSFQb86e/GTIAPe9+KRu6KhJ2GDu3rnoBUG/EL/9dfC1p8EwyEr9r4bacBn
fwrR/xZ7Eq7lTF7+Rs2Al+UIl8SvT0J6SsRti3p9vlvzz/Fi1XConnnlQ84d
ff7g22Mzp6nhcPd96N+YOH1ufFEcPmJvOOQbXrB55KfPo9MyVwTcDIe/Lm1l
kxfp8xqrD9Ot/4TDoF2/zeSG6/O7lnK/Rg06BROVdzhpqOrzhtWyDufWn4KL
y7Lj19Xr8TlN00xdE0/BrMp1zt1Fevy1/u2hgRWnYNF1j4dVSXr85CCDpe16
EXCzxHiEQqAeP/X3YsDDBRHg5djw0WulHm//oFHwOzQClE0Trfra6XGHyDW/
dzyOgAqrETONDPT4NVdLP6YYCYYDClMXtOhytZVHP66aGgmbOxJOPH2ty4X1
W92e7Y8EnbkjFx+7psv9aw7YHC+IBNPg9sVHTulyky37MyO6I8F22MFv93fq
8oPmZv51409D9+Ot7lPn6/LisfMkg/47DYUe06fI2Ojym0MUvFfeOg1rZ1y+
L6Gpy1PXSy/e++806O4bvNLujw7Xz6uM+zzuDKw8OHLT1RId/vK/onEH/c6A
1gqr+Ruv6vC9l14dXp1zBqZPsQ1cFqHDbbXS5HzazsC90JCVB3fp8GkzzPvf
GxcFRSqai38s1uGVTQEl03ZHwbs9O8rCxupwhZHc5V9uFAySGDxvm6EOt3+f
/7myPQparY+N3N+hzXvl/1n33T4aHhkfaHzxXpvbxQ3p6BcQDXz1I9llBdr8
7IbpSw5BNPj8zHuvJ9LmzwdHpihJnoXFDWtaVA9pc7kpmxZenHQWvkdsKrbd
rM3f74s8tyP4LMQdNnoe66TN3VvTvGbcOwuGi1ccHj1cm4c5Xj07QeEcSNrE
u8voaPP+WWYZDjPOQcn5rwrybVp8BjsaveL4OfCWLC4ZX6nFy8bs2Lbv6Tm4
7T193vkCLT5qc+HFLPUYiMxqUZiaosVN5v5++2V+DMS/KNure0yLP0kt0rOK
jIGxfmvHG7hr8V0x46Sdy2LgYlrQQ6dFWnzJ6gXngw1i4Yxr4OWrtlq8uO1B
6sUVsfCsWjtghpkWh+EbJz2OjYXgggX5GnJafB73eFv2IRYmTUzvVGjQ5E5D
ApOem8fBKN+qp0NLNLlMfPuty2vj4OMRxcIDNzX5o5j9X73FcfDX88gmpXhN
fkmcnGxcGwebtikvyz+gyRVltYbG9Y+HtlEBfeK2anLXzAHFTZviYeDoXm4Z
CzR5qHhobe/0eCif0Der1laTNx6fYWLUEA8Z/1bHzLHQ5FNb3oa46ybAaelT
9z4ravLwS8r3skcnwGuv6w+Sf2vwpKyRJRWLE6D99t8JoW81+IGDI+s/eifA
xYjT98QFGjzCc+KnwtMJsGmRclfNBQ2uNNyyM+B6AhinvwueH67BfcU+3zVL
E6Dp9IX22t0a3OZ1wVL/pgR49claJnWtBh8R1+vjDe1EWLm+78TQWRp8tqO/
W9GIRFgcsmNxwigN/pqrFybMT4Qnjz/WvTXV4LlLC887eiTCoDPOcXYKGrw9
bblDTmgipHdyk6Lf6j3zhKb2n8xEOLqgQc37nTpfrXen+sejRAjYe81wdpE6
N66rmHCxPhEep3z5OitLnVtFrhk8RD4JaiPHWe+MVue/53HrLVZJ8G/zyuD8
/eq8awfftWZiEryM+ywesl2d7xtRrKG1KgnOaU+1L1qqzjM1ZCR2704C5Qkf
mwInq/PpDl1bI04nweODv4JWD1HnftlX+7pcSYL27iNh6w3UuY9MddObJ0lg
v/5cSahMz/cPP+jWXZcEFb2f/M350Itr7TFZ9Uw6Gdxut3ucu96Lh1/peSSY
JoMQFXjwTkgv/spO33/12GSwyMuIHu7Wi4NCQ0Lv+clwXGqlTrV9L75i2SLn
PVuSYUvYn3WV2r14QtEWHb/gZKjo59Rk8F2NG0TsLugVmwxOLcffRBSp8U8r
bqwb2fMwCvU1OrUyTo3nqI3fLv0kGSS0DwSt9VHjyzST7jl/SYZ38qd2ps9V
45PDBsU4tifDn9gR5SOt1fj54b3DCzRE8GRq2uBuaTXuW6nWeb+fCEI2Hv6s
+F6VNxt4Gi0bL4Jl1qmeC2+q8nudswZ4zhfBU1vzJe/DVbn8vg53rQ0i2H5q
pkLqNlVu0r4jYYy/CKYbZ0ldnKbKh16eZld5QgTX10ve+WOpytuiXvyQShJB
7k3T+17dKrzO0kQ/9ZoI9EHmxIh3KjwtMMHq3j0RKM8sPjPkhgo33m/Xz+WN
CF6nRLq5nVLhDudCTrrXi6DNNMGvbIcKf30+Q7m1TQSOFn2WBM9S4dW9x7j9
VRTDEj/XfVsGqPDSgLX6qw3EoFR/MPC4nArfHL5hBOsvhhO2BWU1n5X5luBn
4hOjxbA006LX7gJlfuOAWeqMKWLY/Ud80SFemavNTXq5c54YNAz7CNP3KHPj
WzHxsqvE8KNh/ozgFcr88MiXhlKbxXBdK3t58zhlLtXcS9iwSww+X2Lb4/SV
+dCfD06MCBTDlkN9cva0KHFoKJRbf1QMV9SszMJLlfjWk+oLO0+JYU2S9e13
2Ur872zD4tYYMaiyPebLI5W4eUa53FKxGEQ5Km9VdinxnKDDCwwzxZBv5+71
d6ES7/JZVTvhmhg+lr/frzpKiQf9LTQryhWDq+2AqOU6StzINy0yg4vB/dOV
SeVNijzP7/6lpiIxLDfZpnO8VJH7Dn9wJf6hGBx7P0vacUORR9/Vnpb+VAz2
9c/3BEcp8qFf3Kfql4ghaOOXcQ/9FLnT0F2Pa16JYdODH5vZCkU+eN2cJL0y
MQwZN1lcY6/IVy/aUp72puf3X3luT56pIn9+rDIw8a0Yzm/UOFIgochf6VXp
dfZ8XaBltLLpkwJPnGVxLL/na5XPgaFLihT4inGv9Kt7/n3b6uXXa1MV+Gct
Xz2vntd/tkl2o/ioAp8v8bl762sxCMXmdmHbFLiCys5hL3p+v6LeR++lzlXg
r0+2uiU96/l8lJwSv41Q4NeCE4Z+fiSGv4rn16zQU+B+F9VTIu+L4eLj7sTm
f/Jco3b3hPxCMdS1VDTnvZfn4nZl5eX5YrAJqWrNLJTnvvqjDT1uiIHbFwrF
KfLc7PPPIbKXxeA2atpatWPyvChzUr5Bmhhg8MT2/3bI822DB8y6kiSG314B
8doL5Xnwkwz/krNi2FrxuPbVWHmuaLT8ZEC4GPr0/rkl30Se98/78jT3iBhe
LDtz54mUPL/0emrpsZ7rZUO760HZOjle2uSztNlbDCFLH85c90SOGze3bOze
KobFc4ak11+R40tTVidnrBGDU+Btu8gouZ75sjpMeqkYIk/8F7E+QI4XOjdv
VXISw86ukbNWrpPjt+r6Jt6bKAbDb95tvjPk+LMdZ/YIPdd/a1WoTc4wOZ6R
PfaFv7UYpFcfCDHRk+NjGqcY7zPt+fs3qSaIO2V52eYHx5ZrimFq7ZHuuV9k
eWLju0sqcmLwuCU5sfcjWd6lU5Ka0HM//h5g1NbriixvviN/1PR7z3lyRjvP
IlqWOxlqq4RViSBgJTdZEijLLexcWjpfimD1/j2XMzbI8lCZ9XUe90WQNcRG
yXKOLLebNdqnKVcEwWsccnNGy/K+36o6wi/2vN7a6AXuprL8wsqgpoU950n1
l+ANU+VkefRy54mOp0VwufTpQbsfMnzI8FNNXkdFoLs2deKcUhlebxfXVh8g
ApFXUr+g2zL8u6dywhVPESxvuHz/eYoMH1Huf/7dRhFwKbNL40Nl+O0Kj+E7
V/W8/s4j2+/7yHDhzp8/+xeKoEXnTeg2VxkeoxvTajpTBBPGjE8YOl2GP5hZ
93DeJBHEmQ0aqGojw1tszmweaCuCM+cW3pI1kuFLxx6Yd8um5++Pii3Xl5Hh
zkofPDUGicDjfW/Nqd+leeTpSmFCXxGMLDL7erxUmu9wHZYw37zn5yupfm0A
aX7FaFCHi4kItqZ5RrldkOb9JsvP9zUUQelDCf/mcGn+/Ujp4Iv6Irj521c3
/j9p3r/iW4B2z9c7m6/+WLVemqdru7y83fP1rMlRB0fNleYZ+am2BT3//oe1
rquFrTQvq7rkMsxUBOuXWHZYWUnz5StLtptbisB05vVyezVpfvRooHbaABHs
7lW4e1OrFL+ZKNpbNVwE7prDl6d9kuIZeVN/vbMTQfbBT01dj6X4zlXjIq46
imDQSlHx+htS/KD7ySmBi0RwxdJm7sdEKf4+eOHxZW4iiN09RHr7cSm+TV7z
0lKfnp8fZb5CxUeKn63aOP70MRHE/Nv+7NZqKV6fJvYa3vN5Kym7lvrPkuLR
r0e8Y7d6vn+3VvXMMVJ8aPhj2Y+lIthcuHfHQAspPublg2VDmkSQNm97nYGq
FN84ylvHUVcMFVf8C3RbJfmCiMaB02zFUHNIa4v5Z0m+Md3v9ezVYrhlvXXh
uKeS/EPQmKO7j4khNebgt5U5kjxerQO+3hSDSfPA2BMiSX7g2cItUC+G9Lhv
rx6GSvItA+/90jdNgahtBp0a/pLcZVmZi/7iFEi+Whywdr0k1zg5r/3jyRS4
ceN1we15knzCx4EuZ16kgGfWm0GW4yV5XkG/vGU6qZCUZd0nrL8k//lqwmun
lalQveezmqy2JC8dUyURfSEV8vaWzwrqluDyga3XXP+lwro+55nMNwleu/Df
4OI552HdzuQZIaUSfOzVVuPWC+dhmOuHYqNCCe49/F6cnuIFGPhnlHFWpgSf
PNhz9qxtF8AkYULc1GgJntKidhRKL8CFaYvTPwZL8Iehk+yiHdJgaGVs7F53
CV5t0S2Syk2D+/FdT3o7S/DXMQPmWI1MhwaNvhEFjhL8rOteiUHX0uGtbcTU
dSMk+AOv7yUTbTNg+LZIW/neEnzikN+SJ+9lwOwfjncvKEnw2du1kh2WZcKv
GRO3nW7oBseXu0qP/cmEaPv3917f6YbzveIqQsMvwvBmPlr9XDecXtngs3dc
FiSBqvOUnd2wfe4P8aHaLEjbkvPSfXo3GCnV2G2ZfQlq5M+MjTDrhv8228o+
ybgEfMs6y8yWLnj9cPwoiV6XYQKUWuc+7YIxwuZvRrsuw45O0ecccRcUx18d
OPbDZRgbHluV9l8XLBs/a+1WpyvAfly5cmxBF0zcJWn1HK5AdapK/XLrLvCM
r9PzH30VqvwMNPQke14/Pbk5+PJViG5Mun67rBOWyd1ZKDv8GhTlVqyde7ET
1BwaYrWzr4FCfVDiw+BOyL0xafrD8dkg4VPdPHBFJySMWqI44VE2sNlKX3cO
74Q9jflhh1Zeh0VPbnXHyve83oa5Abcbr0PYrNRb6ZUdMN1cZe6/sBsw/7F3
wtmrHVDbKbtovs1NUHnYMHTTkQ5wl2TJlW9uwgY3iW86Lh2wZLzn0KvBOeCV
0D4vfmQH+A28WFg/KheM42O+SCt1QIrXtLAzDbmgrDPCYtKHdmBhjx6WnL8F
503uHll6rR0M8h1GXd6cB6lug886HGkHp0or/Wk2+bBtlWOJ/Kp2SC6YnpjR
nQ9j16hdjrVph9WOk23+ltyG3xPvZ8vKt0PN/SOPh2YAbPPt7zrh3T9Yfe3v
z1wHDhuu7Rs2NesfyNzxGLH1JgeJfj9Sjfb/A9mkVj5ySAH80/aclr/4HzTN
MDlskloALpITIgdY/4M9Tg63h1gWwnzbIk2Xzja4MLzhintSIezJkHJ0ft4G
mWtm//lqdQd2TUzI6Z3cBuN/GN4Spd2BgD2DG1N3tUHWuD9cNOIuDDsyd99f
xzbolD/v8RvuQq2PxB8Jwzbo00c7NGxOEci35rx8+q0VvOcFuBz6VATT1t/M
XZHfCuVG6efKfe/BhFNDx6ecaAUl1xGbT2jeB+mX0o0ZLq1QcClmekrWfRji
qL9n+7BW6JM8pW+fuQ8g5fQW33qJVhg7vtpOtfEBbH/pftT4RQvkVGXpuZ4r
BtPiByvkElsgfl3KIdOpD6HPtaBosXsL9N5YeH1a40OIPrCyqVVogeu1lysq
xY/AR9G/b7daC0z+mXCwYvlj8LD5W3u9shk+bKjdPknrCUR8F7WbZjTDkBmh
01SePYHn3+72H727GQ656NmMPvEUfGZH27c7NoOnneSQW3OfwZJLoLRNpxnq
HvS/MEP5Oewb773t6KcmgATLmvc7nsOzrFqH+VlN8OTv0lW6pc+hZdau/+74
N0G4zFRRw/gXIJaTlKx0bILRyeyNc+oL2KnBHsVqNcHZqMZtqzVL4ND6rnKZ
D41gfzIyoDGgBBbH+YzVSGuEWd5rXXp9L4G8rKjGAq9GaJQZpZju/BI+zVky
QFdohC/Hfe7Ak5fwZ1p7m4piI7wcUzPTgb2CKau2nxKX/IX/Jqrds7n2CgrF
RwZ9OPcX3ocd4gEDXsPXwevkctb9BYOMCUN6J7wG/bsJW20G/4Ufr9a7KeqX
grn1rewZTX/gQ7SJmc3JUpgVtWiyZP4fSHEK9QlRLoOVIcH7FgX/AXnT6Fq1
Q2XwTs2oYerMP3BBtWn6Bek3cOVHo8xrjZ7vF20qnx30BpwXTlzVXfYbMu7n
DP/d/QZernsUWRT7Gzo1/04N2vsW7PUmLu639jecezt818/ut/AwevcSq/6/
4V2kq+fAoHJoaclfldfwC65bZzpbSb8DyRop4eelX2Ds2z/jwYF3YKQ84m2e
1y94YfFgipxiBdiN22zcZ+wvaDH03frweAW03VynMrf5JzQ7ny+V1KiElQV7
HY75/4R81eMxUZGV8FJjnmFH9w+wz1OfudvwPZSXj/yQtP8HlG36+P5k/Ht4
1GEiHyj3A6KTDxQXW32AE/LNlhGHv0NI7ZoW5bQP8H18S80Hxe8gfdboW4Je
FazzkzJfd7QB0iN3WFsvr4KZld8KzZUaIPXkw6bImCqolCqsNDjyDeZsGjD3
zfsqCP6hnOwk/w1838QrVJt9hPMbpN1uB38FnSq73Kw1H6Hr5J3T2yS/gsmy
ey8Gij7CBG+Px8576uH3wHdhs6o/gtcg51shrXUgN2KRhmzfTyD/R8tWyrMO
oi6dmz5t/SeQPOnL8hpqYemOv+qKKZ8gdCDU5rvVgkuqp6Vt9SdoLdy+WfF9
DXxPFPo+tfwMwcfmWyUuqoFJR65k3Fj9GYx2rw0/9LgaFJzq7OvjPoPZvdT5
MKkaVlv6LVz07jPkuihYzbz5BY47n9r2Q/cLHF1nXDN48Be4/kBbJnXeFzi3
pz5qc+JnqDyReM7j2BfoFRbjLKPzGep1ze6wu19APWSkR9ehTzBWpcpIvuML
6B3qM9r530fQXKiy6oZNNWRX/RhgvvUjsCw/lykbq2GXX1r93MoqsM6apJcY
Uw0ZQSHDfjpVgcWBZhF/Vg2vvfjFbv+ez6nXmsWnJWsgfmZ5quqK96Cz4U26
jk3P3+Ve5K4+rhJu1Gu52KyuATnH5W7quhUQaWq4sepEDai8OKyn+6ccRhfN
lta+VQMR+z85WT95C1EKxdcLqmvAQ0ZDanHqG1Bu2bbkvVotgNtol6TAMshO
6VJzGV0LOZoC119WCi+HhriOc66FCgnTi4XDXsPWAT8Hrw2shcApzZUX5F9B
QFq//JKkWhjmPXrom8oSuJ1VlBdwpxaifyVeWHL1BXjlhk5b9akW7v2e7m9z
+Dkoesv92NhdC0suf22ovvkUCh4aXz5tWAeWom5TR9fHMJz59KoaUQfO4ZOy
Y+UegtdST9kJM+vgxLkNWt3p90Hy9zX1NNc6cGt68DJwbhE4gNVIU686yLbN
LRzbWAgVG3/9izhQB9er7761P8MhJWabv2JkHaj6pO6a6pkHTCNxmU9SHXQk
RS6WuXED3hckFZdn9vy8QX1Nq9quwJDRp08Ou1EHB/WWn1D1zYDiQndl79t1
YD/s5dcZ7UnQcXph3wt36iDFwC1T3B4OMzuvbXhwrw4k8D/L0b0bSu7//6/x
+wX6fnw9gV4Pf55APw9/H4F+H/x9Bfp98e8R6O/Bv1egvxffD4HeD3y/BHq/
8P0U6P3E91ug9xs/D4E+D/y8BPq88PMU6PPEz1ugzxuvB4GuB7xeBLpe8HoS
6HrC602g6w2vR4GuR7xeBbpe8XoW6HrG612g6x3vB4HuB7xfBLpf8H4S6H7C
+02g+w3vR4HuR7xfBbpf8X4W6H7G+12g+x3PA4HOAzwvBDov8DwR6DzB80ag
8wbPI4HOIzyvBDqv8DwT6DzD806g8w7PQ4HOQzwvBTov8TwV6DzF81ag8xbP
Y4HOYzyvBTqv8TwX6DzH816g8x6fBwI9D/B5IdDzAp8nAj1P8Hkj0PMGn0cC
PY/weSXQ8wqfZwI9z/B5J9DzDp+HAj0P8Xkp0PMSn6cCPU/xeSvQ8xafxwI9
j/F5LdDzGp/nAj3P8Xkv0PMe5wGB5gGcFwSaF3CeEGiewHlDoHkD5xGB5hGc
VwSaV3CeEWiewXlHoHkH5yGB5iGclwSal3CeEmiewnlLoHkL5zGB5jGc1wSa
13CeE2iew3lPoHkP50GB5kGcFwWaF3GeFGiexHlToHkT51GB5lGcVwWaV3Ge
FWiexXlXoHkX52GB5mGclwWal3GeFmiexnlboHkb53GB5nGc1wWa13GeF2ie
x3lfoHkf9wGB9gHcFwTaF3CfEGifwH1DoH0D9xGB9hHcVwTaV3CfEWifwX1H
oH0H9yGB9iHclwTal3CfEmifwn1LoH0L9zGB9jHc1wTa13CfE2ifw31PoH0P
90GB9kHcFwXaF3GfFGifxH1ToH0T91GB9lHcVwXaV3GfFWifxX1XoH0X92GB
9mHclwXal3GfFmifxn1boH0b93GB9nHc1wXa13GfF2ifx31foH0f8wCB8gDM
CwTKCzBPEChPwLxBoLwB8wiB8gjMKwTKKzDPECjPwLxDoLwD8xCB8hDMSwTK
SzBPEShPwbxFoLwF8xiB8hjMawTKazDPESjPwbxHoLwH8yBGeRDmRYzyIsyT
GOVJmDcxypswj2KUR2FexSivwjyLUZ6FeRejvAvzMEZ5GOZljPIyzNMY5WmY
tzHK2zCPY5THYV7HKK/DPI9Rnod5H6O8D/NARnkg5oWM8kLMExnliZg3Msob
MY9klEdiXskor8Q8k1GeiXkno7wT81BGeSjmpYzyUsxTGeWpmLcyylsxj2WU
x2JeyyivxTyXUZ6LeS+jvBfzYEZ5MObFjPJizJMZ5cmYNzPKmzGPZpRHY17N
KK/GPJtRno15N6O8G/NwRnk45uWM8nLM0xnl6Zi3M8rbMY9nlMdjXs8or8c8
n1Gej3k/o7wf+wBGfQD2BYz6AuwTGPUJ2Dcw6huwj2DUR2BfwaivwD6DUZ+B
fQejvgP7EEZ9CPYljPoS7FMY9SnYtzDqW7CPYdTHYF/DqK/BPodRn4N9D6O+
B/sgRn0Q9kWM+iLskxj1Sdg3MeqbsI9i1EdhX8Wor8I+i1GfhX0Xo74L+zBG
fRj2ZYz6MuzTGPVp2Lcx6tuwj2PUx2Ffx6ivwz6PUZ+HfR+jvg/7QEZ9IPaF
jPpC7BMZ9YnYNzLqG7GPZNRHYl/JqK/EPpNRn4l9J6O+E/tQRn0o9qWM+lLs
Uxn1qdi3MupbsY9l1MdiX8uor8U+l1Gfi30vo74X+2BGfTD2xYz6YuyTGfXJ
2Dcz6puxj2bUR2Nfzaivxj6bUZ+NfTejvhv7cEZ9OPbljPpy7NMZ9enYtzPq
27GPZ9THY1/PqK/HPp9Rn499P6O+H3kARjwA8gKMeAHkCRjxBMgbMOINkEdg
xCMgr8CIV0CegRHPgLwDI94BeQhGPATyEox4CeQpGPEUyFsw4i2Qx2DEYyCv
wYjXQJ6DEc+BvAcj3gN5EEY8CPIijHgR5EkY8STImzDiTZBHYcSjIK/CiFdB
noURz4K8CyPeBXkYRjwM8jKMeBnkaRjxNMjbMOJtkMdhxOMgr8OI10GehxHP
g7wPI94HeSBGPBDyQox4IeSJGPFEyBsx4o2QR2LEIyGvxIhXQp6JEc+EvBMj
3gl5KEY8FPJSjHgp5KkY8VTIWzHirZDHYsRjIa/FiNdCnosRz4W8FyPeC3kw
RjwY8mKMeDHkyRjxZMibMeLNkEdjxKMhr8aIV0OejRHPhrwbI94NeThGPBzy
cox4OeTpGPF0yNsx4u2Qx2PE4yGvx4jXQ56PEc+HvB8j3g95QEY8IPKCjHhB
5AkZ8YTIGzLiDZFHZMQjIq/IiFdEnpERz4i8IyPeEXlIRjwk8pKMeEnkKRnx
lMhbMuItkcdkxGMir8mI10SekxHPibwnI94TeVBGPCjyoox4UeRJGfGkyJsy
4k2RR2XEoyKvyohXRZ6VEc+KvCsj3hV5WEY8LPKyjHhZ5GkZ8bTI2zLibZHH
ZcTjIq/LiNdFnpcRz4u8LyPeF3lgRjww8sKMeGHkiRnxxMgbM+KNkUdmxCMj
r8yIV0aemRHPjLwzI94ZeWhGPDTy0ox4aeSpGfHUyFsz4q2Rx2bEYyOvzYjX
Rp6bEc+NvDcj3ht5cEY8OPLijHhx5MkZ8eTImzPizZFHZ8SjI6/OiFdHnp0R
z468OyPeHXl4Rjw88vKMeHnk6Rnx9MjbM+LtkcdnxOMjr8+I10eenxHPj7w/
I94ffQBGPgD6Aox8AfQJGPkE6Bsw8g3QR2DkI6CvwMhXQJ+Bkc+AvgMj3wF9
CEY+BPoSjHwJ9CkY+RToWzDyLdDHYORjoK/ByNdAn4ORz4G+ByPfA30QRj4I
+iKMfBH0SRj5JOibMPJN0Edh5KOgr8LIV0GfhZHPgr4LI98FfRhGPgz6Mox8
GfRpGPk06Nsw8m3Qx2Hk46Cvw8jXQZ+Hkc+Dvg8j3wd9IEY+EPpCjHwh9IkY
+UToGzHyjdBHYuQjoa/EyFdCn4mRz4S+EyPfCX0oRj4U+lKMfCn0qRj5VOhb
MfKt0Mdi5GOhr8XI10Kfi5HPhb4XI98LfTBGPhj6Yox8MfTJGPlk6Jsx8s3Q
R2Pko6GvxshXQ5+Nkc+Gvhsj3w19OEY+HPpyjHw59OkY+XTo2zHy7dDHY+Tj
oa/HyNdDn4+Rz4e+HyPfD31ARj4g+oKMfEH0CRn5hOgbMvIN0Udk5COir8jI
V0SfkZHPiL4jI98RfUhGPiT6kox8SfQpGfmU6Fsy8i3Rx2TkY6KvycjXRJ+T
kc+Jvicj3xN9UEY+KPqijHxR9EkZ+aTomzLyTdFHZeSjoq/KyFdFn5WRz4q+
KyPf9X+FISar
       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c0Fu4bh+3tfV+vPbLJJqK+iefRspKVQkVWlKKMUkJKWVEpIaHssmWT
5wkZiayQvUKy9/br99d9Pv9c53zOfc59rlvE1tXEgYqCgmKckoLi/9NbRty4
4pskfhUTWOLk8w6cI7oF+sZI4kq1JOni6XeAPlNqYsRJEtv6zqcC6/dgK6mi
f/ywJJYy2Hsx2/4emMoSfwcySuIUR4Fm6tOJQI+f+1F1jwR+/5mT17AuEeiH
p+hGZUpgVhI3HfXJJND57GAnhZ8E9vhxKlmrNgl4dke27hhL4ANSM8du6iUD
t5qauVAJCXzh/gYTR1sy6DFMmkvfEMe9Vl+T+i+mgNSBmjcmzeJ45Pfdh41T
KcCr6vDXJ0ni2G8SQb/7qUAK6RocvyuOPa5vFwWypYFzTab8TwzF8Q/NV3we
H9PA6asBIgaS4niM6QpX/al0cGsz98LrHTHsQV96Jnk8HZjXiv2w/imGbTyi
7iaFfAB/Je1C0rLEcEGdyH8vlD8CGm/6FOcnYtjHpizdZuAjoN8KAx+txbBk
UbG/Q3gGqHXc/8jmPzF8p8+GIvZYJqg3DXn/jF0MM4g80BvbzAQJ+t87lGdF
cUCS1A274iyg06dmrdsgiknOm5LvvbKB5TcU1Josiju6I75aaeYAcql8esMD
UazPR3xiTJMLJnPfcitdEsWZB3dzpp1zwZOFaBXqI/94E2sOOT9zwfKaq6MW
tyi+4hUyo3osDwwnqYv9WRbBR9lSEsl5eUCrU2NgvU0E23i5sN8SzQdsXwu5
XPNEcBMHu27w63xAn11grPdcBHvHRjEdYv0ERM8z8Ae7imAP5trF3Cf/MgOB
VsZQBB+w15IboSoAjnVv0mUVRXC/1i77lH8BCKTrTH5KFMETy+VneqkLgZWf
QIL+vDCWa7BxawoqBH6475hjqzCWefTt+HtSESjVD9AayBfG/a2pHz7GFoEv
ZsYmOa+EcbdRLnOedDEwrzil/Ou2MD7NksMxXlYMru6nT7a0EMbwkCOrm2EJ
2DdZ5Kp89B8vqlnsyEQJsAycsLUWEsbT1+RoLj8sBbdE1Y2GqIQx5djZh0SR
MpBOTRZxahLCnsyRPw5Xl4FKOx+KT5FCWGExy73VqRz8CMunTrASwlnyqxlK
5ApAPT29Li0lhFPfhh06jCrAyAG+EuNFQbxvDnOSbn4G9lRxohyfBfFI4kXU
Jl4JPGcFxFyDBLEQ96vdu/2VACzaZF0+K4i//GI9zf4GgQhNmcpxYUHsNici
elUeA+pDM5Z7M/uwSq2PYeMzDKrkW1+kl+/DcWr2hVbLGHxOs7w7FLwP62uW
jpMufAGtZy8rpZjvw77q9mdnq78APTzUv7x/Hz5enNhNVqwCWTQNuU1rAvhI
7gLhztsqcI88PihfL4AzZeXyVFmqwSHptA/sMQJ4webm0ZO+1eBcDfmszzUB
PNdx7OSXxWoQ7RMud/WoAE7+cicm/2oNkFGpDPxJEMC7vYu+3KM1gNHS/Qse
5sfnzmNnsvVXUPfn2lHpQn48catsKLL/KyjQNrRlDebHSuPXVqutasGU450k
50v8WPlkXkzkSC2IYBi8fUyZHy/axK0LXa0DkxHbFs/p+fGN1kF7z8U6sOr5
tsW0nw97eOW5RPvWg6pLLfahn/hwRVmP+jvWBhA39zlVNYQPP1TuvxOQ0AD0
YxLkjG34MPFe9AHXg9+A4opfRN9hPpxiPJ5t+v0b2CQcu9dJ4sNfI5zzDBwb
QZqrS6jGH168nwnWONJ+B6EHhN1JVbz4lVH63dzU7yBBfmLUIJYXU1b1OCjr
N4HNiU+Ryx68uGUirZl2qQnw52SepDbkxcrRGeFS8c3g+03ZIi9pXpzTsZNW
ePoHyKp/lm1Kw4vzpgxMCnZ/gEVwYCtikAfnjFHv8Vq2gKuMp26olvPg3h/U
iclFLeB57Nee/6J4sIO6KjMlZysgWJsIJrjzYBmSkL+qZyv4b0CU296IB/fL
f76m3dUKxvMX0gPlefBsnT7nCfU2wCjXU87AzIO1sor9ld+3gTrnU0fHJ7nx
IxpZwMPYDh4G9/IJ1XFjJ4fZtW23dnDjuP3p/BRu7KET5jc10A4ce8oa4gO4
sYIR/fXp0x2A+Wn6s1E7bnyqgcKZ5nMHuDM7Fu93nBs713Gdh4o/wY0z81u3
xLhxuIsAXXrST2CzSZtTSs2NE38IVp3g6wQeTDQ1ZmNceCdab3Dfy05wSjxZ
9+RXLvxrTSfxCKEL5GdrnA1M5cKDn1IPfAjtAqIHPDb4grgwQV925AZzN4B6
BaZ7V7lw6+k7Z16GdYPJ7zd9VU7/47EesZAi/wJh5fffFClw4eAppteKMb9A
8zO2xkA2LuxXFfCnQLQHLHLeUEtd5sTS9i6fcXYPaFdqoGXr5sSxJkNRNhq9
4M/tww515Zz4pc4KftvcC67TpzyqT+DE1bR6Tb62feDwcF4EewAnDhQefE7c
6ANc7/Nr05w48U1StP3FiH5gpR12LsCAE+cy2vpeVxgAnaQi73RlTtzjJaNx
pmkApHqxurHzcOJVM44jDK6DwCR66E7NDgfus/mo9ZNxCPT4VjaVjXLg9luR
xLeXhkBcxZOilQYOLGWeKDKSPwQuax2645HLgTs8CYkfGYcBs970ObUoDhzW
zeu2aTMMLhBb44/4cmCuInmtX+XDIHGJ6s0DBw4cnOFqdpp7BAQb+UXSG3Dg
tYjZrXMeI0CeQWKo+SAHvr3C8pyqfQRkOj759lOAA1Nl7hmYqIwCM825VH5a
DsxpyptpEDkK6NOPNSTMsOPBkdr7G+ujQLBk4YlNJzsezdWIvGA1Bq7xTKtd
Rux4WTrczfvrGGjV8jsQm86Om4J+t19U+A0yBixb2CLYMU0RozNDzG8wxGDv
Uu3NjlWDnh73px0Hd5OQY44DO37iz6He4j4OyjbTeX8asmP+fs6hzdFxMDDn
MKJyhB0vBU3S052bAP0qGiKN4uyY8bb08Y2GCcB7ylztDZEdv6zM8O8Bk0BB
8dPDd5tkrEkepcgpngQ938hO/b/JeKD5U6fvgT+A325Ux6iVjP97vx1pmPUH
qLTLBa1XkLFd/MSipOwUOH3lYfDPdDKucDc+wZIxBWz7xnPHX5GxhS5Bglb+
Lxjxxbay/mRs8zrFhSfvL2Diq6ROukHGCwlUTfqHpsHFqIb105Zk/De3biMF
TQOltrlUKW0yLrIzCZXXmwHth/XdVQ+S8WJwVsVk5wwoX52rchMh4w0587B+
h1mwktS1OUgg47DO+nPktVmweq3R7/42G565lGkRFjIHXLUNirSn2LDCly+n
ZUjz4DnzYyqtbjasTtltfujiPCB6StQ71rJhmxOWqTc/zIM7ZZbXygvYMM+K
ks2vtXmQ/DlHXz2JDQtQ/1Ma7QUQAzaaxl+w4SAx5rcnohdAQqeGyecHbFhb
Qm309NQCEDmRcLjSlQ3/6num+FxjEThNgKFJKzZ8u/OMKlvEIiCHyKcdPcOG
863z69omFoE6z8mpEo1/vE4Hty7NJZCSyER7SZ4NL15rbxeJWgL9253GUvvY
sBaFVlDB/BJgtjGW5mNlw042h2de6C+DL2xxIwd2SHj8y6MTFWnLgG9Xsd1l
hoTJugqCarQrAHvnnmnpJ+G2wVvqlPYrQChgJNWsmYTVrsT3CdWsANq7r2V3
K0nYol+85aXEKvj60ECmIYeE1xDjH6ugVUDH/HC28B0JP3l+bf7h9CoQgMe/
VL8g4Y5AJWlKkzVgJCb/Z+EhCR89TTHVU7IGJmP0PgIPEn5efT+ETWQduKss
n8x0IOE6cHA5JWQdyB4o2FQ7T8K3N+W3olfWQUKYJM2gDgnrlCgr/bXZAJnk
njdJR0jYANlOvv2xAV5XKS8/kiNhvpS4sGzNTdC4feKYnyAJXzLdnRTK2QSt
LEWfXpH+9VkKOjIvvAWkfFLcq6lI+FOJxyehV1tA7vyKCecUEQ/t7/qbybAN
xIffL7Q1E7Hdtknva99tQHf7HVXlJyI26rhO07eyDdaIXJ87ool49fN593su
O+BP+BdDTl8iFn//yPLm5A7oV00e8rEj4o8q4d1ldruA7nLTUxZdIk48LM53
fmgXjEaRnJACERP80niOWe0Boam8+684iNgmzDDnTv8eyOdQbgzeJGD2LrOZ
DQUK6Ee3pRs3RMAFNPqz3a4UUOuX6O/vtQRsLnb19rk8CpgzyeHLlUXAsgoS
wa5LFNBOw/zvnZcEfCFpjSCiRgnzw/TXZ+8SsN/FjEHHu5RQu+S7/d3LBFwd
qqgEP1NCA9+9MQ5tAj5StLyVQkkFk/1YRZA8AWeHrihFnqKCmeYtBZ4cBHxf
/JMw41MqyD4epai2xYrdhSV7tlupYNWLCfbdYVbcE/dL0pmHGnJzKXR9q2fF
JLtvlmesqWHF68DhmBxWHHP1/rV3qdRQiNM/zOk1K86OO7lpOUsNxZU79h/0
YcUtthaKd9RooGuc4tyGHSsOanOsn/GlgU4iO+zFeqyYiw0KFNfRwMij0iVO
B1hxl5UKUyOJFhbMzMwy87BiXTOJNWFLWtjlmVgRt8uCTUy5W3OSaOH5jqdc
/L9Z8F7QAQaXGVpYtZY38qCRBdt1jfoZH6KDFOPFa415LLhgoyPd0J8OZvSV
CmxEseBX97LMLjXSQZkHioy0viy48nTagAsnPbxU2mo/bceCn8tWMXhZ00Pi
94d1GboseLaeuOj8gR6G3T9VChRZcHpojprGEj3cK1XNT+ZgwYflJn72H2WA
GgI+fF0bzDjhUb48eMIAPZJs9doHmHH7TD+VyQ8GyBNgHBJZzYxfKpy9TsfD
CGOYFsh86cy453rXtP5lRkhaBKyXnjLj4vN3LrGlM0I2r7IIy5vMeDbJa+bE
HCMsVgrJIpxlxgGFLSIdqkxQ6B029zzEjH+YPerL8GaCIctvHoTwMWO+dS2z
EswEzcRaqfR2mHC0wF+e3zTMMKd0ITtnkAl/rAsj7NNhhi5l9aeKvzDhJQV3
d70QZpg03OF7MYkJC6ybDZ1rZIZ/1+t33wQw4fMHTfVlmVlgnJ6ArYsDE944
OMmcq8sCX9SlH247yYRP0Yf3fn/CAjfOmtNXSTBh9/6PP52qWKA232+d/2iZ
8I9OnhfXtlngoHCSi8oYI1anGaIrOcgKj2TaDWdUMeJrznolas6sMGbThir+
HSNGMocSGhNYYewDbTlaX0bcML15/EIbK3TgAAV9lox42Um+qoGKACuv7vsr
dIgRD5sWdG4qEWCiRozgN/I/Hs2r0daLBPh0JPZN5wwD7vJPYVJ+QoCXvRM+
wnoGLBA1vX83kwBbY/bHUicy4KHAO6s8rQT43ky3nM+bAW+0K3E6LBLgnx5t
K39TBlx5PIz8lUSEzPt0+pVlGfDfR++C+eWIMO4ZV4wMFQMuDjU6qH+CCE/7
UGzbddPj38Evt9UsiNB7FXv3ZNHjUWEXQtU1InTyDogNfkiPwVs9ihYvIlR6
sD5z/Rw9diRUt594RISDkh7cD6TpcRB3tDBtCBHazsu3VG7R4cakcMnVp0TY
fPzRuHgTHR6hOzy1E0qECulGWtlxdHg1V+IcdSARkolmI+du0GGuTdMzsz5E
2OuQMsl3lA5f7b/QkXaTCM++lX65ykiHQ+ssRfmsibBMSPz4eCctnlLdqlfS
JUJK/yrf8URavBFwu71bgQhZbPOWlm7QYmfD5H6Kf/13c4vvMh+mxR0vaI7E
TBNg+W8jThlKWhyoTmR+VUOAQTm6m6cbaHDMyX3XfkcRoKqRWfit5zR4kO7d
vUdXCHB9JN458hwNvuij//jKv31NeZnZFfHTYAqTcPHgFVYIBCUetA1S4z/n
Y/UnC1mhUlI6w2QiNX7SP33z0S1WOMVd5b9iT439GjpeXZRihWl3x3I3JKhx
lKSdvVcPCxypgvFLv6kw7QS1zkAgCwwq7Xo9kkyFrWuPuEcrsUD6hBsKtbZU
uF/Ffv1TBzPkvW6uFS9EhZlEk5qgBzNkW5FZvdZLieN1u/qNicxQ1EkZyb2m
xN6uPTQ7KUxwv9r3C2OGlHiAMVDowmEm+Mbg8a8IBkr8gcp/J7CWER60YYr8
D1NgOf9ym0QjRrgyOnyk5zYFfl5avtvYyQD7SVN1t+UoMOEyp720BQNsjlRn
F6vaQ69sPReGu+jhqJvKUUvpPVRP9EJCpvRQYKJhIjp8F/WGTL4g/rtX+5+O
RPxe2EFFeZVZQ4AOkmUrzbVNd5D2mxdfa/Jo4ff12fmv+dvInDKneU6YFip+
qs+8StpG+Z/LBqLCaKAbxQkP9etbiKaam3pljRpe+GlUdaJ2EwlLu7FoXaaG
OsXJ754JbqKQ1Xe2xbVUsK1uL1HScwNFVFv/fCVLBS3LRoY5vq2jr9kSVtzP
KGHrVsOyw751dMV5bsZngQJ+/TD2V8J1DY1PHlFmMKWAjy6a6tqgVRTQrFQ6
7bgHvHymNsQJq6hsPqeSTXoXRFK9MPC9sIK0niq4UUxtg3Bn+bl7acto0H/a
/r+MLWD2XbVPanEJ+dS0waM3NoFc9syF1+pLqFSr0jJQaQMohuqvtj5aRAUW
MwpRK2ugjfj+2tS3BTTpP7H4u2IVZHvSps6SFtDMi0Kxv09WQEnhs9IZs3lE
avTl5T+7DHZ82t/NqMyhQ+5s8ePiS8A+N0JfuWwGneVpCinbWABN5QUrdZrT
SOPpAde9tnnwagPyNn2ZQr5Si67KtnOAA1ezXz7+B1lSVnxtkpoB3mnHyQnV
Eyhe3P1mwOYUEL15fSft2Diq2Vbg3uuaBD8lGK5E4zHU727B0vtlHNhMd94K
0xhFBU43Fz6UjAHGBz31SaXDyBUYXF+oGAED2lKP1g4OoXTbt7MyP4bAPHWy
go51P0qQiOEPHOwH4hvTEUGmPait/PGvQ5o9wK+MWW3sVBe6sN/SiVTeCUjt
0bfD/utAh2Gy+rtz7UCZPmqhQLYVxQx7C1ixtYBxr5wmsvp3FOt5ZNmoqwEQ
7Yw1XQVr0QpPcl5oYzWAA6npHZQYObQddIzcKwf37+86SzV+Qmm85e4+k7lg
vWNtosMwHnGoFL2w044BzxssuB88jgAZKUWjghLhiOejWYBRRy6wfnEzV7b4
I5oTDOG3pvkMvJNyv0+4F6GFFjX4NLoGtI5eVmsmICQc51/EmPUNqExrRg6/
rkY/WkqVKqxbwHKAEo3W1To0pBD7p9OxHejw3wjx3/uGfPPT7atcOsGDSh3v
cstmBI+9jHHx+AU4yd2hpMoW1HX2KV+zVx/4rhkr6qvchqqyNDg6vQeB3GUZ
0XOh7UjwM58k0hwGAicuFhs3dCD9+JnwocoREP+y2V955ifKFKcrN9AcA+va
1l5f1jpR5VbBFbrPv8GJotvdTX+6EI1uxXNm9QnwccCSR66mGwla6d22LpkE
F4RKVwsCf6Efug/CaVWnQK/56vUTqj1IZcztMdW/P+jRVGpXSVMPar7cqHZR
bgYMX5wgLBr3Ir6P9Om8abPARLYnrKWqF/FQqvi///e3cBYnZR4U6UPnX5+o
vdk0DxAX1+TOjT5UUTTfuhe8AL6crFRm+tiHRpwXLM+eWgQ0ywIWqp19qCc+
7K0H1RKweahwznypDw2mkEwdK5eAz+GxER2qfnTt7dESlXvLYP42w2w3dT86
llXkN6y6Ah6UvZTvXO9DxRdvtXstrACH35MtjCN9yGNWxIgqaxWkpdxdPoT7
0Fp1PmWg0xpYeir5RuhVHyp0bLImia+DiNEjsves+lBegrNe+uA6iHcOt98S
6kM66150FrEboOpFNLfxr15071L+Efnzm+DSxElGsdBepCSqOq3IvgXum4cN
ktV6keSZIu/rP7bAjypapoqeHsQs4po4G7oNbEU3Mz7d7UGKXCauVTo7QNpK
Pj6IvQeJ/LhwYpl2F+wsCDhXp/9CZ63oO55X74JPuYwm4//9QnUyY4Ip/ntA
3vlv4I26boReZh0WEqaAOqODc83G3agqrV6p0I8CHr3F6X/vVxcSr/t8JXaQ
Am7c4hLqsepCNX0h092AEnK5UY4aj3QiZTG7VY93lNCw4+QpaN+JFKbWft3+
59kGIeWE3bGfyLS+jXXclgpSkNWHB+x/ohrXJqlvNVRwdGYnX2msA12/Gjks
s58aHqCNyztq14EcbM8QSCHU0E9mYenUSDuKDzmZ7D9DDQPLHYfDbdrR75GK
4kBjGih2U9DMcLgNgb/fvWWKaOAtTbWKSps2ZOxmecyNnxYGxge6EUdbUUOE
9H1Hf1o4FHxvzMWhFU1rLpaQJ2lh36TrIYY/LeiFQ0bafUM6eJ2iWIrSpQVR
F9dxZRfTwbOXy1w2J3+gVe+U5RxheqirRE9zaKMZfdy/aRgaQg97GinWF1ma
0ci7W+a6K/Qw/7jEWyvxJlSccMR66TIDLCpQJH8A31H+1I+uiCYGGKNGSdyw
akQZvqXmB9QZIft1Z4ZbD78hFeEbb7s/MEKVchl7xY8NiObL8YcRvEzw+sip
A2c669FA+xPi1RAmmBYRIzdEV4+upvrdvLLNBJmENUrX1OvQ9njmxitXZph2
x3sjybMWvdMkS++NMkMNLJUx9ekralP0TMuxYIHZwbb3Oldr0D/b0c1rYYEc
xNT7VzRrUF4BPztR95933M31SQypRvzcKqodVayQQVg44EFvFaIuFGVn0SRA
M963SVQHqpD6YtSxqjIC/BB0+KBo6BfE6FceRvUfEdo7dJ/5+QejwkXiSncJ
EQ67GlwiGWD0+HVut9Q+ElzsOmjz6ipC/JKzbyqsSDCC3Bs2rlWJEpwIvArv
SVA4tiKSSuwzUnp8+NujMRLEVjnMdSwVSGSWeKpGig06Kjv7M+yVIe7zPSdX
b7DB2ssVcR82SpHEb5wiXMAGp6UaN59sl6DwYvIVvS02eCwiStuHvgRlTMdk
3jtOhjsKUkcs+IrRjO3fryVPyTBmneXy1sEipMT0S5Kliwy52T1fHTxfiFZD
B2/cF2WHHcdlGbofFKBg+mR7Nld22BpE41aV9wl52j6mbK9ghxVnZkVr/+Sj
F/wqVxuYOaDb3LeefKl8NHjAaH77Agc0en/lhb1LHvrbrrDvdhYHPNH463FS
WS6yGAz8oEHBCdmE53fOsOai89LmARfPckJPh6Ami+/Z6JtPfnvvB05YP28h
8V9IFgoeKV2toeCCbVfoBYZMM1GQQFygiAUX9CrmG5iUykDu+QmXtvK54FjV
b21Rxo+IjUPn2UUCN3zQzvJt33I6mlEN9TB05oZW3HGFjn/SUJUCzYeBBm7I
u9TstjmZiizOOhA4ZXggt8Bp9fOLKehnXnvzTigPFALWGyK0KUgpz8Y6eY4H
0mwHTKmKJCMemsKHHGa80FqI/zn7qSR0RjFe37KCFzpxDByMc09Evr/HhR5K
8EGqO3zeHh/eo/P9kuXRz/kgNgod+2/iHSLpZBzI2OGD3FojY1Ny71BrV/RS
7XV+6HLfVzRzKR49ufz3x0Y/P5x9yEzt8DYOFR7tWzM2FoCMz3eez5m8RTHF
IlQDtQLwrNLlO1LcsUjX3m82U3MfDFNgO9g4EYMC+IB0c8k+OJ4Qu2n4NRrN
ODE+M1YVhHfQFZ/+7Ci0dD/zpnaBIKQt06lsSXqN7B6zR2FVIWiiq3v9aHIk
4nh3R7u59F+u11tayn6FXLyrxbSEhaGP9/HIOzUv0VvZ1Ztr9sJw8k9xd/Zo
BDJyueLJniEMwx+TtA1YIhCV44mR+EVh2Kvk93JV4wXSUj+Tn6QuAhcUToSv
ez1HShp2cnJPRCCV5iVDaa9nKFuJb/xYmwgcbBzR1CWEo30j92oXhUSh5YXR
Rb/Cp8jTp59B21UUnjvVw/jmWiia+FwL9LEo9BcPk1FWCEGb2pvnmdnF4C4t
z38qe0GoXCQ29qWjGHSIIEmG9AeiDEmXwvnPYnCRQ9BJo+EJem0EChS5xCHP
9GPLa/gxYi2yIFjdFIfPzxm476sJQNkmyinB38VhNsVIsFT7I3TztXQDlpGA
A56rcat/HyIKv1sa5FAJeGD72qctwkO0KbXvaNiMBHz/dfy59lF/5AIt7mmZ
SMLt1cIAc/cHiO9evRwolYQUp2ZW0q74oRZeJpYo0f0w9/2ZJoY1H8Tw19XC
Mnw/XDXLeP0q+j4y5B4afbO9H47AqHis443+B7YT4BY=
       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c41u8Xx+3teR6PPbIJWRH1TdxHC0lGqajIilKUUUpIKSsqJVQoI4qs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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-0.8, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8795958058422747`*^9, 3.87959582823241*^9}, {
   3.8795964363296633`*^9, 3.8795964500713997`*^9}, 3.87959693486693*^9, 
   3.879597277348268*^9, 3.879597424238823*^9, 3.879601450415944*^9, 
   3.879604195584467*^9, 
   3.8796061751954203`*^9},ExpressionUUID->"0db6bb1f-9572-4cd8-a22c-\
9afb861d737b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "1.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "6"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595843893927*^9}, 
   3.879597261138307*^9},ExpressionUUID->"d1ac0a82-0aec-462d-b611-\
618f11fc2d72"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3dcj23Y/9u7tEtDm2whm+vUsvcWJaKQkV2ZSchoKO31/aKk214VHact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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c4Fm4XtvfrffHaeysZSYXK86AoCZHIKPVTNKisBmWvJLIqo1Cyd4jo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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVVXc01/8XtvfH52PvvSoZSYXG60pREqIho9RX0aCyGpS9ksiqjIySnRUi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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-0.8, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8795958058422747`*^9, 3.879595844657091*^9}, {
   3.879596436471487*^9, 3.879596450199666*^9}, 3.879596935001319*^9, 
   3.879597277729362*^9, 3.879597424413447*^9, 3.87960145054916*^9, 
   3.879604195717361*^9, 
   3.8796061753223658`*^9},ExpressionUUID->"d94ab2cf-e481-4f07-9b34-\
cefffe02158c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "1.85"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "6"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.8795958583743477`*^9}, 
   3.8795972611559753`*^9},ExpressionUUID->"7c807d20-3d41-4e70-8c45-\
6faa20b36a7a"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3lYjmvUt5vnmYoGjRQyx6ZwX+awowwhczKkTCWhRIQGpXlA9TxmJVEh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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c0F+4XtjefYe9NEoUSiveV0lBpGJGEVNY3ZZVdpBISIaNCyCx7lPG+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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c8198Xx+09Pp+PvTdJKpRQ3COlodIwIgmprG8qo+wilUoiZFQUMsse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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-0.8, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8795958058422747`*^9, 3.879595859428249*^9}, {
   3.879596436616487*^9, 3.879596450340157*^9}, 3.879596935135414*^9, 
   3.879597277856423*^9, 3.879597424542838*^9, 3.879601450687084*^9, 
   3.879604195886097*^9, 
   3.879606175452443*^9},ExpressionUUID->"0a157799-ceb3-4aa3-981a-\
d686e5cdf3e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "1.9"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "6"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595874174819*^9}, 
   3.8795972611733294`*^9},ExpressionUUID->"73688a31-90a4-49e5-be90-\
d04b5a987f67"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3dYz23Y/9tLpdIk7WFkZK9cFwrZO6OMSCEi0ZBol0J7a5A9uykjnFdG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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVlnc4Fu4Xxu314l323kpFSEbxPImMKKMSWlaJjKIQoi1KlKxSVmgoQhnl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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVlnc8198Xx+31MT7D3luTJJHinkRGlFEJLauUSFEUolIZJUpWywoNRSij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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-0.8, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8795958058422747`*^9, 3.879595875236508*^9}, {
   3.879596436785356*^9, 3.8795964504728107`*^9}, 3.879596935270817*^9, 
   3.879597277981476*^9, 3.879597424676051*^9, 3.87960145082902*^9, 
   3.879604196019086*^9, 
   3.879606175578416*^9},ExpressionUUID->"c9a39f16-ed3a-4fc5-bd4b-\
cb537cc1baa1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "1.95"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "6"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595893527397*^9}, 
   3.87959726119084*^9},ExpressionUUID->"9e17ab33-37b8-4c59-b4e6-\
06b0d6c7490c"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3dcz2v4/9tbOxVKOyNlr+i+dTiUkZAVyT5klaRE28po7yEaoiIUEa47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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3c0F94btvf4bHuLUPmKSMq9ipISRSiSopLZIKLMzJQVCSURkqwKKd2r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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVV3k01d8XNc/De897zzyLUPmKSKp7VEokilAkRSVjAxGVKWPKFAklEZIM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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-0.8, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8795958058422747`*^9, 3.879595894330217*^9}, {
   3.879596436934647*^9, 3.8795964506050873`*^9}, 3.879596935405862*^9, 
   3.879597278196965*^9, 3.879597424805511*^9, 3.879601450964052*^9, 
   3.8796041961561403`*^9, 
   3.879606175707164*^9},ExpressionUUID->"550b257b-0c1f-4f05-abae-\
7643a8891546"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"\[CapitalDelta]", "=", "2.5"}], 
  TraditionalForm]],ExpressionUUID->"b699bca9-e9b3-47f4-be20-282c3e9ea6e2"]], \
"Section",
 CellChangeTimes->{
  3.879596067518147*^9, {3.879596107248501*^9, 
   3.879596107479094*^9}},ExpressionUUID->"3dc83f73-db87-48eb-a1c6-\
3af69de42b82"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "2.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5"}], ",", "3.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.4"}], ",", "1.3"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595893527397*^9}, {3.879596119027556*^9, 3.879596128486479*^9}, 
   3.879597261207781*^9},ExpressionUUID->"79bba02b-1873-43d3-b59b-\
e6bf9fe10ec6"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.006944444444444445], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlu3c41/37/69NW0ObtCTt0kCdpXFVSntIQ9pKmyhpEGkoUkmU0kIkJJXc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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVVnc01/8btceHsspISGSUkmSn5y1kR6FIg1SUTWaSyO4rlAhFQtlkz9db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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVlnc4F24Xxu3xpawyEhIZpSTZ6SHJjkKRBqkom6ySRHY/oURRJJRN9jyP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       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-3.5, 3.5}, {-3.4, 1.3}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8795958058422747`*^9, 3.879595894330217*^9}, 
   3.879596129953223*^9, {3.879596437068295*^9, 3.879596450740815*^9}, 
   3.879596935536787*^9, 3.8795972784679623`*^9, 3.87959742494375*^9, 
   3.879601451107835*^9, 3.879604196293779*^9, 
   3.879606175991529*^9},ExpressionUUID->"b83ed463-a986-436e-8662-\
89933eddcd8a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", "1.7"}], ",", " ", "1.75", ",", " ", 
    "1.8", ",", " ", "1.85", ",", " ", "1.9", ",", " ", "1.95"}], 
   TraditionalForm]],ExpressionUUID->"88bbbac2-0779-4082-b310-7ef592ed8d27"],
 " (zoom)"
}], "Section",
 CellChangeTimes->{
  3.879596067518147*^9, {3.879596147075798*^9, 
   3.879596148507461*^9}},ExpressionUUID->"f78d1bfb-9abc-492d-a2c1-\
75f335ef28a6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "1.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.1"}], ",", "0.1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595807961852*^9}, 3.879596170511832*^9, 
   3.879597261225148*^9},ExpressionUUID->"72f4eecb-bb1d-4be5-9c72-\
0ccd65787c8e"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3dYz23Y/9tDSaWd9iJ7k/G5Qlkhu5KVdJOVlBGVUiIZkSjaGt9UkkKK
86IhiWySRNtMEpHq8Tt+5/n889z/3EfH4XbXt8/nus7z/X69jFy2LVovISYm
lispJvb//h34oiHTrsqCz5Bd3+I+aDu4Vcj1n5ZhwdVCxB2OeGwHG78lqen+
FlzJ1eaM+43t8GHyxp6gxRb8S1zN1Y+ynuCerXy50sKCR+5/vC12iSe8kzdd
efivOV9e1v3XNckT7P7uTc5+bM43TVibWffNE5T6VY2ckWrOfwSYT2i13gGV
m55lTfM15zPq9/09d2oHPFa7/yB9sTkX3zm93bZxB4zfdXfGXktzXuzcdvPx
BC9wO7DjYY64OTcIKioSO+YFil2SlvZVZjxRqWP0wUYvmCU/SHfRZTMeN/VR
jPIUb1iyp3PjtcNmfO9Q/a9Fp72heURtnZ+LGdd6rbU4q9UbFo4+vix1khnf
adG+YMLcnaBi8y1quLoZL7K6E3w1dSeYRike1Gg15Ql3bvQLk94Fq8ZIdTrd
M+WdqnVuza67YPDp34+6kkx53OrRRxNLdoH/O8mfv/xMuc30P3kJFruhd5SB
/XwnUz5/5IOOZ6G7IXyKXkX3WFP+bVm3zcrW3aByINJJWtWUzztmtMNt6R6w
86puXffVhPeqWa7oKdwDV8Y2HdC6b8Ldqw10NM194MwdO1XjNBNe6KyxwuWE
D1xjo6L9g014982jr392+YC+zUT9EetM+IH4mFmGG/dCj9muC6OsTfgMK2fl
9pd7YYuz27iDBib8o3+04fBZ++DS5qp3g3qM+Ur21+5u/j7Ic/1yZUCNMT/9
bqSt9FBfCA3qubOy0JhHRi24fyLBF1SLok0/nzPm22bm8yxNP7hvv/N76V5j
7rmtd1PAcT84K7969pcVxvzIG/tDf+X8oejwiNmrJhvzp9dchtw+4A/FWuVq
2nr//nyehp6q2H5oNRF7MqDHiD+/dueajLAfjL0jRBtqjfgi5aafNX774Z7u
oLtd3IgXpJ5R2wv7Ycn4sY7PE434u01jmn6IBcCorq4TP4KMuN7UUCnj6QEw
5en+RIf/jLjhbPlo4WAA2Dn7FovNMeJuSwePGVkeAHqmy0d8HmLEXZY7zGhR
CoSvQzWMdZSNeMXHYNftSwLB2tjp1eF2Qy72w39qaXQgiLLtI6xeGvJLqqaJ
ynWBoBuYGTW4wJC7xPH88ZYHwHxg3DDnOEPeX1q5fMCOA1AypvTc/QOG/LKr
Gv9Y+O/roCFD9mww5DVWv6emyAbBsrGTh7rOM+RepU/WjlscBG4BV78eGWXI
pxt2aGfHBYHu14t3WjUNedMi9fXtn4Pg2oGGP3pdBtzorf8S/UnBMPG/SZ8e
lxrwtJpRt6aEBoPGk1bZPycNuHS8z9GBr4Phvk2rzOnVBvzno6Xa/QYfBM9h
nokJQwz4sPr6+PJ9B8Hkz6ez+n/0uZbC9O07Kg9CUFRXRp8yfR56pXKckkkI
OK9xTnaN1OcHLHd9CN8VAukPXtgNXq/P3dTcqhorQkD/+kjPlWP0uUPSjN8j
TQ5BxniTlt+S+jzKr9jTzecQzHWeEdz7VI83XlLTCHtyCF55iZluuaDH0+sd
doQOPgymwuFEa2893rHRJe9g8GEIfXq3bq+tHn/1bKVo7bvDcGy5fbmOlh5f
+6BWc/TkUIgYsXia3scBXOhzcsGPs6HQUXJyfGDhAP4r7Orqoz9DoWTV4uhZ
xwfwt5e+LjVbegR8fexXbXMZwIe8WrfmQu4ROJWS7dMxdgC/cPCJnYJ6GKQ6
/fpQJT+Az8rto7x5ZxhYO3aJdN/q8pUxodq5r8IgWb+qID9Hlx9LPn+vadJR
OH2g2eRKiC7vGHdT/XfcUXD8nvFBZqUuf/DfQ3cx6WNQ++uJZu4oXZ4z/uu2
n+7HoKdctzBfTperqJadffH4GOS8X96sUavDX1nl+sdPPA79qxwzy/N0uMuH
PWuWJR6HJNfPps/CdHjD0H4mvdIn4PGpsv9GuerwiflObZMnnQB1sdCTDZN0
uOvpGyntHidgd2Jy8Yf+Onzc74wyg9QToNy22tD6szZXK/avya85AR//3i7/
UKzNLcNPbatQC4cvUuGf6mK0eb/v7S/t7cIhdfOMzMG7tLn6fS0LFhQOI1/9
mVxkr83XO+0wiS8MhzanHeVpltq8b82rNO+OcHhhJHmoWkqbu3gPtrox7CQc
kwhLd6rV4poPFqi7bTgJqrk7Nprd0OIDZYZ8CUg8CSr9z/dYndbi4olDryrV
nITAKMeUaA8tflBn9VtprVMQILspbrqdFl/tPb3TZfEpqKn/Zjl2oBZX0Xxn
Ovz4KShRcwvbKqXFdd2bxq66fwoq00/Lt77T5GG2kfadshFwMub0x7ybmryu
2ya8c0YEPHp/c8+daE3O2pIurQiMgJKEKEm13Zp855siaUMeAQ0tHS9ESzV5
UNXf6/N6IkDuTeGMA6M1+TXoMHw++TSU1PTExalocr9XKpNu7z0Napc+TOlp
1eDb3T2uKhScBnUN8I59qMHbFU3MM/+chs9THsb7Z2pw82bTzjirSHg/YLNO
QpgGP2NXrdflEwmqfl8Eic0avKB68JSigkh4bpfokThXg09fNM/7zt9IeKhw
r2/AYA0+9KeypebUMzB1SZhPjIIGlx2YPKTC/wz4dv/V/fVJnRe8PzWb3z4D
1u7Kjkcr1Pm7ldN2ykqdhRN990WvzlTnlhkmPM72LGzyr52z5Zg67xx0uTfg
8Fmoro95kbdNnYtvCI9IrTgLitVvL05YqM6dV9jrqilHwc1+h606RqnzSI8L
D8oWR8GfQ1N+fFRT59GhrCH/TBRkFyyw0/6lxs03en9qro6CSDN+zb9KjWd7
7GPLDaPh0KgJmXqFavze/r4Zva7REPlIIvl7rBpf5bgmqFoUDU2bZLV7AtT4
4JgtKl++RoPcyuIgYb0av6T2OnT0mHMwX3LO+quz1HioxeUHyXvOwVCvMRNd
hqhxT8US35lwDha2pOyfpqzGHeQGditLn4db5TY3l/3ozzOyyssk556HFbWj
PGNf9edHQoy7tcPPwxZZWVPtm/354Hc/Vs97eR4yh1c4lCb058GXircl6cWA
84GuM8kH+/OfN20TlF1jQN/S2/3qpv5cZs2aBafTY8Bpoa9Tp31/XjPlvyMj
22Lg15er7e7j+nPVzV0NNeNjwa1Uv6jvgP68el32grN+sRBqK7v8nXh/vjuv
w9KpJBb2uKsKdc2qXDbBX9tCMQ4aRg9X7P9QlRs9LdD/tSgOxFJP2XvmqvJB
9Xu07kbFgTLLj+uNVuWt1z08T72LgwH7lh+7EaDKN4+ft+pi/3jobFudk7hB
la+aU2cuPz4e7B3/JF5boMoXT5wpt8YpHvYX+Xd2jlPltg/cj2b6xsPgPTvt
3PRVeZfccYvW+Hgwyj86sVdalR9/fHy9WXE8rLoXtaLoiwrvV7bg6rzmePB7
cXxBznMVbsH+7l3XJwFWmAdcuX9Thb/Zk/79v6EJsEfsrHm/FBW+NX/+GQf7
BLhk2X/2vmMqfKDrsqKRO/79+W/Whaq7VPgkJtbedjoBTLfvN36yWoXb5k0/
HnU9Acb3jDa4MUuFz3HZGGpSnQDvJUuXlY9U4VmJvi7HuxNgd3fCVgldFb7+
Z9nhKoNE2Hl1eF8XKRXeni9/VGJaIoyd8biq5Ysyt41V75VxTQTtK2/3Rb5U
5kEOqXfrgxNh3Y+EOPfbyry0kPufSU0E84WLP7teVOZDdiulGd1LBAtHDaXg
08o8c2zEKL+PiZAd0ZFd7v/vv59tsvaiQtK/+aE2YKy7Mnc+bTchbUgSpKsm
DitZosw/K5oUecxLAuUXLev3CMp8+LlACemtSTDEfMLLhZbKXKbt14U1x5Ig
9caHUfPVlXnqvVfKB7KSoDBskOVWMWU+qXHKMveHSVCg2ljj8rIfj1v6eqPa
1yTYY6axYXhWP35j/daVfn0vwFotSSfr4H583XWNk8lDLsBZw4UDzjr34yum
j9IKnXsBGpsHao8e8+9rpUHfB7pfgJKpwwtVFPvxIVbvJf0PXYC3L309Rzco
8RcGDycfSbkAX8xj0s8UKvFrkV+32xVfgMgFfs+mnFbiCtMmvof3F+A/Ha+1
ZluV+CHDJZl1PRcg/cqQ4nkzlXjlR6fSXN1k0HS66HHVUIknOgxSHj0hGQpu
Wb9Z9acvf3xok+OKJclgseWwr+2zvvxELVca6pEMSrNXVWzO6st7yu5MSDmS
DPpPXlo/PtSX61esySxOSYY/T6c57FjXl38L2N8WfDsZ9iToHFk0tS9/et9/
6YfqZIjxlVy+Vbsvz1vz8eqXjmQY9qN4YukPRf7szgzNE/1S4Ib1tBzHR4r8
8koZj0cDU8Dc35sNzFDkqpvSQjKsU2BV5Yb1Iw8pcp/sfAdjpxT4/n54kper
Iu8vL9d3pGcKHPKt29fGFHlU3BXlV4dTYJntmZ2peop8R4zxJPWEFNj5zkk9
8o8Cf7BpfUfTtRR4qzG0tvClAr+tWOk+72EKlPv+dtLNU+BVgaf7zmxIgZB9
J5Qvn1TgF/8W1z/5nQJp+kmHfD0UuNeDkpOtSqnw4GWB3f75CtzO0Xz+eZNU
UMuZ0Hx9iAI/J9cqUzU+FQbftak3V1Dg5V8MBiXPTYUs65cV9z704d+LXW/1
rkoF21FJIxLK+vD4GdqKLdtTITBW93xGah9uJOFwYWVQKsh4boj5dLAP3yca
2LkmMhVearoUrXTrw48MVn7flpoKFsePxEjY9uEHh9r29MtPhY4gxcIqsz68
XuzxsRv3/n39X/qlOuk+vClYONBelQrr1xbL6zXJ82fp8q35H1JhjqKd86FS
ea5+erOt0u9UsPoDE01T5bl7a9X2Ntk0GKthPvZbiDwfpS1qX6eRBskDZeo+
bZDnmfuO2biZpkHKY5dnGnPk+aDM3aZ/RqZB8YfceI/B8nzjgdgthsK/r40b
qzsV5Xl2rsjr9dw00PSx1b30VY7HF7auGeSQBmsen/hx8pEcf26/J6uvaxp0
LKnqTsqR4zYBQU2h29LguPHxB+8j5HhurLdFok8azOnn9WfuLjke0BV9bGlw
GrRGnNGtc5TjE1afk0s9nganRtmXJU2W49GLPTdGRaVB09xxZ08YyPGqJYfC
hielwb1n+iZpEnI80+PG2k0ZaTA9S038Y6Msbx0do2OflwbnpywuX3pPln9t
HrH5/c00eGBkrfkpQ5bfsyrYaVyaBus03feLTsjy8WqWlRoP0+Dglj2xJ7xk
eULTKe07z9Pgi+mYPvEOsrytKC14YE0aKHrscH45WZa7DY5eMb8hDfZKGQwb
ZyTLjV8P1J3wKQ1WeFpoFUrL8jD7sFMf29Jg2uX9VzZ8lOHtEp0b3TvToOWn
btSkShnu9Cne62ZPGmg9qVs7JleG75f1WdciJYLzTdkpi6JkeEn80MVtfUSQ
oTVfLNJPhptd8q6rVRaBXPAm2Z51Mjyq5daMaxoiOPA1eknobBk+Qb5fmO8A
Eeg4z9pvNVyGW04KjZpiLIIrcvnGSuoyvFZ57+i/FiIod5J4JtUlzR2lS+fe
HiqCNZVSQ/TfS/O1MeOlI0eLYNbUTXcc70rzMf3Vh+2dKIKBxlHDrmVKcy9J
V6MgQQR3t+TJjouQ5jmvlmzIsRGBxMyohuc+0nzLlYP5ynYi8FxSuSJyrTQ3
81PYnLZIBAVZRyV3zZLmvfHXhx5wFEFXbPb2XcOleUrEbamLa0SQ4pE36YyG
NO/yeWNluUEEEa25P593S/G8hIZ6BQ8RtMetGj+6UYo/0RqT47RbBM3r2sOz
KqR48rDvc4wDRNC5h0XPzJXimR0ee7eGiiDdMbq++5wUn1pYEjg3QgRS116K
PT4gxdO33pUqjRWBtLddEN8kxces+zL8k0gECe3FvfcXS/E1IUd2lOWJ4M/E
AKn2SVJcz8f6xKY7IngmOcJkrKkUnz3p5KW6ShFIdn34FK4oxTVeBwZOfiuC
+4ZDvsp1SPLpXgq3Dn8RgWjxi+tRNZL8Bq+c+7JbBLv3mLyeXirJVaqWJo3p
lw6C+YVamUv/vpbZ4pZnlA5Xlk9dVndGkt/qkJHfODYdikaZlz/fL8m1i+Ve
rJmTDqk/qkrfbZTkZ5btXXppTTo4PtF/KbFYkm9PURrmtjsdzjl0BU2aLMl7
qgxVo8LT4W1anmOomSRfV9KyxDEjHaShouarkiSv/W+uXUFZOvhFdpzd0CnB
bx6TmfesKR3KwrVUf72X4Ol5GyOvy1yEixV2lVH3/329e+NM34EXocvl2VL7
PAn+1VwzfILdRdD5rm2pEyfBax3vf+zdfhHg08XKn4ck+BvnUcc+Rl2EGg2r
e42eEvzX0vE6ysUXoeT3ybNNzhLcZZnX3pBvF+GUWdytTlsJbvBWI9vdIANW
Ra8p0B0pwXdeUH3+2D4DQhy/9l2gK8E/HRjNXwRlgL3tjjEnpSV42oRom5MF
GTDm2aCMhlZxPmtC1QmDjgxwGOXUZvNanPcLNpp/bmQmTLFx8s8rFuf7F9mK
G27PhPUuRx6NuiTOqye88Sm9kgmd9xavuhklzu/L7OnM/J0JWjcME5YEiXOt
pMNpHdOyYOoNN+XOreJ85a1P1/OPZ0Htm1jjVEdxfj6n4YH6uywoqLGet3aG
OB+itXj14DGX4IHufSnz4eJ8dsgPPd2wSzBCI7/wh7Y4H/Xqc7tEyyWIu3i4
uUJKnCsNb7kubpoN+WsKf2a2ivGE1GclesuyoSbjgdOZ12K8j4WN+IbQbLDb
OfnAoRIxHsxeObTxbPBYdfjt/mwxrtCWOLj8dzZ4bhvz2v+cGM9ruZghNfYy
TM0oqgs6KMZnlCbNy/a8DGuDFxUe2S7Gz6023/wi5zI0v026G+ssxptm1zaK
Oi5D7RzV3TkzxfjvzFAv3Uk5sEsptubeKDG+KEXGY/aBHHgmfF7doCfGfd8U
Rts8zIGAkIz14vJivFM9ItJkwBVQNZ4qYi294PRbw+Pn5iuw9eoQk4BbvRCq
F3D2Mb8CDsUdYkURvRD5JSGpTDMXgnxj5aQ39cKKgA2dX7fnwoYQ1x4b614Y
GmM8yrEyF7x1H1wI0uyFnHYfrjMiD+qbUwvhSw/o6shPnxWRB3NL9KR/FvVA
6Mai6o6uPPhx+fok8+geWJ4nMXzCf1dB8PYcsMCjBzafTZhp8uIqnGoqXLvN
tgfMDQZ03Z91DTY/Ci8OHtADO6+M/2AL1+Bgj//fE9+7Qev7ekibeB103ubD
8bJu8HCuHi5z/TrYXjMt2h/bDYG53kpeVvlgHLXxhotXN0R+SJaXvZ0Pr79I
O4yZ0w0TKk5WPZ17A8RSVs77YdANrvd+Dm59fQO+6T6ck9DxFyrlG2K2bC2A
fnW3eyfe/wsXXEsK1skUgkp6ic7N+L8gP16yrjGxEMwWx8wetPMvLAn5s1Fu
xk3IObtiou/cv9AgPmRG7YebMKlmV+Q1w78wrLY+1C/iFpy3a1F82dEF5lqb
G35PB+i/32rW6/IuOBk7tdy1E8BKPKsd4rpAsUR36gcHDo6r7G8c9OqC8HM7
GiyvczDI0po5dHYXZOpWiMR0bkNSubRNjl4XjKh3T9/hdxus8yavVvv+B1YN
dn0U1ngb+PiB1otK/4CT6rTKJQvuQHh4VKR79B/YuCbC4FnBHdCY8FHBeesf
CHs964/q4CKQ9NSfbzbtDwS6jXXWjimC19P6KJSo/4GKdQbVX1WKQTvTq23i
h99QqTi+LvpwMdyWEy4HFv6GlU2+e02lSiDR6UhXzPHfcKQya9PJgBKIcmkM
DHX5DVKXWhU/iZfCGv/NXbZjf8M3m8RJY4JLYbDiX50nsr9huWJpxA6Fu7B7
r0OU5etOSJ4Ya5UVcRcOH18xYkFGJ2RsUnvTYlgGirOMz0/16wSxwhEpFtll
8GCs1blfCzqhVzt169Zp92CY+tOvu406Yeadcdv4y3uwtanV6fb3X9DAjcYb
epTDPHOdlMqiX5Dx6k/DcYX7kNMTei4x4hd4Ca0DVdLvw8Bz7nIT1/+C52Zv
mi7MrYD0O2K3wsf+grVbh2ya+60CwlQ2hV+U/gV6d7LmSZ19AGVhj1cEP/8J
tVf9sh9Oewh2x+W69JJ/wuFwm6dp3x7CggXm9l5eP0FxnfaaEwmVYBQydlrI
9J/gYj21m1s+ghmGRYVLVX+C5M6ipskHH8GT1Qez377rgFTQPzex/hFMfnS+
v9GlDnhqreOYa/0YiqXuvtf17YDVy+80iBIew5ctiQMezumAURMsLmtIPgGf
0A/3x2l1QLz7/is/1z8B67bs7iWNP6BPq9cWm/InABbJpRY5P6CzvaOte/hT
qHk7e1qW3w9wqw2v1jnzFHwNJ55qnvMDXlyrnBXZ+xSuBrrUP9H4AVV+cjUb
Nz4Db7c5rtvq2uHIgWu3jz17Bj8GzFlQmNkOm0fmx3Sz5yAeW9l4fXc76L6P
OJ2V9RzO9pzf7jq9HV7/N90uSu8FmF2Qs7nVtx0mKi96nXv0BcRWWxWUvPwO
2oecG371vIBJXh4TfBK+w/RPPlsctr8Eb/NxltXu38HHsle8ouElvPJNk20Z
/R3sZixNnOn4CqLeX14Y/7cNfJeeBHj4CnbU2J6SLGmDCxtzbQbaVIHIJGmt
ytE2iOn38pRXYRW4lgY531vSBvdu9t1/ZsxruPTIbdjgAW3/no/Nyw9kvgar
/IKwcfXfIPnak6eDLKpBy89kwifRN1C08Ru3L6EaYGby31ke32DvmZWDNw14
AwZN9ZcXjPsGYZOlXzWdeQMtdQk7e361glW/RS1v+9f8m6+KlC8FtsLC1Nid
007UQHaBz6DLiq3QlnbaXKzvW/h1p/qRVORXUG5fqy0T+hYeTdMaka7/FWIe
vGuzlq2F2J3PDyekfIFLaiHV8UG1UJe8z+rT0C/gf8G8TFb8HVzMO3w9JPcz
lJWbDropvIMzdx5H7LL6DOPu3/dx83sHv+cU+RTAJ/AILtv1u/Ad2GSKRiyZ
8Qnim9pjN3W9g1yVt2emlX2EdQ8jbXL+rahxx/9mhMz9CFUaA0/e2fUeLG/0
O2T68AMoigr8w/Pew5HaPGcd+w9w+WbS+/7t70HNkPm4P26BrPVn3KaOqIMs
w/tzNRa1wOfdu85Jb6mDfb8WOBg8aYbCLLNvK0V1cHVg9rSQhc2wb+mM65Ma
62CZxvV7Cx41gZPG1xGnDOvBz0u3zGd+E8wpyz/gsKIeVtVsHNOnohF+K+eU
+5+uBzPxLkOx2Y2Q6Oyv3v2wHhY7Py9YVdIAgRLv3ItlG8By3+H5A60bYIH3
uEf3hAbY8l1u6urCetB9UDlHfFcDuOz07CMzvv7fPd7ZuCqzAeLqX8w3uFz3
b2+Zfu1FXQPMn/yTZ1rWgdyWwDpnzUZodW8fkZv0HmxnTY9rnNMINy6JHR47
4D2YxpdNXu/bCLVFEg/GRPz73FO3WjzKagSr6iE6eQrvwDZ88Wed2kY4qW42
b4d0LVQY7xGslJrg1Wi3gCPfa8Bg3/5e48lNcNyxMyb/7Ru4s0jBqnxDEyzt
ExwrVV4NXjHmo8wimmDxDPeMHbmvYXNw5LpBt5pAyD2qpxRbBbMlu0MqmppA
84HhjuqDryBQN/CclFIzZJktc6jf+hKeTpV/f3d0MyQ+lk4YuuwFLPjCmhUd
msGs02bWncnPQV1tQFi5TzOMX9+2VWT8DMwGfRXvPNcMHTeNnD7JPoUbe0Oe
hhU0Q8H2mO0nPj+Gk4uvNu+vaob/fo+bmvDoEdTWrgyu6GgG+09THtltqITX
zaHLNyi3QMjfFe4Lhz2APscNPOYNaoFlsROUXNrLQTnzqJ03a4GDC7ZcOXGt
DBQuPnhZtbQFPljJBLb6lIK3kfxW740t//bFmw9PTCkGb8kltdP2tkC3sZlm
SO9tWKzV13PKkRaoDAzouhcAcPBaQOOaqBYIl9YP85EsgPMX3u8QJbfAzbx+
CTZBV6FFccqz/tktMCliwNCFUjnww2HI5JjrLVB00yXqoOxFqJg9fu10aIHY
89P2BkknwtuZYj5SxS1QqLlqxWPpk3Bx6EihtrQFxPAfk3EGn5/c/b9f458X
6M/j3yfQ34f/P4H+f/j9CPT94Pcr0PeLP49APw/+vAL9vPh5CPR54Ocl0OeF
n6dAnyd+3gJ93vj7EOj3gb8vgX5f+PsU6PeJv2+Bft/4PAj0PODzItDzgs+T
QM8TPm8CPW/4PAr0POLzKtDzis+zQM8zPu8CPe/4Pgj0PuD7ItD7gu+TQO8T
vm8CvW/4Pgr0PuL7KtD7iu+zQO8zvu8Cve94Hgh0HuB5IdB5geeJQOcJnjcC
nTd4Hgl0HuF5JdB5heeZQOcZnncCnXd4Hgp0HuJ5KdB5ieepQOcpnrcCnbd4
Hgt0HuN5LdB5jee5QOc5nvcCnfd4Hwh0H+B9IdB9gfeJQPcJ3jcC3Td4Hwl0
H+F9JdB9hfeZQPcZ3ncC3Xd4Hwp0H+J9KdB9ifepQPcp3rcC3bd4Hwt0H+N9
LdB9jfe5QPc53vcC3fc4Dwg0D+C8INC8gPOEQPMEzhsCzRs4jwg0j+C8ItC8
gvOMQPMMzjsCzTs4Dwk0D+G8JNC8hPOUQPMUzlsCzVs4jwk0j+G8JtC8hvOc
QPMcznsCzXs4Dwo0D+K8KNC8iPOkQPMkzpsCzZs4jwo0j+K8KtC8ivOsQPMs
zrsCzbs4Dws0D+O8LNC8jPO0QPM0ztsCzds4jws0j+O8LtC8jvO8QPM8zvsC
zfu4Dwi0D+C+INC+gPuEQPsE7hsC7Ru4jwi0j+C+ItC+gvuMQPsM7jsC7Tu4
Dwm0D+G+JNC+hPuUQPsU7lsC7Vu4jwm0j+G+JtC+hvucQPsc7nsC7Xu4Dwq0
D+K+KNC+iPukQPsk7psC7Zu4jwq0j+K+KtC+ivusQPss7rsC7bu4Dwu0D+O+
LNC+jPu0QPs07tsC7du4jwu0j+O+LtC+jvu8QPs87vsC7fuYBwiUB2BeIFBe
gHmCQHkC5g0C5Q2YRwiUR2BeIVBegXmGQHkG5h0C5R2YhwiUh2BeIlBegnmK
QHkK5i0C5S2YxwiUx2BeI1Beg3mOQHkO5j0C5T2YBwmUB2FeJFBehHmSQHkS
5k0C5U2YRzHKozCvYpRXYZ7FKM/CvItR3oV5GKM8DPMyRnkZ5mmM8jTM2xjl
bZjHMcrjMK9jlNdhnscoz8O8j1Heh3kgozwQ80JGeSHmiYzyRMwbGeWNmEcy
yiMxr2SUV2KeySjPxLyTUd6JeSijPBTzUkZ5KeapjPJUzFsZ5a2YxzLKYzGv
ZZTXYp7LKM/FvJdR3ot5MKM8GPNiRnkx5smM8mTMmxnlzZhHM8qjMa9mlFdj
ns0oz8a8m1HejXk4ozwc83JGeTnm6YzydMzbGeXtmMczyuMxr2eU12OezyjP
x7yfUd6PfQCjPgD7AkZ9AfYJjPoE7BsY9Q3YRzDqI7CvYNRXYJ/BqM/AvoNR
34F9CKM+BPsSRn0J9imM+hTsWxj1LdjHMOpjsK9h1Ndgn8Ooz8G+h1Hfg30Q
oz4I+yJGfRH2SYz6JOybGPVN2Ecx6qOwr2LUV2GfxajPwr6LUd+FfRijPgz7
MkZ9GfZpjPo07NsY9W3YxzHq47CvY9TXYZ/HqM/Dvo9R34d9IKM+EPtCRn0h
9omM+kTsGxn1jdhHMuojsa9k1Fdin8moz8S+k1HfiX0ooz4U+1JGfSn2qYz6
VOxbGfWt2Mcy6mOxr2XU12Kfy6jPxb6XUd+LfTCjPhj7YkZ9MfbJjPpk7JsZ
9c3YRzPqo7GvZtRXY5/NqM/GvptR3419OKM+HPtyRn059umM+nTs2xn17djH
M+rjsa9n1Ndjn8+oz8e+n1HfjzwAIx4AeQFGvADyBIx4AuQNGPEGyCMw4hGQ
V2DEKyDPwIhnQN6BEe+APAQjHgJ5CUa8BPIUjHgK5C0Y8RbIYzDiMZDXYMRr
IM/BiOdA3oMR74E8CCMeBHkRRrwI8iSMeBLkTRjxJsijMOJRkFdhxKsgz8KI
Z0HehRHvgjwMIx4GeRlGvAzyNIx4GuRtGPE2yOMw4nGQ12HE6yDPw4jnQd6H
Ee+DPBAjHgh5IUa8EPJEjHgi5I0Y8UbIIzHikZBXYsQrIc/EiGdC3okR74Q8
FCMeCnkpRrwU8lSMeCrkrRjxVshjMeKxkNdixGshz8WI50LeixHvhTwYIx4M
eTFGvBjyZIx4MuTNGPFmyKMx4tGQV2PEqyHPxohnQ96NEe+GPBwjHg55OUa8
HPJ0jHg65O0Y8XbI4zHi8ZDXY8TrIc/HiOdD3o8R74c8ICMeEHlBRrwg8oSM
eELkDRnxhsgjMuIRkVdkxCsiz8iIZ0TekRHviDwkIx4SeUlGvCTylIx4SuQt
GfGWyGMy4jGR12TEayLPyYjnRN6TEe+JPCgjHhR5UUa8KPKkjHhS5E0Z8abI
ozLiUZFXZcSrIs/K/pdn/f+8KyPeFXlYRjws8rKMeFnkaRnxtMjbMuJtkcdl
xOMir8uI10WelxHPi7wvI94XeWBGPDDywox4YeSJGfHEyBsz4o2RR2bEIyOv
zIhXRp6ZEc+MvDMj3hl5aEY8NPLSjHhp5KkZ8dTIWzPirZHHZsRjI6/NiNdG
npsRz428NyPeG3lwRjw48uKMeHHkyRnx5MibM+LNkUdnxKMjr86IV0eenRHP
jrw7I94deXhGPDzy8ox4eeTpGfH0yNsz4u2Rx2fE4yOvz4jXR56fEc+PvD8j
3h99AEY+APoCjHwB9AkY+QToGzDyDdBHYOQjoK/AyFdAn4GRz4C+AyPfAX0I
Rj4E+hKMfAn0KRj5FOhbMPIt0Mdg5GOgr8HI10Cfg5HPgb4HI98DfRBGPgj6
Iox8EfRJGPkk6Jsw8k3QR2Hko6CvwshXQZ+Fkc+Cvgsj3wV9GEY+DPoyjHwZ
9GkY+TTo2zDybdDHYeTjoK/DyNdBn4eRz4O+DyPfB30gRj4Q+kKMfCH0iRj5
ROgbMfKN0Edi5COhr8TIV0KfiZHPhL4TI98JfShGPhT6Uox8KfSpGPlU6Fsx
8q3Qx2LkY6GvxcjXQp+Lkc+Fvhcj3wt9MEY+GPpijHwx9MkY+WTomzHyzdBH
Y+Sjoa/GyFdDn42Rz4a+GyPfDX04Rj4c+nKMfDn06Rj5dOjbMfLt0Mdj5OOh
r8fI10Ofj5HPh74fI98PfUBGPiD6gox8QfQJGfmE6Bsy8g3RR2TkI6KvyMhX
RJ+Rkc+IviMj3xF9SEY+JPqSjHxJ9CkZ+ZToWzLyLdHHZORjoq/JyNdEn5OR
z4m+JyPfE31QRj4o+qKMfFH0SRn5pOibMvJN0Udl5KOir8rIV0WflZHPir4r
I98VfVhGPiz6sox82f8BBwVGOQ==
       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVVXc0Fu4ftddrvPbeK1IkI0rPk2TTQkoZadikQVaSnREKGdlURlnZnkcU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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVlHc01/8Xx+31MT723itSJCpKr5tk00JKGWnYpL6R0RAZGaGQkU1llJXt
9RZFZGWPzJRIZGf++v11zz3neZ7nPO95Pq74ZdczV6koKCgKKCko/j/5Pzw9
WjAtC6jdxbmDKhGpiYnm78+XBXajXXlWQ4noaLzErwR3WTCW9vyvszIJTZIc
6yYPysLDbpMMqvQXKHngBzfLtgxk5Qe6e4YnI8U6xSGWDzIQ1nXDsB5S0Gbb
T6lvoTIw0rbZGl2TgpDGca5QUxmwLL1Hajuaim7T3ZugFJWBtC/LdEF1qWi3
rfXosZ/SEDUc5MBjkIaeM9U56RZLQxJ7EjdbbxpykmDfZr8vDe536wfcrqUj
itoBoQRDaQhachcxW09HdrQXrozyS0OP9CMO26gM9Kua1m/4hxQMFafqGe3N
RPpuu1Wj3knBLp82Tsa2TPRX4o7xWoAURN7ym9q5mYWMLV+8YTGTAiv63kcb
Qtkon3Zav01GCvSO27fqNmejbPUhCfU1SRAxvDrZ4vsSbbh06Rk0SYJmZMPB
S6qvUIl7zthOoiTcGpQ+SbvwCu1ZuSBo6iYJV+gHWhuLXqOIS5kHdLUkwedI
eFmRVw5KuVP7oIdPEvgPhdbZ6eSiTdp6s61ZCYi7t3+CkT8P8Zb4yFTUScCR
ixUXT83nIfrTAzZM8RLAen9H9EdLPtpzbShixk0CHEw56XkL3iDf/L2aFroS
IE91mE7A6C3qL+biPScmAUptzwca69+i/eli5UNr4mAmVLqeigqQosiv4Z8d
4nD4vGFwVHUBet7Tp++TIw5v53ciF44Wogzrj02RAeJwfFjmJVFXiJrvdx3c
ZS0O0v3lI/SGReiOo8RtjcPicCb7inh3bxH68/bJrTYecWh7vb545HoxUhkO
UBhaEAOYlQ1xWy9GVT/zUm3axKDEwzLCOLIElSo0jl3KFQNvm1hFXoV3yCTf
jqYtWAxCqBMfjze9Q0oX6+SLrouBkeTVoA/OpSj38b57DNpiYN+DlWK4ypD/
ZeMDLVJiQPtol/1fXIYiqaRCd6jFYMYwX+CaazlKnTkYdrhBFP5+VB6/IVmB
SuunrxsGioJu+S7TP4MV//S1pnt1RaH7t8Td9bhKdPVpCtcwoyg0eDaf6b1Q
hWrKQ93NP4vAl1YH2yDxajTxxtQoPkIEno5MH+OdrUY/O45HpZwVAY+6meXy
6hpEU1SlYccnAt/+Pg0Ij8ao5/Xchd9fhYEhXnHF8CCBSCoh1EoZwrApMOj1
IJtAnk2XreQdhWEn++iIk0At+rm2P2NAWRjYc69KHnpSi25RHuU+uiEEtuNn
zrQxvEddbWTqM/VCcM9pzydd//eIXxU1c4YLwRA/jXkbVR3yLGfou28uBJu2
cTVm/nWoqFUyJUZSCIQuDsrNMtQjs0PeWWfmBCFeJISz+kk9+mrYf6ewUhA0
w96Vlgl+QDPJ1cVFQYLwNPrgCN3rD2hjlnnrrJkgKKmGcpYc/og29PqoI6UE
Yde5ldMd7R+RIr9YgN2iADhZW2q72jcgl8dPdfreCwDBLk4VRduIip5dFRqO
EoCsJ99/WGc2otp768MetgKQ1lZRMqr7Cd12en8rXUUAtv6s1onPf0JH3+98
tqQTAMyiwHA8oQkdNX08mt3HDwpV139a6DejFeXEAp8cfghfbH/tvNWMSJBi
MHiXH9Q2d+Ljij8jrbyt97Vn+OEaKbj1l2sL6omaUNkryw/ZJ7gsPRVbUY2Q
eIPIJh88uXDO4MpiK7qwOpId2cEHPXvSU7Iq21DyySiWgGw++Jv9MldNqx21
U7w6sOrLB0m59pY/c9uRu7ab/XcTPmhS5n0zyduBNqnnFk8p8MHn3sMH9QM6
UKJE8m5VGj4oTWeS5VruQKIGFs6RQ7xQO8k+bnr9C8o/LyV8pYQX7AVb63mH
vqDNOsqsnHBeWHUMWXI824kUnjfeuWbHC0cDdA6atHQi5dt07NGavHCfGBGZ
1OtC5mP104rCvHCis8hG4lMXUh51Dz28xgOcp3w0RAy60YfLLA+KO3kglhy7
8aOtG9HRh1g8f8MDtx6cJgWe60F1WuOFU495wEEWHaUf70G3lyWlU+144NXn
hmov195/eb6frT3BA3zT9KIzO72o30BvSkeSB9j833naRfch0gLbk/2UPLDU
73d+W64fHVOS3/Yb4QblWEnu0rp+FC8ZO61Sww3Tz/qUMqwHEJvaYQ7dJG64
mn9urYtiENUnlR+o9OGG1KGXEqczBlHpkpVI2EVu2KuRckvJYAhpLf6OrjrC
Dd6+86+9loeQm7X/NV1hbkjb009/OP0rMjt3z15xmwvw1wrHEJNhJJCkd8tt
hAvSeMyl3RhHUKGzzmWmWi5Ipw8c2KwdQd39eRybaVxgMc3pK4pGUfeBq3Za
AVzAGqgaK5U8irxZRvTGr3NBkuizOxyUY8iGjiq1S58LMt+zpi5eGUM7JhsX
BPZywb6I4cjWpjHUXC1jV8jOBaWNsUa5yuOIbvdkZcIyJ0gXv5CIThxHPGJ+
ht39nFDt4TAdwjCBXvezc1rWcILq9EX+pNsTiJ7LkKSazglXm9LedXyfQCGT
9vvPB3GC3Jwyu+L5bygigzn0kzMnpL4SvodbvqEvf9j5As5yQmazBUeI1iQq
Cb0zFKLGCc8Mvr2PrZ5E+1k0RvtFOYEqoMZx7tB3JMB3SOEGHScUs64NJ7z7
jj6/X206OcsBYVzv2dMP/ECTqVmNt7o4QOzN/BZr+Q/EvGdYeaSSA+xsuZm/
a0yhpaEIvvB0DuichjjlD1PIfX9f8P3HHOCcBdGbxj+Ry4vh2JKbHDCXWR9j
MPgTrVUVmyhc5IDyq36huxym0QG/vZ0TWhxQcvn7fwkb0+iaRq3M4B4OsJTz
m86NmEHHhC7ZsvNywIH7pteuyvxCtbPaSQEUHLD55qPmZ/wLkQ+sTR2YZof4
SrHaaYtZxMj654JUFzuctDnk17A+i6qy4umNatgBbuxhdUz8jbb8hanfvmSH
4S//WQ/DHNo9rGJjGM0OF1v9/pOdmkNtqeyq4nfZQcfdLkNWbx4p+MtH7rFn
h2dKnOX5yfMoU4gj0M2EHVxYKfNzVufRETZz2Z+IHWjiVWclTv9Bt51NHsTs
Zge5z8PBvLl/UOJvmnQPXnaYljmoE8awgCJIX+MeU7MDhy6lcuC1BaSgEubc
MUeGu5oJegwfF5DZPV553SEyfDO6VMspu4iM+TS7fzeSQS/c9GBu8CLazH59
s76EDBVTrmFds4tIr+MRfWMaGXz3FwlEnF1CPJOeT9YiyFAbRrYcrlhC+345
kEx9ybDifVSxXnIZ8dyScx9yIIPQ87JEzfBlNBQdVBlmToZdGoJaFuvL6B15
beC6NhmGi82C2OxWkDCrDWGvQgZ/vS+PrXtXkLXz4rkoCTJENJ+UPKm7ijyc
F4JHyWR4kvSyerBiFakA/X9Z22xwTvrSKJ3iGkoV+BX1ZZANOI+U87VnrKGK
AEmp4+VssD5+Y/mA0F/kxFHbvRzDBt9dIVr92V/07Na8/tQtNkgc54zvZ1tH
NWNBQnxn2SCVO1ibI3Qd7WZL7vPbxwZps9Vm44wb6BgfN5UMmQ1ePmNa0A7e
QBrb+8g7v1lBfVjyvAbTJgpTFnUhtbLCjZV900ToJrLViPDSzWMF3Juc20Le
Qm7zGoFFoazwobmy1TJmC11i8u7Tc2KF3dGWci7C22jk+ccMBkNWUJk+1L2c
uY0yZU5yze5mBaPyG16/FXdQr3sQLJFYYYbTRf1U5Q6aEirfL/iLBfxMOk0Z
pSjA0NpvyvIzC+R69lLyOFJAhKKXXlUuC+gO64t/KqQAldg3SkphLCBSqLUu
tEEB+y5qXS91ZgFjnTFPkhYlUBpsZhgbs8BiXwddeBglzFZ1RCzsZQHaa2E+
Sb2UwD4cXpnM9s9/fuiosgQVOL65/OrMPDOIl5XRaTlTAfP1Bw30HczQrcpK
31RGBR06tW6VBcxgor2no4KGGgSN0C/7KGbQOdFpynyaGtxyaJ3ZbjKD/+Pf
Q0VJ1DAdWMb+8iwz7CJxbWdOU8OlEZ1viirMICp6MbnnIA28x5n9aVzM8FZp
z89DATTAuB7QsblEgiD6wyfwFxqoshKNUesmwTZ/jZmFGC34h20NmpSQYOPk
t79bzrQQfKTjmP4zEuRkicvGVtKCK9uZU9z/kWCz/SgbDyMdFNjLeBWYkKAk
gZ/D3owOKpy6BAVUSDBofzzJN50OWh1qvfU5SXBPxloZ5ukgdjdq0lhggsIv
PjcSj9BDlkaG+Fw7E0h1HRHwDaIHYuzGo/NvmEB0w3+6uZMeGKMf//AIYwI2
ueXCGyIMUBx6V+SEIxNQx27rm9kxQJngwFylLhOsPPz43LqAAZK640m90kwQ
dlLh0e2/DPCb9JolkooJvrGrMPoCI+ztcLv7bZgRGMoNhc0fMcKV5gedzRWM
wPo9uGW6iRG40867HYv5tx9UV+BlZYIoDbVsdIMRWlqOO9acZALGQu4KwoAR
jvCkNxMRTHA4NmuwRpoR5NXM3261MEG9ZZiSyg4DfHBVST/LRIJ57/h2gT4G
sAplsUnRIsHSJ8VGp7cM4NutPEH4kCDjUS2/VBAD3H5UaR9ZSAKvHA+sbsUA
DReco2cnSTDi9Dv3tSoD8AvrXn7LwwzXvPg7nEkMEN/sbVasxQwPYnX57o7S
Q61EzINOV2bAJGOX7mJ6IHc/if8RywzVip8I5393Fa5x526qYgZW2aeUxyzo
oS80RdNkmBm4u03k9PbQw8ePSo5Wm8ygZKOkfn+bDlzdkqbqeVggbyBdc7SV
DoQ8PhlZ7mGBtqG71rYv6CCkQTeEFlggu3e7jtqZDsrCrGif/ePgDGIrqlSn
A2Ueid4f5iywdiIzNICeDvSapwf7LVnA1Bh9tuikhTbOfas61ixgH+3DovaC
FpjbKhTIl1igY+oLG58dLei59/Swm7LAJnGxYlGJFlY6v/fv0WUBJqFK0YY1
GhCr8mjSPsAC67MsfmGYBixINorHRFmAe2zVTPNfz1mc7qZRU7OA8s8CgzE9
GtAOP8zhMcYMSwGSetdYaIBscXH6UQUzhBlQeLa0UYPMq04D8XBmiPKZ0OKM
pIbbLiePHrzIDCFyV6+o/OPO64v/WJUUM5hrSPbuIVNDmKNXwqsfJPh8r2x2
s4UKej6LwloGCazUXhgmh1DBDf11neyLJFjdmp3j0KaCs/ctFstYScD7YWev
GQUVnHzI67y/8l9/Ur7i6+WUwHhRZ1bsMhNsGwZUaN+ghHpvxS8R1Exg57qY
sCBLCTHvuGqjkhmh9visruNXCsgzNi+AA4wgdP8RuSCSAphr7+4UNzAAxYp5
fr0WBeDln85sJgwQG9odZzy7g17FLMvdGqQHhpDbjCXGO6iZlbaJZEkPyhxf
64m8bSTv63KQeogOio0UP9xm2kaoRjH7sSkdPA7Z9XPoyhYScCtwHWiihd9K
W4t/qzbR85mE5V1HaIGT6kxoN8cmWnr01Lv4FQ08M9RV97y2gZ7aTsxVc9JA
pn38lZnSdeS89aws2IsaipqxoRr9OpLlp3e3GqaCZl5BJmeTv+hhUkduMKKC
oRN7/KOS15CEtXOK6QtKiNLvcHw3tYoeCg/2cfz7v843/fd/V1xFv9bUJzjM
KKBIr5pO6b8V5N7y6dtpqx00fM6cSCtbRj03NzbPkLfRQqP0qNH6EjIbFW/u
xJtoRDb53jH1JTTw4BPrfZcNFNPYcSLccxH9PXm2mlp4HRU+DL1womQBMUwc
UmX6vIam5kfMPef/IGePL+4aPqso6SXFMTX5P+jTr0CtE3tX0CJlin385XmU
Gn4m6OP4EjLZFzl2cf8cYh42tbkcv4gi8krNycmzaN/bP/4lpguoLNFb5T+G
X6imIDDwHPcfdPdHWEqB6zR6LqN1pbhoDjEoSffNdE0h1xjXpkidWUQd50er
f+gHcvxty3vqxzSS1/YTX3g+iRxbVeR/Rk+hcG7nTsb1CXTErYpex/g7ypNX
OP3OfBzFSCwyHuf9hioecIDQu1F0QmNOLXNuDHkklytgqWHU4M0arPN2BIVc
F9zQHhxAYpFm/B/SBpG0Yboj15NexFF4tmWytBdBx86S/fEuZM+/2ZU134kW
7evaApfbEaNhdd+IUTt6s2QUfM6oGdkxc2k+SvmEImTcN8Tz69G23NG1yvn3
6LmYjwMWrEITbL52VwXKEYvFBfhdlIesD/nMdvW/QhrHC1K1ve+gpEdRXrLP
/0MMm5QJcSbZuGLr/CU1lI6DzjZuWcyU4ebB/P3CO0W4tPFiiRN3HaZaf+0/
8aEaF/ZZ1PIVf8IHG70XcrzqcM5SxEzprnYcq53fnt3QgOXl7vgn3O7Ei5++
rVI1N+MknxK3pLoeTHdXQJ/pURu+pxNXmc02gLvtl9gFfTuw5m8FjZcXvuJj
3OFa0Vyd+P2ReWPdM6P4ZvfHFydDuvAhoaTdOStjeLeV2d9jI91Y4uSM+Z34
Cfy9R+CgA1cvTlC/bF2gMYnzBittu+T7cICpet7Z0e/Ywq23N0ayH8c5FwRe
9pvCz2LH3Nt3+nFFiynbuOQ0vkM+M5ZFDGBTIUuVvvoZTHtZeFXr+iAO1pR7
a3h1FntftmPrXxrEDdeXN3Vp5/CYrWx6tMMQjmjwlHE6M4/zw1IHMj8N4cbL
VgS1xB9cxdckBpxf8TOn4nD3P3/wgSw78Ujdr5i+gjaVIBawzIVAp3qHrzgp
LqR1JWIRR75NeUfp/RUrFBW+FbFawgZXsxIcvb5i3ra4JM29y/jR5TxG0X96
kUX3NOetZZzbbnRF2eArnkugupvzeQWLulpUF4t8xTV/6RMYEldxzYHkZ3mT
Q3jkaCtTlOMa3nVEY7dQ6hAWvtJ+z/TwXxw+Vz26cnoIe9Df1rUhreNNsUjL
3X8HsW8ThX794Dp+T9TSvYgdxNv3MzbCcjfwgV9raXJ7B/GDmy02rb6beDxZ
2j+5egATMmmMMSe3cE8nq32D9gDuSXhPsyK+jUvf5h2zaurHr8aPT+4sbWNm
D04XQb1+TLj8Kf/QuIPfjZ3oyqrrw+QOJ9o8YwriWWBJQpp6H36xzDxzvZyC
KBm4uZ6V34vTaR5qJ0lREsq2Og80xXrx8/sfGM49oSS+Mzx124jowXOeG+eT
NymJNAeFWuPtbmwnfz/uvj0V4byUrVTg2I1XrnOZ0/ZSEeIVly9G9HVh/V/q
NodOUBPaTgYeRie68JXPpW+liqkJp/PX63QLO/FAnqZHtyQN0ZLOMdoj2onV
vlvxmz2lIXarzNaeCP+CPRwsFQtpaYnj5Mn4r1sdeDEhKGDZg5aYXHGpHnHp
wKfbfYUUZmgJNzzn9misHf/1eCV32YqOKIlJ5WMwa8f2F9Z4M7roiJhAmpJd
z9vwqaGcoG19esJCM8bxVUgrTos0Mrn7np6ILchBo/db8Ks3k4+VDjMQUs5V
HMw+nzFPoZqXRAkD8fUM+Yi9TzNOdzLJtFFiJNTztetl/JqwuKFw+0YuI9E8
LxboHPYJS9CKb27LMxGa3JEaNi8asXF1kOOd10zEdlmjgVBJA25RUkq/s5tE
BL2y2Sro+Ij5NIedWPNJxKc70V6qSx+wzZOyfm1lZiJpemK2QOgDVjfr01Iu
YyYyZ92TpA3qseLIjOkoYiESHpvGxtyrw4YFcjQ2n1gI/S83L1BVvMd3L5g8
rzdhJRZcdC7YrNfiap3ZYsFxVoLHes4+E2qx3sz9kx432AjNaX7jj6EEdioV
tbpFSSY4Wh56n6vGWIXhxCAYkIlR+xfxcU412L5/YZd8DJkIeTpnKC5bjRO5
/gapjZOJ2L6TrKW/KvHvSk13T0V24iP4jqlXV2AHEvnpvC87kZgt0+sQV47b
s/f25bSwEy9S1wdZ75bhjLWzV4tFOIiV38F+q86leEolJpXrBgfhSTuvPnj9
HS6S+6HSW89BPHVfvxbrWIIjHZpI9AKchN35xf1dnsWY8cj2+TdunIS8mdor
y4gi/PO5ZdJgIyexbxOr/MwvxKbhTSmxElxE0HkJFd3eAizKe+TenC8XsVr/
g1+doQCHyS5kzQ1wEZvybw7YHnuLt1NfDmWocRP371ZEXaB9g43deJFQPDch
6qlabB+bh+P5bPVtN7mJwvms4cxDudi7qGcw0JqHGPO+wXxu6jVGzxJU4z7y
EA+WxFXOZr3Cl6gwVfpeXqKGO26u/sZLfHBTwaI0jpfwD77n/1A/G3eL7DR8
o+Ejgqu4JWYVs3BmQ7vO4Zt8xP5F78kq8UwseMP8bPMEH5E/NGB7XDQD+/dz
jGea8RMdUSOvZXel46vayq5DzfzE39deE2OH03COXvb2/eMCBNsdI0WzC6k4
dfqORFa1AMF8VsW/wy8Fv/lvL4WVuiAxwu9T7eiQjN/gR2a4XJC4XkzH6TOW
hD+6mz0cPCxEmP8qcxh1SMTvVUuDGwkhop71ibwcbQKeZDrHl6grTBS+41cl
v32OXb8JP3HqFCauCa1xcTrG4YRTbKTTNiKEC91YCa1qLGaruWprsyBCOPaJ
6ZBZY7BSMPvhd49ECV19iiW09BTXLr5+oMImRpzyPPTr9VQ0NiHuUDVdFCPU
OWNsW6ai8MafPSpyuWLEM80vB2VXIrFq4nFR6y0xImGGMsyTNRJrjv7W8j0l
TtCUuYaaKj/BR/b2pUdkihPq5C+XKt+HYwY66uqsTXHilraE5zWVMBylNRz3
xVSCqN16e7Kp7DFGE08/SxZIEDk/ovrMT4Vgidqn93JYJQm7aUrKnPUgbKd4
+oa3iyTR8M1HYV9xIK4VP7iT2S5JnCnTeSh59xFus12QP6oqRZyyKamvOheA
abynU84lShF7lq8NG4A/tqJixHR00kTVvofK+QceYuJxY4K1uzSRIZekr6Lu
h3snwlm8x6SJH+FvrlToP8CGbecLnc7KEDpXoxrU7e5j4QO1q4aNMoTYeqML
v/A93NGrJakCsoTtuJW19wNffH4vvcXhSllC4XTkutGmN97cGcz3UdtFHD+h
9cIt3Av/D52E3QI=
       "]]}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Latin Modern Roman", Bold},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->Directive[Automatic, 15],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-11, 11}, {-0.1, 0.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8795958058422747`*^9, 3.87959580835611*^9}, 
   3.879596172503376*^9, {3.8795964372504797`*^9, 3.8795964508848763`*^9}, 
   3.87959693566995*^9, 3.879597278620668*^9, 3.879597425076406*^9, 
   3.8796014512433147`*^9, 3.879604196429844*^9, 
   3.879606176261035*^9},ExpressionUUID->"880e592a-89eb-4361-9ac5-\
904ecf2cf0f0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "1.75"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotrange", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.1"}], ",", "0.1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"CreatePlots", "[", 
    RowBox[{"\[CapitalDelta]sol\[Phi]I\[Phi]JF", ",", "\[CapitalDelta]"}], 
    "]"}], ",", "PlotOptions"}], "]"}]}], "Input",
 CellChangeTimes->{{3.879594659288062*^9, 3.879594698427745*^9}, {
   3.879594753937948*^9, 3.87959484484193*^9}, {3.879594878365704*^9, 
   3.879594885794763*^9}, 3.879595120171735*^9, {3.8795952971606483`*^9, 
   3.8795952988470917`*^9}, 3.8795953875093822`*^9, {3.879595509727212*^9, 
   3.879595827405424*^9}, 3.879596186584292*^9, 
   3.87959726124263*^9},ExpressionUUID->"03217645-61af-4ea4-9fbe-\
01436f2d100b"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxlm3c4lv37x+1N9iarpa2Nuj4NaWnvFA3tQWTkSZR2IlGU7b4pIy0V0fmh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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c0Fu4bh+3tfV+vPbLJJqK+iefRspKVQkVWlKKMUkJKWVEpIaHssmWT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       "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.011111111111111112`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJwVl3c41u8Xx+3teR6PPbIJWRH1TdxHC0lGqajIilKUUUpIKSsqJVQoI4qs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