def _intensity_grids_for_frame(frame_and_events, delta=4):
    frame = frame_and_events[0]
    puff_events = frame_and_events[1]
    puff_intensities = []
    side = 2*delta + 1
    for f_num, xloc, yloc, idx in tqdm(np.array(puff_events)):
        if (f_num < 0) | (f_num >= np.shape(f)[0]):
            block = np.zeros((9,9))
        else:
            y_len, x_len = np.shape(frame)
            xloc = int(xloc)
            yloc = int(yloc)

            # literal edge case detection
            y_start = (yloc - delta) if (yloc - delta) >= 0 else 0
            y_end = (yloc + delta + 1) if (yloc + delta) <= y_len else (y_len + 1)
            x_start = (xloc - delta) if (xloc - delta) >= 0 else 0
            x_end = (xloc + delta + 1) if (xloc + delta) <= x_len else (x_len + 1)
            block = frame[y_start:y_end, x_start:x_end]

            if x_start == 0:
                block = np.pad(block, ((0,0), ((delta-xloc)+1,0)), mode="reflect")
            elif x_end == (x_len + 1):
                block = np.pad(block, ((0,0), (0,delta-(x_len-xloc)+1)), mode="reflect")

            if y_start == 0:
                block = np.pad(block, (((delta-yloc)+1,0), (0,0)), mode="reflect")
            elif y_end == (y_len + 1):
                block = np.pad(block, ((0,delta-(y_len-yloc)+1), (0,0)), mode="reflect")

        for r,c in product(range(side), repeat=2):
            puff_intensities.append([f_num, c - delta, r - delta, idx, block[r,c]])

    puff_intensities = pd.DataFrame(puff_intensities, columns=['frame', 'x', 'y', 'particle', 'intensity'])
    return puff_intensities

def intensity_grid(f, puff_events, delta=4):
    frames = np.unique(puff_events['frame'])
    frame_generator = (n for n in frames)
    frame_events_generator = (puff_events[puff_events['frame'] == n]
                              for n in frames)
    n_cores = multiprocessing.cpu_count()
    f_with_options = partial(_intensity_grids_for_frame,
                             delta=delta)
    with multiprocessing.Pool(3) as pool:
        grids_out = pool.map(f_with_options,
                             zip(frame_generator, frame_events_generator),
                             chunksize=100)

    puff_intensities = pd.concat(grids_out, ignore_index=True)
    return puff_intensities
