import numpy as np
import pandas as pd

def report_performance(events, puff_ids, markers):
    num_puffs = np.shape(np.array(markers))[0]
    detected_puffs = np.sum(puff_ids>0)
    unique_puffs = len(np.unique(puff_ids[puff_ids>0]))
    num_events = len(np.unique(events['particle']))
    puff_freq = unique_puffs/num_events
    print('%d/%d puffs (%d unique) in %d events (%.5f freq)' % 
          (detected_puffs, num_puffs, unique_puffs, num_events, puff_freq))