# Puffapy

## Python tools for analyzing exocytosis in microscopy movies

The tools here are meant to be used with total internal reflection microscopy movies of receptor exocytosis. These scripts can be for blob detection in these movies, tracking particles across frames, and then some basic classification of these particles into bona fide exocytic events vs noise. This code is not user friendly, but is provided for the sake of anyone working on similar projects. Primarily, this code reproduces the particle detection used as the basis for the analysis in [Evans et al 2021](https://arxiv.org/abs/2106.07623).

To detect events in the data used for that study, [download the primary data](https://zenodo.org/record/7460048). Then run
`movies_for_classifier.ipynb` to process all of the movies to be used in downstream classification code.

Other files of interest include:
- `lib` directory, with detection and particle tracking code inspired by [Aguet et al. 2013](https://www.cell.com/developmental-cell/fulltext/S1534-5807(13)00382-1)
- `puffapy.ipynb` as a generalized scheme to run detection.
- `classifier.ipynb` a prototype classifier to differentiate bona fide exocytic events from noise.

Initial code from this project was written by Zara Weinberg and Tiffany Phan in 2016 at Carnegie Mellon University. The current form of the project is a collaboration between Ciaran Evans, Zara Weinberg, Max G'Sell, and Manojkumar Puthenveedu.
