##1. Introduction

The Hydrogen Ontology (HOLY) is a domain ontology for the hydrogen market, which aims to provide conceptual information of the current status and potential developments in the hydrogen market. In its current version, which focuses on Polymer Electrolyte Membrane Fuel Cells (PEMFCs), it is designed to classify information concerning the composition of PEMFCs, their use, manufacturers, geographic areas, indicators and projects. Conceptualizing market requirements is done by providing extensions to other areas of interests such as the organization domain, geo-location, indicators, project schemas and applications.

The ontology is intended to structure market-relevant domain information for the hydrogen market in an accessible format and provide a generic, reusable core for expansion in different areas along the hydrogen value chain or even the use of certain content patterns for other market domain ontologies.

HOLY defines its own classes and properties to describe the hydrogen market, but also uses classes and properties from already existing ontologies. All newly defined concepts are located in the namespace of HOLY. The Hydrogen Ontology utilizes specific elements from select ontologies but does not import full ontologies. As it is intended to structure market-relevant domain information for the hydrogen market, only relevant concepts from existing ontologies are used.

The Hydrogen Ontology uses concepts from the following vocabularies:

|Prefix |Reference                             |Namespace                                     |
|-------|--------------------------------------|----------------------------------------------|
|owl	|Web Ontology Language	               |http://www.w3.org/2002/07/owl#                |
|rdfs	|Resource Description Framework Schema |http://www.w3.org/2000/01/rdf-schema#         |
|skos	|Simple Knowledge Organization System  |http://www.w3.org/2004/02/skos/core#          |
|dbo	|DBpedia Ontology	                   |http://dbpedia.org/ontology/                  |
|xsd	|XSML Schema	                       |http://www.w3.org/2001/XMLSchema#             |
|dc	    |DCMI Metadata Terms	               |http://purl.org/dc/elements/1.1/              |
|dct	|DCMI Metadata Terms	               |http://purl.org/dc/terms/                     |
|org	|The Organization Ontology	           |http://www.w3.org/ns/org#                     |
|schema	|Schema.org	                           |http://schema.org/                            |
|ebg	|The euBusinessGraph Ontology	       |http://data.businessgraph.io/ontology#        |
|rov	|Registered Organization Vocabulary	   |http://www.w3.org/ns/regorg#                  |
|m4i	|Metadata4Ing	                       |https://w3id.org/nfdi4ing/metadata4ing/1.0.0/ |