import matplotlib.pyplot as plt
import numpy as np
import math

kyr_clm, kt, T = np.loadtxt('torn_clm_crujrav2.2.txt', unpack=True)
jja = [] #mean jja temperature for each year (degC)
nyr = 2020 - 1901 + 1
nmo = 12
ndays = [31,28,31,30,31,30,31,31,30,31,30,31]
m = 0
sum = 0
for i in range (nyr):
	for j in range (nmo):
		for k in range (ndays[j]):
			for l in range (4):
				if j == 5 or j == 6 or j == 7:
					sum = sum + T [m] - 273.15
				m = m + 1
	jja.append (sum/float(4*(ndays[5]+ndays[6]+ndays[7])))
	sum = 0
		
#extract years of relevance for plotting jja
jja_obs = []

l_obs = nyr
ib = 1901
ie = 2004
j = ib
for i in range (l_obs):
	if j <= ie:
		jja_obs.append (float(jja [i]))
		j = j + 1

Year, MXDrcs, MXDlow, MXDlow2, MXDlow9, TRWrcs, TRWlow, TRWlow2, TRWlow9 = np.loadtxt('torn_tree_data.txt', unpack=True)
kyr, trw, mxd = np.loadtxt('TRW_torn.dat', unpack=True)

obs = []
pre = []

l_obs = len(Year)
ib = 1901
ie = 2004
j = ib
for i in range (l_obs):
	if Year [i] == j and j <= ie:
		obs.append (TRWrcs [i]*0.796)
		j = j + 1
l_pre = len(kyr)
ib = 1901
ie = 2004
j = ib
for i in range (l_pre):
	if kyr [i] == j and j <= ie:
		pre.append (trw [i]/1000)
		j = j + 1

plt.plot(jja_obs,obs,'o')
plt.plot(jja_obs,pre,'o')

#Compute and plot linear regressions to the two sets of points.
p = np.polyfit(jja_obs,obs,1)
print(p[0])
x = jja_obs
l_fit = len(x)
y = []
for i in range(l_fit):
	y.append (p[0]*x[i]+p[1])
plt.plot(x, y)

p = np.polyfit(jja_obs,pre,1)
print(p[0])
x = jja_obs
l_fit = len(x)
y = []
for i in range(l_fit):
	y.append (p[0]*x[i]+p[1])
plt.plot(x, y)

plt.show()
