# Title of Dataset:
The diversity and distribution of introduced plant species reflects eight thousand years of settlement history


Brief summary of dataset contents, contextualized in experimental procedures and results.


## Description of the Data and file structure

File kvadranty.tb.csv contains table of archaeological occupancy values, plant diversity values and environmental conditions in regular grid (5x3 arc minutes) over the study area (Czech republic). These data were compiled from plant diversity database PLADIAS (Chytrý et al., 2021; Wild et al., 2019), archaeobotanical evidence (Pokorná et al. 2018), archaeological occupancy  model (Kolář et al. 2022), gridded climatologies (Karger et al., 2017; Karger et al., 2021), soil types (Tomášek, 2003) and forest cover (UHUL, www.uhul.cz). Data were processed in R using code which is part of this dataset.


#### file: "kvadranty.tb.csv"  
    
COLUMN   *DESCRIPTION *  

code   *quadrant ID *  
longitude   *longitude of quadrant centroid (decimal degrees, WGS 1984)*  
latitude   *latitude of quadrant centroid  (decimal degrees, WGS 1984)*  
BC..9750 ... AD_750   *mean modelled archaeological occupancy in 500 year window centered around given year  (probability)*  
area.km.clip   *quadrant area within Czech republic (km2)*  
archeo_mean   *average archaeological occupancy 6000 BCE - 1000 CE*  
alpinske.pudni.formy   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
antropogenni.pudy   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
arenosoly.s.hnedymi.pudami.a.podzoly   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
cernice   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
cernozeme   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
cernozeme.s.cernicemi   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
gleje   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
hnede.pudy.eutrofni   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
hnede.pudy.kysele   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
hnede.pudy.s.podzoly.na.terasovych.ulozeninach   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
hnede.pudy.se.surovymi.pudami   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
hnede.pudy.silne.kysele   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
hnedozeme   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
illimerizovane.pudy.s.illimerizovanymi.pudami.oglejenymi   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
nivni.pudy   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
pararendziny   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
pelosoly   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
podzoly   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
pseudogleje.s.hnedymi.pudami.oglejanymi   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
raselinistni.pudy   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
rendziny   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
rezive.pudy.s.podzoly   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
smonice   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
sedozeme   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
zasolene.pudy   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
MAT   *Mean annual temperature from CHELSA  (°C)*  
TMAX.CH   *Mean maximum temperature of the warmest quarter from CHELSA (°C)*  
MAP   *Mean annual precipitation from CHELSA (mm)*  
elev   *median elevation (m asl)*  
forest   *forest cover (fraction of quadrant area)*  
MAT1k   *Mean annual temperature 1ky BP from CHELSA-TraCE21k v1.0 (°C)*  
MAT2k   *Mean annual temperature 2ky BP from CHELSA-TraCE21k v1.0  (°C)*  
MAT3k   *Mean annual temperature 3ky BP from CHELSA-TraCE21k v1.0  (°C)*  
MAT4k   *Mean annual temperature 4ky BP from CHELSA-TraCE21k v1.0  (°C)*  
MAT5k   *Mean annual temperature 5ky BP from CHELSA-TraCE21k v1.0  (°C)*  
MAT6k   *Mean annual temperature 6ky BP from CHELSA-TraCE21k v1.0  (°C)*  
MAT7k   *Mean annual temperature 7ky BP from CHELSA-TraCE21k v1.0  (°C)*  
MAT8k   *Mean annual temperature 8ky BP from CHELSA-TraCE21k v1.0  (°C)*  
records   *number of plant occurance records in PLADIAS database*  
arch   *number of archaeophyte taxa in the quadrant *  
neo   *number of neophyte taxa in the quadrant*  
nat   *number of native taxa in the quadrant*  
tot   *total number  of taxa in the quadrant*  
archnat   *archaeophytes to neophytes (proportion)*  
arch2all   *archaeophytes to total (proportion)*  
arch2nat   *archaeophytes to native  (proportion)*  
neo2all   *neophytes to total  (proportion)*  
neo2nat   *neophytes to native (proportion)*  
Abies.alba ... Zelkova.serrata   *individual taxa (presence / absence)*  
PC1   *environmental PCA scores *  
PC2   *environmental PCA scores *  
PC3   *environmental PCA scores *  
PC4   *environmental PCA scores *  
PC5   *environmental PCA scores *  
PC6   *environmental PCA scores *  
archeo_from_BC..5750   *average archaeological occupancy probability 6000 BCE - 1000 CE *  
archeo_from_BC..5250   *average archaeological occupancy probability 5500 BCE - 1000 CE *  
archeo_from_BC..4750   *average archaeological occupancy probability 5000 BCE - 1000 CE *  
archeo_from_BC..4250   *average archaeological occupancy probability 4500 BCE - 1000 CE *  
archeo_from_BC..3750   *average archaeological occupancy probability 4000 BCE - 1000 CE *  
archeo_from_BC..3250   *average archaeological occupancy probability 3500 BCE - 1000 CE *  
archeo_from_BC..2750   *average archaeological occupancy probability 3000 BCE - 1000 CE *  
archeo_from_BC..2250   *average archaeological occupancy probability 2500 BCE - 1000 CE *  
archeo_from_BC..1750   *average archaeological occupancy probability 2000 BCE - 1000 CE *  
archeo_from_BC..1250   *average archaeological occupancy probability 15000 BCE - 1000 CE*  
archeo_from_BC..750   *average archaeological occupancy probability 1000 BCE - 1000 CE*  
archeo_from_BC..250   *average archaeological occupancy probability 500 BCE - 1000 CE *  
archeo_from_AD.250   *average archaeological occupancy probability 1 CE - 1000 CE *  
archeo_from_AD.750   *average archaeological occupancy probability 500 BCE - 1000 CE*  
  
  
  
#### file "kvadranty.sel.RData"
R object with quadrant grid stored as SpatialPolygonsDataFrame class {sp} with attributes same as in the file "kvadranty.tb.csv".
spatial projection: WGS 84 / UTM zone 33N (EPSG: 32633)

COLUMN   *DESCRIPTION *  

code   *quadrant ID *  
longitude   *longitude of quadrant centroid (decimal degrees)*  
latitude   *latitude of quadrant centroid  (decimal degrees)*  
BC..9750 ... AD_750   *mean modelled archaeological occupancy in 500 year window centered around given year  (probability)*  
area.km.clip   *quadrant area within Czech republic (km2)*  
archeo_mean   *average archaeological occupancy 6000 BCE - 1000 CE*  
alpinske.pudni.formy   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
antropogenni.pudy   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
arenosoly.s.hnedymi.pudami.a.podzoly   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
cernice   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
cernozeme   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
cernozeme.s.cernicemi   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
gleje   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
hnede.pudy.eutrofni   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
hnede.pudy.kysele   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
hnede.pudy.s.podzoly.na.terasovych.ulozeninach   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
hnede.pudy.se.surovymi.pudami   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
hnede.pudy.silne.kysele   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
hnedozeme   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
illimerizovane.pudy.s.illimerizovanymi.pudami.oglejenymi   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
nivni.pudy   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
pararendziny   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
pelosoly   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
podzoly   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
pseudogleje.s.hnedymi.pudami.oglejanymi   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
raselinistni.pudy   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
rendziny   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
rezive.pudy.s.podzoly   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
smonice   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
sedozeme   *soil type according to Tomasek 2003 (fraction of quadrant area) *  
zasolene.pudy   *soil type according to Tomasek 2003 (fraction of quadrant area)*  
MAT   *Mean annual temperature from CHELSA  (°C)*  
TMAX.CH   *Mean maximum temperature of the warmest quarter from CHELSA (°C)*  
MAP   *Mean annual precipitation from CHELSA (mm)*  
elev   *median elevation (m asl)*  
forest   *forest cover (fraction of quadrant area)*  
MAT1k   *Mean annual temperature 1ky BP from CHELSA-TraCE21k v1.0 (°C)*  
MAT2k   *Mean annual temperature 2ky BP from CHELSA-TraCE21k v1.0  (°C)*  
MAT3k   *Mean annual temperature 3ky BP from CHELSA-TraCE21k v1.0  (°C)*  
MAT4k   *Mean annual temperature 4ky BP from CHELSA-TraCE21k v1.0  (°C)*  
MAT5k   *Mean annual temperature 5ky BP from CHELSA-TraCE21k v1.0  (°C)*  
MAT6k   *Mean annual temperature 6ky BP from CHELSA-TraCE21k v1.0  (°C)*  
MAT7k   *Mean annual temperature 7ky BP from CHELSA-TraCE21k v1.0  (°C)*  
MAT8k   *Mean annual temperature 8ky BP from CHELSA-TraCE21k v1.0  (°C)*  
records   *number of plant occurance records in PLADIAS database*  
arch   *number of archaeophyte taxa in the quadrant *  
neo   *number of neophyte taxa in the quadrant*  
nat   *number of native taxa in the quadrant*  
tot   *total number  of taxa in the quadrant*  
archnat   *archaeophytes to neophytes (proportion)*  
arch2all   *archaeophytes to total (proportion)*  
arch2nat   *archaeophytes to native  (proportion)*  
neo2all   *neophytes to total  (proportion)*  
neo2nat   *neophytes to native (proportion)*  
Abies.alba ... Zelkova.serrata   *individual taxa (presence / absence)*  
PC1   *environmental PCA scores *  
PC2   *environmental PCA scores *  
PC3   *environmental PCA scores *  
PC4   *environmental PCA scores *  
PC5   *environmental PCA scores *  
PC6   *environmental PCA scores *  
archeo_from_BC..5750   *average archaeological occupancy probability 6000 BCE - 1000 CE *  
archeo_from_BC..5250   *average archaeological occupancy probability 5500 BCE - 1000 CE *  
archeo_from_BC..4750   *average archaeological occupancy probability 5000 BCE - 1000 CE *  
archeo_from_BC..4250   *average archaeological occupancy probability 4500 BCE - 1000 CE *  
archeo_from_BC..3750   *average archaeological occupancy probability 4000 BCE - 1000 CE *  
archeo_from_BC..3250   *average archaeological occupancy probability 3500 BCE - 1000 CE *  
archeo_from_BC..2750   *average archaeological occupancy probability 3000 BCE - 1000 CE *  
archeo_from_BC..2250   *average archaeological occupancy probability 2500 BCE - 1000 CE *  
archeo_from_BC..1750   *average archaeological occupancy probability 2000 BCE - 1000 CE *  
archeo_from_BC..1250   *average archaeological occupancy probability 15000 BCE - 1000 CE*  
archeo_from_BC..750   *average archaeological occupancy probability 1000 BCE - 1000 CE*  
archeo_from_BC..250   *average archaeological occupancy probability 500 BCE - 1000 CE *  
archeo_from_AD.250   *average archaeological occupancy probability 1 CE - 1000 CE *  
archeo_from_AD.750   *average archaeological occupancy probability 500 BCE - 1000 CE*  
  


#### file: "archaeophytes_introduction.csv"
Minimum residence time according to Pokorná et al. (2018)


COLUMN   *DESCRIPTION *  

Taxon.sp   *Taxon name (harmonized with PLADIAS)*  
Plant species   *Taxon name (original)*  
first_app   *first appearance (broad periods) *  
first_app2   *first appearance (detailed periods) *  
period first appearence   *first appearance (description) *  
ecology   *ecology of the taxa*  

Periods definition for *first_app2*:   

NE1 = Early Neolithic, 5400-4900 BCE    
NE2 = Late Neolithic, 5000-4200 BCE  
EN = Eneolithic, 4500-2300 BCE  
BR1 = Early to Middle Bronze Age, 2300-1250 BCE  
BR2 = Late to Final Bronze Age, 1250-800 BCE  
IR1 = Early Iron Age, 800-400 BCE  
IR2 = Late Iron Age, 480-20 BCE  
EM1 = Early Middle Ages 1–3, 580-950 CE  
EM2 = Early Middle Ages 4, 950-1200 CE)  


#### file: "species_table.csv"

COLUMN   *DESCRIPTION *  

species *Species name*  
Res *Residency status (ar = archaeophyte)*  
first_app *First appearance, 4 periods*  
first_app2 *First appearance, 9 periods*  
ecology *Species ecology*  
n *Number of occupied quadrants*
relarea *Relative area occupied*


#### file: "Macek_etal_Archaeophytes.R"

R script writen under R 4.0.4 version.



## Sharing/access Information

Links to other publicly accessible locations of the data:


Was data derived from another source?
If yes, list source(s):

##### PLADIAS database 
- https://pladias.cz/

- Chytrý M., Danihelka J., Kaplan Z., Wild J., Holubová D., Novotný P., Řezníčková M., Rohn M., Dřevojan P., Grulich V., Klimešová J., Lepš J., Lososová Z., Pergl J., Sádlo J., Šmarda P., Štěpánková P., Tichý L., Axmanová I., Bartušková A., Blažek P., Chrtek J., Fischer F.M., Guo W.-Y., Herben T., Janovský Z., Konečná M., Kühn I., Moravcová L., Petřík P., Pierce S., Prach K., Prokešová H., Štech M., Těšitel J., Těšitelová T., Večeřa M., Zelený D. & Pyšek P. (2021) Pladias Database of the Czech flora and vegetation. Preslia 93: 1–87. https://doi.org/10.23855/preslia.2021.001

- Wild J., Kaplan Z., Danihelka J., Petřík P., Chytrý M., Novotný P., Rohn M., Šulc V., Brůna J., Chobot K., Ekrt L., Holubová D., Knollová I., Kocián P., Štech M., Štěpánek J. & Zouhar V. (2019) Plant distribution data for the Czech Republic integrated in the Pladias database. Preslia 91: 1–24. https://doi.org/10.23855/preslia.2019.001

##### climate from CHELSA database:
- Karger D.N., Conrad, O., Böhner, J., Kawohl, T., Kreft, H., Soria-Auza, R.W., Zimmermann, N.E,, Linder, H.P., Kessler, M.. Data from: Climatologies at high resolution for the earth’s land surface areas. Dryad Digital Repository.http://dx.doi.org/doi:10.5061/dryad.kd1d4

- Karger D.N., Conrad O., Böhner J., Kawohl T., Kreft H., Soria-Auza R.W., Zimmermann N.E., Linder H.P. & Kessler M. (2017) Climatologies at high resolution for the earth’s land surface areas. Scientific Data 4: 170122. https://doi.org/10.1038/sdata.2017.122

##### CHELSA TraCE21k database:
- Karger, D. N., Nobis, M. P., Normand, S., Graham, C. H., and Zimmermann, N. E.: CHELSA-TraCE21k v1.0. Downscaled transient temperature and precipitation data since the last glacial maximum, Clim. Past Discuss. [preprint], https://doi.org/10.5194/cp-2021-30, in review, 2021.

##### Archaeological occupancy model:
- Kolář J., Macek M., Tkáč P., Novák D. & Abraham V. (2022) Long-term demographic trends and spatio-temporal distribution of past human activity in Central Europe: Comparison of archaeological and palaeoecological proxies. Quaternary Science Reviews 297: 107834. https://doi.org/10.1016/j.quascirev.2022.107834


- Long-term demographic trends and spatio-temporal distribution of past human activity in Central Europe: Comparison of archaeological and palaeoecological proxies (datasets and R scripts) https://doi.org/10.5281/zenodo.7236400


##### Residence time:
Pokorná A., Kočár P., Novák J., Šálková T., Žáčková P., Komárková V., Vaneček Z. & Sádlo J. (2018) Ancient and early medieval man-made habitats in the Czech Republic: Colonization history and vegetation changes. Preslia 90: 171–193. https://doi.org/10.23855/preslia.2018.171

##### Soils:
Tomášek M. (2003) Půdy České republiky, 3rd edn. Česká geologická služba. ISBN 80-7075-607-1
https://micka.geology.cz/en/record/basic/50a4d3c3-8e0c-478a-9629-0d100a010817

