setwd("C:/Users/Bogi/Desktop")
adat<-read.csv("Asclepias_kiserlet_talaj_2019_2.csv",header=T,sep=";",dec=",")
str(adat)
attach(adat)
tail(adat)
adat<-adat[1:80,]

adat$ID_site<-as.factor(adat$ID_site)
adat$ID_site<-factor(adat$ID_site)
# adat$Treatment<-factor(adat$Treatment, levels = c("control", "inv", "half",  "total"))
adat$Depth<-factor(adat$Depth, levels = c("0-10 cm", "10-20 cm"))
adat$State<-factor(adat$State, levels = c("Cont", "Inv"))
adat$Date<-factor(adat$Date, levels = c("2019","2021"))
adat$Name_plot<-as.factor(adat$Name_plot)

# used packages
library(nlme)
library(lme4) 
library(lmerTest)
library (multcomp) 
library(DHARMa) 

library(nlme)
library(lme4)

install.packages("glmmTMB")
library(glmmTMB)


# the modell:
# soil properties ~ State* Depth  | Random: field ID, plot ID and after utna post hoc test 
# we used linear mixed model in every studied soil properties 

options(contrasts = c("contr.sum","contr.poly"))
m1<- lmer (pH_KCL~State *Depth  +(1| ID_site), data=adat, REML=TRUE)
summary(m1)
anova(m1)

options(contrasts = c("contr.sum","contr.poly"))
m2<- lmer (mesz~State *Depth  +(1| ID_site), data=adat, REML=TRUE)
summary(m2)
anova(m2)

options(contrasts = c("contr.sum","contr.poly"))
m3<- lmer (Humusz~State *Depth  +(1| ID_site), data=adat, REML=TRUE)
summary(m3)
anova(m3)

options(contrasts = c("contr.sum","contr.poly"))
m4<- lmer (Szerves_szen~State *Depth  +(1| ID_site), data=adat, REML=TRUE)
summary(m4)
anova(m4)

options(contrasts = c("contr.sum","contr.poly"))
m5<- lmer (Foszfor~State *Depth  +(1| ID_site), data=adat, REML=TRUE)
summary(m5)
anova(m5)

options(contrasts = c("contr.sum","contr.poly"))
m6<- lmer (Kalium~State *Depth  +(1| ID_site), data=adat, REML=TRUE)
summary(m6)
anova(m6)

options(contrasts = c("contr.sum","contr.poly"))
m7<- lmer (Nitrat~State *Depth  +(1| ID_site), data=adat, REML=TRUE)
summary(m7)
anova(m7)


# diagramms at every models

par(mar=c(4,5,1,1))
boxplot(pH_KCL~Depth*State, xlab=("Soil layers"), ylab=("pH_KCL"), col = c("indianred1", "indianred", "azure2", "azure4")) 
legend("bottomleft", inset=0.00001, 0.5, title="state_2021",
       c("Cont:not invaded", "Inv:invaded by common milkweed"), fill=c("indianred", "azure3"), horiz=FALSE, cex=0.72)

boxplot(Foszfor~Depth*State)
boxplot(mesz~Depth*State) # depth 10 cm inv s a depth 10 cm non-inv signif. klnbzik, fontos/rdekes??

par(mar=c(4,5,1,1))
boxplot(Humusz~Depth*State,xlab=("Soil layers"), ylab=("Humus %"),col = c("indianred1", "indianred", "azure2", "azure4"))
legend("topright", inset=0.00001, 0.5, title="state_2021",
       c("Cont:non-invaded", "Inv:invaded by common milkweed"), fill=c("indianred", "azure3"), horiz=FALSE, cex=0.8)

boxplot(Szerves_szen~Depth*State) # lehet rdemes bemutatni ua. mint a humusz
boxplot(Kalium~Depth*State)
boxplot(Nitrat~Depth*State)



library(multcompView)
library(multcomp)
library(emmeans)

# checking to significancy


marginal = emmeans(m1,
                   ~ Depth*State)

pairs(marginal,
      adjust="tukey")

cld(marginal,
    alpha=0.05,
    Letters=letters,  ### Use lower-case letters for .group
    adjust="tukey")   ### Tukey adjustment for multiple comparisons 


marginal = emmeans(m2,
                   ~ Depth*State)

pairs(marginal,
      adjust="tukey")

cld(marginal,
    alpha=0.05,
    Letters=letters,  ### Use lower-case letters for .group
    adjust="tukey")   ### Tukey adjustment for multiple comparisons 


marginal = emmeans(m3,
                   ~ Depth*State)

pairs(marginal,
      adjust="tukey")

cld(marginal,
    alpha=0.05,
    Letters=letters,  ### Use lower-case letters for .group
    adjust="tukey")   ### Tukey adjustment for multiple comparisons 


marginal = emmeans(m4,
                   ~ Depth*State)

pairs(marginal,
      adjust="tukey")

cld(marginal,
    alpha=0.05,
    Letters=letters,  ### Use lower-case letters for .group
    adjust="tukey")   ### Tukey adjustment for multiple comparisons 



marginal = emmeans(m5,
                   ~ Depth*State)

pairs(marginal,
      adjust="tukey")

cld(marginal,
    alpha=0.05,
    Letters=letters,  ### Use lower-case letters for .group
    adjust="tukey")   ### Tukey adjustment for multiple comparisons 


marginal = emmeans(m6,
                   ~ Depth*State)

pairs(marginal,
      adjust="tukey")

cld(marginal,
    alpha=0.05,
    Letters=letters,  ### Use lower-case letters for .group
    adjust="tukey")   ### Tukey adjustment for multiple comparisons 



marginal = emmeans(m7,
                   ~ Depth*State)

pairs(marginal,
      adjust="tukey")

cld(marginal,
    alpha=0.05,
    Letters=letters,  ### Use lower-case letters for .group
    adjust="tukey")   ### Tukey adjustment for multiple comparisons 






library (multcomp)


# posthoc teszt
summary(glht(m1, linfct = mcp(Depth= "Tukey")))
summary(glht(m2, linfct = mcp(Melyseg= "Tukey")))
summary(glht(m3, linfct = mcp(Depth= "Tukey")))
summary(glht(m4, linfct = mcp(Melyseg= "Tukey")))
summary(glht(m5, linfct = mcp(Melyseg= "Tukey")))
summary(glht(m6, linfct = mcp(Melyseg= "Tukey")))
summary(glht(m7, linfct = mcp(Melyseg= "Tukey")))


#modell checkings 
qqnorm(resid(m1))
qqline(resid(m1))
plot(fitted(m1),resid(m1))

qqnorm(resid(m2))
qqline(resid(m2))
plot(fitted(m2),resid(m2))

qqnorm(resid(m3))
qqline(resid(m3))
plot(fitted(m3),resid(m3))

qqnorm(resid(m4))
qqline(resid(m4))
plot(fitted(m4),resid(m4))

qqnorm(resid(m5))
qqline(resid(m5))
plot(fitted(m5),resid(m5))

qqnorm(resid(m6))
qqline(resid(m6))
plot(fitted(m6),resid(m6))

qqnorm(resid(m7))
qqline(resid(m7))
plot(fitted(m7),resid(m7))

# checking to the distribution with DHarma package: DHARMa aims at solving these problems 
#by creating readily interpretable residuals for generalized linear (mixed) models 
#that are standardized to values between 0 and 1, and that can be interpreted as intuitively as residuals for the linear model.
# generalized mixed model

simulationOutput <- simulateResiduals(fittedModel = m1, plot = F)
residuals(simulationOutput)
plot(simulationOutput)

simulationOutput <- simulateResiduals(fittedModel = m2, plot = F)
residuals(simulationOutput)
plot(simulationOutput)

simulationOutput <- simulateResiduals(fittedModel = m3, plot = F)
residuals(simulationOutput)
plot(simulationOutput)

simulationOutput <- simulateResiduals(fittedModel = m4, plot = F)
residuals(simulationOutput)
plot(simulationOutput)

simulationOutput <- simulateResiduals(fittedModel = m5, plot = F)
residuals(simulationOutput)
plot(simulationOutput)

simulationOutput <- simulateResiduals(fittedModel = m6, plot = F)
residuals(simulationOutput)
plot(simulationOutput)

simulationOutput <- simulateResiduals(fittedModel = m7, plot = F)
residuals(simulationOutput)
plot(simulationOutput)








