# Asclepias shoots removal 2019-2020-2021


asc<-read.csv("As_kiserlet_3ev_coverjo(1).csv",header=TRUE,sep=";",dec=",",na.string="<null>")

str(asc)
names(asc)
library(DHARMa) 
library(pscl)
library (car)
library (multcomp) 
library(multcompView)
library(emmeans)
library(glmmTMB) 
library(lme4)

# the survey dates
Season<-vector(length=dim(asc)[1])
Season[which(asc$Date<20190930)]<-"summer_2019"
Season[which(asc$Date>=20190930 & asc$Date<20200101)]<-"autumn_2019"
Season[which(asc$Date>20200101)]<-"summer_2020"
Season[which(asc$Date>=20200924)]<-"autumn_2020" 
Season[which(asc$Date>=20210624)]<-"summer_2021"
Season[which(asc$Date>=20210928)]<-"autumn_2021" 

Season

asc<-cbind(asc,Season)
asc$Season<-factor(asc$Season, levels = c("summer_2019", "autumn_2019", "summer_2020", "autumn_2020", "summer_2021", "autumn_2021"))
asc$Treatment<-factor(asc$Treatment, levels = c("control", "inv", "half", "total"))

ID_site_factor<-as.factor(asc$ID_site)
ID_plot_factor<-as.factor(asc$ID_plot)
ID_subplot_factor<-as.factor(asc$ID_subplot02)
asc$Date<-as.factor(asc$Date)

# take out the control, and made new data table 
asc2<-asc[!(asc$Treatment=="control"),]
asc2$Treatment<-as.factor(as.character(asc2$Treatment))
 
#a new, combined variable for the model
asc2$TreatDate<-with(asc2,interaction(Treatment,Season))

#model_ glm fot the Asclepias shoot removals
m2 = glmmTMB(Asclepias_shoot~TreatDate +(1| ID_site/ID_plot/ID_subplot),
             data = asc2,  family="nbinom1")
simulationOutput <- simulateResiduals(fittedModel = m2)
plot(simulationOutput)
testDispersion(m2) 

# vector es matrix contrast analysis
RN<-c("autumn_2019","summer_2020","autumn_2020","summer_2021","autumn_2021")
contr.treat1<-matrix(0,nrow=length(RN),ncol=nlevels(asc2$TreatDate))
row.names(contr.treat1)<-RN
colnames(contr.treat1)<-levels(asc2$TreatDate)
contr.treat1[,"total.summer_2019"]<-(-1)
contr.treat1["autumn_2019","total.autumn_2019"]<-1
contr.treat1["autumn_2020","total.autumn_2020"]<-1
contr.treat1["autumn_2021","total.autumn_2021"]<-1
contr.treat1["summer_2020","total.summer_2020"]<-1
contr.treat1["summer_2021","total.summer_2021"]<-1

contr.treat1[,"inv.summer_2019"]<-1
contr.treat1["autumn_2019","inv.autumn_2019"]<-(-1)
contr.treat1["autumn_2020","inv.autumn_2020"]<-(-1)
contr.treat1["autumn_2021","inv.autumn_2021"]<-(-1)
contr.treat1["summer_2020","inv.summer_2020"]<-(-1)
contr.treat1["summer_2021","inv.summer_2021"]<-(-1)
rowSums(contr.treat1) # checking to rows, their result should sum to 0

# contrast analysis_for the total cut compared to uncut plots
Treat1.effect<-glht(m2, linfct = mcp(TreatDate  = contr.treat1))
Treat1.effect
summary(Treat1.effect)
par(mar=c(6,7,4,5)+0.1)
# plot(Treat1.effect, main=("") ,xlab="Difference between total cut and uncut plots in Asclepias shoot number", axes=F)
# axis(1, xlab="Difference between total cut and uncut plots in Asclepias shoot number", cex.lab = 4)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in Asclepias shoot number", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("a) ???? ",side=1,line=1.8,font=2,cex=1.1,adj=0)



####contrast analysis for the half-cut to compared to uncut plots
contr.treat2<-matrix(0,nrow=length(RN),ncol=nlevels(asc2$TreatDate))
row.names(contr.treat2)<-RN
colnames(contr.treat2)<-levels(asc2$TreatDate)

contr.treat2[,"half.summer_2019"]<-(-1)
contr.treat2["autumn_2019","half.autumn_2019"]<-1
contr.treat2["autumn_2020","half.autumn_2020"]<-1
contr.treat2["autumn_2021","half.autumn_2021"]<-1
contr.treat2["summer_2020","half.summer_2020"]<-1
contr.treat2["summer_2021","half.summer_2021"]<-1

contr.treat2[,"inv.summer_2019"]<-1
contr.treat2["autumn_2019","inv.autumn_2019"]<-(-1)
contr.treat2["autumn_2020","inv.autumn_2020"]<-(-1)
contr.treat2["autumn_2021","inv.autumn_2021"]<-(-1)
contr.treat2["summer_2020","inv.summer_2020"]<-(-1)
contr.treat2["summer_2021","inv.summer_2021"]<-(-1)
rowSums(contr.treat2) # checking to rows, their result should sum to 0

# post-hoc test to checking the results
Treat2.effect<-glht(m2, linfct = mcp(TreatDate  = contr.treat2))
Treat2.effect
summary(Treat2.effect)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat2.effect, main=(""), xlab="Difference between half-cut and uncut plots 
     in Asclepias shoot number", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("b) ???? ",side=1,line=1.8,font=2,cex=1.1,adj=0)



#######################################################
# model the changes the Asclepias cover of treatments

#model to the Asclepias covers
m2 = glmmTMB(Asc_cover~TreatDate +(1| ID_site/ID_plot/ID_subplot), data = asc2,family="tweedie") 
simulationOutput <- simulateResiduals(fittedModel = m2)
plot(simulationOutput)
testDispersion(m2) 

# model diagnostics -checking model assumptions 
par(mfrow=c(1,1))
#plot(m2) # 
plot(fitted(m2),resid(m2))
#normal residuals
qqnorm(resid(m2)) 
qqline(resid(m2))
#zuur examination
E<-residuals(m2, type="response")
plot(E~asc2$TreatDate)

# vector and matrix a contrast
RN<-c("autumn_2019","summer_2020","autumn_2020","summer_2021","autumn_2021")
contr.treat1<-matrix(0,nrow=length(RN),ncol=nlevels(asc2$TreatDate))
row.names(contr.treat1)<-RN
colnames(contr.treat1)<-levels(asc2$TreatDate)

contr.treat1[,"total.summer_2019"]<-(-1)
contr.treat1["autumn_2019","total.autumn_2019"]<-1
contr.treat1["autumn_2020","total.autumn_2020"]<-1
contr.treat1["autumn_2021","total.autumn_2021"]<-1
contr.treat1["summer_2020","total.summer_2020"]<-1
contr.treat1["summer_2021","total.summer_2021"]<-1

contr.treat1[,"inv.summer_2019"]<-1
contr.treat1["autumn_2019","inv.autumn_2019"]<-(-1)
contr.treat1["autumn_2020","inv.autumn_2020"]<-(-1)
contr.treat1["autumn_2021","inv.autumn_2021"]<-(-1)
contr.treat1["summer_2020","inv.summer_2020"]<-(-1)
contr.treat1["summer_2021","inv.summer_2021"]<-(-1)
rowSums(contr.treat1) # checking to rows, their result should sum to 0


# contrast_total cut to compared uncut plots
Treat1.effect<-glht(m2, linfct = mcp(TreatDate  = contr.treat1))
Treat1.effect
summary(Treat1.effect)
# par(mar=c(6,7,4,5)+0.1)
# plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots in Asclepias cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in Asclepias cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("c) ???? ",side=1,line=1.8,font=2,cex=1.1,adj=0)


RN<-c("autumn_2019","summer_2020","autumn_2020","summer_2021","autumn_2021")
contr.treat2<-matrix(0,nrow=length(RN),ncol=nlevels(asc2$TreatDate))
row.names(contr.treat2)<-RN
colnames(contr.treat2)<-levels(asc2$TreatDate)

contr.treat2[,"half.summer_2019"]<-(-1)
contr.treat2["autumn_2019","half.autumn_2019"]<-1
contr.treat2["autumn_2020","half.autumn_2020"]<-1
contr.treat2["autumn_2021","half.autumn_2021"]<-1
contr.treat2["summer_2020","half.summer_2020"]<-1
contr.treat2["summer_2021","half.summer_2021"]<-1

contr.treat2[,"inv.summer_2019"]<-1
contr.treat2["autumn_2019","inv.autumn_2019"]<-(-1)
contr.treat2["autumn_2020","inv.autumn_2020"]<-(-1)
contr.treat2["autumn_2021","inv.autumn_2021"]<-(-1)
contr.treat2["summer_2020","inv.summer_2020"]<-(-1)
contr.treat2["summer_2021","inv.summer_2021"]<-(-1)
rowSums(contr.treat2) # checking to rows, their result should sum to 0


# post-hoc test to half cut treatments 
Treat2.effect<-glht(m2, linfct = mcp(TreatDate  = contr.treat2))
Treat2.effect
summary(Treat2.effect)
par(mar=c(6,7,4,5)+0.1)
plot(Treat2.effect, main=(""), xlab="Difference between half-cut and uncut plots in Asclepias cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat2.effect, main=(""), xlab="Difference between half-cut and uncut plots 
     in Asclepias cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("d) ???? ",side=1,line=1.8,font=2,cex=1.1,adj=0)
