#the impact of Asclepias cutting on plant species groups: generalist, specialist, annual, perennial, native, weed, neophyte plants 2019-2020-2021

asc<-read.csv("As_kiserlet_3ev_coverjo(1).csv",header=TRUE,sep=";",dec=",",na.string="<null>")
str(asc)
attach(asc)
names(asc)
library(DHARMa) 
library(pscl) 
library (car)
library (multcomp) 
library(multcompView) 
library(emmeans) 
library(glmmTMB) 
library(lme4)


asc$ID_site_factor<-as.factor(asc$ID_site)
asc$ID_plot_factor<-as.factor(asc$ID_plot)
asc$ID_subplot_factor<-as.factor(asc$ID_subplot02)

Season<-vector(length=dim(asc)[1])
Season[which(asc$Date<20190930)]<-"summer_2019"
Season[which(asc$Date>=20190930 & asc$Date<20200101)]<-"autumn_2019"
Season[which(asc$Date>20200101)]<-"summer_2020"
Season[which(asc$Date>=20200924)]<-"autumn_2020" 
Season[which(asc$Date>=20210624)]<-"summer_2021"
Season[which(asc$Date>=20210928)]<-"autumn_2021" 
asc<-cbind(asc,Season)
asc$Season<-factor(asc$Season, levels = c("summer_2019", "autumn_2019", "summer_2020", "autumn_2020", "summer_2021", "autumn_2021"))

asc$Treatment<-factor(asc$Treatment, levels = c("control", "inv", "half", "total"))
asc$Date<-as.factor(asc$Date)
asc$TreatDate<-with(asc,interaction(Treatment,Season))

#########################################################xxxxx
#model to generealist covers
hist(Gen_cover)
asc$Gen_t<-asin(sqrt(asc$Gen_cover/100))
m3 = glmmTMB(Gen_t~TreatDate +(1| ID_site/ID_plot/ID_subplot), data = asc) # ez lesz a j?

simulationOutput <- simulateResiduals(fittedModel = m3)
plot(simulationOutput)
testDispersion(m3) 

# vector and matrix contrast
RN<-c("autumn_2019","summer_2020","autumn_2020","summer_2021","autumn_2021")
contr.treat3<-matrix(0,nrow=length(RN),ncol=nlevels(asc$TreatDate))
row.names(contr.treat3)<-RN
colnames(contr.treat3)<-levels(asc$TreatDate)


# 1) models to total cut treatments  
contr.treat3[,"total.summer_2019"]<-(-1)
contr.treat3["autumn_2019","total.autumn_2019"]<-1
contr.treat3["autumn_2020","total.autumn_2020"]<-1
contr.treat3["autumn_2021","total.autumn_2021"]<-1
contr.treat3["summer_2020","total.summer_2020"]<-1
contr.treat3["summer_2021","total.summer_2021"]<-1

contr.treat3[,"inv.summer_2019"]<-1
contr.treat3["autumn_2019","inv.autumn_2019"]<-(-1)
contr.treat3["autumn_2020","inv.autumn_2020"]<-(-1)
contr.treat3["autumn_2021","inv.autumn_2021"]<-(-1)
contr.treat3["summer_2020","inv.summer_2020"]<-(-1)
contr.treat3["summer_2021","inv.summer_2021"]<-(-1)
rowSums(contr.treat3) # rows should sum up to 0

# contrast total cut to compared to uncut plots
Treat1.effect<-glht(m3, linfct = mcp(TreatDate  = contr.treat3))
Treat1.effect
summary(Treat1.effect)
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("a)    ",side=1,line=2,font=2,cex=1.1,adj=0)


# 2) total cut compare to reference plots
contr.treat4<-matrix(0,nrow=length(RN),ncol=nlevels(asc$TreatDate))
row.names(contr.treat4)<-RN
colnames(contr.treat4)<-levels(asc$TreatDate)
contr.treat4[,"total.summer_2019"]<-(-1)
contr.treat4["autumn_2019","total.autumn_2019"]<-1
contr.treat4["autumn_2020","total.autumn_2020"]<-1
contr.treat4["autumn_2021","total.autumn_2021"]<-1
contr.treat4["summer_2020","total.summer_2020"]<-1
contr.treat4["summer_2021","total.summer_2021"]<-1

contr.treat4[,"control.summer_2019"]<-1
contr.treat4["autumn_2019","control.autumn_2019"]<-(-1)
contr.treat4["autumn_2020","control.autumn_2020"]<-(-1)
contr.treat4["autumn_2021","control.autumn_2021"]<-(-1)
contr.treat4["summer_2020","control.summer_2020"]<-(-1)
contr.treat4["summer_2021","control.summer_2021"]<-(-1)
rowSums(contr.treat4) # rows should sum up to 0

# contrast test to the total cut compared to reference plots
Treat1.effect<-glht(m3, linfct = mcp(TreatDate  = contr.treat4))
Treat1.effect
summary(Treat1.effect)
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and reference plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("b)      ",side=1,line=1.8,font=2,cex=1.1,adj=-0.03)

# 3) contrast half cut compared to uncut plots
contr.treat5<-matrix(0,nrow=length(RN),ncol=nlevels(asc$TreatDate))
row.names(contr.treat5)<-RN
colnames(contr.treat5)<-levels(asc$TreatDate)
contr.treat5[,"half.summer_2019"]<-(-1)
contr.treat5["autumn_2019","half.autumn_2019"]<-1
contr.treat5["autumn_2020","half.autumn_2020"]<-1
contr.treat5["autumn_2021","half.autumn_2021"]<-1
contr.treat5["summer_2020","half.summer_2020"]<-1
contr.treat5["summer_2021","half.summer_2021"]<-1

contr.treat5[,"inv.summer_2019"]<-1
contr.treat5["autumn_2019","inv.autumn_2019"]<-(-1)
contr.treat5["autumn_2020","inv.autumn_2020"]<-(-1)
contr.treat5["autumn_2021","inv.autumn_2021"]<-(-1)
contr.treat5["summer_2020","inv.summer_2020"]<-(-1)
contr.treat5["summer_2021","inv.summer_2021"]<-(-1)
rowSums(contr.treat5) # rows should sum up to 0

# contrast test to the half cut treatments
Treat1.effect<-glht(m3, linfct = mcp(TreatDate  = contr.treat5))
Treat1.effect
summary(Treat1.effect)
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between half- cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("c)      ",side=1,line=1.8,font=2,cex=1.1,adj=0)


# 4) contrast test to half-cut compared to reference plots
contr.treat6<-matrix(0,nrow=length(RN),ncol=nlevels(asc$TreatDate))
row.names(contr.treat6)<-RN
colnames(contr.treat6)<-levels(asc$TreatDate)
contr.treat6[,"half.summer_2019"]<-(-1)
contr.treat6["autumn_2019","half.autumn_2019"]<-1
contr.treat6["autumn_2020","half.autumn_2020"]<-1
contr.treat6["autumn_2021","half.autumn_2021"]<-1
contr.treat6["summer_2020","half.summer_2020"]<-1
contr.treat6["summer_2021","half.summer_2021"]<-1

contr.treat6[,"control.summer_2019"]<-1
contr.treat6["autumn_2019","control.autumn_2019"]<-(-1)
contr.treat6["autumn_2020","control.autumn_2020"]<-(-1)
contr.treat6["autumn_2021","control.autumn_2021"]<-(-1)
contr.treat6["summer_2020","control.summer_2020"]<-(-1)
contr.treat6["summer_2021","control.summer_2021"]<-(-1)
rowSums(contr.treat6) # rows should sum up to 0

# contrast test to half-cut treatments
Treat1.effect<-glht(m3, linfct = mcp(TreatDate  = contr.treat6))
Treat1.effect
summary(Treat1.effect)
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between half- cut and reference plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("d)      ",side=1,line=1.8,font=2,cex=1.1,adj=-0.03)

#########################################################xxxxx
#model to annual plants covers

asc$Ann_t<-asin(sqrt(asc$Ann_cover/100))
hist(asc$Ann_t)
m4 = glmmTMB(Ann_t~TreatDate +(1| ID_site/ID_plot/ID_subplot), data = asc) # ez lezs a j?
Anova(m4)
simulationOutput <- simulateResiduals(fittedModel = m4)
plot(simulationOutput)
testDispersion(m4) 

# used same contrast matrix test:  1- total-uncut, 2 total-reference, 3-half-uncut, 4 half-reference plots
# 1) contrast_total compared to uncut plots
par(mar=c(6,7,4,5)+0.1)
Treat1.effect<-glht(m4, linfct = mcp(TreatDate  = contr.treat3))
Treat1.effect
summary(Treat1.effect)
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in annuals cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("a)      ",side=1,line=1.8,font=2,cex=1.1,adj=0)

# 2) contrast_total cut compared to reference plots
Treat1.effect<-glht(m4, linfct = mcp(TreatDate  = contr.treat4))
Treat1.effect
summary(Treat1.effect)
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
# text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between total cut and reference plots 
     in annuals cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("b)      ",side=1,line=1.8,font=2,cex=1.1,adj=-0.03)




# 3) contrast test to half cut compared to uncut plots
Treat1.effect<-glht(m4, linfct = mcp(TreatDate  = contr.treat5))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and uncut plots in Annuals cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
# text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and uncut plots 
     in annuals cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("c)      ",side=1,line=1.8,font=2,cex=1.1,adj=0)



# 4) contrast to the half cut compared to reference plots
Treat1.effect<-glht(m4, linfct = mcp(TreatDate  = contr.treat6))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and reference plots in Annuals cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
# text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and reference plots 
     in annuals cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("d)      ",side=1,line=1.8,font=2,cex=1.1,adj=-0.03)

#########################################################xxxxx
#modell_perennials cover

asc$Per_t<-asin(sqrt(asc$Per_cover/100))
hist(asc$Per_t)
m5= glmmTMB(Per_t~TreatDate +(1| ID_site/ID_plot/ID_subplot), data = asc) 
Anova(m5)
simulationOutput <- simulateResiduals(fittedModel = m5)
plot(simulationOutput)
testDispersion(m5) 

# contrast matrix same way: 3- total-uncut, 4 total-control, 5-half-uncut, 6 half-control
# 1) contrast to total cut compared to uncut
par(mar=c(6,7,4,5)+0.1)
Treat1.effect<-glht(m5, linfct = mcp(TreatDate  = contr.treat3))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots in Perennials cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
# text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between totalcut and uncut plots 
     in perennial cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("a)      ",side=1,line=1.8,font=2,cex=1.1,adj=0)

# 2) contrast to total cut compared to reference plots
Treat1.effect<-glht(m5, linfct = mcp(TreatDate  = contr.treat4))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""),  xlab="Difference between total cut and reference plots in Perennials cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between total cut and reference plots 
     in perennial cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("b)      ",side=1,line=1.8,font=2,cex=1.1,adj=-0.03)


# 3) contrast to half cut compared to uncut
Treat1.effect<-glht(m5, linfct = mcp(TreatDate  = contr.treat5))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and uncut plots in Perennials cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and uncut plots 
     in perennial cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("c)      ",side=1,line=1.8,font=2,cex=1.1,adj=0)



# 4) contrast half cut compared to reference 
Treat1.effect<-glht(m5, linfct = mcp(TreatDate  = contr.treat6))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and reference plots in Perennials cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and reference plots 
     in perennial cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("d)      ",side=1,line=1.8,font=2,cex=1.1,adj=-0.03)





#########################################################
#model_Specialist plant covers

asc$Spec_t<-asin(sqrt(asc$Spec_cover/100))
hist(asc$Spec_t)
m6 = glmmTMB(Spec_t~TreatDate +(1| ID_site/ID_plot/ID_subplot), data = asc, se=F) 
Anova(m6)
simulationOutput <- simulateResiduals(fittedModel = m6)
plot(simulationOutput)
testDispersion(m6) 

# contrast matrix test ways 
# 1) contrast to total cut compared to uncut 
par(mar=c(6,7,4,5)+0.1)
Treat1.effect<-glht(m6, linfct = mcp(TreatDate  = contr.treat3))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots in Specialists cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in specialist cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("a)      ",side=1,line=1.8,font=2,cex=1.1,adj=0)



# 2) contrast to total cut compared to the reference 
Treat1.effect<-glht(m6, linfct = mcp(TreatDate  = contr.treat4))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and reference plots in Specialists cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between total cut and reference plots 
     in specialist cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("b)      ",side=1,line=1.8,font=2,cex=1.1,adj=-0.03)



# 3) contrast half cut compared to uncut
Treat1.effect<-glht(m6, linfct = mcp(TreatDate  = contr.treat5))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and uncut plots in Specialists cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and uncut plots 
     in specialist cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("c)      ",side=1,line=1.8,font=2,cex=1.1,adj=0)



# 4) contrast half cut compared to the reference
Treat1.effect<-glht(m6, linfct = mcp(TreatDate  = contr.treat6))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and reference plots in Specialists cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and reference plots 
     in specialist cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("d)      ",side=1,line=1.8,font=2,cex=1.1,adj=-0.03)





#########################################################xxxxx
#model to the weed plants covers

asc$Weed_t<-asin(sqrt(asc$Weed_cover/100))
hist(asc$Weed_t)
m7= glmmTMB(Weed_t~TreatDate +(1| ID_site/ID_plot/ID_subplot), data = asc) 
Anova(m7)
simulationOutput <- simulateResiduals(fittedModel = m7)
plot(simulationOutput)
testDispersion(m7) 

# same contrast matrix test  
# 1) contrast_total cut compared to uncut
par(mar=c(6,7,4,5)+0.1)
Treat1.effect<-glht(m7, linfct = mcp(TreatDate  = contr.treat3))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots in Weed cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in weed cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("a)      ",side=1,line=1.8,font=2,cex=1.1,adj=0)


# 2) contrast to total cut compared to reference
Treat1.effect<-glht(m7, linfct = mcp(TreatDate  = contr.treat4))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and reference plots in Weed cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between total cut and reference plots 
     in weed cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("b)      ",side=1,line=1.8,font=2,cex=1.1,adj=-0.03)



# 3) contrast to half cut compared to uncut
Treat1.effect<-glht(m7, linfct = mcp(TreatDate  = contr.treat5))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and uncut plots in Weed cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and uncut plots 
     in weed cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("c)      ",side=1,line=1.8,font=2,cex=1.1,adj=0)

# 4) contrast half cut compared to the reference
Treat1.effect<-glht(m7, linfct = mcp(TreatDate  = contr.treat6))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and reference plots in Weed cover")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in generalists cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
text(-0.1, 5.5, "a)",cex=1.2)

par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and reference plots 
     in weed cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("d)      ",side=1,line=1.8,font=2,cex=1.1,adj=-0.03)

#########################################################xxxxx

#Neophyte plants cover

asc$Neo_t<-asin(sqrt(asc$Neo_cover/100))
hist(asc$Neo_t)
m8 = glmmTMB(Neo_t~TreatDate +(1| ID_site/ID_plot/ID_subplot), data = asc) #ez a j?
Anova(m8)
simulationOutput <- simulateResiduals(fittedModel = m8)
plot(simulationOutput)
testDispersion(m8) 

# 1) contrast to total cut compared to uncut
Treat1.effect<-glht(m8, linfct = mcp(TreatDate  = contr.treat3))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, xlab="Difference between total cut on the cover of species flowering late - to uncut")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in neophytes cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots 
     in neophytes cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("a)      ",side=1,line=1.8,font=2,cex=1.1,adj=0)



# 2) contrast to total cut compared to the reference
Treat1.effect<-glht(m8, linfct = mcp(TreatDate  = contr.treat4))
Treat1.effect
summary(Treat1.effect)
# plot(Treat1.effect, xlab="Difference between total cut on the cover of species flowering late - to control")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and reference plots 
     in neophytes cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("b)      ",side=1,line=1.8,font=2,cex=1.1,adj=-0.03)



# 3) contrast to half cut compared to uncut
Treat1.effect<-glht(m8, linfct = mcp(TreatDate  = contr.treat5))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, xlab="Difference between half-cut on the cover of species flowering late-to uncut")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between half- cut and uncut plots 
     in neophytes cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("c)      ",side=1,line=1.8,font=2,cex=1.1,adj=0)


# 4) contrast to half cut compared to the reference  
Treat1.effect<-glht(m8, linfct = mcp(TreatDate  = contr.treat6))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, xlab="Difference between half-cut on the cover of species flowering late -to control")
par(mar=c(6,8,3,5)+0.1, cex.lab=1.1, mgp=c(3,0.55,0))
# plot(Treat1.effect, main=(""),  xlab="Difference between total cut and uncut plots in generalists cover", cex.lab = 4)
plot(Treat1.effect, main=(""), xlab="Difference between half- cut and reference plots 
     in neophytes cover", cex.lab=1.1, cex.axis=1.1, cex.main=1.1, cex.sub=1.1)
mtext("d)      ",side=1,line=1.8,font=2,cex=1.1,adj=-0.03)




######## native plants covers

asc$Ind_t<-asin(sqrt(asc$Ind_cover/100))
hist(asc$Ind_t)
m9 = glmmTMB(Ind_t~TreatDate +(1| ID_site/ID_plot/ID_subplot), data = asc) 
Anova(m9)
simulationOutput <- simulateResiduals(fittedModel = m9)
plot(simulationOutput)
testDispersion(m9)

# 1) contrast to total cut compared to uncut
Treat1.effect<-glht(m9, linfct = mcp(TreatDate  = contr.treat3))
Treat1.effect
summary(Treat1.effect)
par(mar=c(6,7,4,5)+0.1)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and uncut plots in Native cover")

# 2) contrast to total cut to the reference 
Treat1.effect<-glht(m9, linfct = mcp(TreatDate  = contr.treat4))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between total cut and reference plots in Native cover")

# 3) contrast_ to half cut to the uncut
Treat1.effect<-glht(m9, linfct = mcp(TreatDate  = contr.treat5))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and uncut plots in Native cover")

# 4) contrast to half cut to the to the reference 
Treat1.effect<-glht(m9, linfct = mcp(TreatDate  = contr.treat6))
Treat1.effect
summary(Treat1.effect)
plot(Treat1.effect, main=(""), xlab="Difference between half-cut and reference plots in Native cover")

