
adat<-read.csv("As_kiserlet_3ev_cover_2.csv",header=T,sep=";",dec=",")
str(adat)
unique(as.character(adat$Year))

adat<-adat[which(adat$Date02==20190611),]

str(adat)
adat$Year

attach(adat)
tail(adat)

class(adat$ID_site)
class(adat$ID_plot)
class(adat$ID_subplot)


adat$ID_site<-as.factor(adat$ID_site)
adat$ID_subplot<-as.factor(adat$ID_subplot)

adat$State<-factor(adat$State, levels = c("cont", "inv"))

adat.mod<-adat[,c("State", "Annual_cover", "Perennial_cover", "Generalist_cover", "Specialist_cover","Weed_cover", "Neophyte_cover", "Native_cover")]


#library(nlme)
library(lme4) 
#library(lmerTest)
#library (multcomp) 
library(DHARMa) 
library(glmmTMB) 
library(ggeffects)

#1.) Annual cover compared between invaded and not invaded plots
# the modell
#options(contrasts = c("contr.sum","contr.poly"))
m1.2 = glmmTMB(Annual_cover~State +(1| ID_site:ID_plot), data = adat.mod,  family="tweedie")
summary(m1.2)
Anova(m1.2)

simulationOutput <- simulateResiduals(fittedModel = m1.2, plot = F)
residuals(simulationOutput)
plot(simulationOutput)

w<-plot(ggeffect(m1.2, cex.axis=1.4, cex.sub=1.1,terms="State",type="re"))
# w<-plot(ggeffect(m1.2, terms="State", cex.axis=3, cex.sub=2))

w


w<-plot(ggeffect(m1.2, terms="State",type="re"),rawdata=T)
w

par(mar=c(4,5,1,1))
boxplot(Annual_cover~State, xlab=("State_2019"), ylab=("Annual plants cover (%)"), col = c("indianred", "azure3")) 
legend("topright", inset=0.00001, 0.5, title = "State_2019",
       c("Cont:not invaded", "Inv:invaded by common milkweed"), fill=c("indianred", "azure3"), horiz=FALSE, cex=0.72)



#2.) Perennial cover compared between invaded and not invaded plots
# the modell:
# options(contrasts = c("contr.sum","contr.poly")) 
m2.2 = glmmTMB(Perennial_cover~State +(1| ID_site:ID_plot), data = adat.mod,  family="tweedie")
summary(m2.2)
Anova(m2.2)

simulationOutput <- simulateResiduals(fittedModel = m2.2, plot = F)
residuals(simulationOutput)
plot(simulationOutput)

w<-plot(ggeffect(m2.2, cex.axis=1.4, cex.sub=1.1,terms="State",type="re"))

w

w<-plot(ggeffect(m2.2, terms="State",type="re"),rawdata=T)
w


par(mar=c(4,5,1,1))
boxplot(Perennial_cover~State, xlab=("State_2019"), ylab=("Perennial plants cover (%)"), col = c("indianred", "azure3")) 
legend("topright", inset=0.00001, 0.5, title = "State_2019",
       c("Cont:not invaded", "Inv:invaded by common milkweed"), fill=c("indianred", "azure3"), horiz=FALSE, cex=0.72)



#3.) Generalist cover compared between invaded and not invaded plots
# the modell:
# options(contrasts = c("contr.sum","contr.poly")
m3.2 = glmmTMB(Generalist_cover~State +(1| ID_site:ID_plot), data = adat.mod,  family="tweedie")
summary(m3.2)
Anova(m3.2)

simulationOutput <- simulateResiduals(fittedModel = m3, plot = F)
residuals(simulationOutput)
plot(simulationOutput)

w<-plot(ggeffect(m3.2, cex.axis=1.4, cex.sub=1.1,terms="State",type="re"))

w

w<-plot(ggeffect(m3.2, terms="State",type="re"),rawdata=T)
w



par(mar=c(4,5,1,1))
boxplot(Generalist_cover~State, xlab=("State_2019"), ylab=("Generalist plants cover (%)"), col = c("indianred", "azure3")) 
legend("topright", inset=0.00001, 0.5, title="State_2019",
       c("Cont:not invaded", "Inv:invaded by common milkweed"), fill=c("indianred", "azure3"), horiz=FALSE, cex=0.72)




#4.) Specialist cover compared between invaded and not invaded plots
# the modell:
# options(contrasts = c("contr.sum","contr.poly")
adat.mod$Spec_t<-asin(sqrt(adat.mod$Specialist_cover/100))
#arc-sine transformation 
m4.3 = glmmTMB(Spec_t~State +(1| ID_site:ID_plot), data = adat.mod) 

simulationOutput <- simulateResiduals(fittedModel = m4.3, plot = F)
residuals(simulationOutput)
plot(simulationOutput)


summary(m4.3)
Anova(m4.3)


w<-plot(ggeffect(m4.3, cex.axis=1.4, cex.sub=1.1,terms="State",type="re"))

w

w<-plot(ggeffect(m4.3, terms="State",type="re"),rawdata=T)
w

par(mar=c(4,5,1,1))
boxplot(Specialist_cover~State, xlab=("State_2019"), ylab=("Specialist plants cover (%)"), col = c("indianred", "azure3")) 
legend("topright", inset=0.00001, 0.5, title = "State_2019",
       c("Cont:not invaded", "Inv:invaded by common milkweed"), fill=c("indianred", "azure3"), horiz=FALSE, cex=0.72)



#5.) Weed cover compared between invaded and not invaded plots
# the modell:
# options(contrasts = c("contr.sum","contr.poly"))
m5.2 = glmmTMB(Weed_cover~State +(1| ID_site:ID_plot), data = adat.mod,  family="tweedie")
summary(m5.2)
Anova(m5.2)

simulationOutput <- simulateResiduals(fittedModel = m5.2, plot = F)
residuals(simulationOutput)
plot(simulationOutput)

w<-plot(ggeffect(m5.2, cex.axis=1.4, cex.sub=1.1,terms="State",type="re"))

w

w<-plot(ggeffect(m5.2, terms="State",type="re"),rawdata=T)
w


par(mar=c(4,5,1,1))
boxplot(Weed_cover~State, xlab=("State_2019"), ylab=("Weed cover"), col = c("indianred", "azure3")) 
legend("topright", inset=0.00001, 0.5, title = "State_2019",
       c("Cont:not invaded", "Inv:invaded by common milkweed"), fill=c("indianred", "azure3"), horiz=FALSE, cex=0.72)




#6.) Neophyte cover compared between invaded and not invaded plots
# the modell:
# options(contrasts = c("contr.sum","contr.poly"))
m6.2 = glmmTMB(Neophyte_cover~State +(1| ID_site:ID_plot), data = adat.mod,  family="tweedie")
summary(m6.2)
Anova(m6.2)

simulationOutput <- simulateResiduals(fittedModel = m6.2, plot = F)
residuals(simulationOutput)
plot(simulationOutput)

w<-plot(ggeffect(m6.2, cex.axis=1.4, cex.sub=1.1,terms="State",type="re"))

w

w<-plot(ggeffect(m6.2, terms="State",type="re"),rawdata=T)
w

par(mar=c(4,5,1,1))
boxplot(Neophyte_cover~State, xlab=("State_2019"), ylab=("Neophyte plants cover"), col = c("indianred", "azure3")) 
legend("topright", inset=0.00001, 0.5, title = "State_2019",
       c("Cont:not invaded", "Inv:invaded by common milkweed"), fill=c("indianred", "azure3"), horiz=FALSE, cex=0.72)
title("State_2019, Neophytes")



#7.) Native cover compared between invaded and not invaded plots
# the modell:
# options(contrasts = c("contr.sum","contr.poly"))

m7.2 = glmmTMB(Native_cover~State +(1| ID_site:ID_plot), data = adat.mod,  family="tweedie")
summary(m7.2)
Anova(m7.2)

simulationOutput <- simulateResiduals(fittedModel = m7.2, plot = F)
residuals(simulationOutput)
plot(simulationOutput)

w<-plot(ggeffect(m7.2, cex.axis=1.4, cex.sub=1.1,terms="State",type="re"))

w

w<-plot(ggeffect(m7.2, terms="State",type="re"),rawdata=T)
w

par(mar=c(4,5,1,1))
boxplot(Native_cover~State, xlab=("State_2019"), ylab=("Indigenuous plants cover"), col = c("indianred", "azure3")) 
legend("topright", inset=0.00001, 0.5, title = "State_2019",
       c("Cont:not invaded", "Inv:invaded by common milkweed"), fill=c("indianred", "azure3"), horiz=FALSE, cex=0.72)
