!######################################################################################
SUBROUTINE READ_NAMELIST(IOUTDIAG_UNIT,NB_TIME_STEPS, DELTA_T, &
                         GRID_FILENAME, &
                         CTYPE_FCT, VALUE, CNAME_FILE, &
                         NB_RECV_FIELDS, CRCVFIELDS, &
                         NB_SEND_FIELDS, CSNDFIELDS )
!######################################################################################
!
IMPLICIT NONE
!
!
INTEGER :: IOUTDIAG_UNIT
INTEGER :: IND
!
!-- NAM_OASIS
INTEGER, INTENT(OUT) :: NB_TIME_STEPS ! number of time steps
INTEGER, INTENT(OUT) :: DELTA_T          ! time step
CHARACTER(LEN=30), INTENT(OUT) :: GRID_FILENAME
!
!-- NAM_FCT_SEND
CHARACTER(LEN=5), INTENT(OUT) :: CTYPE_FCT
REAL, INTENT(OUT) :: VALUE
CHARACTER(LEN=30), INTENT(OUT) :: CNAME_FILE
!
!-- NAM_RECV_FIELDS
INTEGER, INTENT(OUT) :: NB_RECV_FIELDS
INTEGER, PARAMETER :: NB_RECV_FIELDS_MAX=50
CHARACTER(LEN=8), DIMENSION(NB_RECV_FIELDS_MAX), INTENT(OUT) :: CRCVFIELDS
!
!-- NAM_SEND_FIELDS
INTEGER, INTENT(OUT) :: NB_SEND_FIELDS
INTEGER, PARAMETER :: NB_SEND_FIELDS_MAX=50
CHARACTER(LEN=8), DIMENSION(NB_SEND_FIELDS_MAX), INTENT(OUT) :: CSNDFIELDS
!
NAMELIST /NAM_OASIS/ NB_TIME_STEPS, DELTA_T, GRID_FILENAME
NAMELIST /NAM_FCT_SEND/ CTYPE_FCT, VALUE, CNAME_FILE
NAMELIST /NAM_RECV_FIELDS/ NB_RECV_FIELDS, CRCVFIELDS
NAMELIST /NAM_SEND_FIELDS/ NB_SEND_FIELDS, CSNDFIELDS
!
OPEN(UNIT=10,FILE='TOYNAMELIST.nam', ACTION='READ')
READ(UNIT=10,NML=NAM_OASIS)
READ(UNIT=10,NML=NAM_FCT_SEND)
READ(UNIT=10,NML=NAM_RECV_FIELDS)
READ(UNIT=10,NML=NAM_SEND_FIELDS)
CLOSE(UNIT=10)
!
! VERIFICATION
WRITE(IOUTDIAG_UNIT,*) 'NB_TIME_STEPS=', NB_TIME_STEPS
WRITE(IOUTDIAG_UNIT,*) 'DELTA_T=', DELTA_T
WRITE(IOUTDIAG_UNIT,*) 'GRID_FILENAME=', GRID_FILENAME
!
WRITE(IOUTDIAG_UNIT,*) 'CTYPE_FCT=', CTYPE_FCT
WRITE(IOUTDIAG_UNIT,*) 'VALUE=', VALUE
WRITE(IOUTDIAG_UNIT,*) 'CNAME_FILE=', CNAME_FILE
!
WRITE(IOUTDIAG_UNIT,*) 'NB_RECV_FIELDS=', NB_RECV_FIELDS
DO IND=1, NB_RECV_FIELDS
  WRITE(IOUTDIAG_UNIT,*) 'CRCVFIELDS(',IND,')=', CRCVFIELDS(IND)
END DO
!
WRITE(IOUTDIAG_UNIT,*) 'NB_SEND_FIELDS=', NB_SEND_FIELDS
DO IND=1, NB_SEND_FIELDS
  WRITE(IOUTDIAG_UNIT,*) 'CSNDFIELDS(',IND,')=', CSNDFIELDS(IND)
END DO
!
END SUBROUTINE READ_NAMELIST
