  !**********************************************************************************************
  SUBROUTINE READ_FORCING (IOUTDIAG_UNIT,NBFIELDS,INDI_BEG,INDI_END,INDJ_BEG,INDJ_END,IB, GRID_FILENAME,CSNDFIELDS, &
                           NLON, NLAT, GRID_LON, GRID_LAT, FORCING_DATA)
  !**********************************************************************************************
  !
  USE NETCDF
  IMPLICIT NONE
  !
  INTEGER :: ILOOP
  !
  INTEGER :: NCID, NDIMS, UNLIMDIMID
  INTEGER :: IL_LON_ID, IL_LAT_ID, IL_TIME_ID 
  !
  INTEGER, DIMENSION(3) :: NDIM
  INTEGER :: NX, NY, NT
  CHARACTER(LEN=50), DIMENSION(3) :: CNAME_DIM
  CHARACTER(LEN=50) :: VNAME
  INTEGER, DIMENSION(2) :: DIMIDS
  INTEGER :: XTYPE, VARID
  !
  INTEGER, INTENT(IN) :: IOUTDIAG_UNIT, NBFIELDS
  INTEGER, INTENT(IN) :: INDI_BEG,INDI_END,INDJ_BEG,INDJ_END, IB
  INTEGER, INTENT(IN) :: NLON, NLAT, GRID_LON, GRID_LAT
  !
  INTEGER, DIMENSION(NBFIELDS) :: IL_VAR_ID
  !
  CHARACTER(len=30), INTENT(IN) :: GRID_FILENAME
  CHARACTER(LEN=8), DIMENSION(10), INTENT(IN) :: CSNDFIELDS
  !
  INTEGER, DIMENSION(3) :: ILA_DIM
  !
  REAL, ALLOCATABLE, DIMENSION(:,:,:) :: READING_DATA
  REAL, DIMENSION(NLON,NLAT,10), INTENT(OUT) :: FORCING_DATA
  !
  !
  !*********** OPEN NCDF FILE
  CALL HDLERR(NF90_OPEN(GRID_FILENAME, NF90_NOWRITE, NCID),__LINE__,__FILE__)
  !
  CALL HDLERR(NF90_INQUIRE(NCID, NDIMENSIONS=NDIMS, UNLIMITEDDIMID=UNLIMDIMID),__LINE__,__FILE__)
  !
  CALL HDLERR(NF90_INQUIRE_DIMENSION(NCID,1,CNAME_DIM(1),NDIM(1)),__LINE__,__FILE__)
  CALL HDLERR(NF90_INQUIRE_DIMENSION(NCID,2,CNAME_DIM(2),NDIM(2)),__LINE__,__FILE__)
  CALL HDLERR(NF90_INQUIRE_DIMENSION(NCID,3,CNAME_DIM(3),NDIM(3)),__LINE__,__FILE__)
  !
  DO ILOOP=1, 3
    IF ( (CNAME_DIM(ILOOP) .EQ. 'ni') .OR. (CNAME_DIM(ILOOP) .EQ. 'longitude') .OR. (CNAME_DIM(ILOOP) .EQ. 'nlon') .OR. (CNAME_DIM(ILOOP) .EQ. 'xi_rho') .OR. (CNAME_DIM(ILOOP) .EQ. 'xi_u') .OR. (CNAME_DIM(ILOOP) .EQ. 'xi_v') ) THEN
      NX=NDIM(ILOOP)
    ELSE IF ( (CNAME_DIM(ILOOP) .EQ. 'nj') .OR. (CNAME_DIM(ILOOP) .EQ. 'latitude') .OR. (CNAME_DIM(ILOOP) .EQ. 'nlat') .OR. (CNAME_DIM(ILOOP) .EQ. 'eta_rho') .OR. (CNAME_DIM(ILOOP) .EQ. 'eta_u') .OR. (CNAME_DIM(ILOOP) .EQ. 'eta_v') ) THEN
      NY=NDIM(ILOOP)
    ELSE IF (CNAME_DIM(ILOOP) .EQ. 'time' .OR. (CNAME_DIM(ILOOP) .EQ. 'ntime') ) THEN
      NT=NDIM(ILOOP)
    END IF
  END DO
  !
  ALLOCATE(READING_DATA(NX,NY,NT))
  !

  !CALL HDLERR( NF90_INQ_VARID(NCID, 'longitude', IL_LON_ID),__LINE__,__FILE__)
  !CALL HDLERR( NF90_INQ_VARID(NCID, 'latitude', IL_LAT_ID),__LINE__,__FILE__)
  !CALL HDLERR( NF90_INQ_VARID(NCID, 'time', IL_TIME_ID),__LINE__,__FILE__ )

  DO ILOOP=1, NBFIELDS
    CALL HDLERR( NF90_INQ_VARID(NCID, TRIM(CSNDFIELDS(ILOOP)), IL_VAR_ID(ILOOP)), __LINE__,__FILE__ )
    CALL HDLERR(NF90_INQUIRE_VARIABLE(NCID,IL_VAR_ID(ILOOP),VNAME,XTYPE,NDIMS,ILA_DIM), __LINE__,__FILE__)
    CALL HDLERR(NF90_INQ_VARID(NCID,VNAME,VARID), __LINE__,__FILE__)
    CALL HDLERR(NF90_GET_VAR(NCID,VARID,READING_DATA), __LINE__,__FILE__)
    FORCING_DATA(:,:,ILOOP)=RESHAPE(READING_DATA(INDI_BEG:INDI_END,INDJ_BEG:INDJ_END,IB),&
                           (/ NLON, NLAT /))
  END DO
  !
  !************* CLOSE NCDF FILE
  CALL HDLERR( NF90_CLOSE(NCID), __LINE__,__FILE__ )
  !
END SUBROUTINE READ_FORCING
