#########################################################################
# This is a typical input file for OASIS3-MCT.
# Keywords used in previous versions of OASIS3 
# but now obsolete are marked "Not used"
# Don't hesitate to ask precisions or make suggestions (oasishelp@cerfacs.fr). 
#
# Any line beginning with # is ignored. Blank lines are not allowed.
#
#########################################################################
#
# NFIELDS: total number of fields being exchanged
 $NFIELDS
 3
#########################################################################
# NBMODEL: number of models and their names (6 characters) 
 $NBMODEL
 2  wrfexe   wwatch
###########################################################################
# RUNTIME: total simulated time for the actual run in seconds (<I8)
 $RUNTIME
 <runtime>
###########################################################################
# NLOGPRT: debug and time statistics informations printed in log file 
#          First number: 0 one log file for master, and one for other procs
#                        1 one log file for master, and one for other errors
#                        2 one file per proc with normal diagnostics
#                        5 as 2 + initial debug info
#                        10 as 5 + routine calling tree
#                        12 as 10 + some routine calling notes
#                        15 as 12 + even more debug diagnostics
#                        20 as 15 + some extra runtime analysis
#                        30 full debug information
#          Second number: time statistics
#          		 0 nothing calculated
#          		 1 one file for proc 0 and min/max of other procs
#          		 2 as 1 + one file per proc
#          		 3 as 2 + proc 0 writes all procs results in its file
 $NLOGPRT
 1 1
###########################################################################
# Beginning of fields exchange definition
 $STRINGS
#
# For each exchanged field:
#
# line 1: field in sending model, field in target model, unused, coupling 
#         period, number of transformation, restart file, field status
# line 2: nb of pts for sending model grid (without halo) first dim, and second dim,
#         for target grid first dim, and second dim, sending model grid name, target 
#         model grid name, lag = time step of sending model
# line 3: sending model grid periodical (P) or regional (R), and nb of overlapping 
#         points, target model grid periodical (P) or regional (R), and number of
#         overlapping points
# line 4: list of transformations performed
# line 5: parameters for each transformation
#
# See the correspondances between variables in models and in OASIS:
# Note: for CROCO and WRF nesting capability is useable in coupled 
#       mode. For CROCO the domain in defined by the last number 
#       of coupled field name. For WRF, WRF domain is defined by
#       the number after WRF_d, and the domain of the coupled model
#       (CROCO for example) is given by EXT_d in coupled field name 
#
# |--------------------------------------------------------------|
# | Possibly sent fields by CROCO:                 CROCO | OASIS |
# |--------------------------------------------------------------|
# |     t(:,:,N,nnew,itemp)  |    SRMSSTV0                       |
# |                   zeta   |    SRMSSHV0                       |
# |     u v (at rho points)  |    SRMVOCE0 SRMUOCE0              |
# |--------------------------------------------------------------|
# | Possibly received fields by CROCO:            CROCO | OASIS  |
# |--------------------------------------------------------------|
# |                  srflx   |    RRMSRFL0                       |
# |       stflx(:,:,isalt)   |    RRMEVPR0                       |
# |      stflx(,:,:,itemp)   |    RRMSTFL0                       |
# |                  sustr   |    RRMTAUX0                       |
# |                  svstr   |    RRMTAUY0                       |
# |                  smstr   |    RRMTAUM0                       |
# |                  whrm    |    RRM__HS0                       |
# |                  wfrq    |    RRMT0M10                       |
# |                  wdrx    |    RRMCDIR0                       |
# |                  wdre    |    RRMSDIR0                       |
# |--------------------------------------------------------------|
# | Possibly sent fields by WW3:                    WW3 | OASIS  |
# |--------------------------------------------------------------|
# |            not defined   |    WW3_ODRY                       |
# |                   T0M1   |    WW3_T0M1                       |
# |                     HS   |    WW3__OHS                       |
# |                    DIR   |    WW3_CDIR WW3_SDIR              |
# |                    BHD   |    WW3__BHD                       |
# |                    TWO   |    WW3_TWOX WW3_TWOY              |
# |                    UBR   |    WW3__UBR                       |
# |                    FOC   |    WW3__FOC                       |
# |                    TAW   |    WW3_TAWX WW3_TAWY              |
# |                     LM   |    WW3___LM                       |
# |                    CUR   |    WW3_WSSU WW3_WSSV              |
# |                    CHA   |    WW3__CHA                       |
# |                     HS   |    WW3__AHS                       |
# |                     FP   |    WW3___FP                       |
# |--------------------------------------------------------------|
# | Possibly received fields by WW3:                WW3 | OASIS  |
# |--------------------------------------------------------------|
# |            not defined   |    WW3_OWDH WW3_OWDU WW3_OWDV     |
# |                    SSH   |    WW3__SSH                       |
# |                    CUR   |    WW3_OSSU WW3_OSSV              |
# |                    WND   |    WW3__U10 WW3__V10              |
# |--------------------------------------------------------------|
# | Possibly sent fields by WRF:                    WRF | OASIS  |
# |--------------------------------------------------------------|
# |                GSW   |    WRF_d01_EXT_d01_SURF_NET_SOLAR     |
# |        QFX-(RAINCV                                           |
# |       +RAINNCV)/DT   |    WRF_d01_EXT_d01_EVAP-PRECIP        |
# |   GLW-STBOLT*EMISS                                           |
# |     *SST**4-LH-HFX   |    WRF_d01_EXT_d01_SURF_NET_NON-SOLAR |
# | taut * u_uo / wspd   |    WRF_d01_EXT_d01_TAUX               |
# | taut * u_uo / wspd   |    WRF_d01_EXT_d01_TAUY               |
# |               taut   |    WRF_d01_EXT_d01_TAUMOD             |
# |               u_uo   |    WRF_d01_EXT_d01_U_01               |
# |               v_vo   |    WRF_d01_EXT_d01_V_01               |
# |--------------------------------------------------------------|
# | Possibly received fields by WRF:                WRF | OASIS  |
# |--------------------------------------------------------------|
# |                    SST   |    WRF_d01_EXT_d01_SST            |
# |                   UOCE   |    WRF_d01_EXT_d01_UOCE           |
# |                   VOCE   |    WRF_d01_EXT_d01_VOCE           |
# |               CHA_COEF   |    WRF_d01_EXT_d01_CHA_COEF       |
# |--------------------------------------------------------------|
#
#                     ------------------------------------
#                        WRF (wrfexe) ==> WW3 (wwatch)
#                     ------------------------------------
#~~~~~~~~~~~
# U_01 : wind U component at first level (m/s)
#~~~~~~~~~~~
WRF_d01_EXT_d01_U_01 WW3__U10 1 <cpldt>  1  atm.nc  EXPORTED
<atmnx> <atmny> <wavnx> <wavny> atmt ww3t LAG=<atmdt>
R 0 R 0
SCRIPR
DISTWGT LR SCALAR LATLON 1 4
#
#~~~~~~~~~~~
# V_01 : wind V component at first level (m/s)
#~~~~~~~~~~~
WRF_d01_EXT_d01_V_01 WW3__V10 1 <cpldt>  1  atm.nc  EXPORTED
<atmnx> <atmny> <wavnx> <wavny> atmt ww3t LAG=<atmdt>
R 0 R 0
SCRIPR
DISTWGT LR SCALAR LATLON 1 4
#
#                     ------------------------------------
#                        WW3 (wwatch) ==> WRF (wrfexe)
#                     ------------------------------------
#
#~~~~~~~~~~~
# CHA_COEF : Charnock coefficient
#~~~~~~~~~~~
WW3__CHA WRF_d01_EXT_d01_CHA_COEF 1 <cpldt>  1  wav.nc  EXPORTED
<wavnx> <wavny> <atmnx> <atmny> ww3t atmt LAG=<wavdt>
R  0  R  0
SCRIPR
DISTWGT LR SCALAR LATLON 1 4
#
###########################################################################
$END
