
library(secsse)
library(ape)
library(geiger)
library(BioGeoBEARS)
library(ape)
library(phytools)
library(stringr)
library(deSolve)
library(apTreeshape)
library(phytools)
library(Matrix)
library(lemad)
library(DDD)
library(phylocanvas)
library(phylobase)
library(nodiv)
library(doParallel)
library(foreach)
library(doMC)
source("function_divalike.R")
II <- 3

amazilia_tree <- read.tree("humm_phylo.nex")


amazilia_distribution <- read.csv(file="humm_distribution.csv")


single_otu <- amazilia_distribution$species

to_remove_tree <- NULL
for(i in 1:length(amazilia_tree$tip.label)){
  
  if(any(amazilia_tree$tip.label[i] == single_otu) == FALSE ){
    to_remove_tree <- c(to_remove_tree,amazilia_tree$tip.label[i])
  }
}

amazilia_tree <- drop.tip(amazilia_tree,to_remove_tree)


plot.phylo(amazilia_tree,show.tip.label = FALSE,cex = 0.7)
plot.phylo(amazilia_tree,show.tip.label = TRUE,cex = 0.5)

rownames(amazilia_distribution) <- amazilia_distribution$species
name.check(amazilia_tree, amazilia_distribution, data.names=NULL)




amazilia_distribution$region <- toupper(amazilia_distribution$region)

amazilia_distribution <- amazilia_distribution[order(match(amazilia_distribution$species,amazilia_tree$tip.label)),]

(amazilia_distribution$species) == (amazilia_tree$tip.label)

#alocasia_distribution <- alocasia_distribution$region

all_areas <- c("A","B","C","D","E","F")




phylotree_recons <- amazilia_tree
species_presence <- amazilia_distribution$region

missing_spp_areas <- list()
missing_spp_areas[[1]] <- c("A","B","AB")
missing_spp_areas[[2]] <- c(0.8,0.57,0.83)

###############

bd_estimates <- bd_ML(branching.times(phylotree_recons))
initial_lambda <- c(bd_estimates$lambda0/2,bd_estimates$lambda0/2)
initial_disperextirpation <- bd_estimates$lambda0/5

all_try_this_extinction <- c(NA,0.01,0.005)
try_this_extinction <- all_try_this_extinction[II]
if(is.na(try_this_extinction)){
  try_this_extinction <- "free"
}


species_presence[c(1,2,55,58)] <- "D"
species_presence[c(3,38,27,57)] <- "E"
species_presence[c(10,11,12,17)] <- "F"

cat("________doing this extinction: ",try_this_extinction,"_________\n")
Sys.time()
output <- lemad_analysis(
  phylotree_recons,
  species_presence,
  areas = all_areas,
  num_max_multiregion = 6,
  condition_on_origin = NULL,
  missing_spp_areas = missing_spp_areas,
  lineage_extinction = try_this_extinction,
  initial_lambda = initial_lambda,
  initial_disperextirpation,
  run_parallel = FALSE,
  use_fortran_code = TRUE)
Sys.time()
#saveRDS(output,file=paste0("lemad_ext_",try_this_extinction,".RDS"))
#########################


# 
# output <- cla_secsse_loglik(parameter, amazilia_tree,  amazilia_distribution$region, 
#                             use_fortran = TRUE, methode = "ode45", cond = "proper_cond",
#                             root_state_weight = "proper_weights", sampling_fraction,
#                             run_parallel = FALSE, setting_calculation = NULL,
#                             setting_parallel = NULL, see_ancestral_states = TRUE,
#                             loglik_penalty = 0)
# 
# 
# 

# 
# probabilities_at_node <- output$ancestral_states
# 
# 
# all_states <- give_me_states_combination(all_areas)
# highest_prob_state_lemad <- NULL
# for(ij in 1:nrow(probabilities_at_node)){
#   
#   id_order_state_highest <- which(max(probabilities_at_node[ij,])==probabilities_at_node[ij,])[1]
#   # cat(id_order_state_highest,"\n")
#   highest_prob_state_lemad <- c(highest_prob_state_lemad,all_states[id_order_state_highest])
# }
# 
# 
# 
# plot.phylo(amazilia_tree,show.tip.label = TRUE,cex=0.6,label.offset=0.7)
# title(paste0("Lemad ext_",try_this_extinction),cex.main=2)
# axisPhylo(side = 1, root.time = NULL, backward = TRUE)
# nodelabels(highest_prob_state_lemad,bg = "lightgreen",cex=0.9)
# #tiplabels(amazilia_distribution$region,bg = "lightgreen",cex=0.4)
# #abline(v=15, lty=3,lwd=3,col="red")
# #abline(h=15, lty=3,lwd=3,col="red")
# points(14.5,48,col="red",pch=18,cex=4)


