anc_state_plot_simulated_data <- function(phylotree_full,phylotree_recons,species_presence,
                                initialState_used,Ltable_and_traits,table_ancestral_area_artificial,
                                do_plot){
  phylotree <- phylotree_recons
  
  
  the_nodes <- names(branching.times(phylotree))
  table_ancestral_area <- data.frame(the_nodes,branching.times(phylotree),ances_state = NA)
  for(i in 1:nrow(table_ancestral_area)){
    
    if(any(round(table_ancestral_area[i,2],digits = 5) ==round(Ltable_and_traits[,1],digits = 5))){
      anc_state <- Ltable_and_traits[which(round(table_ancestral_area[i,2],digits = 5) ==round(Ltable_and_traits[,1],digits = 5)),5]
      table_ancestral_area[i,3] <- as.character(anc_state)
    } 
  }
  
  
  if(do_plot == TRUE){
      plot.phylo(phylotree,edge.color = "gray54",font = 1,cex = 0.3,
             label.offset = 1,no.margin = TRUE,edge.width = 2.2)
  
  tiplabels(species_presence)
  nodelabels(table_ancestral_area$ances_state)

  
  }

  
  ### FULL tree
  
  
  if(do_plot == TRUE){
  
  plot.phylo(phylotree_full,edge.color = "gray54",font = 1,cex = 0.3,
             label.offset = 1,no.margin = TRUE,edge.width = 2.2)
  
 
  species_presence_extinction_included <- NULL
  for(i in 1:length(phylotree_full$tip.label)){
    if(any(phylotree_full$tip.label[i]==phylotree_recons$tip.label)){ 
      
      species_presence_extinction_included <- c(species_presence_extinction_included,
                                                species_presence[which(phylotree_full$tip.label[i]==phylotree_recons$tip.label)])
    } else{
      
      species_presence_extinction_included <- c(species_presence_extinction_included,"extinct")
    }
    
  }
  
  
  species_presence_extinction_included
  
  
  tiplabels(species_presence_extinction_included)
  nodelabels(table_ancestral_area_artificial$ances_state) 
  }
  return(list(ances_state = table_ancestral_area$ances_state,
         nodes_times = table_ancestral_area[,-3]))
  
}
