Cla_SecSSE_simul<- function(ancestral_state,states,lambdas,the_mu,timeSimul,max_cycles,qs,maxSpec,the_traits_to_sim,crown_lineages_survival,differential_extinction){
  if (length(lambdas)!= length(states)){
    stop("Every state must have a single rate of speciation and extinction")
    
  }
  
  if(nrow(qs)!=length(states)){
    stop("Incorrect number of transition rates")
  }
  
  pool_init_states <- states
  
  
  
  if(differential_extinction == TRUE){
    
    # to give mu for each state, based on the geographic extent
    # under TRUE, cosmopolitan species have the_mu/length(area) times chances of extinction
    mus <- NULL
    for(i in 1:length(states)){
      mus <- c(mus,the_mu / nchar(states[i]))
    }
  } else {
    mus <- rep(the_mu,length(states))
  }
  
  
  
  
  #speciesID<-c(1,2)
  
  # while(length(speciesID)<=3 & length(unique(speciesTraits))!=length(states) ){
  # speciesTraits <- c(1,2) # to initialize the while loop  
  # while(length(unique(speciesTraits))!=length(states) ){
  
  if(is.null(ancestral_state)){
    initialState <- sample(pool_init_states,1)
  } else {
    initialState <- ancestral_state
    
  }
  
  
  
  
  # cat("initial state",initialState,"\n") 
  speciesTraits <- c(initialState)
  preTree <- simulate_process(timeSimul,states,mus,lambdas,qs,speciesTraits,crown_lineages_survival,maxSpec,max_cycles)
  Ltable_and_traits <- preTree$Ltable
  speciesTraits <- preTree$speciesTraits
  speciesID <- preTree$speciesID
  if(length(unique(speciesTraits))!=length(states) ){
    print("some states died out")
  }
  # }
  Ltable <-  Ltable_and_traits[,1:4]
  if(length(which(Ltable[,4] == 0)) >  4){
 
    if(length(speciesID) < maxSpec ){
      
      
      age <- timeSimul
      #stemTime<-Ltable[2,1]
      Ltable[which(Ltable[,4]==0),4]<--1
      Ltable[,1] = age - c(Ltable[,1])
      notmin1 = which(Ltable[,4] != -1)
      Ltable[notmin1,4] = age - c(Ltable[notmin1,4])
      Ltable[which(Ltable[,4] == age + 1),4] = -1
      phy_full <- L2phylo(Ltable,dropextinct = F)
      phy_recons <- L2phylo(Ltable,dropextinct = T)
      
      
      speciesTraits <- sort_the_traits(phy_recons,speciesTraits)
      Ltable_and_traits <- cbind(Ltable,mother_trait = Ltable_and_traits[,5])
      
      
      
      
      ## aritificial table ancestral states when extinction
      Ltable_artificial <- Ltable
      Ltable_artificial[,4] <- -1 # if we did not have extinction
      phy_artificial <- L2phylo(Ltable_artificial ,dropextinct = T)
      the_nodes <- names(branching.times(phy_artificial))
      table_ancestral_area_artificial <- data.frame(the_nodes,branching.times(phy_artificial),ances_state = NA)
      for(i in 1:nrow(table_ancestral_area_artificial)){
        
        if(any(round(table_ancestral_area_artificial[i,2],digits = 5) ==round(Ltable_and_traits[,1],digits = 5))){
          anc_state <- Ltable_and_traits[which(round(table_ancestral_area_artificial[i,2],digits = 5) ==round(Ltable_and_traits[,1],digits = 5)),5]
          table_ancestral_area_artificial[i,3] <- as.character(anc_state)
        } 
      }
      
      ### end of it
      
      
      
      
      return(list(phy_full=phy_full,phy_recons = phy_recons, speciesTraits=speciesTraits,
                  initialState=initialState,Ltable_and_traits=Ltable_and_traits,
                  table_ancestral_area_artificial=table_ancestral_area_artificial))
    } else {
      print("crown lineages died out")
      return(list(phy_recons="ds",traits=0))
    }
  } else {
    print("clade extinction")
    return(list(phy_recons="ds",traits=0))
  }
  
}