simulate_process <- function(timeSimul,states,mus,lambdas,qs,speciesTraits,crown_lineages_survival,maxSpec,max_cycles){
  
  timeStep<-0
  Ltable_and_traits<- data.frame(cbind(matrix(c(0,0,1,0),ncol=4,nrow=1,byrow=T)),mother_trait=speciesTraits) # parent state, 
    speciesID <- 1
  cycles <- 0

      while(length(speciesID) != 0  && timeStep <= timeSimul) {
        cat("time: ",timeStep,"cycles: ", cycles,"number of living species: ", length(speciesID), "\n")
        cycles <- cycles + 1 
      #while(length(speciesID != 0) ) {
      rates<-Rates(speciesID,states,speciesTraits,mus,lambdas,qs)
      species_mus<-rates$species_mus
      species_lambdas<-rates$species_lambdas
      shiftprob<-rates$shiftprob
      totalRate<-sum(species_mus,species_lambdas,shiftprob)
      timeElapsed <- rexp(1, rate = totalRate)
      timeStep <- timeStep + timeElapsed
      
      if(cycles == max_cycles){
        break
      }
      if(timeStep >= timeSimul)
      {
      break  
      }
      
      if(crown_lineages_survival){
      if(all(speciesID != 1) ){
        print("crown parents died")
        break
        
      }
        if(all(speciesID != 2) ){
          print("crown parents died")
          break
          
        }
      }  
      
      if(length(speciesID) >= maxSpec)
      {
        print("too many species")
        break  
      }
      ##Events
      ## 1=trait shift
      ## 2=speciation
      ## 3=extinction
      
      event<-sample(c(1,2,3),1,prob = c(sum(shiftprob),sum(species_lambdas),sum(species_mus)))
      
  
      
      if(length(speciesID)==1 && event==3)
      {
        print("Clade Extinction")
        break
      }
      # print("here")
      
      
      if (event==1){
        speciesTraits <- event_traitshift(shiftprob,speciesTraits,states,speciesID,qs)
        #speciesTraits<-eventShift
        # speciesTraits
       # cat("trait shift \n")
       # cat(speciesTraits, "\n")
      }
      
      if(event==2){
        #   cat("speciation, traits before \n")
       # cat(speciesTraits, "\n")
        
        
        eventSpec<-event_speciation(species_lambdas,states,lambdas,Ltable_and_traits,speciesTraits,speciesID,timeStep)
        Ltable_and_traits<-eventSpec$Ltable_and_traits
        speciesTraits<-eventSpec$speciesTraits
        speciesID<-eventSpec$speciesID
     
        
      #  cat("speciation, traits after \n")
       # cat(speciesTraits, "\n")
        
      }
      
      if(event==3){
        
        eventExt<-event_extinction(species_mus,speciesTraits,states,Ltable_and_traits,speciesID,mus,timeStep)
        
        speciesID<-eventExt$speciesID
        speciesTraits<-eventExt$speciesTraits
        Ltable_and_traits<-eventExt$Ltable_and_traits
        
      }
   
    }
    return(list(Ltable_and_traits=Ltable_and_traits,speciesID=speciesID,speciesTraits=speciesTraits))

}


Rates<-function(speciesID,states,speciesTraits,mus,lambdas,qs){
  species_mus<-NULL
  for(i in 1:length(speciesID)){
    species_mus<-c(species_mus,mus[which(states==speciesTraits[i])])
  }
  
  species_lambdas<-NULL
  for(i in 1:length(speciesID)){
    species_lambdas<-c(species_lambdas,sum(lambdas[[which(states==speciesTraits[i])]]))

    }
  
  shiftprob<-NULL
  for (i in 1:length(speciesID)){
    shiftprob<-c(shiftprob,sum(qs[which(speciesTraits[i]==states),],na.rm = T))
  }
  
  return(list(species_mus=species_mus,species_lambdas=species_lambdas,shiftprob=shiftprob))
  
}


event_extinction<-function(species_mus,speciesTraits,states,Ltable_and_traits,speciesID,mus,timeStep){
  dying<-sample(speciesID,1,prob=species_mus) 
  Ltable_and_traits[which(Ltable_and_traits[,3]==dying),4]<-timeStep
  speciesTraits<-speciesTraits[-which(speciesID==dying)]
  speciesID<- speciesID[-which(speciesID==dying)]
  return(list(speciesID=speciesID,speciesTraits=speciesTraits,Ltable_and_traits=Ltable_and_traits))
}



event_speciation<-function(species_lambdas,states,lambdas,Ltable_and_traits,speciesTraits,speciesID,timeStep){
  #sample(speciesTraits,1,prob=species_lambdas)  
  if(length(speciesID)==1){
    mother<-speciesID
  } else {
    mother<-sample(speciesID,1,prob=species_lambdas)  
  }
  
  mother_trait <- speciesTraits[which(mother==speciesID)]
  mother_lambdas<-lambdas[[which(mother_trait==states)]]
  
  matri_positio<-matrix(1:(length(states)^2),ncol=length(states),nrow=length(states),byrow = FALSE)
  all_lambdas_mother<-as.vector(mother_lambdas)
  
  picked_speciation <- sample(1:(length(states)^2),1, prob = all_lambdas_mother)
  
  picked_speciation_cell <- which(matri_positio==picked_speciation,arr.ind = TRUE)
  
  state_to_parent <- picked_speciation_cell[2] # parents are in colums
  state_to_parent <- states[state_to_parent]
  state_to_daugther <- picked_speciation_cell[1]
  state_to_daugther <-states[state_to_daugther]
    speciesTraits[which(mother==speciesID)] <- state_to_parent
    speciesTraits <- c(speciesTraits,state_to_daugther)
    Ltable_and_traits <- rbind(Ltable_and_traits,
                              data.frame(matrix(c(timeStep,mother,max(Ltable_and_traits[,3])+1,0),ncol=4),mother_trait))
    #Ltable_and_traits[max(Ltable_and_traits[,3])+1,2]<-mother
  #Ltable_and_traits[max(Ltable_and_traits[,3])+1,1]<-timeStep
  #Ltable_and_traits[max(Ltable_and_traits[,3])+1,3]<-max(Ltable_and_traits[,3])+1
 # speciesTraits<-c(speciesTraits,speciesTraits[which(speciesID==mother)])
  speciesID <- c(speciesID,max(Ltable_and_traits[,3]))
  return(list(Ltable_and_traits=Ltable_and_traits,speciesTraits=speciesTraits,speciesID=speciesID))
  
}


event_traitshift<- function(shiftprob,speciesTraits,states,speciesID,qs){
    if(length(speciesID)==1){
    ID_chosenspecies<-speciesID
  } else {
    ID_chosenspecies<-sample(speciesID,1,prob=shiftprob) 
  }
  trait_chosen_species<-speciesTraits[which(speciesID==ID_chosenspecies)]
   state_prob_to_shift<-qs[which(trait_chosen_species==states),]
  state_prob_to_shift[which(is.na(state_prob_to_shift))]<-0
   shift_to<-sample(states,1,prob = state_prob_to_shift )
   speciesTraits[which(speciesID==ID_chosenspecies)]<-shift_to
  return(speciesTraits=speciesTraits)
}
