
do_divalike <- function(areas,phylotree_recons,traitdata,do_plot){

randomnumber_for_filename <- sample(1:100000,1)
  
the_tree <- phylotree_recons
write.tree(the_tree,paste0(randomnumber_for_filename,"the_tree.newick"))
trfn = np(paste0(randomnumber_for_filename,"the_tree.newick"))

#fake_traitstate <- give_me_states_combination(areas)
#traitdata <- fake_traitstate
############### all this is to built the position matrix

imaginary_values_area <- NULL
for(ii in (length(areas)-1):0){
  imaginary_values_area <- c(imaginary_values_area,format(10^ii,scientific=F))
  
}
imaginary_values_area <- as.matrix(cbind(areas,imaginary_values_area))




positions <- NULL
for(ii in 1:length(traitdata)){
  imaginary_sum <- 0
  for(j in 1:nrow(imaginary_values_area)){
    
    if(any(imaginary_values_area[j,1] == unlist(strsplit(traitdata[ii], split = "")))){
      imaginary_sum <- imaginary_sum + as.numeric(imaginary_values_area[j,2] )
      print(imaginary_sum)
    }
  }
  positions <- c(positions,imaginary_sum)
  
}

options(scipen = 20)


positions <- str_pad(positions, length(areas), pad = "0")

#######    end of it
my_geo <- as.data.frame(positions,ncol=1)

#colnames(my_geo) <-c("K", "O", "M", "H")
the_rownames <- the_tree$tip.label 
rownames(my_geo) <- the_rownames

#cat(paste(nrow(my_geo),length(areas), "A","B","C","D","\n"), file='distribution_simulated.data', append=F)
cat(paste(paste(nrow(my_geo),length(areas)), paste(areas,collapse = " "),"\n"),file=paste0(randomnumber_for_filename,'distribution_simulated.data'), append=F)
write.table(my_geo,paste0(randomnumber_for_filename,"distribution_simulated.data"),quote=FALSE, col.names=FALSE,append = T)

geogfn = np(paste0(randomnumber_for_filename,"distribution_simulated.data"))



# Look at your geographic range data:
tipranges = getranges_from_LagrangePHYLIP(lgdata_fn=geogfn)


# Maximum range size observed:
max(rowSums(dfnums_to_numeric(tipranges@df)))

# Set the maximum number of areas any species may occupy; this cannot be larger 
# than the number of areas you set up, but it can be smaller.
max_range_size = length(areas)


#######################################################
#######################################################
# DIVALIKE AND DIVALIKE+J ANALYSIS
#######################################################
#######################################################
# NOTE: The BioGeoBEARS "DIVALIKE" model is not identical with 
# Ronquist (1997)'s parsimony DIVA. It is a likelihood
# interpretation of DIVA, constructed by modelling DIVA's
# processes the way DEC does, but only allowing the 
# processes DIVA allows (widespread vicariance: yes; subset
# sympatry: no; see Ronquist & Sanmartin 2011, Figure 4).
#
# DIVALIKE is a likelihood interpretation of parsimony
# DIVA, and it is "like DIVA" -- similar to, but not
# identical to, parsimony DIVA.
#
# I thus now call the model "DIVALIKE", and you should also. ;-)
#######################################################
#######################################################

#######################################################
# Run DIVALIKE
#######################################################
BioGeoBEARS_run_object = define_BioGeoBEARS_run()
BioGeoBEARS_run_object$trfn = trfn
BioGeoBEARS_run_object$geogfn = geogfn
BioGeoBEARS_run_object$max_range_size = max_range_size
BioGeoBEARS_run_object$min_branchlength = 0.000001    # Min to treat tip as a direct ancestor (no speciation event)
BioGeoBEARS_run_object$include_null_range = TRUE    # set to FALSE for e.g. DEC* model, DEC*+J, etc.
# (For DEC* and other "*" models, please cite: Massana, Kathryn A.; Beaulieu, 
#  Jeremy M.; Matzke, Nicholas J.; O'Meara, Brian C. (2015). Non-null Effects of 
#  the Null Range in Biogeographic Models: Exploring Parameter Estimation in the 
#  DEC Model. bioRxiv,  http://biorxiv.org/content/early/2015/09/16/026914 )
# Also: search script on "include_null_range" for other places to change

# Set up a time-stratified analysis:
#BioGeoBEARS_run_object$timesfn = "timeperiods.txt"
#BioGeoBEARS_run_object$dispersal_multipliers_fn = "manual_dispersal_multipliers.txt"
#BioGeoBEARS_run_object$areas_allowed_fn = "areas_allowed.txt"
#BioGeoBEARS_run_object$areas_adjacency_fn = "areas_adjacency.txt"
#BioGeoBEARS_run_object$distsfn = "distances_matrix.txt"
# See notes on the distances model on PhyloWiki's BioGeoBEARS updates page.

# Speed options and multicore processing if desired
BioGeoBEARS_run_object$on_NaN_error = -1e50    # returns very low lnL if parameters produce NaN error (underflow check)
BioGeoBEARS_run_object$speedup = TRUE          # shorcuts to speed ML search; use FALSE if worried (e.g. >3 params)
BioGeoBEARS_run_object$use_optimx = "GenSA"    # if FALSE, use optim() instead of optimx()
BioGeoBEARS_run_object$num_cores_to_use = 1
BioGeoBEARS_run_object$force_sparse = FALSE    # force_sparse=TRUE causes pathology & isn't much faster at this scale

# This function loads the dispersal multiplier matrix etc. from the text files into the model object. Required for these to work!
# (It also runs some checks on these inputs for certain errors.)
BioGeoBEARS_run_object = readfiles_BioGeoBEARS_run(BioGeoBEARS_run_object)

# Divide the tree up by timeperiods/strata (uncomment this for stratified analysis)
#BioGeoBEARS_run_object = section_the_tree(inputs=BioGeoBEARS_run_object, make_master_table=TRUE, plot_pieces=FALSE)
# The stratified tree is described in this table:
#BioGeoBEARS_run_object$master_table

# Good default settings to get ancestral states
BioGeoBEARS_run_object$return_condlikes_table = TRUE
BioGeoBEARS_run_object$calc_TTL_loglike_from_condlikes_table = TRUE
BioGeoBEARS_run_object$calc_ancprobs = TRUE    # get ancestral states from optim run

# Set up DIVALIKE model
# Remove subset-sympatry
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["s","type"] = "fixed"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["s","init"] = 0.0
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["s","est"] = 0.0

BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["ysv","type"] = "2-j"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["ys","type"] = "ysv*1/2"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["y","type"] = "ysv*1/2"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["v","type"] = "ysv*1/2"

# Allow classic, widespread vicariance; all events equiprobable
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["mx01v","type"] = "fixed"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["mx01v","init"] = 0.5
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["mx01v","est"] = 0.5

# No jump dispersal/founder-event speciation
# BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["j","type"] = "free"
# BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["j","init"] = 0.01
# BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["j","est"] = 0.01

check_BioGeoBEARS_run(BioGeoBEARS_run_object)

runslow = TRUE
resfn = "Psychotria_DIVALIKE_M0_unconstrained_v1.Rdata"
if (runslow)
{
  res = bears_optim_run(BioGeoBEARS_run_object)
  res    
  
  save(res, file=resfn)
  resDIVALIKE = res
} else {
  # Loads to "res"
  load(resfn)
  resDIVALIKE = res
}


  

  analysis_titletxt = paste("BioGeoBEARS DIVALIKE on simulated data M0_unconstrained \n")
  



# Setup
results_object = resDIVALIKE
scriptdir = np(system.file("extdata/a_scripts", package="BioGeoBEARS"))

# Leonel's function to extract probabilities at nodes

probabilities_at_node <- 
  results_object$ML_marginal_prob_each_state_at_branch_top_AT_node[(length(traitdata)+1):nrow(results_object$ML_marginal_prob_each_state_at_branch_top_AT_node),-1]

  all_states <- give_me_states_combination(areas)
highest_prob_state <- NULL
for(i in 1:nrow(probabilities_at_node)){
  id_order_state_highest <- which(max(probabilities_at_node[i,])==probabilities_at_node[i,])[1]
  #cat(id_order_state_highest,"\n")
  highest_prob_state <- c(highest_prob_state,all_states[id_order_state_highest])
}

# end of it

# States
#res2 = plot_BioGeoBEARS_results(results_object, analysis_titletxt, addl_params=list("j"), plotwhat="text", label.offset=0.45, tipcex=0.7, statecex=0.7, splitcex=0.6, titlecex=0.8, plotsplits=TRUE, cornercoords_loc=scriptdir, include_null_range=TRUE, tr=the_tree, tipranges=tipranges)

# Pie chart
#
if(do_plot == TRUE){
  plot_BioGeoBEARS_results(results_object, analysis_titletxt, 
                     addl_params=list("j"), plotwhat="pie", label.offset=0.45, tipcex=0.7, statecex=0.7, splitcex=0.6, titlecex=0.8, plotsplits=TRUE, cornercoords_loc=scriptdir, include_null_range=TRUE, tr=the_tree, tipranges=tipranges)
plot_BioGeoBEARS_results(results_object, analysis_titletxt, addl_params=list("d"), plotwhat="text", label.offset=0.45, tipcex=0.7, statecex=0.7, splitcex=0.6, titlecex=0.8, plotsplits=TRUE, cornercoords_loc=scriptdir, include_null_range=TRUE, tr=the_tree, tipranges=tipranges)

}
file.remove(paste0(randomnumber_for_filename,"the_tree.newick"))
file.remove(paste0(randomnumber_for_filename,"distribution_simulated.data"))
return (highest_prob_state)

}