library(BioGeoBEARS)
library(ape)
library(phytools)
library(stringr)
library(deSolve)
library(apTreeshape)
library(phytools)
library(Matrix)
library(lemad)
library(DDD)
library(phylocanvas)
library(phylobase)
library(nodiv)
source("some_tools.R")
source("function_divalike.R")
source("plot_simulated_data.R")
source("functionstoSimulateCrown.R")
source("maintoSimulateCrown.R")
source("additional_tools.R")
areas <- c("A", "B", "C")


all_model_to_try <- 1:36
all_simulateRound <- 1:50
all_resuls_multiple_areas <- NULL

for( ii in 23:length(all_model_to_try)){
  for (iii in 1:length(all_simulateRound)){
    model_to_try <- ii
    simulateRound <- iii
    
    if(file.exists(paste0("model_",model_to_try,"_lemad_",simulateRound,"_.RDS"))){
      simulated_data <- readRDS(paste0("model_",model_to_try,"_data_simulated_",simulateRound,"_.RDS"))
      model_lemad <- readRDS(file = paste0("model_",model_to_try,"_lemad_",simulateRound,"_.RDS"))
      
      
      
      phylotree_recons <- simulated_data$phylotree_recons
      phylotree_full <- simulated_data$phylotree_full
      species_presence <- simulated_data$species_presence
      table_ancestral_area_artificial <- simulated_data$table_ancestral_area_artificial
      Ltable_and_traits <- simulated_data$Ltable_and_traits
      initialState_used <- simulated_data$initialState_used
      
      reality <- anc_state_plot_simulated_data(phylotree_full,phylotree_recons,species_presence,
                                               initialState_used,Ltable_and_traits,
                                               table_ancestral_area_artificial,do_plot = FALSE )
      
      
      table_nodes_full_recons <- give_table_nodes_full_reconst(phylotree_full,phylotree_recons,table_ancestral_area_artificial)
      
      
      times_recons_branching <- NULL
      recons_nodes_branchingtimes <- reality$nodes_times
      for(ij in 1:nrow(table_nodes_full_recons)){
        times_recons_branching <- c(times_recons_branching,
                                    recons_nodes_branchingtimes[which(table_nodes_full_recons$node_recons[ij] == recons_nodes_branchingtimes$the_nodes),2])
        
      }
      table_nodes_full_recons <- cbind(table_nodes_full_recons,times_recons_branching)
      table_nodes_full_recons <- table_nodes_full_recons[order(table_nodes_full_recons$node_recons),]
      
      
      
      parameter <- model_lemad$MLpars
      
      lambdas <- parameter[[1]]
      sampling_fraction <- rep(1,length(lambdas))
      output <- cla_secsse_loglik(parameter, phylotree_recons, species_presence, 
                                  use_fortran = TRUE, methode = "ode45", cond = "proper_cond",
                                  root_state_weight = "proper_weights", sampling_fraction,
                                  run_parallel = FALSE, setting_calculation = NULL,
                                  setting_parallel = NULL, see_ancestral_states = TRUE,
                                  loglik_penalty = 0)
      
      
      probabilities_at_node <- output$ancestral_states
      
      
      all_states <- give_me_states_combination(areas)
      highest_prob_state_lemad <- NULL
      for(ij in 1:nrow(probabilities_at_node)){
        
        id_order_state_highest <- which(max(probabilities_at_node[ij,])==probabilities_at_node[ij,])[1]
        # cat(id_order_state_highest,"\n")
        highest_prob_state_lemad <- c(highest_prob_state_lemad,all_states[id_order_state_highest])
      }
      
      
      divalike_analysis <- do_divalike(areas,phylotree_recons,species_presence,do_plot = FALSE )
      
      
      
      table_nodes_branchingtimes <- cbind(table_nodes_full_recons,
                                          Node_divalike = divalike_analysis,
                                          Node_lemad = highest_prob_state_lemad)
      
      
      table_nodes_branchingtimes <- table_nodes_branchingtimes[order(table_nodes_branchingtimes$times_recons_branching),]
      
      # this part finds the number of successed of divalike and lemad methods
      crown_event_age <- max(table_nodes_branchingtimes$times_recons_branching)
      
      time_slices <- seq(from = 0, to = crown_event_age, by = crown_event_age/3)
      
      diva_multi_area_recent <- NULL
      diva_multi_area_mid <- NULL
      diva_multi_area_ancient <- NULL
      
      lemad_multi_area_recent <- NULL
      lemad_multi_area_mid <- NULL
      lemad_multi_area_ancient <- NULL
      
      real_multi_area_recent <- NULL
      real_multi_area_mid <- NULL
      real_multi_area_ancient <- NULL
      
      
      for(jj in 1:3){
        sub_table_low <- table_nodes_branchingtimes[which(table_nodes_branchingtimes$times_recons_branching >= time_slices[jj]),] 
        sub_table <- sub_table_low[which(sub_table_low$times_recons_branching  <= time_slices[jj + 1]) ,] 
        
        if(jj == 1){
          
          for(kji in 1:length(sub_table$ancens_real_full)){
            real_multi_area_recent <-  c(real_multi_area_recent,nchar(as.character(sub_table$ancens_real_full[kji])))
            diva_multi_area_recent <-  c(diva_multi_area_recent,nchar(as.character(sub_table$Node_divalike[kji])))
            lemad_multi_area_recent <-  c(lemad_multi_area_recent,nchar(as.character(sub_table$Node_lemad[kji])))
            
          }
          
        }
        if(jj == 2){
          for(kji in 1:length(sub_table$ancens_real_full)){
            real_multi_area_mid <-  c(real_multi_area_mid,nchar(as.character(sub_table$ancens_real_full[kji])))
            diva_multi_area_mid <-  c(diva_multi_area_mid,nchar(as.character(sub_table$Node_divalike[kji])))
            lemad_multi_area_mid <-  c(lemad_multi_area_mid,nchar(as.character(sub_table$Node_lemad[kji])))
          }
          
        }
        
        if(jj == 3){
          for(kji in 1:length(sub_table$ancens_real_full)){
            real_multi_area_ancient <-  c(real_multi_area_ancient,nchar(as.character(sub_table$ancens_real_full[kji])))
            diva_multi_area_ancient <-  c(diva_multi_area_ancient,nchar(as.character(sub_table$Node_divalike[kji])))
            lemad_multi_area_ancient <-  c(lemad_multi_area_ancient,nchar(as.character(sub_table$Node_lemad[kji])))
          }
          
        }
        
        
      }
      
      single_area_lemad_recent <- length(which(lemad_multi_area_recent == 1))
      multiple_area_lemad_recent <- length(which(lemad_multi_area_recent > 1))
      
      single_area_lemad_mid <- length(which(lemad_multi_area_mid == 1))
      multiple_area_lemad_mid <- length(which(lemad_multi_area_mid > 1))
      
      single_area_lemad_ancient <- length(which(lemad_multi_area_ancient == 1))
      multiple_area_lemad_ancient <- length(which(lemad_multi_area_ancient > 1))
      
      ##
      single_area_diva_recent <- length(which(diva_multi_area_recent == 1))
      multiple_area_diva_recent <- length(which(diva_multi_area_recent > 1))
      
      single_area_diva_mid <- length(which(diva_multi_area_mid == 1))
      multiple_area_diva_mid <- length(which(diva_multi_area_mid > 1))
      
      single_area_diva_ancient <- length(which(diva_multi_area_ancient == 1))
      multiple_area_diva_ancient <- length(which(diva_multi_area_ancient > 1))
      
      ##
      
      single_area_real_recent <- length(which(real_multi_area_recent == 1))
      multiple_area_real_recent <- length(which(real_multi_area_recent > 1))
      
      single_area_real_mid <- length(which(real_multi_area_mid == 1))
      multiple_area_real_mid <- length(which(real_multi_area_mid > 1))
      
      single_area_real_ancient <- length(which(real_multi_area_ancient == 1))
      multiple_area_real_ancient <- length(which(real_multi_area_ancient > 1))
      
      
      resuls_multiple_areas <- c(model_to_try,simulateRound,multiple_area_real_recent,multiple_area_lemad_recent,multiple_area_diva_recent,
                                 multiple_area_real_mid,multiple_area_lemad_mid,multiple_area_diva_mid,
                                 multiple_area_real_ancient,multiple_area_lemad_ancient,multiple_area_diva_ancient)
      
      all_resuls_multiple_areas <- rbind(all_resuls_multiple_areas,resuls_multiple_areas)
      colnames(all_resuls_multiple_areas) <- c("attempt","mod","real_recent","lemad_recent","diva_recent",
                                        "real_mid","lemad_mid","diva_mid",
                                        "real_ancient","lemad_ancient","diva_ancent")
      print(all_resuls_multiple_areas)
      
      #saveRDS(all_resuls_multiple_areas,"some2.RDS")
      
      
    }  
    
  }
  
}



