#rm(list=ls(all=TRUE))
library(AICcmodavg)


ready_files<-list.files(pattern = "lemad_ext_")
models_to_compare<-ready_files

Aics<-NULL
free_parameters<-NULL
loglikelihoods<-NULL

free_parameters <- c(3,3,4)
for(i in 1:length(models_to_compare)){
  cat("loading:",paste0(models_to_compare[[i]]),"\n")
  mod <- readRDS(paste0(models_to_compare[[i]]))
  ll <- mod$model_ml
  free_pars <- mod$number_free_pars
  #free_parameters<-c(free_parameters,free_pars)
  loglikelihoods <- c(loglikelihoods,ll)
  Aics <- c(Aics,AICcCustom(ll,K=free_pars,second.ord = F)) 
}

ICbweights2 <- function(IC){
  bestmodelIC <- min(IC)
  weights <- exp(-0.5*(IC-bestmodelIC))
  weights <- weights/sum(weights)
  return(weights)
}


calculated_weights<-ICbweights2(Aics)

table_calculated_weights <- data.frame(models_to_compare,loglikelihoods,free_parameters,calculated_weights)

class(table_calculated_weights)
table_calculated_weights<-table_calculated_weights[order(table_calculated_weights$calculated_weights,decreasing = TRUE),]

write.csv(table_calculated_weights,"table_aic.csv")



#########  part to see the max and min of the estimates ###

i<- 1
max_lambda <- NULL
min_lambda <- NULL
max_mus <- NULL
min_mus <- NULL
max_qs <- NULL
min_qs <- NULL

for (i in 1:nrow(table_calculated_weights) ){
  one_mod <- readRDS(as.character(table_calculated_weights[i,1]))

  allpars <- one_mod[[1]]$MLpars
  
  lambdas <- unique(unlist(allpars[[1]]))
  lambdas <- lambdas[-which(lambdas==0)]
  
  mus <- unique(unlist(allpars[[2]]))
  if(any(mus==0)){
    mus <- mus[-which(mus==0)]
  }
  
  qs <- unlist(allpars[[3]])
  qs <- qs [qs>0]
  max(qs,na.rm = TRUE)
  
  max_lambda <- c(max_lambda,max(lambdas,na.rm = TRUE))
  min_lambda <- c(min_lambda,min(lambdas,na.rm = TRUE))
  
  max_mus <- c(max_mus,max(mus,na.rm = TRUE))
  min_mus <- c(min_mus,min(mus,na.rm = TRUE))
  
  max_qs <- c(max_qs,max(qs,na.rm = TRUE))
  min_qs <- c(min_qs,min(qs,na.rm = TRUE))
  
  
}

table_calculated_weights <- cbind(table_calculated_weights,
                                  max_lambda,
                                  min_lambda,
                                  max_mus,
                                  min_mus,
                                  max_qs, 
                                  min_qs)



#########

table_to_edit <- table_calculated_weights$models_to_compare


library(stringr)
transition_mode_all<-NULL
speciation_mode_all<-NULL
lumped_mode_all<-NULL
extinction_in_all <- NULL
q_diff_all<- NULL
dependence_all <-NULL

for(ii in 1:length(table_to_edit)){
the_string<-as.character(table_to_edit[ii])
transition_mode<-NULL
speciation_mode<-NULL
lumped_mode<-NULL
extinction_in <- NULL
q_diff <- NULL
dependence<-NULL

if(grepl("&freeQ&",the_string)){
  transition_mode<-"Unconstrained with 6 rates"
}
if(grepl("constrained_freeQ",the_string)){
  transition_mode<-"Constrained with 4 rates"
}
if(grepl("unconstrained_variableQ",the_string)){
  transition_mode<-"Unconstrained with  2 rates"
}
if(grepl("unconstrained_constantQ",the_string)){
  transition_mode<-"Unconstrained with  1 rates"
}
if(grepl("expansion_constantQ",the_string)){
  transition_mode<-"Constrained 1 rates"
}
if(grepl("expansion_variableQ",the_string)){
  transition_mode<-"Constrained 2 rates"
}
if(grepl("general_to_special",the_string)){
  transition_mode<-"General to specialist "
}


if(grepl("1",the_string)){
  speciation_mode<-"Dual inheritance"
}
if(grepl("2",the_string)){
  speciation_mode<-"Single inheritance"
}
if(grepl("3",the_string)){
  speciation_mode<-"Dual Symmetric Transition"
}
if(grepl("4",the_string)){
  speciation_mode<-"Dual Asymmetric Transition"
}
if(grepl("5",the_string)){
  speciation_mode<-"Dual + single inheritance"
}
if(grepl("6",the_string)){
  speciation_mode<-"Dual inheritance + dual symmetric transition"
}
if(grepl("7",the_string)){
  speciation_mode<-"Dual inheritance + dual asymmetric transition"
}
if(grepl("8",the_string)){
  speciation_mode<-"Combination of all main modes"
}
if(grepl("mod1",the_string)){
  speciation_mode<-"Dependent of state mod1"
}
if(grepl("mod2",the_string)){
  speciation_mode<-"Dependent of state mod2"
}
if(grepl("mod3",the_string)){
  speciation_mode<-"Dependent of state mod3"
}
if(grepl("mod4",the_string)){
  speciation_mode<-"Dependent of state mod4"
}
if(grepl("mod5",the_string)){
  speciation_mode<-"Dependent of state mod5"
}


if(grepl("_mu",the_string)){
  extinction_in<-"Yes"
} else{
  extinction_in<-"No"
}

if(grepl("diffq",the_string)){
  q_diff<-"Yes"
} else{
  q_diff<-"No"
}

if(grepl("ETD&",the_string)){
  dependence<-"ETD"
}
if(grepl("CTD&",the_string)){
  dependence<-"CTD"
}
if(grepl("CR&",the_string)){
  dependence<-"CR"
}



if(is.null(transition_mode)){
  transition_mode_all<-c(transition_mode_all,"something odd")
} else {
  transition_mode_all<-c(transition_mode_all,transition_mode)
}

if(is.null(speciation_mode)){
  speciation_mode_all<-c(speciation_mode_all,"something odd")
} else {
  speciation_mode_all<-c(speciation_mode_all,speciation_mode)
}


if(is.null(extinction_in)){
  extinction_in_all<-c(extinction_in_all,"something odd")
} else {
  extinction_in_all<-c(extinction_in_all,extinction_in)
}

if(is.null(q_diff)){
  q_diff_all<-c(q_diff_all,"something odd")
} else {
  q_diff_all<-c(q_diff_all,q_diff)
}

if(is.null(dependence)){
  dependence_all<-c(dependence_all,"something odd")
} else {
  dependence_all<-c(dependence_all,dependence)
}

}

new_table <- cbind(dependence_all,
                   transition_mode_all,
                   speciation_mode_all,
                   extinction_in_all,
                   q_diff_all,
                   table_calculated_weights[,-1])

write.csv(new_table,file="aicTable_full_walterTREE.csv")
